/*     */ package org.jboss.jms.client.container;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import javax.jms.IllegalStateException;
/*     */ import javax.jms.Message;
/*     */ import javax.jms.MessageListener;
/*     */ import javax.jms.ServerSessionPool;
/*     */ import javax.jms.TransactionInProgressException;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.jms.client.JBossConnectionConsumer;
/*     */ import org.jboss.jms.client.delegate.ClientSessionDelegate;
/*     */ import org.jboss.jms.client.delegate.DelegateSupport;
/*     */ import org.jboss.jms.client.state.ConnectionState;
/*     */ import org.jboss.jms.client.state.SessionState;
/*     */ import org.jboss.jms.delegate.ConnectionDelegate;
/*     */ import org.jboss.jms.delegate.DefaultCancel;
/*     */ import org.jboss.jms.delegate.DeliveryInfo;
/*     */ import org.jboss.jms.delegate.SessionDelegate;
/*     */ import org.jboss.jms.destination.JBossDestination;
/*     */ import org.jboss.jms.message.BytesMessageProxy;
/*     */ import org.jboss.jms.message.JBossBytesMessage;
/*     */ import org.jboss.jms.message.JBossMapMessage;
/*     */ import org.jboss.jms.message.JBossMessage;
/*     */ import org.jboss.jms.message.JBossObjectMessage;
/*     */ import org.jboss.jms.message.JBossStreamMessage;
/*     */ import org.jboss.jms.message.JBossTextMessage;
/*     */ import org.jboss.jms.message.MapMessageProxy;
/*     */ import org.jboss.jms.message.MessageProxy;
/*     */ import org.jboss.jms.message.ObjectMessageProxy;
/*     */ import org.jboss.jms.message.StreamMessageProxy;
/*     */ import org.jboss.jms.message.TextMessageProxy;
/*     */ import org.jboss.jms.tx.LocalTx;
/*     */ import org.jboss.jms.tx.ResourceManager;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class SessionAspect
/*     */ {
/*  80 */   private static final Logger log = Logger.getLogger(SessionAspect.class);
/*     */   private boolean trace;
/*     */ 
/*     */   public SessionAspect()
/*     */   {
/*  84 */     this.trace = log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public Object handleClosing(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  94 */     MethodInvocation mi = (MethodInvocation)invocation;
/*  95 */     SessionState state = getState(invocation);
/*  96 */     SessionDelegate del = (SessionDelegate)mi.getTargetObject();
/*     */ 
/*  98 */     if (this.trace) log.trace("handleClosing()");
/*     */ 
/* 101 */     if ((state.isXA()) && (!isXAAndConsideredNonTransacted(state)))
/*     */     {
/* 103 */       if (this.trace) log.trace("Session is XA");
/*     */ 
/* 105 */       ConnectionState connState = (ConnectionState)state.getParent();
/*     */ 
/* 107 */       ResourceManager rm = connState.getResourceManager();
/*     */ 
/* 118 */       if (rm.checkForAcksInSession(state.getSessionID()))
/*     */       {
/* 120 */         throw new IllegalStateException("Attempt to close an XASession when there are still uncommitted acknowledgements!");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 125 */     int ackMode = state.getAcknowledgeMode();
/*     */ 
/* 131 */     if ((ackMode == 1) || (isXAAndConsideredNonTransacted(state)))
/*     */     {
/* 135 */       DeliveryInfo remainingAutoAck = state.getAutoAckInfo();
/*     */ 
/* 137 */       if (remainingAutoAck != null)
/*     */       {
/* 139 */         if (this.trace) log.trace(this + " handleClosing(). Found remaining auto ack. Will ack " + remainingAutoAck);
/*     */ 
/*     */         try
/*     */         {
/* 143 */           ackDelivery(del, remainingAutoAck);
/*     */ 
/* 145 */           if (this.trace) log.trace(this + " acked it");
/*     */         }
/*     */         finally
/*     */         {
/* 149 */           state.setAutoAckInfo(null);
/*     */         }
/*     */       }
/*     */     }
/* 153 */     else if (ackMode == 3)
/*     */     {
/* 157 */       if (!state.getClientAckList().isEmpty())
/*     */       {
/*     */         try
/*     */         {
/* 161 */           acknowledgeDeliveries(del, state.getClientAckList());
/*     */         }
/*     */         finally
/*     */         {
/* 165 */           state.getClientAckList().clear();
/*     */ 
/* 167 */           state.setAutoAckInfo(null);
/*     */         }
/*     */       }
/*     */     }
/* 171 */     else if (ackMode == 2)
/*     */     {
/* 181 */       cancelDeliveries(del, state.getClientAckList());
/*     */ 
/* 183 */       state.getClientAckList().clear();
/*     */     }
/* 185 */     else if ((state.isTransacted()) && (!state.isXA()))
/*     */     {
/* 190 */       ConnectionState connState = (ConnectionState)state.getParent();
/*     */ 
/* 192 */       ResourceManager rm = connState.getResourceManager();
/*     */ 
/* 194 */       List dels = rm.getDeliveriesForSession(state.getSessionID());
/*     */ 
/* 196 */       cancelDeliveries(del, dels);
/*     */     }
/*     */ 
/* 199 */     return invocation.invokeNext();
/*     */   }
/*     */ 
/*     */   public Object handleClose(Invocation invocation) throws Throwable
/*     */   {
/* 204 */     Object res = invocation.invokeNext();
/*     */ 
/* 206 */     SessionState state = getState(invocation);
/*     */ 
/* 208 */     ConnectionState connState = (ConnectionState)state.getParent();
/*     */ 
/* 210 */     Object xid = state.getCurrentTxId();
/*     */ 
/* 212 */     if (xid != null)
/*     */     {
/* 215 */       connState.getResourceManager().removeTx(xid);
/*     */     }
/*     */ 
/* 220 */     state.getExecutor().shutdownNow();
/*     */ 
/* 222 */     return res;
/*     */   }
/*     */ 
/*     */   public Object handlePreDeliver(Invocation invocation) throws Throwable
/*     */   {
/* 227 */     MethodInvocation mi = (MethodInvocation)invocation;
/* 228 */     SessionState state = getState(invocation);
/*     */ 
/* 230 */     int ackMode = state.getAcknowledgeMode();
/*     */ 
/* 232 */     Object[] args = mi.getArguments();
/* 233 */     DeliveryInfo info = (DeliveryInfo)args[0];
/*     */ 
/* 235 */     if (ackMode == 2)
/*     */     {
/* 239 */       if (this.trace) log.trace(this + " added to CLIENT_ACKNOWLEDGE list delivery " + info);
/*     */ 
/* 242 */       if (info.getConnectionConsumerSession() != null)
/*     */       {
/* 244 */         throw new IllegalStateException("CLIENT_ACKNOWLEDGE cannot be used with a connection consumer");
/*     */       }
/*     */ 
/* 248 */       state.getClientAckList().add(info);
/*     */     }
/* 252 */     else if ((ackMode == 1) || (isXAAndConsideredNonTransacted(state)))
/*     */     {
/* 256 */       if (this.trace) log.trace(this + " added " + info + " to session state");
/*     */ 
/* 258 */       state.setAutoAckInfo(info);
/*     */     }
/* 260 */     else if (ackMode == 3)
/*     */     {
/* 262 */       if (this.trace) log.trace(this + " added to DUPS_OK_ACKNOWLEDGE list delivery " + info);
/*     */ 
/* 264 */       state.getClientAckList().add(info);
/*     */ 
/* 267 */       state.setAutoAckInfo(info);
/*     */     }
/*     */     else
/*     */     {
/* 271 */       Object txID = state.getCurrentTxId();
/*     */ 
/* 273 */       if (txID != null)
/*     */       {
/* 279 */         ConnectionState connState = (ConnectionState)state.getParent();
/*     */ 
/* 281 */         if (this.trace) log.trace("sending acknowlegment transactionally, queueing on resource manager");
/*     */ 
/* 287 */         ClientSessionDelegate connectionConsumerDelegate = (ClientSessionDelegate)info.getConnectionConsumerSession();
/*     */ 
/* 290 */         String sessionId = connectionConsumerDelegate != null ? connectionConsumerDelegate.getID() : state.getSessionID();
/*     */ 
/* 293 */         connState.getResourceManager().addAck(txID, sessionId, info);
/*     */       }
/*     */     }
/*     */ 
/* 297 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handlePostDeliver(Invocation invocation) throws Throwable
/*     */   {
/* 302 */     MethodInvocation mi = (MethodInvocation)invocation;
/* 303 */     SessionState state = getState(invocation);
/*     */ 
/* 305 */     int ackMode = state.getAcknowledgeMode();
/*     */ 
/* 307 */     SessionDelegate sd = (SessionDelegate)mi.getTargetObject();
/*     */ 
/* 309 */     boolean res = true;
/*     */ 
/* 313 */     if ((ackMode == 1) || (isXAAndConsideredNonTransacted(state)))
/*     */     {
/* 318 */       if (!state.isRecoverCalled())
/*     */       {
/* 320 */         DeliveryInfo delivery = state.getAutoAckInfo();
/*     */ 
/* 322 */         if (delivery == null)
/*     */         {
/* 324 */           throw new IllegalStateException("Cannot find delivery to AUTO_ACKNOWLEDGE");
/*     */         }
/*     */ 
/* 327 */         if (this.trace) log.trace(this + " auto acknowledging delivery " + delivery);
/*     */ 
/*     */         try
/*     */         {
/* 338 */           res = ackDelivery(sd, delivery);
/*     */         }
/*     */         finally
/*     */         {
/* 342 */           state.setAutoAckInfo(null);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 347 */         if (this.trace) log.trace(this + " recover called, so NOT acknowledging");
/*     */ 
/* 349 */         state.setRecoverCalled(false);
/*     */       }
/*     */     }
/* 352 */     else if (ackMode == 3)
/*     */     {
/* 354 */       List acks = state.getClientAckList();
/*     */ 
/* 356 */       if (!state.isRecoverCalled())
/*     */       {
/* 358 */         if (acks.size() >= state.getDupsOKBatchSize())
/*     */         {
/*     */           try
/*     */           {
/* 365 */             acknowledgeDeliveries(sd, acks);
/*     */           }
/*     */           finally
/*     */           {
/* 369 */             acks.clear();
/* 370 */             state.setAutoAckInfo(null);
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 376 */         if (this.trace) log.trace(this + " recover called, so NOT acknowledging");
/*     */ 
/* 378 */         state.setRecoverCalled(false);
/*     */       }
/* 380 */       state.setAutoAckInfo(null);
/*     */     }
/*     */ 
/* 383 */     return Boolean.valueOf(res);
/*     */   }
/*     */ 
/*     */   public Object handleAcknowledgeAll(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 391 */     MethodInvocation mi = (MethodInvocation)invocation;
/* 392 */     SessionState state = getState(invocation);
/* 393 */     SessionDelegate del = (SessionDelegate)mi.getTargetObject();
/*     */ 
/* 395 */     if (!state.getClientAckList().isEmpty())
/*     */     {
/* 399 */       acknowledgeDeliveries(del, state.getClientAckList());
/*     */ 
/* 401 */       state.getClientAckList().clear();
/*     */     }
/*     */ 
/* 404 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handleRecover(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 412 */     if (this.trace) log.trace("recover called");
/*     */ 
/* 414 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/* 416 */     SessionState state = getState(invocation);
/*     */ 
/* 418 */     if ((state.isTransacted()) && (!isXAAndConsideredNonTransacted(state)))
/*     */     {
/* 420 */       throw new IllegalStateException("Cannot recover a transacted session");
/*     */     }
/*     */ 
/* 423 */     if (this.trace) log.trace("recovering the session");
/*     */ 
/* 426 */     SessionDelegate del = (SessionDelegate)mi.getTargetObject();
/*     */ 
/* 428 */     int ackMode = state.getAcknowledgeMode();
/*     */ 
/* 430 */     if (ackMode == 2)
/*     */     {
/* 432 */       List dels = state.getClientAckList();
/*     */ 
/* 434 */       state.setClientAckList(new ArrayList());
/*     */ 
/* 436 */       del.redeliver(dels);
/*     */ 
/* 438 */       state.setRecoverCalled(true);
/*     */     }
/* 440 */     else if ((ackMode == 1) || (ackMode == 3) || (isXAAndConsideredNonTransacted(state)))
/*     */     {
/* 442 */       DeliveryInfo info = state.getAutoAckInfo();
/*     */ 
/* 446 */       if (info != null)
/*     */       {
/* 448 */         List redels = new ArrayList();
/*     */ 
/* 450 */         redels.add(info);
/*     */ 
/* 452 */         del.redeliver(redels);
/*     */ 
/* 454 */         state.setAutoAckInfo(null);
/*     */ 
/* 456 */         state.setRecoverCalled(true);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 461 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handleRedeliver(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 496 */     MethodInvocation mi = (MethodInvocation)invocation;
/* 497 */     SessionState state = getState(invocation);
/*     */ 
/* 501 */     List toRedeliver = (List)mi.getArguments()[0];
/*     */ 
/* 503 */     if (this.trace) log.trace(this + " handleRedeliver() called: " + toRedeliver);
/*     */ 
/* 505 */     SessionDelegate del = (SessionDelegate)mi.getTargetObject();
/*     */ 
/* 508 */     for (int i = toRedeliver.size() - 1; i >= 0; i--)
/*     */     {
/* 510 */       DeliveryInfo info = (DeliveryInfo)toRedeliver.get(i);
/* 511 */       MessageProxy proxy = info.getMessageProxy();
/*     */ 
/* 513 */       ClientConsumer handler = state.getCallbackHandler(info.getConsumerId());
/*     */ 
/* 515 */       if (handler == null)
/*     */       {
/* 519 */         cancelDelivery(del, info);
/*     */       }
/* 521 */       else if (handler.getRedeliveryDelay() != 0L)
/*     */       {
/* 525 */         cancelDelivery(del, info);
/*     */       }
/*     */       else
/*     */       {
/* 529 */         if (this.trace) log.trace("Adding proxy back to front of buffer");
/*     */ 
/* 531 */         handler.addToFrontOfBuffer(proxy);
/*     */       }
/*     */     }
/*     */ 
/* 535 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handleCommit(Invocation invocation) throws Throwable
/*     */   {
/* 540 */     SessionState state = getState(invocation);
/*     */ 
/* 542 */     if (!state.isTransacted())
/*     */     {
/* 544 */       throw new IllegalStateException("Cannot commit a non-transacted session");
/*     */     }
/*     */ 
/* 547 */     if (state.isXA())
/*     */     {
/* 549 */       throw new TransactionInProgressException("Cannot call commit on an XA session");
/*     */     }
/*     */ 
/* 552 */     ConnectionState connState = (ConnectionState)state.getParent();
/* 553 */     ConnectionDelegate conn = (ConnectionDelegate)connState.getDelegate();
/*     */     try
/*     */     {
/* 557 */       connState.getResourceManager().commitLocal((LocalTx)state.getCurrentTxId(), conn);
/*     */     }
/*     */     finally
/*     */     {
/*     */       Object xid;
/* 562 */       Object xid = connState.getResourceManager().createLocalTx();
/*     */ 
/* 564 */       state.setCurrentTxId(xid);
/*     */     }
/*     */ 
/* 569 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handleRollback(Invocation invocation) throws Throwable
/*     */   {
/* 574 */     SessionState state = getState(invocation);
/*     */ 
/* 576 */     if (!state.isTransacted())
/*     */     {
/* 578 */       throw new IllegalStateException("Cannot rollback a non-transacted session");
/*     */     }
/*     */ 
/* 581 */     if (state.isXA())
/*     */     {
/* 583 */       throw new TransactionInProgressException("Cannot call rollback on an XA session");
/*     */     }
/*     */ 
/* 586 */     ConnectionState connState = (ConnectionState)state.getParent();
/* 587 */     ResourceManager rm = connState.getResourceManager();
/*     */     try
/*     */     {
/* 590 */       rm.rollbackLocal((LocalTx)state.getCurrentTxId());
/*     */     }
/*     */     finally
/*     */     {
/*     */       Object xid;
/* 595 */       Object xid = rm.createLocalTx();
/* 596 */       state.setCurrentTxId(xid);
/*     */     }
/*     */ 
/* 599 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handleSend(Invocation invocation) throws Throwable
/*     */   {
/* 604 */     SessionState state = getState(invocation);
/* 605 */     Object txID = state.getCurrentTxId();
/*     */ 
/* 612 */     if (((!state.isXA()) && (state.isTransacted())) || ((state.isXA()) && (!(txID instanceof LocalTx))))
/*     */     {
/* 618 */       ConnectionState connState = (ConnectionState)state.getParent();
/* 619 */       MethodInvocation mi = (MethodInvocation)invocation;
/* 620 */       Message m = (Message)mi.getArguments()[0];
/*     */ 
/* 622 */       if (this.trace) log.trace("sending message " + m + " transactionally, queueing on resource manager txID=" + txID + " sessionID= " + state.getSessionID());
/*     */ 
/* 624 */       connState.getResourceManager().addMessage(txID, state.getSessionID(), (JBossMessage)m);
/*     */ 
/* 627 */       return null;
/*     */     }
/*     */ 
/* 630 */     if (this.trace) log.trace("sending message NON-transactionally");
/*     */ 
/* 632 */     return invocation.invokeNext();
/*     */   }
/*     */ 
/*     */   public Object handleGetXAResource(Invocation invocation) throws Throwable
/*     */   {
/* 637 */     return getState(invocation).getXAResource();
/*     */   }
/*     */ 
/*     */   public Object handleGetTransacted(Invocation invocation) throws Throwable
/*     */   {
/* 642 */     return getState(invocation).isTransacted() ? Boolean.TRUE : Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object handleGetAcknowledgeMode(Invocation invocation) throws Throwable
/*     */   {
/* 647 */     return new Integer(getState(invocation).getAcknowledgeMode());
/*     */   }
/*     */ 
/*     */   public Object handleCreateMessage(Invocation invocation) throws Throwable
/*     */   {
/* 652 */     JBossMessage jbm = new JBossMessage(0L);
/*     */ 
/* 654 */     return new MessageProxy(jbm);
/*     */   }
/*     */ 
/*     */   public Object handleCreateBytesMessage(Invocation invocation) throws Throwable
/*     */   {
/* 659 */     JBossBytesMessage jbm = new JBossBytesMessage(0L);
/*     */ 
/* 661 */     return new BytesMessageProxy(jbm);
/*     */   }
/*     */ 
/*     */   public Object handleCreateMapMessage(Invocation invocation) throws Throwable
/*     */   {
/* 666 */     JBossMapMessage jbm = new JBossMapMessage(0L);
/*     */ 
/* 668 */     return new MapMessageProxy(jbm);
/*     */   }
/*     */ 
/*     */   public Object handleCreateObjectMessage(Invocation invocation) throws Throwable
/*     */   {
/* 673 */     JBossObjectMessage jbm = new JBossObjectMessage(0L);
/*     */ 
/* 675 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/* 677 */     if ((mi.getArguments() != null) && (mi.getArguments().length > 0))
/*     */     {
/* 679 */       jbm.setObject((Serializable)mi.getArguments()[0]);
/*     */     }
/*     */ 
/* 682 */     return new ObjectMessageProxy(jbm);
/*     */   }
/*     */ 
/*     */   public Object handleCreateStreamMessage(Invocation invocation) throws Throwable
/*     */   {
/* 687 */     JBossStreamMessage jbm = new JBossStreamMessage(0L);
/*     */ 
/* 689 */     return new StreamMessageProxy(jbm);
/*     */   }
/*     */ 
/*     */   public Object handleCreateTextMessage(Invocation invocation) throws Throwable
/*     */   {
/* 694 */     JBossTextMessage jbm = new JBossTextMessage(0L);
/*     */ 
/* 696 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/* 698 */     if ((mi.getArguments() != null) && (mi.getArguments().length > 0))
/*     */     {
/* 700 */       jbm.setText((String)mi.getArguments()[0]);
/*     */     }
/*     */ 
/* 703 */     return new TextMessageProxy(jbm);
/*     */   }
/*     */ 
/*     */   public Object handleSetMessageListener(Invocation invocation) throws Throwable
/*     */   {
/* 708 */     if (this.trace) log.trace("setMessageListener()");
/*     */ 
/* 710 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/* 712 */     MessageListener listener = (MessageListener)mi.getArguments()[0];
/*     */ 
/* 714 */     if (listener == null)
/*     */     {
/* 716 */       throw new IllegalStateException("Cannot set a null MessageListener on the session");
/*     */     }
/*     */ 
/* 719 */     getState(invocation).setDistinguishedListener(listener);
/*     */ 
/* 721 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handleGetMessageListener(Invocation invocation) throws Throwable
/*     */   {
/* 726 */     if (this.trace) log.trace("getMessageListener()");
/*     */ 
/* 728 */     return getState(invocation).getDistinguishedListener();
/*     */   }
/*     */ 
/*     */   public Object handleCreateConnectionConsumer(Invocation invocation) throws Throwable
/*     */   {
/* 733 */     if (this.trace) log.trace("createConnectionConsumer()");
/*     */ 
/* 735 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/* 737 */     JBossDestination dest = (JBossDestination)mi.getArguments()[0];
/* 738 */     String subscriptionName = (String)mi.getArguments()[1];
/* 739 */     String messageSelector = (String)mi.getArguments()[2];
/* 740 */     ServerSessionPool sessionPool = (ServerSessionPool)mi.getArguments()[3];
/* 741 */     int maxMessages = ((Integer)mi.getArguments()[4]).intValue();
/*     */ 
/* 743 */     return new JBossConnectionConsumer((ConnectionDelegate)mi.getTargetObject(), dest, subscriptionName, messageSelector, sessionPool, maxMessages);
/*     */   }
/*     */ 
/*     */   public Object handleAddAsfMessage(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 750 */     if (this.trace) log.trace("addAsfMessage()");
/*     */ 
/* 752 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/* 756 */     MessageProxy m = (MessageProxy)mi.getArguments()[0];
/* 757 */     String theConsumerID = (String)mi.getArguments()[1];
/* 758 */     String queueName = (String)mi.getArguments()[2];
/* 759 */     int maxDeliveries = ((Integer)mi.getArguments()[3]).intValue();
/* 760 */     SessionDelegate connectionConsumerDelegate = (SessionDelegate)mi.getArguments()[4];
/* 761 */     boolean shouldAck = ((Boolean)mi.getArguments()[5]).booleanValue();
/*     */ 
/* 763 */     if (m == null)
/*     */     {
/* 765 */       throw new IllegalStateException("Cannot add a null message to the session");
/*     */     }
/*     */ 
/* 768 */     AsfMessageHolder holder = new AsfMessageHolder(null);
/* 769 */     AsfMessageHolder.access$102(holder, m);
/* 770 */     AsfMessageHolder.access$202(holder, theConsumerID);
/* 771 */     AsfMessageHolder.access$302(holder, queueName);
/* 772 */     AsfMessageHolder.access$402(holder, maxDeliveries);
/* 773 */     AsfMessageHolder.access$502(holder, connectionConsumerDelegate);
/* 774 */     AsfMessageHolder.access$602(holder, shouldAck);
/*     */ 
/* 776 */     getState(invocation).getASFMessages().add(holder);
/*     */ 
/* 778 */     return null;
/*     */   }
/*     */ 
/*     */   public Object handleRun(Invocation invocation) throws Throwable
/*     */   {
/* 783 */     if (this.trace) log.trace("run()");
/*     */ 
/* 785 */     MethodInvocation mi = (MethodInvocation)invocation;
/*     */ 
/* 788 */     SessionDelegate del = (SessionDelegate)mi.getTargetObject();
/*     */ 
/* 790 */     SessionState state = getState(invocation);
/*     */ 
/* 792 */     int ackMode = state.getAcknowledgeMode();
/*     */ 
/* 794 */     LinkedList msgs = state.getASFMessages();
/*     */ 
/* 796 */     while (msgs.size() > 0)
/*     */     {
/* 798 */       AsfMessageHolder holder = (AsfMessageHolder)msgs.removeFirst();
/*     */ 
/* 800 */       if (this.trace) log.trace("sending " + holder.msg + " to the message listener");
/*     */ 
/* 802 */       ClientConsumer.callOnMessage(del, state.getDistinguishedListener(), holder.consumerID, holder.queueName, false, holder.msg, ackMode, holder.maxDeliveries, holder.connectionConsumerDelegate, holder.shouldAck);
/*     */     }
/*     */ 
/* 808 */     return null;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 815 */     return "SessionAspect[" + Integer.toHexString(hashCode()) + "]";
/*     */   }
/*     */ 
/*     */   private SessionState getState(Invocation inv)
/*     */   {
/* 830 */     return (SessionState)((DelegateSupport)inv.getTargetObject()).getState();
/*     */   }
/*     */ 
/*     */   private boolean ackDelivery(SessionDelegate sess, DeliveryInfo delivery) throws Exception
/*     */   {
/* 835 */     if (delivery.isShouldAck())
/*     */     {
/* 837 */       SessionDelegate connectionConsumerSession = delivery.getConnectionConsumerSession();
/*     */ 
/* 842 */       SessionDelegate sessionToUse = connectionConsumerSession != null ? connectionConsumerSession : sess;
/*     */ 
/* 844 */       return sessionToUse.acknowledgeDelivery(delivery);
/*     */     }
/*     */ 
/* 848 */     return true;
/*     */   }
/*     */ 
/*     */   private void cancelDelivery(SessionDelegate sess, DeliveryInfo delivery)
/*     */     throws Exception
/*     */   {
/* 854 */     if (delivery.isShouldAck())
/*     */     {
/* 856 */       SessionDelegate connectionConsumerSession = delivery.getConnectionConsumerSession();
/*     */ 
/* 861 */       SessionDelegate sessionToUse = connectionConsumerSession != null ? connectionConsumerSession : sess;
/*     */ 
/* 863 */       sessionToUse.cancelDelivery(new DefaultCancel(delivery.getDeliveryID(), delivery.getMessageProxy().getDeliveryCount(), false, false));
/*     */     }
/*     */   }
/*     */ 
/*     */   private void cancelDeliveries(SessionDelegate del, List deliveryInfos)
/*     */     throws Exception
/*     */   {
/* 870 */     List cancels = new ArrayList();
/*     */ 
/* 872 */     for (Iterator i = deliveryInfos.iterator(); i.hasNext(); )
/*     */     {
/* 874 */       DeliveryInfo ack = (DeliveryInfo)i.next();
/*     */ 
/* 876 */       if (ack.isShouldAck())
/*     */       {
/* 878 */         DefaultCancel cancel = new DefaultCancel(ack.getMessageProxy().getDeliveryId(), ack.getMessageProxy().getDeliveryCount(), false, false);
/*     */ 
/* 882 */         cancels.add(cancel);
/*     */       }
/*     */     }
/*     */ 
/* 886 */     if (!cancels.isEmpty())
/*     */     {
/* 888 */       del.cancelDeliveries(cancels);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void acknowledgeDeliveries(SessionDelegate del, List deliveryInfos) throws Exception
/*     */   {
/* 894 */     List acks = new ArrayList();
/*     */ 
/* 896 */     for (Iterator i = deliveryInfos.iterator(); i.hasNext(); )
/*     */     {
/* 898 */       DeliveryInfo ack = (DeliveryInfo)i.next();
/*     */ 
/* 900 */       if (ack.isShouldAck())
/*     */       {
/* 902 */         acks.add(ack);
/*     */       }
/*     */     }
/*     */ 
/* 906 */     if (!acks.isEmpty())
/*     */     {
/* 908 */       del.acknowledgeDeliveries(acks);
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean isXAAndConsideredNonTransacted(SessionState state)
/*     */   {
/* 929 */     return (state.isXA()) && ((state.getCurrentTxId() instanceof LocalTx)) && (state.getTreatAsNonTransactedWhenNotEnlisted()) && (state.getDistinguishedListener() == null);
/*     */   }
/*     */ 
/*     */   private static class AsfMessageHolder
/*     */   {
/*     */     private MessageProxy msg;
/*     */     private String consumerID;
/*     */     private String queueName;
/*     */     private int maxDeliveries;
/*     */     private SessionDelegate connectionConsumerDelegate;
/*     */     private boolean shouldAck;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.container.SessionAspect
 * JD-Core Version:    0.6.0
 */