/*     */ package org.jboss.jms.client.delegate;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.Serializable;
/*     */ import java.lang.ref.Reference;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collections;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.jms.JMSException;
/*     */ import org.jboss.aop.Advised;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.ClassInstanceAdvisor;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.JoinPointInfo;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.instrument.Untransformable;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.InvocationBase;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.jms.client.container.JMSClientVMIdentifier;
/*     */ import org.jboss.jms.client.plugin.LoadBalancingPolicy;
/*     */ import org.jboss.jms.client.remoting.CallbackManager;
/*     */ import org.jboss.jms.client.remoting.ConnectionFactoryCallbackHandler;
/*     */ import org.jboss.jms.client.remoting.JMSRemotingConnection;
/*     */ import org.jboss.jms.delegate.ConnectionFactoryDelegate;
/*     */ import org.jboss.jms.delegate.CreateConnectionResult;
/*     */ import org.jboss.jms.delegate.IDBlock;
/*     */ import org.jboss.jms.delegate.TopologyResult;
/*     */ import org.jboss.jms.exception.MessagingNetworkFailureException;
/*     */ import org.jboss.jms.wireformat.ConnectionFactoryAddCallbackRequest;
/*     */ import org.jboss.jms.wireformat.ConnectionFactoryGetTopologyRequest;
/*     */ import org.jboss.jms.wireformat.ConnectionFactoryGetTopologyResponse;
/*     */ import org.jboss.jms.wireformat.ConnectionFactoryRemoveCallbackRequest;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.util.Version;
/*     */ import org.jboss.messaging.util.WeakHashSet;
/*     */ import org.jboss.remoting.Client;
/*     */ 
/*     */ public class ClientClusteredConnectionFactoryDelegate extends DelegateSupport
/*     */   implements Serializable, ConnectionFactoryDelegate, Advised
/*     */ {
/*     */   private static final long serialVersionUID = 8286850860206289277L;
/*     */   private static final Logger log;
/*     */   private static boolean trace;
/*     */   private transient JMSRemotingConnection remoting;
/*     */   private transient ClientConnectionFactoryDelegate currentDelegate;
/*     */   private String uniqueName;
/*     */   private ClientConnectionFactoryDelegate[] delegates;
/*     */   private Map failoverMap;
/*     */   private LoadBalancingPolicy loadBalancingPolicy;
/*     */   private boolean supportsFailover;
/*     */   private boolean supportsLoadBalancing;
/*     */   static FinalizerShutdownHook finalizerHook;
/*     */   private static ClassAdvisor aop$classAdvisor$aop;
/*     */   protected transient ClassInstanceAdvisor _instanceAdvisor;
/*     */   private static WeakReference aop$MethodInfo_getClientAOPStack7161396531404689859;
/*     */   private static WeakReference aop$MethodInfo_createConnectionDelegate_N_3019492359065420858;
/*     */   private static WeakReference aop$MethodInfo_getTopology7611120934159013485;
/*     */ 
/*     */   private void readObject(ObjectInputStream s)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  82 */     s.defaultReadObject();
/*  83 */     establishCallback();
/*     */   }
/*     */ 
/*     */   public synchronized void establishCallback()
/*     */   {
/*  88 */     log.debug(" Establishing CFCallback\n");
/*     */ 
/*  90 */     for (int server = this.delegates.length - 1; server >= 0; server--)
/*     */     {
/*  92 */       if (trace) log.trace("Closing current callback");
/*  93 */       closeCallback();
/*     */ 
/*  95 */       if (trace) log.trace(new StringBuilder().append("Trying communication on server(").append(server).append(")=").append(this.delegates[server].getServerLocatorURI()).toString());
/*     */       try
/*     */       {
/*  98 */         this.remoting = new JMSRemotingConnection(this.delegates[server].getServerLocatorURI(), true, this.delegates[server].getStrictTck());
/*  99 */         this.remoting.start();
/* 100 */         this.currentDelegate = this.delegates[server];
/* 101 */         if (trace) log.trace("Adding callback");
/* 102 */         addCallback(this.delegates[server]);
/* 103 */         if (trace) log.trace("Getting topology");
/* 104 */         TopologyResult topology = getTopology();
/* 105 */         if (trace) log.trace(new StringBuilder().append("delegates.size = ").append(topology.getDelegates().length).toString());
/* 106 */         addShutdownHook();
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/* 112 */         log.debug(new StringBuilder().append("Server communication to server[").append(server).append("] (").append(this.delegates[server].getServerLocatorURI()).append(") during establishCallback was broken, ").append("trying the next one").toString(), e);
/*     */ 
/* 115 */         if (this.remoting == null)
/*     */           continue;
/* 117 */         this.remoting.stop();
/* 118 */         this.remoting = null;
/* 119 */         this.currentDelegate = null;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addCallback(ClientConnectionFactoryDelegate delegate)
/*     */     throws Throwable
/*     */   {
/* 127 */     this.remoting.getCallbackManager().setConnectionfactoryCallbackHandler(new ConnectionFactoryCallbackHandler(this, this.remoting));
/*     */ 
/* 129 */     ConnectionFactoryAddCallbackRequest request = new ConnectionFactoryAddCallbackRequest(JMSClientVMIdentifier.instance, this.remoting.getRemotingClient().getSessionId(), delegate.getID(), Version.instance().getProviderIncrementingVersion());
/*     */ 
/* 135 */     this.remoting.getRemotingClient().invoke(request, null);
/*     */   }
/*     */ 
/*     */   private void addShutdownHook()
/*     */   {
/* 141 */     finalizerHook.addDelegate(this);
/*     */   }
/*     */ 
/*     */   private void removeCallback() throws Throwable
/*     */   {
/* 146 */     ConnectionFactoryRemoveCallbackRequest request = new ConnectionFactoryRemoveCallbackRequest(JMSClientVMIdentifier.instance, this.remoting.getRemotingClient().getSessionId(), this.currentDelegate.getID(), Version.instance().getProviderIncrementingVersion());
/*     */ 
/* 152 */     this.remoting.getRemotingClient().invoke(request, null);
/*     */   }
/*     */ 
/*     */   protected void finalize() throws Throwable
/*     */   {
/* 157 */     super.finalize();
/* 158 */     closeCallback();
/*     */   }
/*     */ 
/*     */   public void closeCallback()
/*     */   {
/* 164 */     if (this.remoting != null)
/*     */     {
/*     */       try
/*     */       {
/* 168 */         removeCallback();
/*     */       }
/*     */       catch (Throwable warn)
/*     */       {
/* 172 */         log.debug(warn, warn);
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 177 */         this.remoting.removeConnectionListener();
/* 178 */         this.remoting.stop();
/* 179 */         this.currentDelegate = null;
/*     */       }
/*     */       catch (Throwable ignored)
/*     */       {
/*     */       }
/*     */ 
/* 185 */       this.remoting = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public ClientClusteredConnectionFactoryDelegate(String uniqueName, ClientConnectionFactoryDelegate[] delegates, Map failoverMap, LoadBalancingPolicy loadBalancingPolicy, boolean supportsFailover)
/*     */   {
/* 216 */     this.uniqueName = uniqueName;
/* 217 */     this.delegates = delegates;
/* 218 */     this.failoverMap = failoverMap;
/* 219 */     this.loadBalancingPolicy = loadBalancingPolicy;
/* 220 */     this.supportsFailover = supportsFailover;
/*     */   }
/*     */   public synchronized byte[] getClientAOPStack() throws JMSException {
/*     */     MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getClientAOPStack7161396531404689859.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); getClientAOPStack_7161396531404689859 localgetClientAOPStack_7161396531404689859 = new getClientAOPStack_7161396531404689859(localMethodInfo, arrayOfInterceptor);
/*     */       localgetClientAOPStack_7161396531404689859.setTargetObject(this);
/*     */       localgetClientAOPStack_7161396531404689859.typedTargetObject = this;
/*     */       localgetClientAOPStack_7161396531404689859.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (byte[])localgetClientAOPStack_7161396531404689859.invokeNext(); }
/*     */     return org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$getClientAOPStack$aop();
/*     */   }
/*     */   public CreateConnectionResult createConnectionDelegate(String paramString1, String paramString2, int paramInt) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createConnectionDelegate_N_3019492359065420858.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); createConnectionDelegate_N3019492359065420858 localcreateConnectionDelegate_N3019492359065420858 = new createConnectionDelegate_N3019492359065420858(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateConnectionDelegate_N3019492359065420858.arg0 = paramString1;
/*     */       localcreateConnectionDelegate_N3019492359065420858.arg1 = paramString2;
/*     */       localcreateConnectionDelegate_N3019492359065420858.arg2 = paramInt;
/*     */       localcreateConnectionDelegate_N3019492359065420858.setTargetObject(this);
/*     */       localcreateConnectionDelegate_N3019492359065420858.typedTargetObject = this;
/*     */       localcreateConnectionDelegate_N3019492359065420858.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (CreateConnectionResult)localcreateConnectionDelegate_N3019492359065420858.invokeNext(); }
/*     */     return org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$createConnectionDelegate$aop(paramString1, paramString2, paramInt); }
/*     */ 
/* 269 */   public IDBlock getIdBlock(int size) throws JMSException { throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public ClientConnectionFactoryDelegate[] getDelegates()
/*     */   {
/* 276 */     return this.delegates;
/*     */   }
/*     */ 
/*     */   public void setDelegates(ClientConnectionFactoryDelegate[] dels)
/*     */   {
/* 281 */     this.delegates = dels;
/* 282 */     this.loadBalancingPolicy.updateView(dels);
/*     */   }
/*     */ 
/*     */   public Map getFailoverMap()
/*     */   {
/* 287 */     return this.failoverMap;
/*     */   }
/*     */ 
/*     */   public void setFailoverMap(Map failoverMap)
/*     */   {
/* 292 */     this.failoverMap = failoverMap;
/*     */   }
/*     */ 
/*     */   public LoadBalancingPolicy getLoadBalancingPolicy()
/*     */   {
/* 297 */     return this.loadBalancingPolicy;
/*     */   }
/*     */ 
/*     */   public boolean isSupportsFailover()
/*     */   {
/* 302 */     return this.supportsFailover;
/*     */   }
/*     */ 
/*     */   public String getUniqueName()
/*     */   {
/* 307 */     return this.uniqueName;
/*     */   }
/*     */ 
/*     */   public TopologyResult getTopology() throws JMSException {
/*     */     MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getTopology7611120934159013485.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) {
/*     */       if (localClassInstanceAdvisor != null)
/*     */         arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor);
/*     */       getTopology_7611120934159013485 localgetTopology_7611120934159013485 = new getTopology_7611120934159013485(localMethodInfo, arrayOfInterceptor);
/*     */       localgetTopology_7611120934159013485.setTargetObject(this);
/*     */       localgetTopology_7611120934159013485.typedTargetObject = this;
/*     */       localgetTopology_7611120934159013485.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (TopologyResult)localgetTopology_7611120934159013485.invokeNext();
/*     */     }
/*     */     return org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$getTopology$aop();
/*     */   }
/*     */ 
/*     */   public void setSupportsFailover(boolean failover) {
/* 337 */     this.supportsFailover = failover;
/*     */   }
/*     */ 
/*     */   public synchronized void updateFailoverInfo(ClientConnectionFactoryDelegate[] delegates, Map newFailoverMap)
/*     */   {
/* 344 */     log.trace(new StringBuilder().append("Updating failover info ").append(delegates.length).append(" map ").append(newFailoverMap).toString());
/*     */ 
/* 346 */     this.delegates = delegates;
/*     */ 
/* 350 */     this.failoverMap.putAll(newFailoverMap);
/*     */ 
/* 352 */     this.loadBalancingPolicy.updateView(delegates);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 357 */     StringBuffer sb = new StringBuffer("ClusteredConnectionFactoryDelegate[");
/* 358 */     if (this.delegates == null)
/*     */     {
/* 360 */       sb.append("-]");
/*     */     }
/*     */     else
/*     */     {
/* 364 */       sb.append("SIDs={");
/* 365 */       for (int i = 0; i < this.delegates.length; i++)
/*     */       {
/* 367 */         sb.append(this.delegates[i].getServerID());
/* 368 */         if (i >= this.delegates.length - 1)
/*     */           continue;
/* 370 */         sb.append(',');
/*     */       }
/*     */ 
/* 373 */       sb.append("}]");
/*     */     }
/* 375 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  70 */     jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor = AspectManager.instance().getAdvisor(Class.forName("org.jboss.jms.client.delegate.ClientClusteredConnectionFactoryDelegate")); log = Logger.getLogger(ClientClusteredConnectionFactoryDelegate.class);
/*     */ 
/*  72 */     trace = log.isTraceEnabled();
/*     */ 
/* 390 */     finalizerHook = new FinalizerShutdownHook();
/* 391 */     Runtime.getRuntime().addShutdownHook(finalizerHook);
/*     */   }
/*     */ 
/*     */   public Advisor _getAdvisor()
/*     */   {
/*     */     return jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor;
/*     */   }
/*     */ 
/*     */   public InstanceAdvisor _getInstanceAdvisor()
/*     */   {
/*     */     synchronized (this)
/*     */     {
/*     */       if (this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor == null)
/*     */         this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor = new ClassInstanceAdvisor(this);
/*     */       return this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void _setInstanceAdvisor(InstanceAdvisor paramInstanceAdvisor)
/*     */   {
/*     */     synchronized (this)
/*     */     {
/*     */       this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor = ((ClassInstanceAdvisor)paramInstanceAdvisor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized byte[] org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$getClientAOPStack$aop()
/*     */     throws JMSException
/*     */   {
/* 232 */     ClientClusteredConnectionFactoryDelegate.jdField_log_of_type_OrgJbossLoggingLogger.trace("Getting AOP stack, there are " + this.jdField_delegates_of_type_ArrayOfOrgJbossJmsClientDelegateClientConnectionFactoryDelegate.length + " delegates to choose from"); for (int server = 0; server < this.jdField_delegates_of_type_ArrayOfOrgJbossJmsClientDelegateClientConnectionFactoryDelegate.length; server++) try { ConnectionFactoryDelegate aopStackProvider = this.jdField_delegates_of_type_ArrayOfOrgJbossJmsClientDelegateClientConnectionFactoryDelegate[server]; ClientClusteredConnectionFactoryDelegate.jdField_log_of_type_OrgJbossLoggingLogger.trace("getting AOP stack from " + aopStackProvider);
/*     */         MessagingNetworkFailureException e;
/* 232 */         return aopStackProvider.getClientAOPStack(); } catch (MessagingNetworkFailureException localMessagingNetworkFailureException1) { ClientClusteredConnectionFactoryDelegate.jdField_log_of_type_OrgJbossLoggingLogger.debug("Server" + server + " was broken, loading AOP from next delegate", localMessagingNetworkFailureException1); } throw new MessagingNetworkFailureException("Failed to download and/or install client side AOP stack");
/*     */   }
/*     */ 
/*     */   public CreateConnectionResult org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$createConnectionDelegate$aop(String username, String password, int failedNodeID)
/*     */     throws JMSException
/*     */   {
/* 260 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public TopologyResult org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$getTopology$aop()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 316 */       ConnectionFactoryGetTopologyRequest request = new ConnectionFactoryGetTopologyRequest(this.currentDelegate.getID());
/*     */ 
/* 319 */       ConnectionFactoryGetTopologyResponse response = (ConnectionFactoryGetTopologyResponse)this.remoting.getRemotingClient().invoke(request, null);
/*     */ 
/* 322 */       TopologyResult topology = (TopologyResult)response.getResponse();
/*     */ 
/* 324 */       updateFailoverInfo(topology.getDelegates(), topology.getFailoverMap());
/*     */ 
/* 326 */       return topology;
/*     */     }
/*     */     catch (Throwable e) {
/*     */     }
/* 330 */     throw handleThrowable(e);
/*     */   }
/*     */ 
/*     */   static class FinalizerShutdownHook extends Thread
/*     */   {
/*     */     Set<ClientClusteredConnectionFactoryDelegate> delegates;
/*     */ 
/*     */     public FinalizerShutdownHook()
/*     */     {
/* 404 */       this.delegates = Collections.synchronizedSet(new WeakHashSet());
/*     */     }
/*     */ 
/*     */     public void addDelegate(ClientClusteredConnectionFactoryDelegate delegate)
/*     */     {
/* 409 */       this.delegates.add(delegate);
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 414 */       for (ClientClusteredConnectionFactoryDelegate delegate : this.delegates)
/*     */       {
/*     */         try
/*     */         {
/* 418 */           delegate.finalize();
/*     */         }
/*     */         catch (Throwable ignored)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getClientAOPStack_7161396531404689859 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientClusteredConnectionFactoryDelegate typedTargetObject;
/*     */ 
/*     */     public getClientAOPStack_7161396531404689859(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getClientAOPStack_7161396531404689859(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getClientAOPStack_7161396531404689859(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getClientAOPStack_7161396531404689859()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientClusteredConnectionFactoryDelegate.org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$getClientAOPStack$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getClientAOPStack_7161396531404689859 localgetClientAOPStack_7161396531404689859 = new getClientAOPStack_7161396531404689859(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetClientAOPStack_7161396531404689859.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetClientAOPStack_7161396531404689859.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetClientAOPStack_7161396531404689859.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetClientAOPStack_7161396531404689859.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetClientAOPStack_7161396531404689859.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientClusteredConnectionFactoryDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientClusteredConnectionFactoryDelegate;
/*     */       localgetClientAOPStack_7161396531404689859.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localgetClientAOPStack_7161396531404689859;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class createConnectionDelegate_N3019492359065420858 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public String arg0;
/*     */     public String arg1;
/*     */     public int arg2;
/*     */     public ClientClusteredConnectionFactoryDelegate typedTargetObject;
/*     */ 
/*     */     public createConnectionDelegate_N3019492359065420858(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createConnectionDelegate_N3019492359065420858(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createConnectionDelegate_N3019492359065420858(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createConnectionDelegate_N3019492359065420858()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientClusteredConnectionFactoryDelegate.org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$createConnectionDelegate$aop(this.jdField_arg0_of_type_JavaLangString, this.jdField_arg1_of_type_JavaLangString, this.jdField_arg2_of_type_Int);
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject1 = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_JavaLangString = ((String)localObject1);
/*     */       Object localObject2 = paramArrayOfObject[1];
/*     */       this.jdField_arg1_of_type_JavaLangString = ((String)localObject2);
/*     */       this.jdField_arg2_of_type_Int = ((Integer)paramArrayOfObject[2]).intValue();
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[3];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_JavaLangString;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[1] = this.jdField_arg1_of_type_JavaLangString;
/*     */       Integer tmp79_76 = new java/lang/Integer;
/*     */       Integer tmp80_79 = tmp79_76;
/*     */       Integer tmp80_79 = tmp79_76;
/*     */       tmp80_79;
/*     */       this.jdField_arg2_of_type_Int.<init>(tmp80_79);
/*     */       2[tmp80_79] = tmp80_79;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createConnectionDelegate_N3019492359065420858 localcreateConnectionDelegate_N3019492359065420858 = new createConnectionDelegate_N3019492359065420858(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientClusteredConnectionFactoryDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientClusteredConnectionFactoryDelegate;
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_arg0_of_type_JavaLangString = this.jdField_arg0_of_type_JavaLangString;
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_arg1_of_type_JavaLangString = this.jdField_arg1_of_type_JavaLangString;
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_arg2_of_type_Int = this.jdField_arg2_of_type_Int;
/*     */       return localcreateConnectionDelegate_N3019492359065420858;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getTopology_7611120934159013485 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientClusteredConnectionFactoryDelegate typedTargetObject;
/*     */ 
/*     */     public getTopology_7611120934159013485(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getTopology_7611120934159013485(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getTopology_7611120934159013485(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getTopology_7611120934159013485()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientClusteredConnectionFactoryDelegate.org$jboss$jms$client$delegate$ClientClusteredConnectionFactoryDelegate$getTopology$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getTopology_7611120934159013485 localgetTopology_7611120934159013485 = new getTopology_7611120934159013485(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetTopology_7611120934159013485.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetTopology_7611120934159013485.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetTopology_7611120934159013485.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetTopology_7611120934159013485.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetTopology_7611120934159013485.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientClusteredConnectionFactoryDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientClusteredConnectionFactoryDelegate;
/*     */       localgetTopology_7611120934159013485.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localgetTopology_7611120934159013485;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.delegate.ClientClusteredConnectionFactoryDelegate
 * JD-Core Version:    0.6.0
 */