/*     */ package org.jboss.jms.client.delegate;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.lang.ref.Reference;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Method;
/*     */ import javax.jms.ConnectionMetaData;
/*     */ import javax.jms.Destination;
/*     */ import javax.jms.ExceptionListener;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.ServerSessionPool;
/*     */ import org.jboss.aop.Advised;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.ClassInstanceAdvisor;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.JoinPointInfo;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.instrument.Untransformable;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.InvocationBase;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.jms.client.FailoverListener;
/*     */ import org.jboss.jms.client.JBossConnectionConsumer;
/*     */ import org.jboss.jms.client.remoting.JMSRemotingConnection;
/*     */ import org.jboss.jms.client.state.ConnectionState;
/*     */ import org.jboss.jms.client.state.HierarchicalState;
/*     */ import org.jboss.jms.delegate.ConnectionDelegate;
/*     */ import org.jboss.jms.delegate.IDBlock;
/*     */ import org.jboss.jms.delegate.SessionDelegate;
/*     */ import org.jboss.jms.tx.MessagingXid;
/*     */ import org.jboss.jms.tx.ResourceManagerFactory;
/*     */ import org.jboss.jms.tx.TransactionRequest;
/*     */ import org.jboss.jms.wireformat.CloseRequest;
/*     */ import org.jboss.jms.wireformat.ClosingRequest;
/*     */ import org.jboss.jms.wireformat.ConnectionCreateSessionDelegateRequest;
/*     */ import org.jboss.jms.wireformat.ConnectionGetClientIDRequest;
/*     */ import org.jboss.jms.wireformat.ConnectionGetIDBlockRequest;
/*     */ import org.jboss.jms.wireformat.ConnectionGetPreparedTransactionsRequest;
/*     */ import org.jboss.jms.wireformat.ConnectionSendTransactionRequest;
/*     */ import org.jboss.jms.wireformat.ConnectionSetClientIDRequest;
/*     */ import org.jboss.jms.wireformat.ConnectionStartRequest;
/*     */ import org.jboss.jms.wireformat.ConnectionStopRequest;
/*     */ import org.jboss.jms.wireformat.RequestSupport;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.util.Version;
/*     */ 
/*     */ public class ClientConnectionDelegate extends DelegateSupport
/*     */   implements ConnectionDelegate, Advised
/*     */ {
/*     */   private static final long serialVersionUID = -5485083713058725777L;
/*     */   private static final Logger log;
/*     */   private int serverID;
/*     */   private transient JMSRemotingConnection remotingConnection;
/*     */   private transient Version versionToUse;
/*     */   private static ClassAdvisor aop$classAdvisor$aop;
/*     */   protected transient ClassInstanceAdvisor _instanceAdvisor;
/*     */   private static WeakReference aop$MethodInfo_close_N_4742752445160157748;
/*     */   private static WeakReference aop$MethodInfo_closing2473194355759371067;
/*     */   private static WeakReference aop$MethodInfo_createConnectionConsumer7915292773999367429;
/*     */   private static WeakReference aop$MethodInfo_createSessionDelegate6052335267724906805;
/*     */   private static WeakReference aop$MethodInfo_getClientID_N_1471463430436177237;
/*     */   private static WeakReference aop$MethodInfo_getConnectionMetaData_N_7487289701255244996;
/*     */   private static WeakReference aop$MethodInfo_getExceptionListener_N_4742818582415724694;
/*     */   private static WeakReference aop$MethodInfo_sendTransaction_N_3268650789275322226;
/*     */   private static WeakReference aop$MethodInfo_setClientID_N_1479100880614063379;
/*     */   private static WeakReference aop$MethodInfo_setExceptionListener8089029433030319178;
/*     */   private static WeakReference aop$MethodInfo_start_N_8025343665958530775;
/*     */   private static WeakReference aop$MethodInfo_startAfterFailover4824875258671238473;
/*     */   private static WeakReference aop$MethodInfo_stop_N_2856118408655404442;
/*     */   private static WeakReference aop$MethodInfo_getPreparedTransactions8083036720366990761;
/*     */   private static WeakReference aop$MethodInfo_registerFailoverListener5217231757412585200;
/*     */   private static WeakReference aop$MethodInfo_unregisterFailoverListener_N_7288918302650237719;
/*     */   private static WeakReference aop$MethodInfo_getIdBlock7224852188662164551;
/*     */ 
/*     */   public ClientConnectionDelegate(String objectID, int serverID)
/*     */   {
/*  91 */     super(objectID);
/*     */ 
/*  93 */     this.serverID = serverID;
/*     */   }
/*     */ 
/*     */   public ClientConnectionDelegate()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void synchronizeWith(DelegateSupport nd)
/*     */     throws Exception
/*     */   {
/* 104 */     log.trace(this + " synchronizing with " + nd);
/*     */ 
/* 106 */     super.synchronizeWith(nd);
/*     */ 
/* 108 */     ClientConnectionDelegate newDelegate = (ClientConnectionDelegate)nd;
/*     */ 
/* 116 */     ConnectionState thisState = (ConnectionState)this.state;
/*     */ 
/* 118 */     if (thisState.getClientID() != null)
/*     */     {
/* 120 */       newDelegate.setClientID(thisState.getClientID());
/*     */     }
/*     */ 
/* 125 */     this.state.synchronizeWith(newDelegate.getState());
/*     */ 
/* 129 */     this.remotingConnection = newDelegate.getRemotingConnection();
/* 130 */     this.versionToUse = newDelegate.getVersionToUse();
/*     */ 
/* 133 */     ResourceManagerFactory.instance.handleFailover(this.serverID, newDelegate.getServerID());
/*     */ 
/* 135 */     this.client = thisState.getRemotingConnection().getRemotingClient();
/*     */ 
/* 137 */     this.serverID = newDelegate.getServerID();
/*     */   }
/*     */ 
/*     */   public void setState(HierarchicalState state)
/*     */   {
/* 142 */     super.setState(state);
/*     */ 
/* 144 */     this.client = ((ConnectionState)state).getRemotingConnection().getRemotingClient(); } 
/*     */   public void close() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_close_N_4742752445160157748.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); close_N4742752445160157748 localclose_N4742752445160157748 = new close_N4742752445160157748(localMethodInfo, arrayOfInterceptor);
/*     */       localclose_N4742752445160157748.setTargetObject(this);
/*     */       localclose_N4742752445160157748.typedTargetObject = this;
/*     */       localclose_N4742752445160157748.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localclose_N4742752445160157748.invokeNext(); } else { org$jboss$jms$client$delegate$ClientConnectionDelegate$close$aop(); }  } 
/*     */   public long closing(long paramLong) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_closing2473194355759371067.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); closing_2473194355759371067 localclosing_2473194355759371067 = new closing_2473194355759371067(localMethodInfo, arrayOfInterceptor);
/*     */       localclosing_2473194355759371067.arg0 = paramLong;
/*     */       localclosing_2473194355759371067.setTargetObject(this);
/*     */       localclosing_2473194355759371067.typedTargetObject = this;
/*     */       localclosing_2473194355759371067.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return ((Long)localclosing_2473194355759371067.invokeNext()).longValue(); } return org$jboss$jms$client$delegate$ClientConnectionDelegate$closing$aop(paramLong); } 
/*     */   public JBossConnectionConsumer createConnectionConsumer(Destination paramDestination, String paramString1, String paramString2, ServerSessionPool paramServerSessionPool, int paramInt) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createConnectionConsumer7915292773999367429.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); createConnectionConsumer_7915292773999367429 localcreateConnectionConsumer_7915292773999367429 = new createConnectionConsumer_7915292773999367429(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateConnectionConsumer_7915292773999367429.arg0 = paramDestination;
/*     */       localcreateConnectionConsumer_7915292773999367429.arg1 = paramString1;
/*     */       localcreateConnectionConsumer_7915292773999367429.arg2 = paramString2;
/*     */       localcreateConnectionConsumer_7915292773999367429.arg3 = paramServerSessionPool;
/*     */       localcreateConnectionConsumer_7915292773999367429.arg4 = paramInt;
/*     */       localcreateConnectionConsumer_7915292773999367429.setTargetObject(this);
/*     */       localcreateConnectionConsumer_7915292773999367429.typedTargetObject = this;
/*     */       localcreateConnectionConsumer_7915292773999367429.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (JBossConnectionConsumer)localcreateConnectionConsumer_7915292773999367429.invokeNext(); } return org$jboss$jms$client$delegate$ClientConnectionDelegate$createConnectionConsumer$aop(paramDestination, paramString1, paramString2, paramServerSessionPool, paramInt); } 
/*     */   public SessionDelegate createSessionDelegate(boolean paramBoolean1, int paramInt, boolean paramBoolean2) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createSessionDelegate6052335267724906805.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); createSessionDelegate_6052335267724906805 localcreateSessionDelegate_6052335267724906805 = new createSessionDelegate_6052335267724906805(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateSessionDelegate_6052335267724906805.arg0 = paramBoolean1;
/*     */       localcreateSessionDelegate_6052335267724906805.arg1 = paramInt;
/*     */       localcreateSessionDelegate_6052335267724906805.arg2 = paramBoolean2;
/*     */       localcreateSessionDelegate_6052335267724906805.setTargetObject(this);
/*     */       localcreateSessionDelegate_6052335267724906805.typedTargetObject = this;
/*     */       localcreateSessionDelegate_6052335267724906805.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (SessionDelegate)localcreateSessionDelegate_6052335267724906805.invokeNext(); } return org$jboss$jms$client$delegate$ClientConnectionDelegate$createSessionDelegate$aop(paramBoolean1, paramInt, paramBoolean2); } 
/*     */   public String getClientID() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getClientID_N_1471463430436177237.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); getClientID_N1471463430436177237 localgetClientID_N1471463430436177237 = new getClientID_N1471463430436177237(localMethodInfo, arrayOfInterceptor);
/*     */       localgetClientID_N1471463430436177237.setTargetObject(this);
/*     */       localgetClientID_N1471463430436177237.typedTargetObject = this;
/*     */       localgetClientID_N1471463430436177237.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (String)localgetClientID_N1471463430436177237.invokeNext(); } return org$jboss$jms$client$delegate$ClientConnectionDelegate$getClientID$aop(); } 
/*     */   public ConnectionMetaData getConnectionMetaData() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getConnectionMetaData_N_7487289701255244996.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); getConnectionMetaData_N7487289701255244996 localgetConnectionMetaData_N7487289701255244996 = new getConnectionMetaData_N7487289701255244996(localMethodInfo, arrayOfInterceptor);
/*     */       localgetConnectionMetaData_N7487289701255244996.setTargetObject(this);
/*     */       localgetConnectionMetaData_N7487289701255244996.typedTargetObject = this;
/*     */       localgetConnectionMetaData_N7487289701255244996.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (ConnectionMetaData)localgetConnectionMetaData_N7487289701255244996.invokeNext(); } return org$jboss$jms$client$delegate$ClientConnectionDelegate$getConnectionMetaData$aop(); } 
/*     */   public ExceptionListener getExceptionListener() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getExceptionListener_N_4742818582415724694.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); getExceptionListener_N4742818582415724694 localgetExceptionListener_N4742818582415724694 = new getExceptionListener_N4742818582415724694(localMethodInfo, arrayOfInterceptor);
/*     */       localgetExceptionListener_N4742818582415724694.setTargetObject(this);
/*     */       localgetExceptionListener_N4742818582415724694.typedTargetObject = this;
/*     */       localgetExceptionListener_N4742818582415724694.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (ExceptionListener)localgetExceptionListener_N4742818582415724694.invokeNext(); } return org$jboss$jms$client$delegate$ClientConnectionDelegate$getExceptionListener$aop(); } 
/*     */   public void sendTransaction(TransactionRequest paramTransactionRequest, boolean paramBoolean) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_sendTransaction_N_3268650789275322226.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); sendTransaction_N3268650789275322226 localsendTransaction_N3268650789275322226 = new sendTransaction_N3268650789275322226(localMethodInfo, arrayOfInterceptor);
/*     */       localsendTransaction_N3268650789275322226.arg0 = paramTransactionRequest;
/*     */       localsendTransaction_N3268650789275322226.arg1 = paramBoolean;
/*     */       localsendTransaction_N3268650789275322226.setTargetObject(this);
/*     */       localsendTransaction_N3268650789275322226.typedTargetObject = this;
/*     */       localsendTransaction_N3268650789275322226.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localsendTransaction_N3268650789275322226.invokeNext(); } else { org$jboss$jms$client$delegate$ClientConnectionDelegate$sendTransaction$aop(paramTransactionRequest, paramBoolean); }  } 
/*     */   public void setClientID(String paramString) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_setClientID_N_1479100880614063379.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); setClientID_N1479100880614063379 localsetClientID_N1479100880614063379 = new setClientID_N1479100880614063379(localMethodInfo, arrayOfInterceptor);
/*     */       localsetClientID_N1479100880614063379.arg0 = paramString;
/*     */       localsetClientID_N1479100880614063379.setTargetObject(this);
/*     */       localsetClientID_N1479100880614063379.typedTargetObject = this;
/*     */       localsetClientID_N1479100880614063379.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localsetClientID_N1479100880614063379.invokeNext(); } else { org$jboss$jms$client$delegate$ClientConnectionDelegate$setClientID$aop(paramString); }  } 
/*     */   public void setExceptionListener(ExceptionListener paramExceptionListener) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_setExceptionListener8089029433030319178.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); setExceptionListener_8089029433030319178 localsetExceptionListener_8089029433030319178 = new setExceptionListener_8089029433030319178(localMethodInfo, arrayOfInterceptor);
/*     */       localsetExceptionListener_8089029433030319178.arg0 = paramExceptionListener;
/*     */       localsetExceptionListener_8089029433030319178.setTargetObject(this);
/*     */       localsetExceptionListener_8089029433030319178.typedTargetObject = this;
/*     */       localsetExceptionListener_8089029433030319178.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localsetExceptionListener_8089029433030319178.invokeNext(); } else { org$jboss$jms$client$delegate$ClientConnectionDelegate$setExceptionListener$aop(paramExceptionListener); }  } 
/*     */   public void start() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_start_N_8025343665958530775.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); start_N8025343665958530775 localstart_N8025343665958530775 = new start_N8025343665958530775(localMethodInfo, arrayOfInterceptor);
/*     */       localstart_N8025343665958530775.setTargetObject(this);
/*     */       localstart_N8025343665958530775.typedTargetObject = this;
/*     */       localstart_N8025343665958530775.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localstart_N8025343665958530775.invokeNext(); } else { org$jboss$jms$client$delegate$ClientConnectionDelegate$start$aop(); }  } 
/*     */   public void startAfterFailover() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_startAfterFailover4824875258671238473.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); startAfterFailover_4824875258671238473 localstartAfterFailover_4824875258671238473 = new startAfterFailover_4824875258671238473(localMethodInfo, arrayOfInterceptor);
/*     */       localstartAfterFailover_4824875258671238473.setTargetObject(this);
/*     */       localstartAfterFailover_4824875258671238473.typedTargetObject = this;
/*     */       localstartAfterFailover_4824875258671238473.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localstartAfterFailover_4824875258671238473.invokeNext(); } else { org$jboss$jms$client$delegate$ClientConnectionDelegate$startAfterFailover$aop(); }  } 
/*     */   public void stop() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_stop_N_2856118408655404442.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); stop_N2856118408655404442 localstop_N2856118408655404442 = new stop_N2856118408655404442(localMethodInfo, arrayOfInterceptor);
/*     */       localstop_N2856118408655404442.setTargetObject(this);
/*     */       localstop_N2856118408655404442.typedTargetObject = this;
/*     */       localstop_N2856118408655404442.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localstop_N2856118408655404442.invokeNext(); } else { org$jboss$jms$client$delegate$ClientConnectionDelegate$stop$aop(); }  } 
/*     */   public MessagingXid[] getPreparedTransactions() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getPreparedTransactions8083036720366990761.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); getPreparedTransactions_8083036720366990761 localgetPreparedTransactions_8083036720366990761 = new getPreparedTransactions_8083036720366990761(localMethodInfo, arrayOfInterceptor);
/*     */       localgetPreparedTransactions_8083036720366990761.setTargetObject(this);
/*     */       localgetPreparedTransactions_8083036720366990761.typedTargetObject = this;
/*     */       localgetPreparedTransactions_8083036720366990761.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (MessagingXid[])localgetPreparedTransactions_8083036720366990761.invokeNext(); } return org$jboss$jms$client$delegate$ClientConnectionDelegate$getPreparedTransactions$aop(); } 
/*     */   public void registerFailoverListener(FailoverListener paramFailoverListener) { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_registerFailoverListener5217231757412585200.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); registerFailoverListener_5217231757412585200 localregisterFailoverListener_5217231757412585200 = new registerFailoverListener_5217231757412585200(localMethodInfo, arrayOfInterceptor);
/*     */       localregisterFailoverListener_5217231757412585200.arg0 = paramFailoverListener;
/*     */       localregisterFailoverListener_5217231757412585200.setTargetObject(this);
/*     */       localregisterFailoverListener_5217231757412585200.typedTargetObject = this;
/*     */       localregisterFailoverListener_5217231757412585200.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localregisterFailoverListener_5217231757412585200.invokeNext(); } else { org$jboss$jms$client$delegate$ClientConnectionDelegate$registerFailoverListener$aop(paramFailoverListener); }  } 
/*     */   public boolean unregisterFailoverListener(FailoverListener paramFailoverListener) { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_unregisterFailoverListener_N_7288918302650237719.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); unregisterFailoverListener_N7288918302650237719 localunregisterFailoverListener_N7288918302650237719 = new unregisterFailoverListener_N7288918302650237719(localMethodInfo, arrayOfInterceptor);
/*     */       localunregisterFailoverListener_N7288918302650237719.arg0 = paramFailoverListener;
/*     */       localunregisterFailoverListener_N7288918302650237719.setTargetObject(this);
/*     */       localunregisterFailoverListener_N7288918302650237719.typedTargetObject = this;
/*     */       localunregisterFailoverListener_N7288918302650237719.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return ((Boolean)localunregisterFailoverListener_N7288918302650237719.invokeNext()).booleanValue(); } return org$jboss$jms$client$delegate$ClientConnectionDelegate$unregisterFailoverListener$aop(paramFailoverListener); } 
/*     */   public IDBlock getIdBlock(int paramInt) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getIdBlock7224852188662164551.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); getIdBlock_7224852188662164551 localgetIdBlock_7224852188662164551 = new getIdBlock_7224852188662164551(localMethodInfo, arrayOfInterceptor);
/*     */       localgetIdBlock_7224852188662164551.arg0 = paramInt;
/*     */       localgetIdBlock_7224852188662164551.setTargetObject(this);
/*     */       localgetIdBlock_7224852188662164551.typedTargetObject = this;
/*     */       localgetIdBlock_7224852188662164551.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (IDBlock)localgetIdBlock_7224852188662164551.invokeNext(); } return org$jboss$jms$client$delegate$ClientConnectionDelegate$getIdBlock$aop(paramInt); } 
/* 295 */   public void setRemotingConnection(JMSRemotingConnection conn) { this.remotingConnection = conn;
/*     */   }
/*     */ 
/*     */   public JMSRemotingConnection getRemotingConnection()
/*     */   {
/* 300 */     return this.remotingConnection;
/*     */   }
/*     */ 
/*     */   public int getServerID()
/*     */   {
/* 305 */     return this.serverID;
/*     */   }
/*     */ 
/*     */   public Version getVersionToUse()
/*     */   {
/* 310 */     return this.versionToUse;
/*     */   }
/*     */ 
/*     */   public void setVersionToUse(Version versionToUse)
/*     */   {
/* 315 */     this.versionToUse = versionToUse;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 320 */     return "ConnectionDelegate[" + System.identityHashCode(this) + ", ID=" + this.id + ", SID=" + this.serverID + "]";
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in)
/*     */     throws Exception
/*     */   {
/* 330 */     super.read(in);
/*     */ 
/* 332 */     this.serverID = in.readInt();
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out) throws Exception
/*     */   {
/* 337 */     super.write(out);
/*     */ 
/* 339 */     out.writeInt(this.serverID);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  75 */     jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor = AspectManager.instance().getAdvisor(Class.forName("org.jboss.jms.client.delegate.ClientConnectionDelegate")); log = Logger.getLogger(ClientConnectionDelegate.class);
/*     */   }
/*     */ 
/*     */   public Advisor _getAdvisor()
/*     */   {
/*     */     return jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor;
/*     */   }
/*     */ 
/*     */   public InstanceAdvisor _getInstanceAdvisor()
/*     */   {
/*     */     synchronized (this)
/*     */     {
/*     */       if (this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor == null)
/*     */         this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor = new ClassInstanceAdvisor(this);
/*     */       return this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void _setInstanceAdvisor(InstanceAdvisor paramInstanceAdvisor)
/*     */   {
/*     */     synchronized (this)
/*     */     {
/*     */       this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor = ((ClassInstanceAdvisor)paramInstanceAdvisor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientConnectionDelegate$close$aop()
/*     */     throws JMSException
/*     */   {
/* 151 */     RequestSupport req = new CloseRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte);
/*     */ 
/* 153 */     doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public long org$jboss$jms$client$delegate$ClientConnectionDelegate$closing$aop(long sequence) throws JMSException
/*     */   {
/* 158 */     RequestSupport req = new ClosingRequest(sequence, this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte);
/*     */ 
/* 160 */     return ((Long)doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req)).longValue();
/*     */   }
/*     */ 
/*     */   public JBossConnectionConsumer org$jboss$jms$client$delegate$ClientConnectionDelegate$createConnectionConsumer$aop(Destination dest, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages)
/*     */     throws JMSException
/*     */   {
/* 175 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public SessionDelegate org$jboss$jms$client$delegate$ClientConnectionDelegate$createSessionDelegate$aop(boolean transacted, int acknowledgmentMode, boolean isXA)
/*     */     throws JMSException
/*     */   {
/* 182 */     RequestSupport req = new ConnectionCreateSessionDelegateRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, transacted, acknowledgmentMode, isXA);
/*     */ 
/* 186 */     return (SessionDelegate)doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public String org$jboss$jms$client$delegate$ClientConnectionDelegate$getClientID$aop()
/*     */     throws JMSException
/*     */   {
/* 192 */     RequestSupport req = new ConnectionGetClientIDRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte);
/*     */ 
/* 194 */     return (String)doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public ConnectionMetaData org$jboss$jms$client$delegate$ClientConnectionDelegate$getConnectionMetaData$aop()
/*     */     throws JMSException
/*     */   {
/* 203 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public ExceptionListener org$jboss$jms$client$delegate$ClientConnectionDelegate$getExceptionListener$aop()
/*     */     throws JMSException
/*     */   {
/* 212 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientConnectionDelegate$sendTransaction$aop(TransactionRequest request, boolean checkForDuplicates)
/*     */     throws JMSException
/*     */   {
/* 218 */     RequestSupport req = new ConnectionSendTransactionRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, request, checkForDuplicates);
/*     */ 
/* 221 */     doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientConnectionDelegate$setClientID$aop(String clientID) throws JMSException
/*     */   {
/* 226 */     RequestSupport req = new ConnectionSetClientIDRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, clientID);
/*     */ 
/* 228 */     doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientConnectionDelegate$setExceptionListener$aop(ExceptionListener listener)
/*     */     throws JMSException
/*     */   {
/* 237 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientConnectionDelegate$start$aop() throws JMSException
/*     */   {
/* 242 */     RequestSupport req = new ConnectionStartRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte);
/*     */ 
/* 244 */     doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientConnectionDelegate$startAfterFailover$aop() throws JMSException
/*     */   {
/* 249 */     RequestSupport req = new ConnectionStartRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte);
/*     */ 
/* 251 */     doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientConnectionDelegate$stop$aop() throws JMSException
/*     */   {
/* 256 */     RequestSupport req = new ConnectionStopRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte);
/*     */ 
/* 258 */     doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public MessagingXid[] org$jboss$jms$client$delegate$ClientConnectionDelegate$getPreparedTransactions$aop() throws JMSException
/*     */   {
/* 263 */     RequestSupport req = new ConnectionGetPreparedTransactionsRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte);
/*     */ 
/* 265 */     return (MessagingXid[])(MessagingXid[])doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientConnectionDelegate$registerFailoverListener$aop(FailoverListener l)
/*     */   {
/* 273 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public boolean org$jboss$jms$client$delegate$ClientConnectionDelegate$unregisterFailoverListener$aop(FailoverListener l)
/*     */   {
/* 281 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public IDBlock org$jboss$jms$client$delegate$ClientConnectionDelegate$getIdBlock$aop(int size) throws JMSException
/*     */   {
/* 286 */     RequestSupport req = new ConnectionGetIDBlockRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, size);
/*     */ 
/* 288 */     return (IDBlock)doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public static class close_N4742752445160157748 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public close_N4742752445160157748(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public close_N4742752445160157748(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public close_N4742752445160157748(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public close_N4742752445160157748()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate.org$jboss$jms$client$delegate$ClientConnectionDelegate$close$aop();
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       close_N4742752445160157748 localclose_N4742752445160157748 = new close_N4742752445160157748(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localclose_N4742752445160157748.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localclose_N4742752445160157748.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localclose_N4742752445160157748.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localclose_N4742752445160157748.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localclose_N4742752445160157748.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localclose_N4742752445160157748.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localclose_N4742752445160157748;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class closing_2473194355759371067 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public long arg0;
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public closing_2473194355759371067(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public closing_2473194355759371067(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public closing_2473194355759371067(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public closing_2473194355759371067()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       this.jdField_arg0_of_type_Long = ((Long)paramArrayOfObject[0]).longValue();
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       Long tmp59_56 = new java/lang/Long;
/*     */       Long tmp60_59 = tmp59_56;
/*     */       Long tmp60_59 = tmp59_56;
/*     */       tmp60_59;
/*     */       this.jdField_arg0_of_type_Long.<init>(tmp60_59);
/*     */       tmp60_59[tmp60_59] = 0;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       closing_2473194355759371067 localclosing_2473194355759371067 = new closing_2473194355759371067(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localclosing_2473194355759371067.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localclosing_2473194355759371067.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localclosing_2473194355759371067.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localclosing_2473194355759371067.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localclosing_2473194355759371067.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localclosing_2473194355759371067.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localclosing_2473194355759371067.jdField_arg0_of_type_Long = this.jdField_arg0_of_type_Long;
/*     */       return localclosing_2473194355759371067;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class createConnectionConsumer_7915292773999367429 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public Destination arg0;
/*     */     public String arg1;
/*     */     public String arg2;
/*     */     public ServerSessionPool arg3;
/*     */     public int arg4;
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public createConnectionConsumer_7915292773999367429(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createConnectionConsumer_7915292773999367429(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createConnectionConsumer_7915292773999367429(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createConnectionConsumer_7915292773999367429()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate.org$jboss$jms$client$delegate$ClientConnectionDelegate$createConnectionConsumer$aop(this.jdField_arg0_of_type_JavaxJmsDestination, this.jdField_arg1_of_type_JavaLangString, this.jdField_arg2_of_type_JavaLangString, this.jdField_arg3_of_type_JavaxJmsServerSessionPool, this.jdField_arg4_of_type_Int);
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject1 = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_JavaxJmsDestination = ((Destination)localObject1);
/*     */       Object localObject2 = paramArrayOfObject[1];
/*     */       this.jdField_arg1_of_type_JavaLangString = ((String)localObject2);
/*     */       Object localObject3 = paramArrayOfObject[2];
/*     */       this.jdField_arg2_of_type_JavaLangString = ((String)localObject3);
/*     */       Object localObject4 = paramArrayOfObject[3];
/*     */       this.jdField_arg3_of_type_JavaxJmsServerSessionPool = ((ServerSessionPool)localObject4);
/*     */       this.jdField_arg4_of_type_Int = ((Integer)paramArrayOfObject[4]).intValue();
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[5];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_JavaxJmsDestination;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[1] = this.jdField_arg1_of_type_JavaLangString;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[2] = this.jdField_arg2_of_type_JavaLangString;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[3] = this.jdField_arg3_of_type_JavaxJmsServerSessionPool;
/*     */       Integer tmp99_96 = new java/lang/Integer;
/*     */       Integer tmp100_99 = tmp99_96;
/*     */       Integer tmp100_99 = tmp99_96;
/*     */       tmp100_99;
/*     */       this.jdField_arg4_of_type_Int.<init>(tmp100_99);
/*     */       4[tmp100_99] = tmp100_99;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createConnectionConsumer_7915292773999367429 localcreateConnectionConsumer_7915292773999367429 = new createConnectionConsumer_7915292773999367429(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateConnectionConsumer_7915292773999367429.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateConnectionConsumer_7915292773999367429.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateConnectionConsumer_7915292773999367429.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateConnectionConsumer_7915292773999367429.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateConnectionConsumer_7915292773999367429.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localcreateConnectionConsumer_7915292773999367429.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localcreateConnectionConsumer_7915292773999367429.jdField_arg0_of_type_JavaxJmsDestination = this.jdField_arg0_of_type_JavaxJmsDestination;
/*     */       localcreateConnectionConsumer_7915292773999367429.jdField_arg1_of_type_JavaLangString = this.jdField_arg1_of_type_JavaLangString;
/*     */       localcreateConnectionConsumer_7915292773999367429.jdField_arg2_of_type_JavaLangString = this.jdField_arg2_of_type_JavaLangString;
/*     */       localcreateConnectionConsumer_7915292773999367429.jdField_arg3_of_type_JavaxJmsServerSessionPool = this.jdField_arg3_of_type_JavaxJmsServerSessionPool;
/*     */       localcreateConnectionConsumer_7915292773999367429.jdField_arg4_of_type_Int = this.jdField_arg4_of_type_Int;
/*     */       return localcreateConnectionConsumer_7915292773999367429;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class createSessionDelegate_6052335267724906805 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public boolean arg0;
/*     */     public int arg1;
/*     */     public boolean arg2;
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public createSessionDelegate_6052335267724906805(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createSessionDelegate_6052335267724906805(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createSessionDelegate_6052335267724906805(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createSessionDelegate_6052335267724906805()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate.org$jboss$jms$client$delegate$ClientConnectionDelegate$createSessionDelegate$aop(this.jdField_arg0_of_type_Boolean, this.jdField_arg1_of_type_Int, this.jdField_arg2_of_type_Boolean);
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       this.jdField_arg0_of_type_Boolean = ((Boolean)paramArrayOfObject[0]).booleanValue();
/*     */       this.jdField_arg1_of_type_Int = ((Integer)paramArrayOfObject[1]).intValue();
/*     */       this.jdField_arg2_of_type_Boolean = ((Boolean)paramArrayOfObject[2]).booleanValue();
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[3];
/*     */       Boolean tmp59_56 = new java/lang/Boolean;
/*     */       Boolean tmp60_59 = tmp59_56;
/*     */       Boolean tmp60_59 = tmp59_56;
/*     */       tmp60_59;
/*     */       this.jdField_arg0_of_type_Boolean.<init>(tmp60_59);
/*     */       0[tmp60_59] = tmp60_59;
/*     */       Integer tmp78_75 = new java/lang/Integer;
/*     */       Integer tmp79_78 = tmp78_75;
/*     */       Integer tmp79_78 = tmp78_75;
/*     */       tmp79_78;
/*     */       this.jdField_arg1_of_type_Int.<init>(tmp79_78);
/*     */       1[tmp79_78] = tmp79_78;
/*     */       Boolean tmp97_94 = new java/lang/Boolean;
/*     */       Boolean tmp98_97 = tmp97_94;
/*     */       Boolean tmp98_97 = tmp97_94;
/*     */       tmp98_97;
/*     */       this.jdField_arg2_of_type_Boolean.<init>(tmp98_97);
/*     */       2[tmp98_97] = tmp98_97;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createSessionDelegate_6052335267724906805 localcreateSessionDelegate_6052335267724906805 = new createSessionDelegate_6052335267724906805(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateSessionDelegate_6052335267724906805.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateSessionDelegate_6052335267724906805.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateSessionDelegate_6052335267724906805.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateSessionDelegate_6052335267724906805.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateSessionDelegate_6052335267724906805.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localcreateSessionDelegate_6052335267724906805.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localcreateSessionDelegate_6052335267724906805.jdField_arg0_of_type_Boolean = this.jdField_arg0_of_type_Boolean;
/*     */       localcreateSessionDelegate_6052335267724906805.jdField_arg1_of_type_Int = this.jdField_arg1_of_type_Int;
/*     */       localcreateSessionDelegate_6052335267724906805.jdField_arg2_of_type_Boolean = this.jdField_arg2_of_type_Boolean;
/*     */       return localcreateSessionDelegate_6052335267724906805;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getClientID_N1471463430436177237 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public getClientID_N1471463430436177237(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getClientID_N1471463430436177237(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getClientID_N1471463430436177237(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getClientID_N1471463430436177237()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate.org$jboss$jms$client$delegate$ClientConnectionDelegate$getClientID$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getClientID_N1471463430436177237 localgetClientID_N1471463430436177237 = new getClientID_N1471463430436177237(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetClientID_N1471463430436177237.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetClientID_N1471463430436177237.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetClientID_N1471463430436177237.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetClientID_N1471463430436177237.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetClientID_N1471463430436177237.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localgetClientID_N1471463430436177237.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localgetClientID_N1471463430436177237;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getConnectionMetaData_N7487289701255244996 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public getConnectionMetaData_N7487289701255244996(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getConnectionMetaData_N7487289701255244996(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getConnectionMetaData_N7487289701255244996(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getConnectionMetaData_N7487289701255244996()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate.org$jboss$jms$client$delegate$ClientConnectionDelegate$getConnectionMetaData$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getConnectionMetaData_N7487289701255244996 localgetConnectionMetaData_N7487289701255244996 = new getConnectionMetaData_N7487289701255244996(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetConnectionMetaData_N7487289701255244996.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetConnectionMetaData_N7487289701255244996.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetConnectionMetaData_N7487289701255244996.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetConnectionMetaData_N7487289701255244996.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetConnectionMetaData_N7487289701255244996.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localgetConnectionMetaData_N7487289701255244996.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localgetConnectionMetaData_N7487289701255244996;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getExceptionListener_N4742818582415724694 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public getExceptionListener_N4742818582415724694(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getExceptionListener_N4742818582415724694(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getExceptionListener_N4742818582415724694(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getExceptionListener_N4742818582415724694()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate.org$jboss$jms$client$delegate$ClientConnectionDelegate$getExceptionListener$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getExceptionListener_N4742818582415724694 localgetExceptionListener_N4742818582415724694 = new getExceptionListener_N4742818582415724694(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetExceptionListener_N4742818582415724694.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetExceptionListener_N4742818582415724694.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetExceptionListener_N4742818582415724694.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetExceptionListener_N4742818582415724694.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetExceptionListener_N4742818582415724694.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localgetExceptionListener_N4742818582415724694.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localgetExceptionListener_N4742818582415724694;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class sendTransaction_N3268650789275322226 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public TransactionRequest arg0;
/*     */     public boolean arg1;
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public sendTransaction_N3268650789275322226(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public sendTransaction_N3268650789275322226(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public sendTransaction_N3268650789275322226(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public sendTransaction_N3268650789275322226()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate.org$jboss$jms$client$delegate$ClientConnectionDelegate$sendTransaction$aop(this.jdField_arg0_of_type_OrgJbossJmsTxTransactionRequest, this.jdField_arg1_of_type_Boolean);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_OrgJbossJmsTxTransactionRequest = ((TransactionRequest)localObject);
/*     */       this.jdField_arg1_of_type_Boolean = ((Boolean)paramArrayOfObject[1]).booleanValue();
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[2];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_OrgJbossJmsTxTransactionRequest;
/*     */       Boolean tmp69_66 = new java/lang/Boolean;
/*     */       Boolean tmp70_69 = tmp69_66;
/*     */       Boolean tmp70_69 = tmp69_66;
/*     */       tmp70_69;
/*     */       this.jdField_arg1_of_type_Boolean.<init>(tmp70_69);
/*     */       1[tmp70_69] = tmp70_69;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       sendTransaction_N3268650789275322226 localsendTransaction_N3268650789275322226 = new sendTransaction_N3268650789275322226(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localsendTransaction_N3268650789275322226.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localsendTransaction_N3268650789275322226.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localsendTransaction_N3268650789275322226.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localsendTransaction_N3268650789275322226.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localsendTransaction_N3268650789275322226.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localsendTransaction_N3268650789275322226.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localsendTransaction_N3268650789275322226.jdField_arg0_of_type_OrgJbossJmsTxTransactionRequest = this.jdField_arg0_of_type_OrgJbossJmsTxTransactionRequest;
/*     */       localsendTransaction_N3268650789275322226.jdField_arg1_of_type_Boolean = this.jdField_arg1_of_type_Boolean;
/*     */       return localsendTransaction_N3268650789275322226;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class setClientID_N1479100880614063379 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public String arg0;
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public setClientID_N1479100880614063379(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public setClientID_N1479100880614063379(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public setClientID_N1479100880614063379(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public setClientID_N1479100880614063379()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate.org$jboss$jms$client$delegate$ClientConnectionDelegate$setClientID$aop(this.jdField_arg0_of_type_JavaLangString);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_JavaLangString = ((String)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_JavaLangString;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       setClientID_N1479100880614063379 localsetClientID_N1479100880614063379 = new setClientID_N1479100880614063379(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localsetClientID_N1479100880614063379.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localsetClientID_N1479100880614063379.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localsetClientID_N1479100880614063379.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localsetClientID_N1479100880614063379.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localsetClientID_N1479100880614063379.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localsetClientID_N1479100880614063379.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localsetClientID_N1479100880614063379.jdField_arg0_of_type_JavaLangString = this.jdField_arg0_of_type_JavaLangString;
/*     */       return localsetClientID_N1479100880614063379;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class setExceptionListener_8089029433030319178 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ExceptionListener arg0;
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public setExceptionListener_8089029433030319178(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public setExceptionListener_8089029433030319178(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public setExceptionListener_8089029433030319178(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public setExceptionListener_8089029433030319178()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate.org$jboss$jms$client$delegate$ClientConnectionDelegate$setExceptionListener$aop(this.jdField_arg0_of_type_JavaxJmsExceptionListener);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_JavaxJmsExceptionListener = ((ExceptionListener)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_JavaxJmsExceptionListener;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       setExceptionListener_8089029433030319178 localsetExceptionListener_8089029433030319178 = new setExceptionListener_8089029433030319178(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localsetExceptionListener_8089029433030319178.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localsetExceptionListener_8089029433030319178.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localsetExceptionListener_8089029433030319178.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localsetExceptionListener_8089029433030319178.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localsetExceptionListener_8089029433030319178.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localsetExceptionListener_8089029433030319178.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localsetExceptionListener_8089029433030319178.jdField_arg0_of_type_JavaxJmsExceptionListener = this.jdField_arg0_of_type_JavaxJmsExceptionListener;
/*     */       return localsetExceptionListener_8089029433030319178;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class start_N8025343665958530775 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public start_N8025343665958530775(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public start_N8025343665958530775(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public start_N8025343665958530775(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public start_N8025343665958530775()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate.org$jboss$jms$client$delegate$ClientConnectionDelegate$start$aop();
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       start_N8025343665958530775 localstart_N8025343665958530775 = new start_N8025343665958530775(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localstart_N8025343665958530775.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localstart_N8025343665958530775.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localstart_N8025343665958530775.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localstart_N8025343665958530775.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localstart_N8025343665958530775.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localstart_N8025343665958530775.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localstart_N8025343665958530775;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class startAfterFailover_4824875258671238473 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public startAfterFailover_4824875258671238473(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public startAfterFailover_4824875258671238473(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public startAfterFailover_4824875258671238473(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public startAfterFailover_4824875258671238473()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate.org$jboss$jms$client$delegate$ClientConnectionDelegate$startAfterFailover$aop();
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       startAfterFailover_4824875258671238473 localstartAfterFailover_4824875258671238473 = new startAfterFailover_4824875258671238473(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localstartAfterFailover_4824875258671238473.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localstartAfterFailover_4824875258671238473.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localstartAfterFailover_4824875258671238473.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localstartAfterFailover_4824875258671238473.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localstartAfterFailover_4824875258671238473.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localstartAfterFailover_4824875258671238473.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localstartAfterFailover_4824875258671238473;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class stop_N2856118408655404442 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public stop_N2856118408655404442(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public stop_N2856118408655404442(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public stop_N2856118408655404442(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public stop_N2856118408655404442()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate.org$jboss$jms$client$delegate$ClientConnectionDelegate$stop$aop();
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       stop_N2856118408655404442 localstop_N2856118408655404442 = new stop_N2856118408655404442(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localstop_N2856118408655404442.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localstop_N2856118408655404442.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localstop_N2856118408655404442.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localstop_N2856118408655404442.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localstop_N2856118408655404442.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localstop_N2856118408655404442.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localstop_N2856118408655404442;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getPreparedTransactions_8083036720366990761 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public getPreparedTransactions_8083036720366990761(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getPreparedTransactions_8083036720366990761(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getPreparedTransactions_8083036720366990761(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getPreparedTransactions_8083036720366990761()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate.org$jboss$jms$client$delegate$ClientConnectionDelegate$getPreparedTransactions$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getPreparedTransactions_8083036720366990761 localgetPreparedTransactions_8083036720366990761 = new getPreparedTransactions_8083036720366990761(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetPreparedTransactions_8083036720366990761.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetPreparedTransactions_8083036720366990761.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetPreparedTransactions_8083036720366990761.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetPreparedTransactions_8083036720366990761.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetPreparedTransactions_8083036720366990761.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localgetPreparedTransactions_8083036720366990761.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localgetPreparedTransactions_8083036720366990761;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class registerFailoverListener_5217231757412585200 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public FailoverListener arg0;
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public registerFailoverListener_5217231757412585200(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public registerFailoverListener_5217231757412585200(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public registerFailoverListener_5217231757412585200(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public registerFailoverListener_5217231757412585200()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate.org$jboss$jms$client$delegate$ClientConnectionDelegate$registerFailoverListener$aop(this.jdField_arg0_of_type_OrgJbossJmsClientFailoverListener);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_OrgJbossJmsClientFailoverListener = ((FailoverListener)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_OrgJbossJmsClientFailoverListener;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       registerFailoverListener_5217231757412585200 localregisterFailoverListener_5217231757412585200 = new registerFailoverListener_5217231757412585200(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localregisterFailoverListener_5217231757412585200.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localregisterFailoverListener_5217231757412585200.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localregisterFailoverListener_5217231757412585200.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localregisterFailoverListener_5217231757412585200.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localregisterFailoverListener_5217231757412585200.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localregisterFailoverListener_5217231757412585200.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localregisterFailoverListener_5217231757412585200.jdField_arg0_of_type_OrgJbossJmsClientFailoverListener = this.jdField_arg0_of_type_OrgJbossJmsClientFailoverListener;
/*     */       return localregisterFailoverListener_5217231757412585200;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class unregisterFailoverListener_N7288918302650237719 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public FailoverListener arg0;
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public unregisterFailoverListener_N7288918302650237719(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public unregisterFailoverListener_N7288918302650237719(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public unregisterFailoverListener_N7288918302650237719(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public unregisterFailoverListener_N7288918302650237719()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       Boolean tmp76_73 = new java/lang/Boolean;
/*     */       Boolean tmp77_76 = tmp76_73;
/*     */       tmp77_76;
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate.org$jboss$jms$client$delegate$ClientConnectionDelegate$unregisterFailoverListener$aop(this.jdField_arg0_of_type_OrgJbossJmsClientFailoverListener).<init>(tmp76_73);
/*     */       return tmp77_76;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_OrgJbossJmsClientFailoverListener = ((FailoverListener)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_OrgJbossJmsClientFailoverListener;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       unregisterFailoverListener_N7288918302650237719 localunregisterFailoverListener_N7288918302650237719 = new unregisterFailoverListener_N7288918302650237719(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localunregisterFailoverListener_N7288918302650237719.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localunregisterFailoverListener_N7288918302650237719.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localunregisterFailoverListener_N7288918302650237719.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localunregisterFailoverListener_N7288918302650237719.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localunregisterFailoverListener_N7288918302650237719.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localunregisterFailoverListener_N7288918302650237719.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localunregisterFailoverListener_N7288918302650237719.jdField_arg0_of_type_OrgJbossJmsClientFailoverListener = this.jdField_arg0_of_type_OrgJbossJmsClientFailoverListener;
/*     */       return localunregisterFailoverListener_N7288918302650237719;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getIdBlock_7224852188662164551 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public int arg0;
/*     */     public ClientConnectionDelegate typedTargetObject;
/*     */ 
/*     */     public getIdBlock_7224852188662164551(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getIdBlock_7224852188662164551(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getIdBlock_7224852188662164551(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getIdBlock_7224852188662164551()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate.org$jboss$jms$client$delegate$ClientConnectionDelegate$getIdBlock$aop(this.jdField_arg0_of_type_Int);
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       this.jdField_arg0_of_type_Int = ((Integer)paramArrayOfObject[0]).intValue();
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       Integer tmp59_56 = new java/lang/Integer;
/*     */       Integer tmp60_59 = tmp59_56;
/*     */       Integer tmp60_59 = tmp59_56;
/*     */       tmp60_59;
/*     */       this.jdField_arg0_of_type_Int.<init>(tmp60_59);
/*     */       0[tmp60_59] = tmp60_59;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getIdBlock_7224852188662164551 localgetIdBlock_7224852188662164551 = new getIdBlock_7224852188662164551(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetIdBlock_7224852188662164551.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetIdBlock_7224852188662164551.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetIdBlock_7224852188662164551.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetIdBlock_7224852188662164551.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetIdBlock_7224852188662164551.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionDelegate;
/*     */       localgetIdBlock_7224852188662164551.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localgetIdBlock_7224852188662164551.jdField_arg0_of_type_Int = this.jdField_arg0_of_type_Int;
/*     */       return localgetIdBlock_7224852188662164551;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.delegate.ClientConnectionDelegate
 * JD-Core Version:    0.6.0
 */