/*     */ package org.jboss.jms.client.delegate;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.lang.ref.Reference;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.jms.JMSException;
/*     */ import org.jboss.aop.Advised;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.ClassInstanceAdvisor;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.JoinPointInfo;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.instrument.Untransformable;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.InvocationBase;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.jms.client.container.JMSClientVMIdentifier;
/*     */ import org.jboss.jms.client.remoting.JMSRemotingConnection;
/*     */ import org.jboss.jms.delegate.ConnectionFactoryDelegate;
/*     */ import org.jboss.jms.delegate.CreateConnectionResult;
/*     */ import org.jboss.jms.delegate.TopologyResult;
/*     */ import org.jboss.jms.exception.MessagingNetworkFailureException;
/*     */ import org.jboss.jms.wireformat.ConnectionFactoryCreateConnectionDelegateRequest;
/*     */ import org.jboss.jms.wireformat.ConnectionFactoryGetClientAOPStackRequest;
/*     */ import org.jboss.jms.wireformat.JMSWireFormat;
/*     */ import org.jboss.jms.wireformat.ResponseSupport;
/*     */ import org.jboss.messaging.util.Version;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ 
/*     */ public class ClientConnectionFactoryDelegate extends DelegateSupport
/*     */   implements ConnectionFactoryDelegate, Serializable, Advised
/*     */ {
/*     */   private static final long serialVersionUID = 2512460695662741413L;
/*     */   private String uniqueName;
/*     */   private String serverLocatorURI;
/*     */   private Version serverVersion;
/*     */   private int serverID;
/*     */   private boolean clientPing;
/*     */   private boolean strictTck;
/*     */   private static ClassAdvisor aop$classAdvisor$aop;
/*     */   protected transient ClassInstanceAdvisor _instanceAdvisor;
/*     */   private static WeakReference aop$MethodInfo_createConnectionDelegate_N_3019492359065420858;
/*     */   private static WeakReference aop$MethodInfo_getClientAOPStack7161396531404689859;
/*     */   private static WeakReference aop$MethodInfo_getTopology7611120934159013485;
/*     */ 
/*     */   public static Version getVersionToUse(Version connectionVersion)
/*     */   {
/*  89 */     Version clientVersion = Version.instance();
/*     */     Version versionToUse;
/*     */     Version versionToUse;
/*  93 */     if (connectionVersion.getProviderIncrementingVersion() <= clientVersion.getProviderIncrementingVersion())
/*     */     {
/*  96 */       versionToUse = connectionVersion;
/*     */     }
/*     */     else
/*     */     {
/* 100 */       versionToUse = clientVersion;
/*     */     }
/*     */ 
/* 103 */     return versionToUse;
/*     */   }
/*     */ 
/*     */   public ClientConnectionFactoryDelegate(String uniqueName, String objectID, int serverID, String serverLocatorURI, Version serverVersion, boolean clientPing, boolean strictTck)
/*     */   {
/* 111 */     super(objectID);
/*     */ 
/* 113 */     this.uniqueName = uniqueName;
/* 114 */     this.serverID = serverID;
/* 115 */     this.serverLocatorURI = serverLocatorURI;
/* 116 */     this.serverVersion = serverVersion;
/* 117 */     this.clientPing = clientPing;
/* 118 */     this.strictTck = strictTck;
/*     */   }
/*     */ 
/*     */   public ClientConnectionFactoryDelegate()
/*     */   {
/*     */   }
/*     */ 
/*     */   public CreateConnectionResult createConnectionDelegate(String paramString1, String paramString2, int paramInt)
/*     */     throws JMSException
/*     */   {
/*     */     MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createConnectionDelegate_N_3019492359065420858.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean)))
/*     */     {
/*     */       if (localClassInstanceAdvisor != null)
/*     */         arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor);
/*     */       createConnectionDelegate_N3019492359065420858 localcreateConnectionDelegate_N3019492359065420858 = new createConnectionDelegate_N3019492359065420858(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateConnectionDelegate_N3019492359065420858.arg0 = paramString1;
/*     */       localcreateConnectionDelegate_N3019492359065420858.arg1 = paramString2;
/*     */       localcreateConnectionDelegate_N3019492359065420858.arg2 = paramInt;
/*     */       localcreateConnectionDelegate_N3019492359065420858.setTargetObject(this);
/*     */       localcreateConnectionDelegate_N3019492359065420858.typedTargetObject = this;
/*     */       localcreateConnectionDelegate_N3019492359065420858.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (CreateConnectionResult)localcreateConnectionDelegate_N3019492359065420858.invokeNext();
/*     */     }
/*     */     return org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$createConnectionDelegate$aop(paramString1, paramString2, paramInt);
/*     */   }
/*     */ 
/*     */   public byte[] getClientAOPStack()
/*     */     throws JMSException
/*     */   {
/*     */     MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getClientAOPStack7161396531404689859.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean)))
/*     */     {
/*     */       if (localClassInstanceAdvisor != null)
/*     */         arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor);
/*     */       getClientAOPStack_7161396531404689859 localgetClientAOPStack_7161396531404689859 = new getClientAOPStack_7161396531404689859(localMethodInfo, arrayOfInterceptor);
/*     */       localgetClientAOPStack_7161396531404689859.setTargetObject(this);
/*     */       localgetClientAOPStack_7161396531404689859.typedTargetObject = this;
/*     */       localgetClientAOPStack_7161396531404689859.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (byte[])localgetClientAOPStack_7161396531404689859.invokeNext();
/*     */     }
/*     */     return org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$getClientAOPStack$aop();
/*     */   }
/*     */ 
/*     */   public TopologyResult getTopology()
/*     */     throws JMSException
/*     */   {
/*     */     MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getTopology7611120934159013485.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean)))
/*     */     {
/*     */       if (localClassInstanceAdvisor != null)
/*     */         arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor);
/*     */       getTopology_7611120934159013485 localgetTopology_7611120934159013485 = new getTopology_7611120934159013485(localMethodInfo, arrayOfInterceptor);
/*     */       localgetTopology_7611120934159013485.setTargetObject(this);
/*     */       localgetTopology_7611120934159013485.typedTargetObject = this;
/*     */       localgetTopology_7611120934159013485.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (TopologyResult)localgetTopology_7611120934159013485.invokeNext();
/*     */     }
/*     */     return org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$getTopology$aop();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 245 */     return "ConnectionFactoryDelegate[" + this.id + ", SID=" + this.serverID + "]";
/*     */   }
/*     */ 
/*     */   public String getServerLocatorURI()
/*     */   {
/* 250 */     return this.serverLocatorURI;
/*     */   }
/*     */ 
/*     */   public int getServerID()
/*     */   {
/* 255 */     return this.serverID;
/*     */   }
/*     */ 
/*     */   public boolean getClientPing()
/*     */   {
/* 260 */     return this.clientPing;
/*     */   }
/*     */ 
/*     */   public Version getServerVersion()
/*     */   {
/* 265 */     return this.serverVersion;
/*     */   }
/*     */ 
/*     */   public boolean getStrictTck()
/*     */   {
/* 271 */     return this.strictTck;
/*     */   }
/*     */ 
/*     */   public void synchronizeWith(DelegateSupport newDelegate) throws Exception
/*     */   {
/* 276 */     super.synchronizeWith(newDelegate);
/*     */   }
/*     */ 
/*     */   private Client createClient()
/*     */     throws JMSException
/*     */   {
/* 289 */     Map configuration = new HashMap();
/*     */ 
/* 291 */     configuration.put("enableLease", String.valueOf(false));
/*     */     Client client;
/*     */     try
/*     */     {
/* 298 */       client = new Client(new InvokerLocator(this.serverLocatorURI), configuration);
/* 299 */       client.setSubsystem("JMS");
/* 300 */       client.connect();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 304 */       throw new MessagingNetworkFailureException("Failed to connect client", e);
/*     */     }
/*     */ 
/* 307 */     client.setMarshaller(new JMSWireFormat());
/* 308 */     client.setUnMarshaller(new JMSWireFormat());
/*     */ 
/* 310 */     return client;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in)
/*     */     throws Exception
/*     */   {
/* 317 */     super.read(in);
/*     */ 
/* 319 */     this.serverLocatorURI = in.readUTF();
/*     */ 
/* 321 */     this.serverVersion = new Version();
/*     */ 
/* 323 */     this.serverVersion.read(in);
/*     */ 
/* 325 */     this.serverID = in.readInt();
/*     */ 
/* 327 */     this.clientPing = in.readBoolean();
/*     */ 
/* 329 */     this.strictTck = in.readBoolean();
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out) throws Exception
/*     */   {
/* 334 */     super.write(out);
/*     */ 
/* 336 */     out.writeUTF(this.serverLocatorURI);
/*     */ 
/* 338 */     this.serverVersion.write(out);
/*     */ 
/* 340 */     out.writeInt(this.serverID);
/*     */ 
/* 342 */     out.writeBoolean(this.clientPing);
/*     */ 
/* 344 */     out.writeBoolean(this.strictTck);
/*     */   }
/*     */ 
/*     */   public Advisor _getAdvisor()
/*     */   {
/*     */     return jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor;
/*     */   }
/*     */ 
/*     */   public InstanceAdvisor _getInstanceAdvisor()
/*     */   {
/*     */     synchronized (this)
/*     */     {
/*     */       if (this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor == null)
/*     */         this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor = new ClassInstanceAdvisor(this);
/*     */       return this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void _setInstanceAdvisor(InstanceAdvisor paramInstanceAdvisor)
/*     */   {
/*     */     synchronized (this)
/*     */     {
/*     */       this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor = ((ClassInstanceAdvisor)paramInstanceAdvisor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public CreateConnectionResult org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$createConnectionDelegate$aop(String username, String password, int failedNodeID)
/*     */     throws JMSException
/*     */   {
/* 142 */     Version version = ClientConnectionFactoryDelegate.getVersionToUse(this.jdField_serverVersion_of_type_OrgJbossMessagingUtilVersion);
/*     */ 
/* 144 */     byte v = version.getProviderIncrementingVersion();
/*     */ 
/* 146 */     JMSRemotingConnection remotingConnection = null;
/*     */     CreateConnectionResult res;
/*     */     try
/*     */     {
/* 152 */       remotingConnection = new JMSRemotingConnection(this.serverLocatorURI, this.clientPing, this.strictTck);
/*     */ 
/* 154 */       remotingConnection.start();
/*     */ 
/* 156 */       Client client = remotingConnection.getRemotingClient();
/*     */ 
/* 158 */       String remotingSessionId = client.getSessionId();
/*     */ 
/* 160 */       String clientVMId = JMSClientVMIdentifier.instance;
/*     */ 
/* 162 */       ConnectionFactoryCreateConnectionDelegateRequest req = new ConnectionFactoryCreateConnectionDelegateRequest(this.jdField_id_of_type_JavaLangString, v, remotingSessionId, clientVMId, username, password, failedNodeID);
/*     */ 
/* 167 */       ResponseSupport rs = (ResponseSupport)client.invoke(req, null);
/*     */ 
/* 169 */       res = (CreateConnectionResult)rs.getResponse();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 176 */       if (remotingConnection != null)
/*     */       {
/*     */         try
/*     */         {
/* 180 */           remotingConnection.stop();
/*     */         }
/*     */         catch (Throwable ignore)
/*     */         {
/*     */         }
/*     */       }
/*     */ 
/* 187 */       throw handleThrowable(t);
/*     */     }
/*     */ 
/* 190 */     ClientConnectionDelegate connectionDelegate = res.getDelegate();
/*     */ 
/* 192 */     if (connectionDelegate != null)
/*     */     {
/* 194 */       connectionDelegate.setRemotingConnection(remotingConnection);
/*     */ 
/* 196 */       connectionDelegate.setVersionToUse(version);
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 204 */         remotingConnection.stop();
/*     */       }
/*     */       catch (Throwable ignore)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 211 */     return res;
/*     */   }
/*     */ 
/*     */   public byte[] org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$getClientAOPStack$aop() throws JMSException
/*     */   {
/* 216 */     Version version = ClientConnectionFactoryDelegate.getVersionToUse(this.jdField_serverVersion_of_type_OrgJbossMessagingUtilVersion);
/*     */ 
/* 218 */     byte v = version.getProviderIncrementingVersion();
/*     */ 
/* 222 */     Map configuration = new HashMap();
/*     */ 
/* 224 */     configuration.put("enableLease", String.valueOf(false));
/*     */ 
/* 228 */     Client localClient1 = createClient();
/*     */     Client theClient;
/* 228 */     ConnectionFactoryGetClientAOPStackRequest localConnectionFactoryGetClientAOPStackRequest1 = new ConnectionFactoryGetClientAOPStackRequest(this.jdField_id_of_type_JavaLangString, v);
/*     */     ConnectionFactoryGetClientAOPStackRequest req;
/* 228 */     return (byte[])(byte[])doInvoke(theClient, req);
/*     */   }
/*     */ 
/*     */   public TopologyResult org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$getTopology$aop()
/*     */     throws JMSException
/*     */   {
/* 238 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor = AspectManager.instance().getAdvisor(Class.forName("org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate"));
/*     */   }
/*     */ 
/*     */   public static class createConnectionDelegate_N3019492359065420858 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public String arg0;
/*     */     public String arg1;
/*     */     public int arg2;
/*     */     public ClientConnectionFactoryDelegate typedTargetObject;
/*     */ 
/*     */     public createConnectionDelegate_N3019492359065420858(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createConnectionDelegate_N3019492359065420858(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createConnectionDelegate_N3019492359065420858(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createConnectionDelegate_N3019492359065420858()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionFactoryDelegate.org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$createConnectionDelegate$aop(this.jdField_arg0_of_type_JavaLangString, this.jdField_arg1_of_type_JavaLangString, this.jdField_arg2_of_type_Int);
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject1 = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_JavaLangString = ((String)localObject1);
/*     */       Object localObject2 = paramArrayOfObject[1];
/*     */       this.jdField_arg1_of_type_JavaLangString = ((String)localObject2);
/*     */       this.jdField_arg2_of_type_Int = ((Integer)paramArrayOfObject[2]).intValue();
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[3];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_JavaLangString;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[1] = this.jdField_arg1_of_type_JavaLangString;
/*     */       Integer tmp79_76 = new java/lang/Integer;
/*     */       Integer tmp80_79 = tmp79_76;
/*     */       Integer tmp80_79 = tmp79_76;
/*     */       tmp80_79;
/*     */       this.jdField_arg2_of_type_Int.<init>(tmp80_79);
/*     */       2[tmp80_79] = tmp80_79;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createConnectionDelegate_N3019492359065420858 localcreateConnectionDelegate_N3019492359065420858 = new createConnectionDelegate_N3019492359065420858(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionFactoryDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionFactoryDelegate;
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_arg0_of_type_JavaLangString = this.jdField_arg0_of_type_JavaLangString;
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_arg1_of_type_JavaLangString = this.jdField_arg1_of_type_JavaLangString;
/*     */       localcreateConnectionDelegate_N3019492359065420858.jdField_arg2_of_type_Int = this.jdField_arg2_of_type_Int;
/*     */       return localcreateConnectionDelegate_N3019492359065420858;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getClientAOPStack_7161396531404689859 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientConnectionFactoryDelegate typedTargetObject;
/*     */ 
/*     */     public getClientAOPStack_7161396531404689859(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getClientAOPStack_7161396531404689859(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getClientAOPStack_7161396531404689859(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getClientAOPStack_7161396531404689859()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionFactoryDelegate.org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$getClientAOPStack$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getClientAOPStack_7161396531404689859 localgetClientAOPStack_7161396531404689859 = new getClientAOPStack_7161396531404689859(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetClientAOPStack_7161396531404689859.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetClientAOPStack_7161396531404689859.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetClientAOPStack_7161396531404689859.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetClientAOPStack_7161396531404689859.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetClientAOPStack_7161396531404689859.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionFactoryDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionFactoryDelegate;
/*     */       localgetClientAOPStack_7161396531404689859.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localgetClientAOPStack_7161396531404689859;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getTopology_7611120934159013485 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientConnectionFactoryDelegate typedTargetObject;
/*     */ 
/*     */     public getTopology_7611120934159013485(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getTopology_7611120934159013485(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getTopology_7611120934159013485(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getTopology_7611120934159013485()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionFactoryDelegate.org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$getTopology$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getTopology_7611120934159013485 localgetTopology_7611120934159013485 = new getTopology_7611120934159013485(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetTopology_7611120934159013485.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetTopology_7611120934159013485.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetTopology_7611120934159013485.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetTopology_7611120934159013485.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetTopology_7611120934159013485.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionFactoryDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConnectionFactoryDelegate;
/*     */       localgetTopology_7611120934159013485.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localgetTopology_7611120934159013485;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate
 * JD-Core Version:    0.6.0
 */