/*     */ package org.jboss.jms.client.delegate;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.lang.ref.Reference;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Method;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.Message;
/*     */ import javax.jms.MessageListener;
/*     */ import org.jboss.aop.Advised;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.ClassInstanceAdvisor;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.JoinPointInfo;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.instrument.Untransformable;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.InvocationBase;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.jms.client.remoting.JMSRemotingConnection;
/*     */ import org.jboss.jms.client.state.ConnectionState;
/*     */ import org.jboss.jms.client.state.HierarchicalState;
/*     */ import org.jboss.jms.delegate.ConsumerDelegate;
/*     */ import org.jboss.jms.destination.JBossDestination;
/*     */ import org.jboss.jms.wireformat.CloseRequest;
/*     */ import org.jboss.jms.wireformat.ClosingRequest;
/*     */ import org.jboss.jms.wireformat.ConsumerChangeRateRequest;
/*     */ import org.jboss.jms.wireformat.RequestSupport;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClientConsumerDelegate extends DelegateSupport
/*     */   implements ConsumerDelegate, Advised
/*     */ {
/*     */   private static final long serialVersionUID = 3253922610778321868L;
/*     */   private static final Logger log;
/*     */   private int bufferSize;
/*     */   private int maxDeliveries;
/*     */   private long redeliveryDelay;
/*     */   private static ClassAdvisor aop$classAdvisor$aop;
/*     */   protected transient ClassInstanceAdvisor _instanceAdvisor;
/*     */   private static WeakReference aop$MethodInfo_close_N_4742752445160157748;
/*     */   private static WeakReference aop$MethodInfo_closing2473194355759371067;
/*     */   private static WeakReference aop$MethodInfo_changeRate_N_952316153687074823;
/*     */   private static WeakReference aop$MethodInfo_getMessageListener2204309074290103460;
/*     */   private static WeakReference aop$MethodInfo_receive_N_8299950230150603585;
/*     */   private static WeakReference aop$MethodInfo_setMessageListener_N_8112055063220820757;
/*     */   private static WeakReference aop$MethodInfo_getNoLocal_N_6345624988403093910;
/*     */   private static WeakReference aop$MethodInfo_getDestination5050744306400666989;
/*     */   private static WeakReference aop$MethodInfo_getMessageSelector_N_2218644250563348824;
/*     */ 
/*     */   public ClientConsumerDelegate(String objectID, int bufferSize, int maxDeliveries, long redeliveryDelay)
/*     */   {
/*  71 */     super(objectID);
/*  72 */     this.bufferSize = bufferSize;
/*  73 */     this.maxDeliveries = maxDeliveries;
/*  74 */     this.redeliveryDelay = redeliveryDelay;
/*     */   }
/*     */ 
/*     */   public ClientConsumerDelegate()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void synchronizeWith(DelegateSupport nd)
/*     */     throws Exception
/*     */   {
/*  85 */     log.trace(this + " synchronizing with " + nd);
/*     */ 
/*  87 */     super.synchronizeWith(nd);
/*     */ 
/*  89 */     ClientConsumerDelegate newDelegate = (ClientConsumerDelegate)nd;
/*     */ 
/*  92 */     this.client = ((ConnectionState)this.state.getParent().getParent()).getRemotingConnection().getRemotingClient();
/*     */ 
/*  99 */     this.state.synchronizeWith(newDelegate.getState());
/*     */ 
/* 103 */     this.bufferSize = newDelegate.getBufferSize();
/* 104 */     this.maxDeliveries = newDelegate.getMaxDeliveries();
/*     */   }
/*     */ 
/*     */   public void setState(HierarchicalState state)
/*     */   {
/* 110 */     super.setState(state);
/*     */ 
/* 112 */     this.client = ((ConnectionState)state.getParent().getParent()).getRemotingConnection().getRemotingClient(); } 
/*     */   public void close() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_close_N_4742752445160157748.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); close_N4742752445160157748 localclose_N4742752445160157748 = new close_N4742752445160157748(localMethodInfo, arrayOfInterceptor);
/*     */       localclose_N4742752445160157748.setTargetObject(this);
/*     */       localclose_N4742752445160157748.typedTargetObject = this;
/*     */       localclose_N4742752445160157748.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localclose_N4742752445160157748.invokeNext(); } else { org$jboss$jms$client$delegate$ClientConsumerDelegate$close$aop(); }  } 
/*     */   public long closing(long paramLong) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_closing2473194355759371067.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); closing_2473194355759371067 localclosing_2473194355759371067 = new closing_2473194355759371067(localMethodInfo, arrayOfInterceptor);
/*     */       localclosing_2473194355759371067.arg0 = paramLong;
/*     */       localclosing_2473194355759371067.setTargetObject(this);
/*     */       localclosing_2473194355759371067.typedTargetObject = this;
/*     */       localclosing_2473194355759371067.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return ((Long)localclosing_2473194355759371067.invokeNext()).longValue(); } return org$jboss$jms$client$delegate$ClientConsumerDelegate$closing$aop(paramLong); } 
/*     */   public void changeRate(float paramFloat) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_changeRate_N_952316153687074823.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); changeRate_N952316153687074823 localchangeRate_N952316153687074823 = new changeRate_N952316153687074823(localMethodInfo, arrayOfInterceptor);
/*     */       localchangeRate_N952316153687074823.arg0 = paramFloat;
/*     */       localchangeRate_N952316153687074823.setTargetObject(this);
/*     */       localchangeRate_N952316153687074823.typedTargetObject = this;
/*     */       localchangeRate_N952316153687074823.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localchangeRate_N952316153687074823.invokeNext(); } else { org$jboss$jms$client$delegate$ClientConsumerDelegate$changeRate$aop(paramFloat); }  } 
/*     */   public MessageListener getMessageListener() { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getMessageListener2204309074290103460.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); getMessageListener_2204309074290103460 localgetMessageListener_2204309074290103460 = new getMessageListener_2204309074290103460(localMethodInfo, arrayOfInterceptor);
/*     */       localgetMessageListener_2204309074290103460.setTargetObject(this);
/*     */       localgetMessageListener_2204309074290103460.typedTargetObject = this;
/*     */       localgetMessageListener_2204309074290103460.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (MessageListener)localgetMessageListener_2204309074290103460.invokeNext(); } return org$jboss$jms$client$delegate$ClientConsumerDelegate$getMessageListener$aop(); } 
/*     */   public Message receive(long paramLong) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_receive_N_8299950230150603585.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); receive_N8299950230150603585 localreceive_N8299950230150603585 = new receive_N8299950230150603585(localMethodInfo, arrayOfInterceptor);
/*     */       localreceive_N8299950230150603585.arg0 = paramLong;
/*     */       localreceive_N8299950230150603585.setTargetObject(this);
/*     */       localreceive_N8299950230150603585.typedTargetObject = this;
/*     */       localreceive_N8299950230150603585.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (Message)localreceive_N8299950230150603585.invokeNext(); } return org$jboss$jms$client$delegate$ClientConsumerDelegate$receive$aop(paramLong); } 
/*     */   public void setMessageListener(MessageListener paramMessageListener) { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_setMessageListener_N_8112055063220820757.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); setMessageListener_N8112055063220820757 localsetMessageListener_N8112055063220820757 = new setMessageListener_N8112055063220820757(localMethodInfo, arrayOfInterceptor);
/*     */       localsetMessageListener_N8112055063220820757.arg0 = paramMessageListener;
/*     */       localsetMessageListener_N8112055063220820757.setTargetObject(this);
/*     */       localsetMessageListener_N8112055063220820757.typedTargetObject = this;
/*     */       localsetMessageListener_N8112055063220820757.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localsetMessageListener_N8112055063220820757.invokeNext(); } else { org$jboss$jms$client$delegate$ClientConsumerDelegate$setMessageListener$aop(paramMessageListener); }  } 
/*     */   public boolean getNoLocal() { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getNoLocal_N_6345624988403093910.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); getNoLocal_N6345624988403093910 localgetNoLocal_N6345624988403093910 = new getNoLocal_N6345624988403093910(localMethodInfo, arrayOfInterceptor);
/*     */       localgetNoLocal_N6345624988403093910.setTargetObject(this);
/*     */       localgetNoLocal_N6345624988403093910.typedTargetObject = this;
/*     */       localgetNoLocal_N6345624988403093910.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return ((Boolean)localgetNoLocal_N6345624988403093910.invokeNext()).booleanValue(); } return org$jboss$jms$client$delegate$ClientConsumerDelegate$getNoLocal$aop(); } 
/*     */   public JBossDestination getDestination() { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getDestination5050744306400666989.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); getDestination_5050744306400666989 localgetDestination_5050744306400666989 = new getDestination_5050744306400666989(localMethodInfo, arrayOfInterceptor);
/*     */       localgetDestination_5050744306400666989.setTargetObject(this);
/*     */       localgetDestination_5050744306400666989.typedTargetObject = this;
/*     */       localgetDestination_5050744306400666989.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (JBossDestination)localgetDestination_5050744306400666989.invokeNext(); } return org$jboss$jms$client$delegate$ClientConsumerDelegate$getDestination$aop(); } 
/*     */   public String getMessageSelector() { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getMessageSelector_N_2218644250563348824.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); getMessageSelector_N2218644250563348824 localgetMessageSelector_N2218644250563348824 = new getMessageSelector_N2218644250563348824(localMethodInfo, arrayOfInterceptor);
/*     */       localgetMessageSelector_N2218644250563348824.setTargetObject(this);
/*     */       localgetMessageSelector_N2218644250563348824.typedTargetObject = this;
/*     */       localgetMessageSelector_N2218644250563348824.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (String)localgetMessageSelector_N2218644250563348824.invokeNext(); } return org$jboss$jms$client$delegate$ClientConsumerDelegate$getMessageSelector$aop(); } 
/* 199 */   public void read(DataInputStream in) throws Exception { super.read(in);
/*     */ 
/* 201 */     this.bufferSize = in.readInt();
/*     */ 
/* 203 */     this.maxDeliveries = in.readInt();
/*     */ 
/* 205 */     this.redeliveryDelay = in.readLong(); }
/*     */ 
/*     */   public void write(DataOutputStream out)
/*     */     throws Exception
/*     */   {
/* 210 */     super.write(out);
/*     */ 
/* 212 */     out.writeInt(this.bufferSize);
/*     */ 
/* 214 */     out.writeInt(this.maxDeliveries);
/*     */ 
/* 216 */     out.writeLong(this.redeliveryDelay);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 223 */     return "ConsumerDelegate[" + System.identityHashCode(this) + ", ID=" + this.id + "]";
/*     */   }
/*     */ 
/*     */   public int getBufferSize()
/*     */   {
/* 228 */     return this.bufferSize;
/*     */   }
/*     */ 
/*     */   public int getMaxDeliveries()
/*     */   {
/* 233 */     return this.maxDeliveries;
/*     */   }
/*     */ 
/*     */   public long getRedeliveryDelay()
/*     */   {
/* 238 */     return this.redeliveryDelay;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  57 */     jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor = AspectManager.instance().getAdvisor(Class.forName("org.jboss.jms.client.delegate.ClientConsumerDelegate")); log = Logger.getLogger(ClientConsumerDelegate.class);
/*     */   }
/*     */ 
/*     */   public Advisor _getAdvisor()
/*     */   {
/*     */     return jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor;
/*     */   }
/*     */ 
/*     */   public InstanceAdvisor _getInstanceAdvisor()
/*     */   {
/*     */     synchronized (this)
/*     */     {
/*     */       if (this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor == null)
/*     */         this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor = new ClassInstanceAdvisor(this);
/*     */       return this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void _setInstanceAdvisor(InstanceAdvisor paramInstanceAdvisor)
/*     */   {
/*     */     synchronized (this)
/*     */     {
/*     */       this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor = ((ClassInstanceAdvisor)paramInstanceAdvisor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientConsumerDelegate$close$aop()
/*     */     throws JMSException
/*     */   {
/* 120 */     RequestSupport req = new CloseRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte);
/*     */ 
/* 122 */     doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public long org$jboss$jms$client$delegate$ClientConsumerDelegate$closing$aop(long sequence) throws JMSException
/*     */   {
/* 127 */     RequestSupport req = new ClosingRequest(sequence, this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte);
/*     */ 
/* 129 */     return ((Long)doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req)).longValue();
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientConsumerDelegate$changeRate$aop(float newRate)
/*     */     throws JMSException
/*     */   {
/* 136 */     RequestSupport req = new ConsumerChangeRateRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, newRate);
/*     */ 
/* 138 */     doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public MessageListener org$jboss$jms$client$delegate$ClientConsumerDelegate$getMessageListener$aop()
/*     */   {
/* 147 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public Message org$jboss$jms$client$delegate$ClientConsumerDelegate$receive$aop(long timeout)
/*     */     throws JMSException
/*     */   {
/* 156 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientConsumerDelegate$setMessageListener$aop(MessageListener listener)
/*     */   {
/* 165 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public boolean org$jboss$jms$client$delegate$ClientConsumerDelegate$getNoLocal$aop()
/*     */   {
/* 174 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public JBossDestination org$jboss$jms$client$delegate$ClientConsumerDelegate$getDestination$aop()
/*     */   {
/* 183 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public String org$jboss$jms$client$delegate$ClientConsumerDelegate$getMessageSelector$aop()
/*     */   {
/* 192 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public static class close_N4742752445160157748 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientConsumerDelegate typedTargetObject;
/*     */ 
/*     */     public close_N4742752445160157748(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public close_N4742752445160157748(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public close_N4742752445160157748(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public close_N4742752445160157748()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate.org$jboss$jms$client$delegate$ClientConsumerDelegate$close$aop();
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       close_N4742752445160157748 localclose_N4742752445160157748 = new close_N4742752445160157748(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localclose_N4742752445160157748.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localclose_N4742752445160157748.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localclose_N4742752445160157748.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localclose_N4742752445160157748.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localclose_N4742752445160157748.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate;
/*     */       localclose_N4742752445160157748.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localclose_N4742752445160157748;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class closing_2473194355759371067 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public long arg0;
/*     */     public ClientConsumerDelegate typedTargetObject;
/*     */ 
/*     */     public closing_2473194355759371067(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public closing_2473194355759371067(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public closing_2473194355759371067(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public closing_2473194355759371067()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       this.jdField_arg0_of_type_Long = ((Long)paramArrayOfObject[0]).longValue();
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       Long tmp59_56 = new java/lang/Long;
/*     */       Long tmp60_59 = tmp59_56;
/*     */       Long tmp60_59 = tmp59_56;
/*     */       tmp60_59;
/*     */       this.jdField_arg0_of_type_Long.<init>(tmp60_59);
/*     */       tmp60_59[tmp60_59] = 0;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       closing_2473194355759371067 localclosing_2473194355759371067 = new closing_2473194355759371067(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localclosing_2473194355759371067.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localclosing_2473194355759371067.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localclosing_2473194355759371067.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localclosing_2473194355759371067.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localclosing_2473194355759371067.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate;
/*     */       localclosing_2473194355759371067.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localclosing_2473194355759371067.jdField_arg0_of_type_Long = this.jdField_arg0_of_type_Long;
/*     */       return localclosing_2473194355759371067;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class changeRate_N952316153687074823 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public float arg0;
/*     */     public ClientConsumerDelegate typedTargetObject;
/*     */ 
/*     */     public changeRate_N952316153687074823(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public changeRate_N952316153687074823(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public changeRate_N952316153687074823(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public changeRate_N952316153687074823()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate.org$jboss$jms$client$delegate$ClientConsumerDelegate$changeRate$aop(this.jdField_arg0_of_type_Float);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       this.jdField_arg0_of_type_Float = ((Float)paramArrayOfObject[0]).floatValue();
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       Float tmp59_56 = new java/lang/Float;
/*     */       Float tmp60_59 = tmp59_56;
/*     */       Float tmp60_59 = tmp59_56;
/*     */       tmp60_59;
/*     */       this.jdField_arg0_of_type_Float.<init>(tmp60_59);
/*     */       0[tmp60_59] = tmp60_59;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       changeRate_N952316153687074823 localchangeRate_N952316153687074823 = new changeRate_N952316153687074823(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localchangeRate_N952316153687074823.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localchangeRate_N952316153687074823.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localchangeRate_N952316153687074823.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localchangeRate_N952316153687074823.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localchangeRate_N952316153687074823.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate;
/*     */       localchangeRate_N952316153687074823.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localchangeRate_N952316153687074823.jdField_arg0_of_type_Float = this.jdField_arg0_of_type_Float;
/*     */       return localchangeRate_N952316153687074823;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getMessageListener_2204309074290103460 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientConsumerDelegate typedTargetObject;
/*     */ 
/*     */     public getMessageListener_2204309074290103460(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getMessageListener_2204309074290103460(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getMessageListener_2204309074290103460(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getMessageListener_2204309074290103460()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate.org$jboss$jms$client$delegate$ClientConsumerDelegate$getMessageListener$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getMessageListener_2204309074290103460 localgetMessageListener_2204309074290103460 = new getMessageListener_2204309074290103460(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetMessageListener_2204309074290103460.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetMessageListener_2204309074290103460.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetMessageListener_2204309074290103460.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetMessageListener_2204309074290103460.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetMessageListener_2204309074290103460.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate;
/*     */       localgetMessageListener_2204309074290103460.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localgetMessageListener_2204309074290103460;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class receive_N8299950230150603585 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public long arg0;
/*     */     public ClientConsumerDelegate typedTargetObject;
/*     */ 
/*     */     public receive_N8299950230150603585(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public receive_N8299950230150603585(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public receive_N8299950230150603585(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public receive_N8299950230150603585()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate.org$jboss$jms$client$delegate$ClientConsumerDelegate$receive$aop(this.jdField_arg0_of_type_Long);
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       this.jdField_arg0_of_type_Long = ((Long)paramArrayOfObject[0]).longValue();
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       Long tmp59_56 = new java/lang/Long;
/*     */       Long tmp60_59 = tmp59_56;
/*     */       Long tmp60_59 = tmp59_56;
/*     */       tmp60_59;
/*     */       this.jdField_arg0_of_type_Long.<init>(tmp60_59);
/*     */       tmp60_59[tmp60_59] = 0;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       receive_N8299950230150603585 localreceive_N8299950230150603585 = new receive_N8299950230150603585(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localreceive_N8299950230150603585.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localreceive_N8299950230150603585.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localreceive_N8299950230150603585.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localreceive_N8299950230150603585.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localreceive_N8299950230150603585.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate;
/*     */       localreceive_N8299950230150603585.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localreceive_N8299950230150603585.jdField_arg0_of_type_Long = this.jdField_arg0_of_type_Long;
/*     */       return localreceive_N8299950230150603585;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class setMessageListener_N8112055063220820757 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public MessageListener arg0;
/*     */     public ClientConsumerDelegate typedTargetObject;
/*     */ 
/*     */     public setMessageListener_N8112055063220820757(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public setMessageListener_N8112055063220820757(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public setMessageListener_N8112055063220820757(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public setMessageListener_N8112055063220820757()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate.org$jboss$jms$client$delegate$ClientConsumerDelegate$setMessageListener$aop(this.jdField_arg0_of_type_JavaxJmsMessageListener);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_JavaxJmsMessageListener = ((MessageListener)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_JavaxJmsMessageListener;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       setMessageListener_N8112055063220820757 localsetMessageListener_N8112055063220820757 = new setMessageListener_N8112055063220820757(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localsetMessageListener_N8112055063220820757.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localsetMessageListener_N8112055063220820757.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localsetMessageListener_N8112055063220820757.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localsetMessageListener_N8112055063220820757.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localsetMessageListener_N8112055063220820757.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate;
/*     */       localsetMessageListener_N8112055063220820757.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localsetMessageListener_N8112055063220820757.jdField_arg0_of_type_JavaxJmsMessageListener = this.jdField_arg0_of_type_JavaxJmsMessageListener;
/*     */       return localsetMessageListener_N8112055063220820757;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getNoLocal_N6345624988403093910 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientConsumerDelegate typedTargetObject;
/*     */ 
/*     */     public getNoLocal_N6345624988403093910(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getNoLocal_N6345624988403093910(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getNoLocal_N6345624988403093910(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getNoLocal_N6345624988403093910()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       Boolean tmp72_69 = new java/lang/Boolean;
/*     */       Boolean tmp73_72 = tmp72_69;
/*     */       tmp73_72;
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate.org$jboss$jms$client$delegate$ClientConsumerDelegate$getNoLocal$aop().<init>(tmp72_69);
/*     */       return tmp73_72;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getNoLocal_N6345624988403093910 localgetNoLocal_N6345624988403093910 = new getNoLocal_N6345624988403093910(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetNoLocal_N6345624988403093910.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetNoLocal_N6345624988403093910.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetNoLocal_N6345624988403093910.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetNoLocal_N6345624988403093910.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetNoLocal_N6345624988403093910.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate;
/*     */       localgetNoLocal_N6345624988403093910.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localgetNoLocal_N6345624988403093910;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getDestination_5050744306400666989 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientConsumerDelegate typedTargetObject;
/*     */ 
/*     */     public getDestination_5050744306400666989(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getDestination_5050744306400666989(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getDestination_5050744306400666989(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getDestination_5050744306400666989()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate.org$jboss$jms$client$delegate$ClientConsumerDelegate$getDestination$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getDestination_5050744306400666989 localgetDestination_5050744306400666989 = new getDestination_5050744306400666989(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetDestination_5050744306400666989.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetDestination_5050744306400666989.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetDestination_5050744306400666989.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetDestination_5050744306400666989.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetDestination_5050744306400666989.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate;
/*     */       localgetDestination_5050744306400666989.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localgetDestination_5050744306400666989;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getMessageSelector_N2218644250563348824 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientConsumerDelegate typedTargetObject;
/*     */ 
/*     */     public getMessageSelector_N2218644250563348824(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getMessageSelector_N2218644250563348824(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getMessageSelector_N2218644250563348824(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getMessageSelector_N2218644250563348824()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate.org$jboss$jms$client$delegate$ClientConsumerDelegate$getMessageSelector$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getMessageSelector_N2218644250563348824 localgetMessageSelector_N2218644250563348824 = new getMessageSelector_N2218644250563348824(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetMessageSelector_N2218644250563348824.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetMessageSelector_N2218644250563348824.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetMessageSelector_N2218644250563348824.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetMessageSelector_N2218644250563348824.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetMessageSelector_N2218644250563348824.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientConsumerDelegate;
/*     */       localgetMessageSelector_N2218644250563348824.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localgetMessageSelector_N2218644250563348824;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.delegate.ClientConsumerDelegate
 * JD-Core Version:    0.6.0
 */