/*     */ package org.jboss.jms.client.delegate;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.lang.ref.Reference;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.List;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.MessageListener;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import org.jboss.aop.Advised;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.ClassInstanceAdvisor;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.JoinPointInfo;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.instrument.Untransformable;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.InvocationBase;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.jms.client.remoting.JMSRemotingConnection;
/*     */ import org.jboss.jms.client.state.ConnectionState;
/*     */ import org.jboss.jms.client.state.HierarchicalState;
/*     */ import org.jboss.jms.client.state.SessionState;
/*     */ import org.jboss.jms.delegate.Ack;
/*     */ import org.jboss.jms.delegate.BrowserDelegate;
/*     */ import org.jboss.jms.delegate.Cancel;
/*     */ import org.jboss.jms.delegate.ConsumerDelegate;
/*     */ import org.jboss.jms.delegate.DeliveryInfo;
/*     */ import org.jboss.jms.delegate.ProducerDelegate;
/*     */ import org.jboss.jms.delegate.SessionDelegate;
/*     */ import org.jboss.jms.destination.JBossDestination;
/*     */ import org.jboss.jms.destination.JBossQueue;
/*     */ import org.jboss.jms.destination.JBossTopic;
/*     */ import org.jboss.jms.message.BytesMessageProxy;
/*     */ import org.jboss.jms.message.JBossMessage;
/*     */ import org.jboss.jms.message.MapMessageProxy;
/*     */ import org.jboss.jms.message.MessageProxy;
/*     */ import org.jboss.jms.message.ObjectMessageProxy;
/*     */ import org.jboss.jms.message.StreamMessageProxy;
/*     */ import org.jboss.jms.message.TextMessageProxy;
/*     */ import org.jboss.jms.wireformat.CloseRequest;
/*     */ import org.jboss.jms.wireformat.ClosingRequest;
/*     */ import org.jboss.jms.wireformat.RequestSupport;
/*     */ import org.jboss.jms.wireformat.SessionAcknowledgeDeliveriesRequest;
/*     */ import org.jboss.jms.wireformat.SessionAcknowledgeDeliveryRequest;
/*     */ import org.jboss.jms.wireformat.SessionAddTemporaryDestinationRequest;
/*     */ import org.jboss.jms.wireformat.SessionCancelDeliveriesRequest;
/*     */ import org.jboss.jms.wireformat.SessionCancelDeliveryRequest;
/*     */ import org.jboss.jms.wireformat.SessionCreateBrowserDelegateRequest;
/*     */ import org.jboss.jms.wireformat.SessionCreateConsumerDelegateRequest;
/*     */ import org.jboss.jms.wireformat.SessionCreateQueueRequest;
/*     */ import org.jboss.jms.wireformat.SessionCreateTopicRequest;
/*     */ import org.jboss.jms.wireformat.SessionDeleteTemporaryDestinationRequest;
/*     */ import org.jboss.jms.wireformat.SessionRecoverDeliveriesRequest;
/*     */ import org.jboss.jms.wireformat.SessionSendRequest;
/*     */ import org.jboss.jms.wireformat.SessionUnsubscribeRequest;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClientSessionDelegate extends DelegateSupport
/*     */   implements SessionDelegate, Advised
/*     */ {
/*     */   private static final Logger log;
/*     */   private static final long serialVersionUID = -8096852898620279131L;
/*     */   private int dupsOKBatchSize;
/*     */   private boolean strictTck;
/*     */   private static ClassAdvisor aop$classAdvisor$aop;
/*     */   protected transient ClassInstanceAdvisor _instanceAdvisor;
/*     */   private static WeakReference aop$MethodInfo_close_N_4742752445160157748;
/*     */   private static WeakReference aop$MethodInfo_closing2473194355759371067;
/*     */   private static WeakReference aop$MethodInfo_acknowledgeDelivery_N_5825751487881460811;
/*     */   private static WeakReference aop$MethodInfo_acknowledgeDeliveries1767561430588382789;
/*     */   private static WeakReference aop$MethodInfo_acknowledgeAll3428828241771477154;
/*     */   private static WeakReference aop$MethodInfo_addTemporaryDestination4607215820163210272;
/*     */   private static WeakReference aop$MethodInfo_commit8461082169793485964;
/*     */   private static WeakReference aop$MethodInfo_createBrowserDelegate_N_5828981013655274081;
/*     */   private static WeakReference aop$MethodInfo_createBytesMessage7082074764812825153;
/*     */   private static WeakReference aop$MethodInfo_createConsumerDelegate8721389917985689973;
/*     */   private static WeakReference aop$MethodInfo_createMapMessage6454173539027268961;
/*     */   private static WeakReference aop$MethodInfo_createMessage7458165539797107901;
/*     */   private static WeakReference aop$MethodInfo_createObjectMessage_N_7497440531089519617;
/*     */   private static WeakReference aop$MethodInfo_createObjectMessage5541516037526997237;
/*     */   private static WeakReference aop$MethodInfo_createProducerDelegate332221920261695411;
/*     */   private static WeakReference aop$MethodInfo_createQueue6431069199924553036;
/*     */   private static WeakReference aop$MethodInfo_createStreamMessage_N_9186959628979934744;
/*     */   private static WeakReference aop$MethodInfo_createTextMessage2320081262968295190;
/*     */   private static WeakReference aop$MethodInfo_createTextMessage4391803803118822775;
/*     */   private static WeakReference aop$MethodInfo_createTopic_N_1144803973659535745;
/*     */   private static WeakReference aop$MethodInfo_deleteTemporaryDestination_N_5233806045047796315;
/*     */   private static WeakReference aop$MethodInfo_getMessageListener2204309074290103460;
/*     */   private static WeakReference aop$MethodInfo_postDeliver1255239194451907669;
/*     */   private static WeakReference aop$MethodInfo_preDeliver5548846795541436298;
/*     */   private static WeakReference aop$MethodInfo_recover6753106934534422686;
/*     */   private static WeakReference aop$MethodInfo_redeliver_N_1959001033568420259;
/*     */   private static WeakReference aop$MethodInfo_rollback_N_2202008398766919932;
/*     */   private static WeakReference aop$MethodInfo_run_N_8003352271541955702;
/*     */   private static WeakReference aop$MethodInfo_setMessageListener_N_8112055063220820757;
/*     */   private static WeakReference aop$MethodInfo_unsubscribe8775578479443985821;
/*     */   private static WeakReference aop$MethodInfo_getXAResource5045584642641131496;
/*     */   private static WeakReference aop$MethodInfo_getAcknowledgeMode_N_7774033054566619384;
/*     */   private static WeakReference aop$MethodInfo_getTransacted_N_1613179584734032131;
/*     */   private static WeakReference aop$MethodInfo_addAsfMessage_N_3142450851726069886;
/*     */   private static WeakReference aop$MethodInfo_send6145266547759487588;
/*     */   private static WeakReference aop$MethodInfo_cancelDeliveries6592991528584912127;
/*     */   private static WeakReference aop$MethodInfo_cancelDelivery2980985335510575813;
/*     */   private static WeakReference aop$MethodInfo_recoverDeliveries4196799148363996265;
/*     */ 
/*     */   public ClientSessionDelegate(String objectID, int dupsOKBatchSize)
/*     */   {
/* 103 */     super(objectID);
/*     */ 
/* 105 */     this.dupsOKBatchSize = dupsOKBatchSize;
/*     */   }
/*     */ 
/*     */   public ClientSessionDelegate()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void synchronizeWith(DelegateSupport nd)
/*     */     throws Exception
/*     */   {
/* 116 */     log.trace(this + " synchronizing with " + nd);
/*     */ 
/* 118 */     super.synchronizeWith(nd);
/*     */ 
/* 120 */     ClientSessionDelegate newDelegate = (ClientSessionDelegate)nd;
/*     */ 
/* 126 */     this.state.synchronizeWith(newDelegate.getState());
/*     */ 
/* 128 */     JMSRemotingConnection conn = ((ConnectionState)this.state.getParent()).getRemotingConnection();
/*     */ 
/* 130 */     this.client = conn.getRemotingClient();
/*     */ 
/* 132 */     this.strictTck = conn.isStrictTck();
/*     */   }
/*     */ 
/*     */   public void setState(HierarchicalState state)
/*     */   {
/* 137 */     super.setState(state);
/*     */ 
/* 139 */     JMSRemotingConnection conn = ((ConnectionState)state.getParent()).getRemotingConnection();
/*     */ 
/* 141 */     this.client = conn.getRemotingClient();
/*     */ 
/* 143 */     this.strictTck = conn.isStrictTck(); } 
/*     */   public void close() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_close_N_4742752445160157748.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); close_N4742752445160157748 localclose_N4742752445160157748 = new close_N4742752445160157748(localMethodInfo, arrayOfInterceptor);
/*     */       localclose_N4742752445160157748.setTargetObject(this);
/*     */       localclose_N4742752445160157748.typedTargetObject = this;
/*     */       localclose_N4742752445160157748.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localclose_N4742752445160157748.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$close$aop(); }  } 
/*     */   public long closing(long paramLong) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_closing2473194355759371067.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); closing_2473194355759371067 localclosing_2473194355759371067 = new closing_2473194355759371067(localMethodInfo, arrayOfInterceptor);
/*     */       localclosing_2473194355759371067.arg0 = paramLong;
/*     */       localclosing_2473194355759371067.setTargetObject(this);
/*     */       localclosing_2473194355759371067.typedTargetObject = this;
/*     */       localclosing_2473194355759371067.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return ((Long)localclosing_2473194355759371067.invokeNext()).longValue(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$closing$aop(paramLong); } 
/*     */   public boolean acknowledgeDelivery(Ack paramAck) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_acknowledgeDelivery_N_5825751487881460811.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); acknowledgeDelivery_N5825751487881460811 localacknowledgeDelivery_N5825751487881460811 = new acknowledgeDelivery_N5825751487881460811(localMethodInfo, arrayOfInterceptor);
/*     */       localacknowledgeDelivery_N5825751487881460811.arg0 = paramAck;
/*     */       localacknowledgeDelivery_N5825751487881460811.setTargetObject(this);
/*     */       localacknowledgeDelivery_N5825751487881460811.typedTargetObject = this;
/*     */       localacknowledgeDelivery_N5825751487881460811.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return ((Boolean)localacknowledgeDelivery_N5825751487881460811.invokeNext()).booleanValue(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$acknowledgeDelivery$aop(paramAck); } 
/*     */   public void acknowledgeDeliveries(List paramList) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_acknowledgeDeliveries1767561430588382789.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); acknowledgeDeliveries_1767561430588382789 localacknowledgeDeliveries_1767561430588382789 = new acknowledgeDeliveries_1767561430588382789(localMethodInfo, arrayOfInterceptor);
/*     */       localacknowledgeDeliveries_1767561430588382789.arg0 = paramList;
/*     */       localacknowledgeDeliveries_1767561430588382789.setTargetObject(this);
/*     */       localacknowledgeDeliveries_1767561430588382789.typedTargetObject = this;
/*     */       localacknowledgeDeliveries_1767561430588382789.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localacknowledgeDeliveries_1767561430588382789.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$acknowledgeDeliveries$aop(paramList); }  } 
/*     */   public void acknowledgeAll() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_acknowledgeAll3428828241771477154.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); acknowledgeAll_3428828241771477154 localacknowledgeAll_3428828241771477154 = new acknowledgeAll_3428828241771477154(localMethodInfo, arrayOfInterceptor);
/*     */       localacknowledgeAll_3428828241771477154.setTargetObject(this);
/*     */       localacknowledgeAll_3428828241771477154.typedTargetObject = this;
/*     */       localacknowledgeAll_3428828241771477154.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localacknowledgeAll_3428828241771477154.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$acknowledgeAll$aop(); }  } 
/*     */   public void addTemporaryDestination(JBossDestination paramJBossDestination) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_addTemporaryDestination4607215820163210272.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); addTemporaryDestination_4607215820163210272 localaddTemporaryDestination_4607215820163210272 = new addTemporaryDestination_4607215820163210272(localMethodInfo, arrayOfInterceptor);
/*     */       localaddTemporaryDestination_4607215820163210272.arg0 = paramJBossDestination;
/*     */       localaddTemporaryDestination_4607215820163210272.setTargetObject(this);
/*     */       localaddTemporaryDestination_4607215820163210272.typedTargetObject = this;
/*     */       localaddTemporaryDestination_4607215820163210272.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localaddTemporaryDestination_4607215820163210272.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$addTemporaryDestination$aop(paramJBossDestination); }  } 
/* 200 */   public void redeliver() throws JMSException { throw new IllegalStateException("This invocation should not be handled here!"); } 
/*     */   public void commit() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_commit8461082169793485964.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); commit_8461082169793485964 localcommit_8461082169793485964 = new commit_8461082169793485964(localMethodInfo, arrayOfInterceptor);
/*     */       localcommit_8461082169793485964.setTargetObject(this);
/*     */       localcommit_8461082169793485964.typedTargetObject = this;
/*     */       localcommit_8461082169793485964.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localcommit_8461082169793485964.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$commit$aop(); }  } 
/*     */   public BrowserDelegate createBrowserDelegate(JBossDestination paramJBossDestination, String paramString) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createBrowserDelegate_N_5828981013655274081.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); createBrowserDelegate_N5828981013655274081 localcreateBrowserDelegate_N5828981013655274081 = new createBrowserDelegate_N5828981013655274081(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateBrowserDelegate_N5828981013655274081.arg0 = paramJBossDestination;
/*     */       localcreateBrowserDelegate_N5828981013655274081.arg1 = paramString;
/*     */       localcreateBrowserDelegate_N5828981013655274081.setTargetObject(this);
/*     */       localcreateBrowserDelegate_N5828981013655274081.typedTargetObject = this;
/*     */       localcreateBrowserDelegate_N5828981013655274081.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (BrowserDelegate)localcreateBrowserDelegate_N5828981013655274081.invokeNext(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$createBrowserDelegate$aop(paramJBossDestination, paramString); } 
/*     */   public BytesMessageProxy createBytesMessage() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createBytesMessage7082074764812825153.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); createBytesMessage_7082074764812825153 localcreateBytesMessage_7082074764812825153 = new createBytesMessage_7082074764812825153(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateBytesMessage_7082074764812825153.setTargetObject(this);
/*     */       localcreateBytesMessage_7082074764812825153.typedTargetObject = this;
/*     */       localcreateBytesMessage_7082074764812825153.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (BytesMessageProxy)localcreateBytesMessage_7082074764812825153.invokeNext(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$createBytesMessage$aop(); } 
/*     */   public ConsumerDelegate createConsumerDelegate(JBossDestination paramJBossDestination, String paramString1, boolean paramBoolean1, String paramString2, boolean paramBoolean2, boolean paramBoolean3) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createConsumerDelegate8721389917985689973.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); createConsumerDelegate_8721389917985689973 localcreateConsumerDelegate_8721389917985689973 = new createConsumerDelegate_8721389917985689973(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateConsumerDelegate_8721389917985689973.arg0 = paramJBossDestination;
/*     */       localcreateConsumerDelegate_8721389917985689973.arg1 = paramString1;
/*     */       localcreateConsumerDelegate_8721389917985689973.arg2 = paramBoolean1;
/*     */       localcreateConsumerDelegate_8721389917985689973.arg3 = paramString2;
/*     */       localcreateConsumerDelegate_8721389917985689973.arg4 = paramBoolean2;
/*     */       localcreateConsumerDelegate_8721389917985689973.arg5 = paramBoolean3;
/*     */       localcreateConsumerDelegate_8721389917985689973.setTargetObject(this);
/*     */       localcreateConsumerDelegate_8721389917985689973.typedTargetObject = this;
/*     */       localcreateConsumerDelegate_8721389917985689973.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (ConsumerDelegate)localcreateConsumerDelegate_8721389917985689973.invokeNext(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$createConsumerDelegate$aop(paramJBossDestination, paramString1, paramBoolean1, paramString2, paramBoolean2, paramBoolean3); } 
/*     */   public MapMessageProxy createMapMessage() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createMapMessage6454173539027268961.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); createMapMessage_6454173539027268961 localcreateMapMessage_6454173539027268961 = new createMapMessage_6454173539027268961(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateMapMessage_6454173539027268961.setTargetObject(this);
/*     */       localcreateMapMessage_6454173539027268961.typedTargetObject = this;
/*     */       localcreateMapMessage_6454173539027268961.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (MapMessageProxy)localcreateMapMessage_6454173539027268961.invokeNext(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$createMapMessage$aop(); } 
/*     */   public MessageProxy createMessage() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createMessage7458165539797107901.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); createMessage_7458165539797107901 localcreateMessage_7458165539797107901 = new createMessage_7458165539797107901(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateMessage_7458165539797107901.setTargetObject(this);
/*     */       localcreateMessage_7458165539797107901.typedTargetObject = this;
/*     */       localcreateMessage_7458165539797107901.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (MessageProxy)localcreateMessage_7458165539797107901.invokeNext(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$createMessage$aop(); } 
/*     */   public ObjectMessageProxy createObjectMessage() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createObjectMessage_N_7497440531089519617.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); createObjectMessage_N7497440531089519617 localcreateObjectMessage_N7497440531089519617 = new createObjectMessage_N7497440531089519617(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateObjectMessage_N7497440531089519617.setTargetObject(this);
/*     */       localcreateObjectMessage_N7497440531089519617.typedTargetObject = this;
/*     */       localcreateObjectMessage_N7497440531089519617.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (ObjectMessageProxy)localcreateObjectMessage_N7497440531089519617.invokeNext(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$createObjectMessage$aop(); } 
/*     */   public ObjectMessageProxy createObjectMessage(Serializable paramSerializable) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createObjectMessage5541516037526997237.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); createObjectMessage_5541516037526997237 localcreateObjectMessage_5541516037526997237 = new createObjectMessage_5541516037526997237(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateObjectMessage_5541516037526997237.arg0 = paramSerializable;
/*     */       localcreateObjectMessage_5541516037526997237.setTargetObject(this);
/*     */       localcreateObjectMessage_5541516037526997237.typedTargetObject = this;
/*     */       localcreateObjectMessage_5541516037526997237.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (ObjectMessageProxy)localcreateObjectMessage_5541516037526997237.invokeNext(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$createObjectMessage$aop(paramSerializable); } 
/*     */   public ProducerDelegate createProducerDelegate(JBossDestination paramJBossDestination) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createProducerDelegate332221920261695411.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); createProducerDelegate_332221920261695411 localcreateProducerDelegate_332221920261695411 = new createProducerDelegate_332221920261695411(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateProducerDelegate_332221920261695411.arg0 = paramJBossDestination;
/*     */       localcreateProducerDelegate_332221920261695411.setTargetObject(this);
/*     */       localcreateProducerDelegate_332221920261695411.typedTargetObject = this;
/*     */       localcreateProducerDelegate_332221920261695411.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (ProducerDelegate)localcreateProducerDelegate_332221920261695411.invokeNext(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$createProducerDelegate$aop(paramJBossDestination); } 
/*     */   public JBossQueue createQueue(String paramString) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createQueue6431069199924553036.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); createQueue_6431069199924553036 localcreateQueue_6431069199924553036 = new createQueue_6431069199924553036(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateQueue_6431069199924553036.arg0 = paramString;
/*     */       localcreateQueue_6431069199924553036.setTargetObject(this);
/*     */       localcreateQueue_6431069199924553036.typedTargetObject = this;
/*     */       localcreateQueue_6431069199924553036.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (JBossQueue)localcreateQueue_6431069199924553036.invokeNext(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$createQueue$aop(paramString); } 
/*     */   public StreamMessageProxy createStreamMessage() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createStreamMessage_N_9186959628979934744.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); createStreamMessage_N9186959628979934744 localcreateStreamMessage_N9186959628979934744 = new createStreamMessage_N9186959628979934744(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateStreamMessage_N9186959628979934744.setTargetObject(this);
/*     */       localcreateStreamMessage_N9186959628979934744.typedTargetObject = this;
/*     */       localcreateStreamMessage_N9186959628979934744.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (StreamMessageProxy)localcreateStreamMessage_N9186959628979934744.invokeNext(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$createStreamMessage$aop(); } 
/*     */   public TextMessageProxy createTextMessage() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createTextMessage2320081262968295190.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); createTextMessage_2320081262968295190 localcreateTextMessage_2320081262968295190 = new createTextMessage_2320081262968295190(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateTextMessage_2320081262968295190.setTargetObject(this);
/*     */       localcreateTextMessage_2320081262968295190.typedTargetObject = this;
/*     */       localcreateTextMessage_2320081262968295190.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (TextMessageProxy)localcreateTextMessage_2320081262968295190.invokeNext(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$createTextMessage$aop(); } 
/*     */   public TextMessageProxy createTextMessage(String paramString) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createTextMessage4391803803118822775.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); createTextMessage_4391803803118822775 localcreateTextMessage_4391803803118822775 = new createTextMessage_4391803803118822775(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateTextMessage_4391803803118822775.arg0 = paramString;
/*     */       localcreateTextMessage_4391803803118822775.setTargetObject(this);
/*     */       localcreateTextMessage_4391803803118822775.typedTargetObject = this;
/*     */       localcreateTextMessage_4391803803118822775.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (TextMessageProxy)localcreateTextMessage_4391803803118822775.invokeNext(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$createTextMessage$aop(paramString); } 
/*     */   public JBossTopic createTopic(String paramString) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_createTopic_N_1144803973659535745.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); createTopic_N1144803973659535745 localcreateTopic_N1144803973659535745 = new createTopic_N1144803973659535745(localMethodInfo, arrayOfInterceptor);
/*     */       localcreateTopic_N1144803973659535745.arg0 = paramString;
/*     */       localcreateTopic_N1144803973659535745.setTargetObject(this);
/*     */       localcreateTopic_N1144803973659535745.typedTargetObject = this;
/*     */       localcreateTopic_N1144803973659535745.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (JBossTopic)localcreateTopic_N1144803973659535745.invokeNext(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$createTopic$aop(paramString); } 
/*     */   public void deleteTemporaryDestination(JBossDestination paramJBossDestination) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_deleteTemporaryDestination_N_5233806045047796315.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); deleteTemporaryDestination_N5233806045047796315 localdeleteTemporaryDestination_N5233806045047796315 = new deleteTemporaryDestination_N5233806045047796315(localMethodInfo, arrayOfInterceptor);
/*     */       localdeleteTemporaryDestination_N5233806045047796315.arg0 = paramJBossDestination;
/*     */       localdeleteTemporaryDestination_N5233806045047796315.setTargetObject(this);
/*     */       localdeleteTemporaryDestination_N5233806045047796315.typedTargetObject = this;
/*     */       localdeleteTemporaryDestination_N5233806045047796315.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localdeleteTemporaryDestination_N5233806045047796315.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$deleteTemporaryDestination$aop(paramJBossDestination); }  } 
/*     */   public MessageListener getMessageListener() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getMessageListener2204309074290103460.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); getMessageListener_2204309074290103460 localgetMessageListener_2204309074290103460 = new getMessageListener_2204309074290103460(localMethodInfo, arrayOfInterceptor);
/*     */       localgetMessageListener_2204309074290103460.setTargetObject(this);
/*     */       localgetMessageListener_2204309074290103460.typedTargetObject = this;
/*     */       localgetMessageListener_2204309074290103460.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (MessageListener)localgetMessageListener_2204309074290103460.invokeNext(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$getMessageListener$aop(); } 
/*     */   public boolean postDeliver() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_postDeliver1255239194451907669.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); postDeliver_1255239194451907669 localpostDeliver_1255239194451907669 = new postDeliver_1255239194451907669(localMethodInfo, arrayOfInterceptor);
/*     */       localpostDeliver_1255239194451907669.setTargetObject(this);
/*     */       localpostDeliver_1255239194451907669.typedTargetObject = this;
/*     */       localpostDeliver_1255239194451907669.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return ((Boolean)localpostDeliver_1255239194451907669.invokeNext()).booleanValue(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$postDeliver$aop(); } 
/*     */   public void preDeliver(DeliveryInfo paramDeliveryInfo) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_preDeliver5548846795541436298.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); preDeliver_5548846795541436298 localpreDeliver_5548846795541436298 = new preDeliver_5548846795541436298(localMethodInfo, arrayOfInterceptor);
/*     */       localpreDeliver_5548846795541436298.arg0 = paramDeliveryInfo;
/*     */       localpreDeliver_5548846795541436298.setTargetObject(this);
/*     */       localpreDeliver_5548846795541436298.typedTargetObject = this;
/*     */       localpreDeliver_5548846795541436298.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localpreDeliver_5548846795541436298.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$preDeliver$aop(paramDeliveryInfo); }  } 
/*     */   public void recover() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_recover6753106934534422686.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); recover_6753106934534422686 localrecover_6753106934534422686 = new recover_6753106934534422686(localMethodInfo, arrayOfInterceptor);
/*     */       localrecover_6753106934534422686.setTargetObject(this);
/*     */       localrecover_6753106934534422686.typedTargetObject = this;
/*     */       localrecover_6753106934534422686.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localrecover_6753106934534422686.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$recover$aop(); }  } 
/*     */   public void redeliver(List paramList) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_redeliver_N_1959001033568420259.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); redeliver_N1959001033568420259 localredeliver_N1959001033568420259 = new redeliver_N1959001033568420259(localMethodInfo, arrayOfInterceptor);
/*     */       localredeliver_N1959001033568420259.arg0 = paramList;
/*     */       localredeliver_N1959001033568420259.setTargetObject(this);
/*     */       localredeliver_N1959001033568420259.typedTargetObject = this;
/*     */       localredeliver_N1959001033568420259.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localredeliver_N1959001033568420259.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$redeliver$aop(paramList); }  } 
/*     */   public void rollback() throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_rollback_N_2202008398766919932.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); rollback_N2202008398766919932 localrollback_N2202008398766919932 = new rollback_N2202008398766919932(localMethodInfo, arrayOfInterceptor);
/*     */       localrollback_N2202008398766919932.setTargetObject(this);
/*     */       localrollback_N2202008398766919932.typedTargetObject = this;
/*     */       localrollback_N2202008398766919932.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localrollback_N2202008398766919932.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$rollback$aop(); }  } 
/*     */   public void run() { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_run_N_8003352271541955702.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); run_N8003352271541955702 localrun_N8003352271541955702 = new run_N8003352271541955702(localMethodInfo, arrayOfInterceptor);
/*     */       localrun_N8003352271541955702.setTargetObject(this);
/*     */       localrun_N8003352271541955702.typedTargetObject = this;
/*     */       localrun_N8003352271541955702.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localrun_N8003352271541955702.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$run$aop(); }  } 
/*     */   public void setMessageListener(MessageListener paramMessageListener) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_setMessageListener_N_8112055063220820757.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); setMessageListener_N8112055063220820757 localsetMessageListener_N8112055063220820757 = new setMessageListener_N8112055063220820757(localMethodInfo, arrayOfInterceptor);
/*     */       localsetMessageListener_N8112055063220820757.arg0 = paramMessageListener;
/*     */       localsetMessageListener_N8112055063220820757.setTargetObject(this);
/*     */       localsetMessageListener_N8112055063220820757.typedTargetObject = this;
/*     */       localsetMessageListener_N8112055063220820757.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localsetMessageListener_N8112055063220820757.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$setMessageListener$aop(paramMessageListener); }  } 
/*     */   public void unsubscribe(String paramString) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_unsubscribe8775578479443985821.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); unsubscribe_8775578479443985821 localunsubscribe_8775578479443985821 = new unsubscribe_8775578479443985821(localMethodInfo, arrayOfInterceptor);
/*     */       localunsubscribe_8775578479443985821.arg0 = paramString;
/*     */       localunsubscribe_8775578479443985821.setTargetObject(this);
/*     */       localunsubscribe_8775578479443985821.typedTargetObject = this;
/*     */       localunsubscribe_8775578479443985821.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localunsubscribe_8775578479443985821.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$unsubscribe$aop(paramString); }  } 
/*     */   public XAResource getXAResource() { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getXAResource5045584642641131496.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); getXAResource_5045584642641131496 localgetXAResource_5045584642641131496 = new getXAResource_5045584642641131496(localMethodInfo, arrayOfInterceptor);
/*     */       localgetXAResource_5045584642641131496.setTargetObject(this);
/*     */       localgetXAResource_5045584642641131496.typedTargetObject = this;
/*     */       localgetXAResource_5045584642641131496.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return (XAResource)localgetXAResource_5045584642641131496.invokeNext(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$getXAResource$aop(); } 
/*     */   public int getAcknowledgeMode() { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getAcknowledgeMode_N_7774033054566619384.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); getAcknowledgeMode_N7774033054566619384 localgetAcknowledgeMode_N7774033054566619384 = new getAcknowledgeMode_N7774033054566619384(localMethodInfo, arrayOfInterceptor);
/*     */       localgetAcknowledgeMode_N7774033054566619384.setTargetObject(this);
/*     */       localgetAcknowledgeMode_N7774033054566619384.typedTargetObject = this;
/*     */       localgetAcknowledgeMode_N7774033054566619384.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return ((Integer)localgetAcknowledgeMode_N7774033054566619384.invokeNext()).intValue(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$getAcknowledgeMode$aop(); } 
/*     */   public boolean getTransacted() { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_getTransacted_N_1613179584734032131.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); getTransacted_N1613179584734032131 localgetTransacted_N1613179584734032131 = new getTransacted_N1613179584734032131(localMethodInfo, arrayOfInterceptor);
/*     */       localgetTransacted_N1613179584734032131.setTargetObject(this);
/*     */       localgetTransacted_N1613179584734032131.typedTargetObject = this;
/*     */       localgetTransacted_N1613179584734032131.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       return ((Boolean)localgetTransacted_N1613179584734032131.invokeNext()).booleanValue(); } return org$jboss$jms$client$delegate$ClientSessionDelegate$getTransacted$aop(); } 
/*     */   public void addAsfMessage(MessageProxy paramMessageProxy, String paramString1, String paramString2, int paramInt, SessionDelegate paramSessionDelegate, boolean paramBoolean) { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_addAsfMessage_N_3142450851726069886.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); addAsfMessage_N3142450851726069886 localaddAsfMessage_N3142450851726069886 = new addAsfMessage_N3142450851726069886(localMethodInfo, arrayOfInterceptor);
/*     */       localaddAsfMessage_N3142450851726069886.arg0 = paramMessageProxy;
/*     */       localaddAsfMessage_N3142450851726069886.arg1 = paramString1;
/*     */       localaddAsfMessage_N3142450851726069886.arg2 = paramString2;
/*     */       localaddAsfMessage_N3142450851726069886.arg3 = paramInt;
/*     */       localaddAsfMessage_N3142450851726069886.arg4 = paramSessionDelegate;
/*     */       localaddAsfMessage_N3142450851726069886.arg5 = paramBoolean;
/*     */       localaddAsfMessage_N3142450851726069886.setTargetObject(this);
/*     */       localaddAsfMessage_N3142450851726069886.typedTargetObject = this;
/*     */       localaddAsfMessage_N3142450851726069886.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localaddAsfMessage_N3142450851726069886.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$addAsfMessage$aop(paramMessageProxy, paramString1, paramString2, paramInt, paramSessionDelegate, paramBoolean); }  } 
/*     */   public void send(JBossMessage paramJBossMessage, boolean paramBoolean) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_send6145266547759487588.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); send_6145266547759487588 localsend_6145266547759487588 = new send_6145266547759487588(localMethodInfo, arrayOfInterceptor);
/*     */       localsend_6145266547759487588.arg0 = paramJBossMessage;
/*     */       localsend_6145266547759487588.arg1 = paramBoolean;
/*     */       localsend_6145266547759487588.setTargetObject(this);
/*     */       localsend_6145266547759487588.typedTargetObject = this;
/*     */       localsend_6145266547759487588.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localsend_6145266547759487588.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$send$aop(paramJBossMessage, paramBoolean); }  } 
/*     */   public void cancelDeliveries(List paramList) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_cancelDeliveries6592991528584912127.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); cancelDeliveries_6592991528584912127 localcancelDeliveries_6592991528584912127 = new cancelDeliveries_6592991528584912127(localMethodInfo, arrayOfInterceptor);
/*     */       localcancelDeliveries_6592991528584912127.arg0 = paramList;
/*     */       localcancelDeliveries_6592991528584912127.setTargetObject(this);
/*     */       localcancelDeliveries_6592991528584912127.typedTargetObject = this;
/*     */       localcancelDeliveries_6592991528584912127.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localcancelDeliveries_6592991528584912127.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$cancelDeliveries$aop(paramList); }  } 
/*     */   public void cancelDelivery(Cancel paramCancel) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_cancelDelivery2980985335510575813.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); cancelDelivery_2980985335510575813 localcancelDelivery_2980985335510575813 = new cancelDelivery_2980985335510575813(localMethodInfo, arrayOfInterceptor);
/*     */       localcancelDelivery_2980985335510575813.arg0 = paramCancel;
/*     */       localcancelDelivery_2980985335510575813.setTargetObject(this);
/*     */       localcancelDelivery_2980985335510575813.typedTargetObject = this;
/*     */       localcancelDelivery_2980985335510575813.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localcancelDelivery_2980985335510575813.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$cancelDelivery$aop(paramCancel); }  } 
/*     */   public void recoverDeliveries(List paramList, String paramString) throws JMSException { MethodInfo localMethodInfo = (MethodInfo)aop$MethodInfo_recoverDeliveries4196799148363996265.get();
/*     */     ClassInstanceAdvisor localClassInstanceAdvisor = (ClassInstanceAdvisor)_getInstanceAdvisor();
/*     */     Interceptor[] arrayOfInterceptor = localMethodInfo.getInterceptors();
/*     */     if ((arrayOfInterceptor != (Object[])null) || ((localClassInstanceAdvisor == null) || (localClassInstanceAdvisor.jdField_hasInstanceAspects_of_type_Boolean))) { if (localClassInstanceAdvisor != null) arrayOfInterceptor = localClassInstanceAdvisor.getInterceptors(arrayOfInterceptor); recoverDeliveries_4196799148363996265 localrecoverDeliveries_4196799148363996265 = new recoverDeliveries_4196799148363996265(localMethodInfo, arrayOfInterceptor);
/*     */       localrecoverDeliveries_4196799148363996265.arg0 = paramList;
/*     */       localrecoverDeliveries_4196799148363996265.arg1 = paramString;
/*     */       localrecoverDeliveries_4196799148363996265.setTargetObject(this);
/*     */       localrecoverDeliveries_4196799148363996265.typedTargetObject = this;
/*     */       localrecoverDeliveries_4196799148363996265.setAdvisor(jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor);
/*     */       localrecoverDeliveries_4196799148363996265.invokeNext(); } else { org$jboss$jms$client$delegate$ClientSessionDelegate$recoverDeliveries$aop(paramList, paramString); }  } 
/* 507 */   public void read(DataInputStream in) throws Exception { super.read(in);
/*     */ 
/* 509 */     this.dupsOKBatchSize = in.readInt(); }
/*     */ 
/*     */   public void write(DataOutputStream out)
/*     */     throws Exception
/*     */   {
/* 514 */     super.write(out);
/*     */ 
/* 516 */     out.writeInt(this.dupsOKBatchSize);
/*     */   }
/*     */ 
/*     */   public int getDupsOKBatchSize()
/*     */   {
/* 523 */     return this.dupsOKBatchSize;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 528 */     return "SessionDelegate[" + System.identityHashCode(this) + ", ID=" + this.id + "]";
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  87 */     jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor = AspectManager.instance().getAdvisor(Class.forName("org.jboss.jms.client.delegate.ClientSessionDelegate")); log = Logger.getLogger(ClientSessionDelegate.class);
/*     */   }
/*     */ 
/*     */   public Advisor _getAdvisor()
/*     */   {
/*     */     return jdField_aop$classAdvisor$aop_of_type_OrgJbossAopClassAdvisor;
/*     */   }
/*     */ 
/*     */   public InstanceAdvisor _getInstanceAdvisor()
/*     */   {
/*     */     synchronized (this)
/*     */     {
/*     */       if (this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor == null)
/*     */         this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor = new ClassInstanceAdvisor(this);
/*     */       return this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void _setInstanceAdvisor(InstanceAdvisor paramInstanceAdvisor)
/*     */   {
/*     */     synchronized (this)
/*     */     {
/*     */       this.jdField__instanceAdvisor_of_type_OrgJbossAopClassInstanceAdvisor = ((ClassInstanceAdvisor)paramInstanceAdvisor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$close$aop()
/*     */     throws JMSException
/*     */   {
/* 150 */     RequestSupport req = new CloseRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte);
/*     */ 
/* 152 */     doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public long org$jboss$jms$client$delegate$ClientSessionDelegate$closing$aop(long sequence) throws JMSException
/*     */   {
/* 157 */     RequestSupport req = new ClosingRequest(((SessionState)this.jdField_state_of_type_OrgJbossJmsClientStateHierarchicalState).getNPSendSequence(), this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte);
/*     */ 
/* 159 */     return ((Long)doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req)).longValue();
/*     */   }
/*     */ 
/*     */   public boolean org$jboss$jms$client$delegate$ClientSessionDelegate$acknowledgeDelivery$aop(Ack ack)
/*     */     throws JMSException
/*     */   {
/* 166 */     RequestSupport req = new SessionAcknowledgeDeliveryRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, ack);
/*     */ 
/* 168 */     return ((Boolean)doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req)).booleanValue();
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$acknowledgeDeliveries$aop(List acks) throws JMSException
/*     */   {
/* 173 */     RequestSupport req = new SessionAcknowledgeDeliveriesRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, acks);
/*     */ 
/* 175 */     doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$acknowledgeAll$aop()
/*     */     throws JMSException
/*     */   {
/* 184 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$addTemporaryDestination$aop(JBossDestination destination) throws JMSException
/*     */   {
/* 189 */     RequestSupport req = new SessionAddTemporaryDestinationRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, destination);
/*     */ 
/* 191 */     doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$commit$aop()
/*     */     throws JMSException
/*     */   {
/* 209 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public BrowserDelegate org$jboss$jms$client$delegate$ClientSessionDelegate$createBrowserDelegate$aop(JBossDestination queue, String messageSelector)
/*     */     throws JMSException
/*     */   {
/* 215 */     RequestSupport req = new SessionCreateBrowserDelegateRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, queue, messageSelector);
/*     */ 
/* 218 */     Object res = doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */ 
/* 220 */     return (BrowserDelegate)res;
/*     */   }
/*     */ 
/*     */   public BytesMessageProxy org$jboss$jms$client$delegate$ClientSessionDelegate$createBytesMessage$aop()
/*     */     throws JMSException
/*     */   {
/* 229 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public ConsumerDelegate org$jboss$jms$client$delegate$ClientSessionDelegate$createConsumerDelegate$aop(JBossDestination destination, String selector, boolean noLocal, String subscriptionName, boolean connectionConsumer, boolean started)
/*     */     throws JMSException
/*     */   {
/* 237 */     RequestSupport req = new SessionCreateConsumerDelegateRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, destination, selector, noLocal, subscriptionName, connectionConsumer, started);
/*     */ 
/* 241 */     return (ConsumerDelegate)doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public MapMessageProxy org$jboss$jms$client$delegate$ClientSessionDelegate$createMapMessage$aop()
/*     */     throws JMSException
/*     */   {
/* 250 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public MessageProxy org$jboss$jms$client$delegate$ClientSessionDelegate$createMessage$aop()
/*     */     throws JMSException
/*     */   {
/* 259 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public ObjectMessageProxy org$jboss$jms$client$delegate$ClientSessionDelegate$createObjectMessage$aop()
/*     */     throws JMSException
/*     */   {
/* 268 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public ObjectMessageProxy org$jboss$jms$client$delegate$ClientSessionDelegate$createObjectMessage$aop(Serializable object)
/*     */     throws JMSException
/*     */   {
/* 277 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public ProducerDelegate org$jboss$jms$client$delegate$ClientSessionDelegate$createProducerDelegate$aop(JBossDestination destination)
/*     */     throws JMSException
/*     */   {
/* 286 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public JBossQueue org$jboss$jms$client$delegate$ClientSessionDelegate$createQueue$aop(String queueName) throws JMSException
/*     */   {
/* 291 */     RequestSupport req = new SessionCreateQueueRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, queueName);
/*     */ 
/* 293 */     return (JBossQueue)doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public StreamMessageProxy org$jboss$jms$client$delegate$ClientSessionDelegate$createStreamMessage$aop()
/*     */     throws JMSException
/*     */   {
/* 302 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public TextMessageProxy org$jboss$jms$client$delegate$ClientSessionDelegate$createTextMessage$aop()
/*     */     throws JMSException
/*     */   {
/* 311 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public TextMessageProxy org$jboss$jms$client$delegate$ClientSessionDelegate$createTextMessage$aop(String text)
/*     */     throws JMSException
/*     */   {
/* 320 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public JBossTopic org$jboss$jms$client$delegate$ClientSessionDelegate$createTopic$aop(String topicName) throws JMSException
/*     */   {
/* 325 */     RequestSupport req = new SessionCreateTopicRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, topicName);
/*     */ 
/* 327 */     return (JBossTopic)doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$deleteTemporaryDestination$aop(JBossDestination destination) throws JMSException
/*     */   {
/* 332 */     RequestSupport req = new SessionDeleteTemporaryDestinationRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, destination);
/*     */ 
/* 334 */     doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public MessageListener org$jboss$jms$client$delegate$ClientSessionDelegate$getMessageListener$aop()
/*     */     throws JMSException
/*     */   {
/* 343 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public boolean org$jboss$jms$client$delegate$ClientSessionDelegate$postDeliver$aop()
/*     */     throws JMSException
/*     */   {
/* 352 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$preDeliver$aop(DeliveryInfo deliveryInfo)
/*     */     throws JMSException
/*     */   {
/* 361 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$recover$aop()
/*     */     throws JMSException
/*     */   {
/* 370 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$redeliver$aop(List ackInfos)
/*     */     throws JMSException
/*     */   {
/* 379 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$rollback$aop()
/*     */     throws JMSException
/*     */   {
/* 388 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$run$aop()
/*     */   {
/* 397 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$setMessageListener$aop(MessageListener listener)
/*     */     throws JMSException
/*     */   {
/* 406 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$unsubscribe$aop(String subscriptionName) throws JMSException
/*     */   {
/* 411 */     RequestSupport req = new SessionUnsubscribeRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, subscriptionName);
/*     */ 
/* 413 */     doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public XAResource org$jboss$jms$client$delegate$ClientSessionDelegate$getXAResource$aop()
/*     */   {
/* 422 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public int org$jboss$jms$client$delegate$ClientSessionDelegate$getAcknowledgeMode$aop()
/*     */   {
/* 431 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public boolean org$jboss$jms$client$delegate$ClientSessionDelegate$getTransacted$aop()
/*     */   {
/* 440 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$addAsfMessage$aop(MessageProxy m, String consumerID, String queueName, int maxDeliveries, SessionDelegate connectionConsumerSession, boolean shouldAck)
/*     */   {
/* 450 */     throw new IllegalStateException("This invocation should not be handled here!");
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$send$aop(JBossMessage m, boolean checkForDuplicates)
/*     */     throws JMSException
/*     */   {
/*     */     long seq;
/*     */     long seq;
/* 457 */     if ((m.isReliable()) || (this.strictTck))
/*     */     {
/* 459 */       seq = -1L;
/*     */     }
/*     */     else
/*     */     {
/* 463 */       SessionState sstate = (SessionState)this.jdField_state_of_type_OrgJbossJmsClientStateHierarchicalState;
/*     */ 
/* 465 */       seq = sstate.getNPSendSequence();
/*     */ 
/* 467 */       sstate.incNpSendSequence();
/*     */     }
/*     */ 
/* 470 */     RequestSupport req = new SessionSendRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, m, checkForDuplicates, seq);
/*     */ 
/* 472 */     if (seq == -1L)
/*     */     {
/* 474 */       doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */     }
/*     */     else
/*     */     {
/* 478 */       doInvokeOneway(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$cancelDeliveries$aop(List cancels) throws JMSException
/*     */   {
/* 484 */     RequestSupport req = new SessionCancelDeliveriesRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, cancels);
/*     */ 
/* 486 */     doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$cancelDelivery$aop(Cancel cancel) throws JMSException
/*     */   {
/* 491 */     RequestSupport req = new SessionCancelDeliveryRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, cancel);
/*     */ 
/* 493 */     doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public void org$jboss$jms$client$delegate$ClientSessionDelegate$recoverDeliveries$aop(List acks, String sessionID) throws JMSException
/*     */   {
/* 498 */     RequestSupport req = new SessionRecoverDeliveriesRequest(this.jdField_id_of_type_JavaLangString, this.jdField_version_of_type_Byte, acks, sessionID);
/*     */ 
/* 500 */     doInvoke(this.jdField_client_of_type_OrgJbossRemotingClient, req);
/*     */   }
/*     */ 
/*     */   public static class close_N4742752445160157748 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public close_N4742752445160157748(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public close_N4742752445160157748(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public close_N4742752445160157748(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public close_N4742752445160157748()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$close$aop();
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       close_N4742752445160157748 localclose_N4742752445160157748 = new close_N4742752445160157748(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localclose_N4742752445160157748.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localclose_N4742752445160157748.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localclose_N4742752445160157748.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localclose_N4742752445160157748.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localclose_N4742752445160157748.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localclose_N4742752445160157748.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localclose_N4742752445160157748;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class closing_2473194355759371067 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public long arg0;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public closing_2473194355759371067(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public closing_2473194355759371067(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public closing_2473194355759371067(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public closing_2473194355759371067()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       this.jdField_arg0_of_type_Long = ((Long)paramArrayOfObject[0]).longValue();
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       Long tmp59_56 = new java/lang/Long;
/*     */       Long tmp60_59 = tmp59_56;
/*     */       Long tmp60_59 = tmp59_56;
/*     */       tmp60_59;
/*     */       this.jdField_arg0_of_type_Long.<init>(tmp60_59);
/*     */       tmp60_59[tmp60_59] = 0;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       closing_2473194355759371067 localclosing_2473194355759371067 = new closing_2473194355759371067(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localclosing_2473194355759371067.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localclosing_2473194355759371067.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localclosing_2473194355759371067.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localclosing_2473194355759371067.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localclosing_2473194355759371067.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localclosing_2473194355759371067.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localclosing_2473194355759371067.jdField_arg0_of_type_Long = this.jdField_arg0_of_type_Long;
/*     */       return localclosing_2473194355759371067;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class acknowledgeDelivery_N5825751487881460811 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public Ack arg0;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public acknowledgeDelivery_N5825751487881460811(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public acknowledgeDelivery_N5825751487881460811(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public acknowledgeDelivery_N5825751487881460811(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public acknowledgeDelivery_N5825751487881460811()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       Boolean tmp76_73 = new java/lang/Boolean;
/*     */       Boolean tmp77_76 = tmp76_73;
/*     */       tmp77_76;
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$acknowledgeDelivery$aop(this.jdField_arg0_of_type_OrgJbossJmsDelegateAck).<init>(tmp76_73);
/*     */       return tmp77_76;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_OrgJbossJmsDelegateAck = ((Ack)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_OrgJbossJmsDelegateAck;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       acknowledgeDelivery_N5825751487881460811 localacknowledgeDelivery_N5825751487881460811 = new acknowledgeDelivery_N5825751487881460811(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localacknowledgeDelivery_N5825751487881460811.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localacknowledgeDelivery_N5825751487881460811.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localacknowledgeDelivery_N5825751487881460811.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localacknowledgeDelivery_N5825751487881460811.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localacknowledgeDelivery_N5825751487881460811.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localacknowledgeDelivery_N5825751487881460811.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localacknowledgeDelivery_N5825751487881460811.jdField_arg0_of_type_OrgJbossJmsDelegateAck = this.jdField_arg0_of_type_OrgJbossJmsDelegateAck;
/*     */       return localacknowledgeDelivery_N5825751487881460811;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class acknowledgeDeliveries_1767561430588382789 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public List arg0;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public acknowledgeDeliveries_1767561430588382789(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public acknowledgeDeliveries_1767561430588382789(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public acknowledgeDeliveries_1767561430588382789(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public acknowledgeDeliveries_1767561430588382789()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$acknowledgeDeliveries$aop(this.jdField_arg0_of_type_JavaUtilList);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_JavaUtilList = ((List)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_JavaUtilList;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       acknowledgeDeliveries_1767561430588382789 localacknowledgeDeliveries_1767561430588382789 = new acknowledgeDeliveries_1767561430588382789(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localacknowledgeDeliveries_1767561430588382789.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localacknowledgeDeliveries_1767561430588382789.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localacknowledgeDeliveries_1767561430588382789.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localacknowledgeDeliveries_1767561430588382789.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localacknowledgeDeliveries_1767561430588382789.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localacknowledgeDeliveries_1767561430588382789.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localacknowledgeDeliveries_1767561430588382789.jdField_arg0_of_type_JavaUtilList = this.jdField_arg0_of_type_JavaUtilList;
/*     */       return localacknowledgeDeliveries_1767561430588382789;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class acknowledgeAll_3428828241771477154 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public acknowledgeAll_3428828241771477154(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public acknowledgeAll_3428828241771477154(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public acknowledgeAll_3428828241771477154(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public acknowledgeAll_3428828241771477154()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$acknowledgeAll$aop();
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       acknowledgeAll_3428828241771477154 localacknowledgeAll_3428828241771477154 = new acknowledgeAll_3428828241771477154(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localacknowledgeAll_3428828241771477154.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localacknowledgeAll_3428828241771477154.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localacknowledgeAll_3428828241771477154.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localacknowledgeAll_3428828241771477154.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localacknowledgeAll_3428828241771477154.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localacknowledgeAll_3428828241771477154.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localacknowledgeAll_3428828241771477154;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class addTemporaryDestination_4607215820163210272 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public JBossDestination arg0;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public addTemporaryDestination_4607215820163210272(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public addTemporaryDestination_4607215820163210272(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public addTemporaryDestination_4607215820163210272(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public addTemporaryDestination_4607215820163210272()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$addTemporaryDestination$aop(this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination = ((JBossDestination)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       addTemporaryDestination_4607215820163210272 localaddTemporaryDestination_4607215820163210272 = new addTemporaryDestination_4607215820163210272(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localaddTemporaryDestination_4607215820163210272.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localaddTemporaryDestination_4607215820163210272.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localaddTemporaryDestination_4607215820163210272.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localaddTemporaryDestination_4607215820163210272.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localaddTemporaryDestination_4607215820163210272.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localaddTemporaryDestination_4607215820163210272.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localaddTemporaryDestination_4607215820163210272.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination = this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination;
/*     */       return localaddTemporaryDestination_4607215820163210272;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class commit_8461082169793485964 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public commit_8461082169793485964(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public commit_8461082169793485964(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public commit_8461082169793485964(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public commit_8461082169793485964()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$commit$aop();
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       commit_8461082169793485964 localcommit_8461082169793485964 = new commit_8461082169793485964(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcommit_8461082169793485964.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcommit_8461082169793485964.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcommit_8461082169793485964.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcommit_8461082169793485964.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcommit_8461082169793485964.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localcommit_8461082169793485964.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localcommit_8461082169793485964;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class createBrowserDelegate_N5828981013655274081 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public JBossDestination arg0;
/*     */     public String arg1;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public createBrowserDelegate_N5828981013655274081(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createBrowserDelegate_N5828981013655274081(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createBrowserDelegate_N5828981013655274081(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createBrowserDelegate_N5828981013655274081()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$createBrowserDelegate$aop(this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination, this.jdField_arg1_of_type_JavaLangString);
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject1 = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination = ((JBossDestination)localObject1);
/*     */       Object localObject2 = paramArrayOfObject[1];
/*     */       this.jdField_arg1_of_type_JavaLangString = ((String)localObject2);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[2];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[1] = this.jdField_arg1_of_type_JavaLangString;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createBrowserDelegate_N5828981013655274081 localcreateBrowserDelegate_N5828981013655274081 = new createBrowserDelegate_N5828981013655274081(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateBrowserDelegate_N5828981013655274081.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateBrowserDelegate_N5828981013655274081.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateBrowserDelegate_N5828981013655274081.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateBrowserDelegate_N5828981013655274081.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateBrowserDelegate_N5828981013655274081.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localcreateBrowserDelegate_N5828981013655274081.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localcreateBrowserDelegate_N5828981013655274081.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination = this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination;
/*     */       localcreateBrowserDelegate_N5828981013655274081.jdField_arg1_of_type_JavaLangString = this.jdField_arg1_of_type_JavaLangString;
/*     */       return localcreateBrowserDelegate_N5828981013655274081;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class createBytesMessage_7082074764812825153 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public createBytesMessage_7082074764812825153(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createBytesMessage_7082074764812825153(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createBytesMessage_7082074764812825153(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createBytesMessage_7082074764812825153()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$createBytesMessage$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createBytesMessage_7082074764812825153 localcreateBytesMessage_7082074764812825153 = new createBytesMessage_7082074764812825153(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateBytesMessage_7082074764812825153.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateBytesMessage_7082074764812825153.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateBytesMessage_7082074764812825153.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateBytesMessage_7082074764812825153.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateBytesMessage_7082074764812825153.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localcreateBytesMessage_7082074764812825153.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localcreateBytesMessage_7082074764812825153;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class createConsumerDelegate_8721389917985689973 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public JBossDestination arg0;
/*     */     public String arg1;
/*     */     public boolean arg2;
/*     */     public String arg3;
/*     */     public boolean arg4;
/*     */     public boolean arg5;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public createConsumerDelegate_8721389917985689973(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createConsumerDelegate_8721389917985689973(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createConsumerDelegate_8721389917985689973(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createConsumerDelegate_8721389917985689973()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$createConsumerDelegate$aop(this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination, this.jdField_arg1_of_type_JavaLangString, this.jdField_arg2_of_type_Boolean, this.jdField_arg3_of_type_JavaLangString, this.jdField_arg4_of_type_Boolean, this.jdField_arg5_of_type_Boolean);
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject1 = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination = ((JBossDestination)localObject1);
/*     */       Object localObject2 = paramArrayOfObject[1];
/*     */       this.jdField_arg1_of_type_JavaLangString = ((String)localObject2);
/*     */       this.jdField_arg2_of_type_Boolean = ((Boolean)paramArrayOfObject[2]).booleanValue();
/*     */       Object localObject3 = paramArrayOfObject[3];
/*     */       this.jdField_arg3_of_type_JavaLangString = ((String)localObject3);
/*     */       this.jdField_arg4_of_type_Boolean = ((Boolean)paramArrayOfObject[4]).booleanValue();
/*     */       this.jdField_arg5_of_type_Boolean = ((Boolean)paramArrayOfObject[5]).booleanValue();
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[6];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[1] = this.jdField_arg1_of_type_JavaLangString;
/*     */       Boolean tmp80_77 = new java/lang/Boolean;
/*     */       Boolean tmp81_80 = tmp80_77;
/*     */       Boolean tmp81_80 = tmp80_77;
/*     */       tmp81_80;
/*     */       this.jdField_arg2_of_type_Boolean.<init>(tmp81_80);
/*     */       2[tmp81_80] = tmp81_80;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[3] = this.jdField_arg3_of_type_JavaLangString;
/*     */       Boolean tmp109_106 = new java/lang/Boolean;
/*     */       Boolean tmp110_109 = tmp109_106;
/*     */       Boolean tmp110_109 = tmp109_106;
/*     */       tmp110_109;
/*     */       this.jdField_arg4_of_type_Boolean.<init>(tmp110_109);
/*     */       4[tmp110_109] = tmp110_109;
/*     */       Boolean tmp128_125 = new java/lang/Boolean;
/*     */       Boolean tmp129_128 = tmp128_125;
/*     */       Boolean tmp129_128 = tmp128_125;
/*     */       tmp129_128;
/*     */       this.jdField_arg5_of_type_Boolean.<init>(tmp129_128);
/*     */       5[tmp129_128] = tmp129_128;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createConsumerDelegate_8721389917985689973 localcreateConsumerDelegate_8721389917985689973 = new createConsumerDelegate_8721389917985689973(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateConsumerDelegate_8721389917985689973.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateConsumerDelegate_8721389917985689973.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateConsumerDelegate_8721389917985689973.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateConsumerDelegate_8721389917985689973.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateConsumerDelegate_8721389917985689973.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localcreateConsumerDelegate_8721389917985689973.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localcreateConsumerDelegate_8721389917985689973.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination = this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination;
/*     */       localcreateConsumerDelegate_8721389917985689973.jdField_arg1_of_type_JavaLangString = this.jdField_arg1_of_type_JavaLangString;
/*     */       localcreateConsumerDelegate_8721389917985689973.jdField_arg2_of_type_Boolean = this.jdField_arg2_of_type_Boolean;
/*     */       localcreateConsumerDelegate_8721389917985689973.jdField_arg3_of_type_JavaLangString = this.jdField_arg3_of_type_JavaLangString;
/*     */       localcreateConsumerDelegate_8721389917985689973.jdField_arg4_of_type_Boolean = this.jdField_arg4_of_type_Boolean;
/*     */       localcreateConsumerDelegate_8721389917985689973.jdField_arg5_of_type_Boolean = this.jdField_arg5_of_type_Boolean;
/*     */       return localcreateConsumerDelegate_8721389917985689973;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class createMapMessage_6454173539027268961 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public createMapMessage_6454173539027268961(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createMapMessage_6454173539027268961(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createMapMessage_6454173539027268961(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createMapMessage_6454173539027268961()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$createMapMessage$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createMapMessage_6454173539027268961 localcreateMapMessage_6454173539027268961 = new createMapMessage_6454173539027268961(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateMapMessage_6454173539027268961.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateMapMessage_6454173539027268961.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateMapMessage_6454173539027268961.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateMapMessage_6454173539027268961.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateMapMessage_6454173539027268961.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localcreateMapMessage_6454173539027268961.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localcreateMapMessage_6454173539027268961;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class createMessage_7458165539797107901 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public createMessage_7458165539797107901(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createMessage_7458165539797107901(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createMessage_7458165539797107901(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createMessage_7458165539797107901()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$createMessage$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createMessage_7458165539797107901 localcreateMessage_7458165539797107901 = new createMessage_7458165539797107901(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateMessage_7458165539797107901.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateMessage_7458165539797107901.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateMessage_7458165539797107901.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateMessage_7458165539797107901.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateMessage_7458165539797107901.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localcreateMessage_7458165539797107901.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localcreateMessage_7458165539797107901;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class createObjectMessage_N7497440531089519617 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public createObjectMessage_N7497440531089519617(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createObjectMessage_N7497440531089519617(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createObjectMessage_N7497440531089519617(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createObjectMessage_N7497440531089519617()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$createObjectMessage$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createObjectMessage_N7497440531089519617 localcreateObjectMessage_N7497440531089519617 = new createObjectMessage_N7497440531089519617(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateObjectMessage_N7497440531089519617.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateObjectMessage_N7497440531089519617.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateObjectMessage_N7497440531089519617.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateObjectMessage_N7497440531089519617.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateObjectMessage_N7497440531089519617.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localcreateObjectMessage_N7497440531089519617.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localcreateObjectMessage_N7497440531089519617;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class createObjectMessage_5541516037526997237 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public Serializable arg0;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public createObjectMessage_5541516037526997237(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createObjectMessage_5541516037526997237(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createObjectMessage_5541516037526997237(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createObjectMessage_5541516037526997237()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$createObjectMessage$aop(this.jdField_arg0_of_type_JavaIoSerializable);
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_JavaIoSerializable = ((Serializable)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_JavaIoSerializable;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createObjectMessage_5541516037526997237 localcreateObjectMessage_5541516037526997237 = new createObjectMessage_5541516037526997237(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateObjectMessage_5541516037526997237.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateObjectMessage_5541516037526997237.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateObjectMessage_5541516037526997237.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateObjectMessage_5541516037526997237.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateObjectMessage_5541516037526997237.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localcreateObjectMessage_5541516037526997237.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localcreateObjectMessage_5541516037526997237.jdField_arg0_of_type_JavaIoSerializable = this.jdField_arg0_of_type_JavaIoSerializable;
/*     */       return localcreateObjectMessage_5541516037526997237;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class createProducerDelegate_332221920261695411 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public JBossDestination arg0;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public createProducerDelegate_332221920261695411(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createProducerDelegate_332221920261695411(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createProducerDelegate_332221920261695411(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createProducerDelegate_332221920261695411()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$createProducerDelegate$aop(this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination);
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination = ((JBossDestination)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createProducerDelegate_332221920261695411 localcreateProducerDelegate_332221920261695411 = new createProducerDelegate_332221920261695411(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateProducerDelegate_332221920261695411.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateProducerDelegate_332221920261695411.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateProducerDelegate_332221920261695411.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateProducerDelegate_332221920261695411.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateProducerDelegate_332221920261695411.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localcreateProducerDelegate_332221920261695411.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localcreateProducerDelegate_332221920261695411.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination = this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination;
/*     */       return localcreateProducerDelegate_332221920261695411;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class createQueue_6431069199924553036 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public String arg0;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public createQueue_6431069199924553036(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createQueue_6431069199924553036(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createQueue_6431069199924553036(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createQueue_6431069199924553036()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$createQueue$aop(this.jdField_arg0_of_type_JavaLangString);
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_JavaLangString = ((String)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_JavaLangString;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createQueue_6431069199924553036 localcreateQueue_6431069199924553036 = new createQueue_6431069199924553036(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateQueue_6431069199924553036.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateQueue_6431069199924553036.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateQueue_6431069199924553036.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateQueue_6431069199924553036.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateQueue_6431069199924553036.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localcreateQueue_6431069199924553036.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localcreateQueue_6431069199924553036.jdField_arg0_of_type_JavaLangString = this.jdField_arg0_of_type_JavaLangString;
/*     */       return localcreateQueue_6431069199924553036;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class createStreamMessage_N9186959628979934744 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public createStreamMessage_N9186959628979934744(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createStreamMessage_N9186959628979934744(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createStreamMessage_N9186959628979934744(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createStreamMessage_N9186959628979934744()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$createStreamMessage$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createStreamMessage_N9186959628979934744 localcreateStreamMessage_N9186959628979934744 = new createStreamMessage_N9186959628979934744(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateStreamMessage_N9186959628979934744.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateStreamMessage_N9186959628979934744.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateStreamMessage_N9186959628979934744.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateStreamMessage_N9186959628979934744.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateStreamMessage_N9186959628979934744.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localcreateStreamMessage_N9186959628979934744.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localcreateStreamMessage_N9186959628979934744;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class createTextMessage_2320081262968295190 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public createTextMessage_2320081262968295190(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createTextMessage_2320081262968295190(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createTextMessage_2320081262968295190(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createTextMessage_2320081262968295190()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$createTextMessage$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createTextMessage_2320081262968295190 localcreateTextMessage_2320081262968295190 = new createTextMessage_2320081262968295190(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateTextMessage_2320081262968295190.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateTextMessage_2320081262968295190.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateTextMessage_2320081262968295190.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateTextMessage_2320081262968295190.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateTextMessage_2320081262968295190.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localcreateTextMessage_2320081262968295190.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localcreateTextMessage_2320081262968295190;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class createTextMessage_4391803803118822775 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public String arg0;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public createTextMessage_4391803803118822775(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createTextMessage_4391803803118822775(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createTextMessage_4391803803118822775(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createTextMessage_4391803803118822775()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$createTextMessage$aop(this.jdField_arg0_of_type_JavaLangString);
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_JavaLangString = ((String)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_JavaLangString;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createTextMessage_4391803803118822775 localcreateTextMessage_4391803803118822775 = new createTextMessage_4391803803118822775(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateTextMessage_4391803803118822775.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateTextMessage_4391803803118822775.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateTextMessage_4391803803118822775.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateTextMessage_4391803803118822775.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateTextMessage_4391803803118822775.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localcreateTextMessage_4391803803118822775.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localcreateTextMessage_4391803803118822775.jdField_arg0_of_type_JavaLangString = this.jdField_arg0_of_type_JavaLangString;
/*     */       return localcreateTextMessage_4391803803118822775;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class createTopic_N1144803973659535745 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public String arg0;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public createTopic_N1144803973659535745(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public createTopic_N1144803973659535745(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public createTopic_N1144803973659535745(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public createTopic_N1144803973659535745()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$createTopic$aop(this.jdField_arg0_of_type_JavaLangString);
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_JavaLangString = ((String)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_JavaLangString;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       createTopic_N1144803973659535745 localcreateTopic_N1144803973659535745 = new createTopic_N1144803973659535745(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcreateTopic_N1144803973659535745.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcreateTopic_N1144803973659535745.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcreateTopic_N1144803973659535745.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcreateTopic_N1144803973659535745.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcreateTopic_N1144803973659535745.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localcreateTopic_N1144803973659535745.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localcreateTopic_N1144803973659535745.jdField_arg0_of_type_JavaLangString = this.jdField_arg0_of_type_JavaLangString;
/*     */       return localcreateTopic_N1144803973659535745;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class deleteTemporaryDestination_N5233806045047796315 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public JBossDestination arg0;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public deleteTemporaryDestination_N5233806045047796315(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public deleteTemporaryDestination_N5233806045047796315(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public deleteTemporaryDestination_N5233806045047796315(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public deleteTemporaryDestination_N5233806045047796315()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$deleteTemporaryDestination$aop(this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination = ((JBossDestination)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       deleteTemporaryDestination_N5233806045047796315 localdeleteTemporaryDestination_N5233806045047796315 = new deleteTemporaryDestination_N5233806045047796315(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localdeleteTemporaryDestination_N5233806045047796315.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localdeleteTemporaryDestination_N5233806045047796315.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localdeleteTemporaryDestination_N5233806045047796315.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localdeleteTemporaryDestination_N5233806045047796315.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localdeleteTemporaryDestination_N5233806045047796315.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localdeleteTemporaryDestination_N5233806045047796315.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localdeleteTemporaryDestination_N5233806045047796315.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination = this.jdField_arg0_of_type_OrgJbossJmsDestinationJBossDestination;
/*     */       return localdeleteTemporaryDestination_N5233806045047796315;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getMessageListener_2204309074290103460 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public getMessageListener_2204309074290103460(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getMessageListener_2204309074290103460(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getMessageListener_2204309074290103460(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getMessageListener_2204309074290103460()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$getMessageListener$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getMessageListener_2204309074290103460 localgetMessageListener_2204309074290103460 = new getMessageListener_2204309074290103460(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetMessageListener_2204309074290103460.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetMessageListener_2204309074290103460.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetMessageListener_2204309074290103460.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetMessageListener_2204309074290103460.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetMessageListener_2204309074290103460.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localgetMessageListener_2204309074290103460.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localgetMessageListener_2204309074290103460;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class postDeliver_1255239194451907669 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public postDeliver_1255239194451907669(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public postDeliver_1255239194451907669(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public postDeliver_1255239194451907669(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public postDeliver_1255239194451907669()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       Boolean tmp72_69 = new java/lang/Boolean;
/*     */       Boolean tmp73_72 = tmp72_69;
/*     */       tmp73_72;
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$postDeliver$aop().<init>(tmp72_69);
/*     */       return tmp73_72;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       postDeliver_1255239194451907669 localpostDeliver_1255239194451907669 = new postDeliver_1255239194451907669(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localpostDeliver_1255239194451907669.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localpostDeliver_1255239194451907669.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localpostDeliver_1255239194451907669.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localpostDeliver_1255239194451907669.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localpostDeliver_1255239194451907669.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localpostDeliver_1255239194451907669.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localpostDeliver_1255239194451907669;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class preDeliver_5548846795541436298 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public DeliveryInfo arg0;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public preDeliver_5548846795541436298(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public preDeliver_5548846795541436298(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public preDeliver_5548846795541436298(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public preDeliver_5548846795541436298()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$preDeliver$aop(this.jdField_arg0_of_type_OrgJbossJmsDelegateDeliveryInfo);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_OrgJbossJmsDelegateDeliveryInfo = ((DeliveryInfo)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_OrgJbossJmsDelegateDeliveryInfo;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       preDeliver_5548846795541436298 localpreDeliver_5548846795541436298 = new preDeliver_5548846795541436298(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localpreDeliver_5548846795541436298.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localpreDeliver_5548846795541436298.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localpreDeliver_5548846795541436298.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localpreDeliver_5548846795541436298.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localpreDeliver_5548846795541436298.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localpreDeliver_5548846795541436298.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localpreDeliver_5548846795541436298.jdField_arg0_of_type_OrgJbossJmsDelegateDeliveryInfo = this.jdField_arg0_of_type_OrgJbossJmsDelegateDeliveryInfo;
/*     */       return localpreDeliver_5548846795541436298;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class recover_6753106934534422686 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public recover_6753106934534422686(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public recover_6753106934534422686(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public recover_6753106934534422686(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public recover_6753106934534422686()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$recover$aop();
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       recover_6753106934534422686 localrecover_6753106934534422686 = new recover_6753106934534422686(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localrecover_6753106934534422686.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localrecover_6753106934534422686.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localrecover_6753106934534422686.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localrecover_6753106934534422686.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localrecover_6753106934534422686.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localrecover_6753106934534422686.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localrecover_6753106934534422686;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class redeliver_N1959001033568420259 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public List arg0;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public redeliver_N1959001033568420259(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public redeliver_N1959001033568420259(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public redeliver_N1959001033568420259(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public redeliver_N1959001033568420259()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$redeliver$aop(this.jdField_arg0_of_type_JavaUtilList);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_JavaUtilList = ((List)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_JavaUtilList;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       redeliver_N1959001033568420259 localredeliver_N1959001033568420259 = new redeliver_N1959001033568420259(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localredeliver_N1959001033568420259.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localredeliver_N1959001033568420259.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localredeliver_N1959001033568420259.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localredeliver_N1959001033568420259.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localredeliver_N1959001033568420259.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localredeliver_N1959001033568420259.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localredeliver_N1959001033568420259.jdField_arg0_of_type_JavaUtilList = this.jdField_arg0_of_type_JavaUtilList;
/*     */       return localredeliver_N1959001033568420259;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class rollback_N2202008398766919932 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public rollback_N2202008398766919932(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public rollback_N2202008398766919932(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public rollback_N2202008398766919932(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public rollback_N2202008398766919932()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$rollback$aop();
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       rollback_N2202008398766919932 localrollback_N2202008398766919932 = new rollback_N2202008398766919932(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localrollback_N2202008398766919932.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localrollback_N2202008398766919932.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localrollback_N2202008398766919932.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localrollback_N2202008398766919932.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localrollback_N2202008398766919932.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localrollback_N2202008398766919932.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localrollback_N2202008398766919932;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class run_N8003352271541955702 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public run_N8003352271541955702(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public run_N8003352271541955702(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public run_N8003352271541955702(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public run_N8003352271541955702()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$run$aop();
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       run_N8003352271541955702 localrun_N8003352271541955702 = new run_N8003352271541955702(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localrun_N8003352271541955702.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localrun_N8003352271541955702.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localrun_N8003352271541955702.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localrun_N8003352271541955702.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localrun_N8003352271541955702.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localrun_N8003352271541955702.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localrun_N8003352271541955702;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class setMessageListener_N8112055063220820757 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public MessageListener arg0;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public setMessageListener_N8112055063220820757(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public setMessageListener_N8112055063220820757(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public setMessageListener_N8112055063220820757(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public setMessageListener_N8112055063220820757()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$setMessageListener$aop(this.jdField_arg0_of_type_JavaxJmsMessageListener);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_JavaxJmsMessageListener = ((MessageListener)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_JavaxJmsMessageListener;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       setMessageListener_N8112055063220820757 localsetMessageListener_N8112055063220820757 = new setMessageListener_N8112055063220820757(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localsetMessageListener_N8112055063220820757.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localsetMessageListener_N8112055063220820757.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localsetMessageListener_N8112055063220820757.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localsetMessageListener_N8112055063220820757.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localsetMessageListener_N8112055063220820757.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localsetMessageListener_N8112055063220820757.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localsetMessageListener_N8112055063220820757.jdField_arg0_of_type_JavaxJmsMessageListener = this.jdField_arg0_of_type_JavaxJmsMessageListener;
/*     */       return localsetMessageListener_N8112055063220820757;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class unsubscribe_8775578479443985821 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public String arg0;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public unsubscribe_8775578479443985821(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public unsubscribe_8775578479443985821(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public unsubscribe_8775578479443985821(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public unsubscribe_8775578479443985821()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$unsubscribe$aop(this.jdField_arg0_of_type_JavaLangString);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_JavaLangString = ((String)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_JavaLangString;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       unsubscribe_8775578479443985821 localunsubscribe_8775578479443985821 = new unsubscribe_8775578479443985821(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localunsubscribe_8775578479443985821.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localunsubscribe_8775578479443985821.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localunsubscribe_8775578479443985821.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localunsubscribe_8775578479443985821.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localunsubscribe_8775578479443985821.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localunsubscribe_8775578479443985821.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localunsubscribe_8775578479443985821.jdField_arg0_of_type_JavaLangString = this.jdField_arg0_of_type_JavaLangString;
/*     */       return localunsubscribe_8775578479443985821;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getXAResource_5045584642641131496 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public getXAResource_5045584642641131496(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getXAResource_5045584642641131496(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getXAResource_5045584642641131496(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getXAResource_5045584642641131496()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       return this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$getXAResource$aop();
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getXAResource_5045584642641131496 localgetXAResource_5045584642641131496 = new getXAResource_5045584642641131496(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetXAResource_5045584642641131496.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetXAResource_5045584642641131496.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetXAResource_5045584642641131496.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetXAResource_5045584642641131496.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetXAResource_5045584642641131496.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localgetXAResource_5045584642641131496.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localgetXAResource_5045584642641131496;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getAcknowledgeMode_N7774033054566619384 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public getAcknowledgeMode_N7774033054566619384(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getAcknowledgeMode_N7774033054566619384(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getAcknowledgeMode_N7774033054566619384(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getAcknowledgeMode_N7774033054566619384()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       Integer tmp72_69 = new java/lang/Integer;
/*     */       Integer tmp73_72 = tmp72_69;
/*     */       tmp73_72;
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$getAcknowledgeMode$aop().<init>(tmp72_69);
/*     */       return tmp73_72;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getAcknowledgeMode_N7774033054566619384 localgetAcknowledgeMode_N7774033054566619384 = new getAcknowledgeMode_N7774033054566619384(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetAcknowledgeMode_N7774033054566619384.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetAcknowledgeMode_N7774033054566619384.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetAcknowledgeMode_N7774033054566619384.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetAcknowledgeMode_N7774033054566619384.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetAcknowledgeMode_N7774033054566619384.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localgetAcknowledgeMode_N7774033054566619384.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localgetAcknowledgeMode_N7774033054566619384;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class getTransacted_N1613179584734032131 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public getTransacted_N1613179584734032131(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public getTransacted_N1613179584734032131(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public getTransacted_N1613179584734032131(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public getTransacted_N1613179584734032131()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       Boolean tmp72_69 = new java/lang/Boolean;
/*     */       Boolean tmp73_72 = tmp72_69;
/*     */       tmp73_72;
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$getTransacted$aop().<init>(tmp72_69);
/*     */       return tmp73_72;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       getTransacted_N1613179584734032131 localgetTransacted_N1613179584734032131 = new getTransacted_N1613179584734032131(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localgetTransacted_N1613179584734032131.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localgetTransacted_N1613179584734032131.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localgetTransacted_N1613179584734032131.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localgetTransacted_N1613179584734032131.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localgetTransacted_N1613179584734032131.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localgetTransacted_N1613179584734032131.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       return localgetTransacted_N1613179584734032131;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class addAsfMessage_N3142450851726069886 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public MessageProxy arg0;
/*     */     public String arg1;
/*     */     public String arg2;
/*     */     public int arg3;
/*     */     public SessionDelegate arg4;
/*     */     public boolean arg5;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public addAsfMessage_N3142450851726069886(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public addAsfMessage_N3142450851726069886(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public addAsfMessage_N3142450851726069886(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public addAsfMessage_N3142450851726069886()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$addAsfMessage$aop(this.jdField_arg0_of_type_OrgJbossJmsMessageMessageProxy, this.jdField_arg1_of_type_JavaLangString, this.jdField_arg2_of_type_JavaLangString, this.jdField_arg3_of_type_Int, this.jdField_arg4_of_type_OrgJbossJmsDelegateSessionDelegate, this.jdField_arg5_of_type_Boolean);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject1 = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_OrgJbossJmsMessageMessageProxy = ((MessageProxy)localObject1);
/*     */       Object localObject2 = paramArrayOfObject[1];
/*     */       this.jdField_arg1_of_type_JavaLangString = ((String)localObject2);
/*     */       Object localObject3 = paramArrayOfObject[2];
/*     */       this.jdField_arg2_of_type_JavaLangString = ((String)localObject3);
/*     */       this.jdField_arg3_of_type_Int = ((Integer)paramArrayOfObject[3]).intValue();
/*     */       Object localObject4 = paramArrayOfObject[4];
/*     */       this.jdField_arg4_of_type_OrgJbossJmsDelegateSessionDelegate = ((SessionDelegate)localObject4);
/*     */       this.jdField_arg5_of_type_Boolean = ((Boolean)paramArrayOfObject[5]).booleanValue();
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[6];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_OrgJbossJmsMessageMessageProxy;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[1] = this.jdField_arg1_of_type_JavaLangString;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[2] = this.jdField_arg2_of_type_JavaLangString;
/*     */       Integer tmp90_87 = new java/lang/Integer;
/*     */       Integer tmp91_90 = tmp90_87;
/*     */       Integer tmp91_90 = tmp90_87;
/*     */       tmp91_90;
/*     */       this.jdField_arg3_of_type_Int.<init>(tmp91_90);
/*     */       3[tmp91_90] = tmp91_90;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[4] = this.jdField_arg4_of_type_OrgJbossJmsDelegateSessionDelegate;
/*     */       Boolean tmp119_116 = new java/lang/Boolean;
/*     */       Boolean tmp120_119 = tmp119_116;
/*     */       Boolean tmp120_119 = tmp119_116;
/*     */       tmp120_119;
/*     */       this.jdField_arg5_of_type_Boolean.<init>(tmp120_119);
/*     */       5[tmp120_119] = tmp120_119;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       addAsfMessage_N3142450851726069886 localaddAsfMessage_N3142450851726069886 = new addAsfMessage_N3142450851726069886(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localaddAsfMessage_N3142450851726069886.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localaddAsfMessage_N3142450851726069886.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localaddAsfMessage_N3142450851726069886.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localaddAsfMessage_N3142450851726069886.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localaddAsfMessage_N3142450851726069886.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localaddAsfMessage_N3142450851726069886.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localaddAsfMessage_N3142450851726069886.jdField_arg0_of_type_OrgJbossJmsMessageMessageProxy = this.jdField_arg0_of_type_OrgJbossJmsMessageMessageProxy;
/*     */       localaddAsfMessage_N3142450851726069886.jdField_arg1_of_type_JavaLangString = this.jdField_arg1_of_type_JavaLangString;
/*     */       localaddAsfMessage_N3142450851726069886.jdField_arg2_of_type_JavaLangString = this.jdField_arg2_of_type_JavaLangString;
/*     */       localaddAsfMessage_N3142450851726069886.jdField_arg3_of_type_Int = this.jdField_arg3_of_type_Int;
/*     */       localaddAsfMessage_N3142450851726069886.jdField_arg4_of_type_OrgJbossJmsDelegateSessionDelegate = this.jdField_arg4_of_type_OrgJbossJmsDelegateSessionDelegate;
/*     */       localaddAsfMessage_N3142450851726069886.jdField_arg5_of_type_Boolean = this.jdField_arg5_of_type_Boolean;
/*     */       return localaddAsfMessage_N3142450851726069886;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class send_6145266547759487588 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public JBossMessage arg0;
/*     */     public boolean arg1;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public send_6145266547759487588(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public send_6145266547759487588(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public send_6145266547759487588(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public send_6145266547759487588()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$send$aop(this.jdField_arg0_of_type_OrgJbossJmsMessageJBossMessage, this.jdField_arg1_of_type_Boolean);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_OrgJbossJmsMessageJBossMessage = ((JBossMessage)localObject);
/*     */       this.jdField_arg1_of_type_Boolean = ((Boolean)paramArrayOfObject[1]).booleanValue();
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[2];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_OrgJbossJmsMessageJBossMessage;
/*     */       Boolean tmp69_66 = new java/lang/Boolean;
/*     */       Boolean tmp70_69 = tmp69_66;
/*     */       Boolean tmp70_69 = tmp69_66;
/*     */       tmp70_69;
/*     */       this.jdField_arg1_of_type_Boolean.<init>(tmp70_69);
/*     */       1[tmp70_69] = tmp70_69;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       send_6145266547759487588 localsend_6145266547759487588 = new send_6145266547759487588(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localsend_6145266547759487588.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localsend_6145266547759487588.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localsend_6145266547759487588.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localsend_6145266547759487588.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localsend_6145266547759487588.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localsend_6145266547759487588.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localsend_6145266547759487588.jdField_arg0_of_type_OrgJbossJmsMessageJBossMessage = this.jdField_arg0_of_type_OrgJbossJmsMessageJBossMessage;
/*     */       localsend_6145266547759487588.jdField_arg1_of_type_Boolean = this.jdField_arg1_of_type_Boolean;
/*     */       return localsend_6145266547759487588;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class cancelDeliveries_6592991528584912127 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public List arg0;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public cancelDeliveries_6592991528584912127(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public cancelDeliveries_6592991528584912127(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public cancelDeliveries_6592991528584912127(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public cancelDeliveries_6592991528584912127()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$cancelDeliveries$aop(this.jdField_arg0_of_type_JavaUtilList);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_JavaUtilList = ((List)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_JavaUtilList;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       cancelDeliveries_6592991528584912127 localcancelDeliveries_6592991528584912127 = new cancelDeliveries_6592991528584912127(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcancelDeliveries_6592991528584912127.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcancelDeliveries_6592991528584912127.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcancelDeliveries_6592991528584912127.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcancelDeliveries_6592991528584912127.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcancelDeliveries_6592991528584912127.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localcancelDeliveries_6592991528584912127.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localcancelDeliveries_6592991528584912127.jdField_arg0_of_type_JavaUtilList = this.jdField_arg0_of_type_JavaUtilList;
/*     */       return localcancelDeliveries_6592991528584912127;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class cancelDelivery_2980985335510575813 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public Cancel arg0;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public cancelDelivery_2980985335510575813(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public cancelDelivery_2980985335510575813(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public cancelDelivery_2980985335510575813(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public cancelDelivery_2980985335510575813()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$cancelDelivery$aop(this.jdField_arg0_of_type_OrgJbossJmsDelegateCancel);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_OrgJbossJmsDelegateCancel = ((Cancel)localObject);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[1];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_OrgJbossJmsDelegateCancel;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       cancelDelivery_2980985335510575813 localcancelDelivery_2980985335510575813 = new cancelDelivery_2980985335510575813(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localcancelDelivery_2980985335510575813.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localcancelDelivery_2980985335510575813.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localcancelDelivery_2980985335510575813.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localcancelDelivery_2980985335510575813.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localcancelDelivery_2980985335510575813.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localcancelDelivery_2980985335510575813.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localcancelDelivery_2980985335510575813.jdField_arg0_of_type_OrgJbossJmsDelegateCancel = this.jdField_arg0_of_type_OrgJbossJmsDelegateCancel;
/*     */       return localcancelDelivery_2980985335510575813;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class recoverDeliveries_4196799148363996265 extends MethodInvocation
/*     */     implements Untransformable
/*     */   {
/*     */     public List arg0;
/*     */     public String arg1;
/*     */     public ClientSessionDelegate typedTargetObject;
/*     */ 
/*     */     public recoverDeliveries_4196799148363996265(MethodInfo paramMethodInfo, Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super(paramArrayOfInterceptor);
/*     */     }
/*     */ 
/*     */     public recoverDeliveries_4196799148363996265(Interceptor[] paramArrayOfInterceptor, long paramLong, Method paramMethod1, Method paramMethod2, Advisor paramAdvisor)
/*     */     {
/*     */       super(paramLong, paramMethod1, paramMethod2, paramAdvisor);
/*     */     }
/*     */ 
/*     */     public recoverDeliveries_4196799148363996265(Interceptor[] paramArrayOfInterceptor)
/*     */     {
/*     */       super();
/*     */     }
/*     */ 
/*     */     public recoverDeliveries_4196799148363996265()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object invokeNext()
/*     */       throws Throwable
/*     */     {
/*     */       if (this.jdField_currentInterceptor_of_type_Int < this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor.length)
/*     */         try
/*     */         {
/*     */           localObject1 = this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor[(this.jdField_currentInterceptor_of_type_Int++)].invoke(this);
/*     */         }
/*     */         catch (Throwable localThrowable)
/*     */         {
/*     */           Object localObject1;
/*     */           throw localThrowable;
/*     */         }
/*     */         finally
/*     */         {
/*     */           this.jdField_currentInterceptor_of_type_Int -= 1;
/*     */         }
/*     */       this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate.org$jboss$jms$client$delegate$ClientSessionDelegate$recoverDeliveries$aop(this.jdField_arg0_of_type_JavaUtilList, this.jdField_arg1_of_type_JavaLangString);
/*     */       return null;
/*     */     }
/*     */ 
/*     */     public void setArguments(Object[] paramArrayOfObject)
/*     */     {
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = paramArrayOfObject;
/*     */       Object localObject1 = paramArrayOfObject[0];
/*     */       this.jdField_arg0_of_type_JavaUtilList = ((List)localObject1);
/*     */       Object localObject2 = paramArrayOfObject[1];
/*     */       this.jdField_arg1_of_type_JavaLangString = ((String)localObject2);
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/*     */       if (this.marshalledArguments != null)
/*     */       {
/*     */         Object[] arrayOfObject = super.getArguments();
/*     */         setArguments(arrayOfObject);
/*     */         return arrayOfObject;
/*     */       }
/*     */       if (this.jdField_arguments_of_type_ArrayOfJavaLangObject != (Object[])null)
/*     */         return (Object[])this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject = new Object[2];
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[0] = this.jdField_arg0_of_type_JavaUtilList;
/*     */       this.jdField_arguments_of_type_ArrayOfJavaLangObject[1] = this.jdField_arg1_of_type_JavaLangString;
/*     */       return this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */     }
/*     */ 
/*     */     public Invocation copy()
/*     */     {
/*     */       recoverDeliveries_4196799148363996265 localrecoverDeliveries_4196799148363996265 = new recoverDeliveries_4196799148363996265(this.jdField_interceptors_of_type_ArrayOfOrgJbossAopAdviceInterceptor, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
/*     */       localrecoverDeliveries_4196799148363996265.jdField_arguments_of_type_ArrayOfJavaLangObject = this.jdField_arguments_of_type_ArrayOfJavaLangObject;
/*     */       localrecoverDeliveries_4196799148363996265.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData = this.jdField_metadata_of_type_OrgJbossAopMetadataSimpleMetaData;
/*     */       localrecoverDeliveries_4196799148363996265.jdField_currentInterceptor_of_type_Int = this.jdField_currentInterceptor_of_type_Int;
/*     */       localrecoverDeliveries_4196799148363996265.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver = this.jdField_instanceResolver_of_type_OrgJbossAopMetadataMetaDataResolver;
/*     */       localrecoverDeliveries_4196799148363996265.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate = this.jdField_typedTargetObject_of_type_OrgJbossJmsClientDelegateClientSessionDelegate;
/*     */       localrecoverDeliveries_4196799148363996265.jdField_targetObject_of_type_JavaLangObject = this.jdField_targetObject_of_type_JavaLangObject;
/*     */       localrecoverDeliveries_4196799148363996265.jdField_arg0_of_type_JavaUtilList = this.jdField_arg0_of_type_JavaUtilList;
/*     */       localrecoverDeliveries_4196799148363996265.jdField_arg1_of_type_JavaLangString = this.jdField_arg1_of_type_JavaLangString;
/*     */       return localrecoverDeliveries_4196799148363996265;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.delegate.ClientSessionDelegate
 * JD-Core Version:    0.6.0
 */