/*     */ package org.jboss.jms.client.delegate;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.net.SocketException;
/*     */ import javax.jms.JMSException;
/*     */ import org.jboss.jms.client.state.HierarchicalState;
/*     */ import org.jboss.jms.exception.MessagingJMSException;
/*     */ import org.jboss.jms.exception.MessagingNetworkFailureException;
/*     */ import org.jboss.jms.wireformat.RequestSupport;
/*     */ import org.jboss.jms.wireformat.ResponseSupport;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.util.Streamable;
/*     */ import org.jboss.messaging.util.Version;
/*     */ import org.jboss.remoting.CannotConnectException;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.ConnectionFailedException;
/*     */ 
/*     */ public abstract class DelegateSupport
/*     */   implements Streamable, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -1362079381836473747L;
/*  68 */   private static final Logger log = Logger.getLogger(DelegateSupport.class);
/*     */ 
/*  70 */   private static boolean trace = log.isTraceEnabled();
/*     */   protected String id;
/*     */   protected transient HierarchicalState state;
/*     */   protected transient byte version;
/*     */   protected transient Client client;
/*     */ 
/*     */   public DelegateSupport(String id)
/*     */   {
/*  93 */     this.id = id;
/*  94 */     this.state = null;
/*     */   }
/*     */ 
/*     */   public DelegateSupport()
/*     */   {
/*  99 */     this("NO_ID_SET");
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 107 */     return getClass().getName();
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in)
/*     */     throws Exception
/*     */   {
/* 114 */     this.id = in.readUTF();
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out) throws Exception
/*     */   {
/* 119 */     out.writeUTF(this.id);
/*     */   }
/*     */ 
/*     */   public HierarchicalState getState()
/*     */   {
/* 126 */     return this.state;
/*     */   }
/*     */ 
/*     */   public void setState(HierarchicalState state)
/*     */   {
/* 131 */     this.state = state;
/*     */ 
/* 133 */     this.version = state.getVersionToUse().getProviderIncrementingVersion();
/*     */   }
/*     */ 
/*     */   public String getID()
/*     */   {
/* 138 */     return this.id;
/*     */   }
/*     */ 
/*     */   public void synchronizeWith(DelegateSupport newDelegate)
/*     */     throws Exception
/*     */   {
/* 149 */     this.id = newDelegate.getID();
/*     */   }
/*     */ 
/*     */   protected Object doInvoke(Client client, RequestSupport req)
/*     */     throws JMSException
/*     */   {
/* 158 */     return doInvoke(client, req, false);
/*     */   }
/*     */ 
/*     */   protected Object doInvokeOneway(Client client, RequestSupport req) throws JMSException
/*     */   {
/* 163 */     return doInvoke(client, req, true);
/*     */   }
/*     */ 
/*     */   private Object doInvoke(Client client, RequestSupport req, boolean oneWay)
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 172 */       Object resp = null;
/*     */ 
/* 174 */       if (oneWay)
/*     */       {
/* 176 */         if (trace) log.trace(this + " invoking " + req + " asynchronously on server using " + client);
/*     */ 
/* 178 */         client.invokeOneway(req);
/*     */ 
/* 180 */         if (trace) log.trace(this + " asynchronously invoked " + req + " on server, no response expected");
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 185 */         if (trace) log.trace(this + " invoking " + req + " synchronously on server using " + client);
/*     */ 
/* 187 */         resp = client.invoke(req);
/*     */ 
/* 189 */         if (trace) log.trace(this + " got server response for " + req + ": " + resp);
/*     */       }
/*     */ 
/* 192 */       Object res = null;
/*     */ 
/* 194 */       if ((resp instanceof ResponseSupport))
/*     */       {
/* 196 */         res = ((ResponseSupport)resp).getResponse();
/*     */       }
/*     */ 
/* 199 */       return res;
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 203 */     throw handleThrowable(t);
/*     */   }
/*     */ 
/*     */   public JMSException handleThrowable(Throwable t)
/*     */   {
/* 214 */     if ((t instanceof JMSException))
/*     */     {
/* 216 */       return (JMSException)t;
/*     */     }
/* 218 */     if ((t instanceof CannotConnectException))
/*     */     {
/* 220 */       boolean failover = true;
/* 221 */       CannotConnectException cc = (CannotConnectException)t;
/* 222 */       Throwable underlying = cc.getCause();
/* 223 */       if ((underlying != null) && ((underlying instanceof SocketException)))
/*     */       {
/* 228 */         if ((underlying.getMessage() != null) && (underlying.getMessage().startsWith("Can not obtain client socket connection from pool")))
/*     */         {
/* 231 */           log.warn("Timed out getting a connection from the pool. Try increasing clientMaxPoolSize and/or numberOfRetries attributes in remoting-xxx-service.xml");
/*     */ 
/* 233 */           failover = false;
/*     */         }
/*     */       }
/* 236 */       if (failover)
/*     */       {
/* 238 */         return new MessagingNetworkFailureException(cc);
/*     */       }
/*     */     } else {
/* 241 */       if (((t instanceof IOException)) || ((t instanceof ConnectionFailedException)))
/*     */       {
/* 243 */         return new MessagingNetworkFailureException((Exception)t);
/*     */       }
/*     */ 
/* 247 */       if ((t instanceof RuntimeException))
/*     */       {
/* 249 */         RuntimeException re = (RuntimeException)t;
/*     */ 
/* 251 */         Throwable initCause = re.getCause();
/*     */ 
/* 253 */         if (initCause != null)
/*     */         {
/*     */           do
/*     */           {
/* 257 */             if (((initCause instanceof CannotConnectException)) || ((initCause instanceof IOException)) || ((initCause instanceof ConnectionFailedException)))
/*     */             {
/* 261 */               return new MessagingNetworkFailureException((Exception)initCause);
/*     */             }
/* 263 */             initCause = initCause.getCause();
/*     */           }
/* 265 */           while (initCause != null);
/*     */         }
/*     */       }
/*     */     }
/* 269 */     return new MessagingJMSException("Failed to invoke", t);
/*     */   }
/*     */ 
/*     */   public Client getClient()
/*     */   {
/* 274 */     return this.client;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.delegate.DelegateSupport
 * JD-Core Version:    0.6.0
 */