/*     */ package org.jboss.jms.client.remoting;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.BufferedOutputStream;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.net.Socket;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.transport.socket.OpenConnectionChecker;
/*     */ import org.jboss.remoting.transport.socket.SocketWrapper;
/*     */ 
/*     */ public class ClientSocketWrapper extends SocketWrapper
/*     */   implements OpenConnectionChecker
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(ClientSocketWrapper.class);
/*     */   protected static final int CLOSING = 1;
/*     */   private DataInputStream in;
/*     */   private DataOutputStream out;
/*     */ 
/*     */   public ClientSocketWrapper(Socket socket)
/*     */     throws IOException
/*     */   {
/*  63 */     super(socket);
/*  64 */     createStreams(socket, null);
/*     */   }
/*     */ 
/*     */   public ClientSocketWrapper(Socket socket, Map metadata, Integer timeout) throws Exception
/*     */   {
/*  69 */     super(socket, timeout);
/*  70 */     createStreams(socket, metadata);
/*     */   }
/*     */ 
/*     */   public OutputStream getOutputStream()
/*     */   {
/*  77 */     return this.out;
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream()
/*     */   {
/*  82 */     return this.in;
/*     */   }
/*     */ 
/*     */   public void checkConnection()
/*     */     throws IOException
/*     */   {
/*  88 */     byte ACK = 1;
/*     */ 
/*  90 */     this.out.writeByte(1);
/*  91 */     this.out.flush();
/*  92 */     this.in.readByte();
/*     */   }
/*     */ 
/*     */   public void checkOpenConnection()
/*     */     throws IOException
/*     */   {
/*  98 */     if (this.in.available() > 0)
/*     */     {
/* 100 */       log.trace("remote endpoint has closed");
/* 101 */       throw new IOException("remote endpoint has closed");
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 109 */     Socket socket = getSocket();
/* 110 */     return "ClientSocketWrapper[" + socket + "." + Integer.toHexString(System.identityHashCode(socket)) + "]";
/*     */   }
/*     */ 
/*     */   protected void createStreams(Socket socket, Map metadata)
/*     */     throws IOException
/*     */   {
/* 120 */     this.out = createOutputStream(socket);
/* 121 */     this.in = createInputStream(socket);
/*     */   }
/*     */ 
/*     */   protected DataInputStream createInputStream(Socket socket)
/*     */     throws IOException
/*     */   {
/* 131 */     BufferedInputStream bin = new BufferedInputStream(socket.getInputStream(), 65536);
/*     */ 
/* 133 */     return new DataInputStream(bin);
/*     */   }
/*     */ 
/*     */   protected DataOutputStream createOutputStream(Socket socket)
/*     */     throws IOException
/*     */   {
/* 143 */     BufferedOutputStream bout = new BufferedOutputStream(socket.getOutputStream(), 65536);
/*     */ 
/* 145 */     return new DataOutputStream(bout);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.remoting.ClientSocketWrapper
 * JD-Core Version:    0.6.0
 */