/*     */ package org.jboss.jms.client.state;
/*     */ 
/*     */ import java.util.Collections;
/*     */ import org.jboss.jms.client.container.ClientConsumer;
/*     */ import org.jboss.jms.client.delegate.ClientConnectionDelegate;
/*     */ import org.jboss.jms.client.delegate.DelegateSupport;
/*     */ import org.jboss.jms.client.remoting.CallbackManager;
/*     */ import org.jboss.jms.client.remoting.JMSRemotingConnection;
/*     */ import org.jboss.jms.delegate.ConsumerDelegate;
/*     */ import org.jboss.jms.destination.JBossDestination;
/*     */ import org.jboss.messaging.util.Version;
/*     */ 
/*     */ public class ConsumerState extends HierarchicalStateSupport
/*     */ {
/*     */   private String consumerID;
/*     */   private JBossDestination destination;
/*     */   private String selector;
/*     */   private String subscriptionName;
/*     */   private boolean noLocal;
/*     */   private boolean isConnectionConsumer;
/*     */   private ClientConsumer clientConsumer;
/*     */   private int bufferSize;
/*     */   private int maxDeliveries;
/*     */   private long redeliveryDelay;
/*     */   private boolean storingDeliveries;
/*     */   private SessionState parent;
/*     */   private ConsumerDelegate delegate;
/*     */ 
/*     */   public ConsumerState(SessionState parent, ConsumerDelegate delegate, JBossDestination dest, String selector, boolean noLocal, String subscriptionName, String consumerID, boolean isCC, int bufferSize, int maxDeliveries, long redeliveryDelay)
/*     */   {
/*  75 */     super(parent, (DelegateSupport)delegate);
/*  76 */     this.children = Collections.EMPTY_SET;
/*  77 */     this.destination = dest;
/*  78 */     this.selector = selector;
/*  79 */     this.noLocal = noLocal;
/*  80 */     this.consumerID = consumerID;
/*  81 */     this.isConnectionConsumer = isCC;
/*  82 */     this.bufferSize = bufferSize;
/*  83 */     this.subscriptionName = subscriptionName;
/*  84 */     this.maxDeliveries = maxDeliveries;
/*  85 */     this.redeliveryDelay = redeliveryDelay;
/*     */ 
/*  89 */     if ((dest.isTopic()) && (subscriptionName == null))
/*     */     {
/*  91 */       this.storingDeliveries = false;
/*     */     }
/*     */     else
/*     */     {
/*  95 */       this.storingDeliveries = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public DelegateSupport getDelegate()
/*     */   {
/* 103 */     return (DelegateSupport)this.delegate;
/*     */   }
/*     */ 
/*     */   public void setDelegate(DelegateSupport delegate)
/*     */   {
/* 108 */     this.delegate = ((ConsumerDelegate)delegate);
/*     */   }
/*     */ 
/*     */   public HierarchicalState getParent()
/*     */   {
/* 113 */     return this.parent;
/*     */   }
/*     */ 
/*     */   public void setParent(HierarchicalState parent)
/*     */   {
/* 118 */     this.parent = ((SessionState)parent);
/*     */   }
/*     */ 
/*     */   public Version getVersionToUse()
/*     */   {
/* 123 */     return this.parent.getVersionToUse();
/*     */   }
/*     */ 
/*     */   public void synchronizeWith(HierarchicalState ns)
/*     */     throws Exception
/*     */   {
/* 130 */     ConsumerState newState = (ConsumerState)ns;
/*     */ 
/* 132 */     String oldConsumerID = this.consumerID;
/* 133 */     this.consumerID = newState.consumerID;
/*     */ 
/* 135 */     CallbackManager oldCallbackManager = ((ClientConnectionDelegate)getParent().getParent().getDelegate()).getRemotingConnection().getCallbackManager();
/*     */ 
/* 137 */     CallbackManager newCallbackManager = ((ClientConnectionDelegate)ns.getParent().getParent().getDelegate()).getRemotingConnection().getCallbackManager();
/*     */ 
/* 142 */     ClientConsumer handler = oldCallbackManager.unregisterHandler(oldConsumerID);
/* 143 */     ClientConsumer newHandler = newCallbackManager.unregisterHandler(this.consumerID);
/*     */ 
/* 145 */     handler.synchronizeWith(newHandler);
/* 146 */     newCallbackManager.registerHandler(this.consumerID, handler);
/*     */   }
/*     */ 
/*     */   public JBossDestination getDestination()
/*     */   {
/* 153 */     return this.destination;
/*     */   }
/*     */ 
/*     */   public String getSelector()
/*     */   {
/* 158 */     return this.selector;
/*     */   }
/*     */ 
/*     */   public boolean isNoLocal()
/*     */   {
/* 163 */     return this.noLocal;
/*     */   }
/*     */ 
/*     */   public String getConsumerID()
/*     */   {
/* 168 */     return this.consumerID;
/*     */   }
/*     */ 
/*     */   public boolean isConnectionConsumer()
/*     */   {
/* 173 */     return this.isConnectionConsumer;
/*     */   }
/*     */ 
/*     */   public void setClientConsumer(ClientConsumer handler)
/*     */   {
/* 178 */     this.clientConsumer = handler;
/*     */   }
/*     */ 
/*     */   public ClientConsumer getClientConsumer()
/*     */   {
/* 183 */     return this.clientConsumer;
/*     */   }
/*     */ 
/*     */   public int getBufferSize()
/*     */   {
/* 188 */     return this.bufferSize;
/*     */   }
/*     */ 
/*     */   public String getSubscriptionName()
/*     */   {
/* 193 */     return this.subscriptionName;
/*     */   }
/*     */ 
/*     */   public void setSubscriptionName(String subscriptionName)
/*     */   {
/* 198 */     this.subscriptionName = subscriptionName;
/*     */   }
/*     */ 
/*     */   public int getMaxDeliveries()
/*     */   {
/* 203 */     return this.maxDeliveries;
/*     */   }
/*     */ 
/*     */   public boolean isStoringDeliveries()
/*     */   {
/* 208 */     return this.storingDeliveries;
/*     */   }
/*     */ 
/*     */   public boolean isShouldAck()
/*     */   {
/* 216 */     return (!this.destination.isTopic()) || (this.subscriptionName != null);
/*     */   }
/*     */ 
/*     */   public long getRedeliveryDelay()
/*     */   {
/* 221 */     return this.redeliveryDelay;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.state.ConsumerState
 * JD-Core Version:    0.6.0
 */