/*    */ package org.jboss.jms.destination;
/*    */ 
/*    */ import javax.jms.JMSException;
/*    */ import javax.jms.TemporaryTopic;
/*    */ import org.jboss.jms.delegate.SessionDelegate;
/*    */ import org.jboss.messaging.util.GUIDGenerator;
/*    */ 
/*    */ public class JBossTemporaryTopic extends JBossTopic
/*    */   implements TemporaryTopic
/*    */ {
/*    */   private static final long serialVersionUID = -1412919224718697967L;
/*    */   private transient SessionDelegate delegate;
/*    */ 
/*    */   public JBossTemporaryTopic(SessionDelegate delegate)
/*    */   {
/* 52 */     super(GUIDGenerator.generateGUID());
/* 53 */     this.delegate = delegate;
/*    */   }
/*    */ 
/*    */   public JBossTemporaryTopic(String name)
/*    */   {
/* 58 */     super(name);
/*    */   }
/*    */ 
/*    */   public void delete()
/*    */     throws JMSException
/*    */   {
/* 65 */     if (this.delegate != null) this.delegate.deleteTemporaryDestination(this);
/*    */   }
/*    */ 
/*    */   public boolean isTemporary()
/*    */   {
/* 72 */     return true;
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 79 */     return "JBossTemporaryTopic[" + this.name + "]";
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.destination.JBossTemporaryTopic
 * JD-Core Version:    0.6.0
 */