/*     */ package org.jboss.jms.message;
/*     */ 
/*     */ import B;
/*     */ import java.util.Collections;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.MapMessage;
/*     */ import javax.jms.MessageFormatException;
/*     */ import org.jboss.util.Primitives;
/*     */ 
/*     */ public class JBossMapMessage extends JBossMessage
/*     */   implements MapMessage
/*     */ {
/*     */   private static final long serialVersionUID = 7939593521831220924L;
/*     */   public static final byte TYPE = 5;
/*     */ 
/*     */   public JBossMapMessage()
/*     */   {
/*     */   }
/*     */ 
/*     */   public JBossMapMessage(long messageID)
/*     */   {
/*  74 */     super(messageID);
/*  75 */     this.payload = new HashMap();
/*     */   }
/*     */ 
/*     */   public JBossMapMessage(long messageID, boolean reliable, long expiration, long timestamp, byte priority, Map coreHeaders, byte[] payloadAsByteArray)
/*     */   {
/*  84 */     super(messageID, reliable, expiration, timestamp, priority, coreHeaders, payloadAsByteArray);
/*     */   }
/*     */ 
/*     */   public JBossMapMessage(JBossMapMessage other)
/*     */   {
/*  89 */     super(other);
/*     */   }
/*     */ 
/*     */   public JBossMapMessage(MapMessage foreign, long id)
/*     */     throws JMSException
/*     */   {
/* 100 */     super(foreign, id);
/* 101 */     this.payload = new HashMap();
/* 102 */     Enumeration names = foreign.getMapNames();
/* 103 */     while (names.hasMoreElements())
/*     */     {
/* 105 */       String name = (String)names.nextElement();
/* 106 */       Object obj = foreign.getObject(name);
/* 107 */       setObject(name, obj);
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte getType()
/*     */   {
/* 115 */     return 5;
/*     */   }
/*     */ 
/*     */   public void copyPayload(Object otherPayload) throws JMSException
/*     */   {
/* 120 */     this.payload = new HashMap((Map)otherPayload);
/*     */   }
/*     */ 
/*     */   public void setBoolean(String name, boolean value)
/*     */     throws JMSException
/*     */   {
/* 127 */     checkName(name);
/* 128 */     ((Map)getPayload()).put(name, Primitives.valueOf(value));
/*     */   }
/*     */ 
/*     */   public void setByte(String name, byte value) throws JMSException
/*     */   {
/* 133 */     checkName(name);
/* 134 */     ((Map)getPayload()).put(name, new Byte(value));
/*     */   }
/*     */ 
/*     */   public void setShort(String name, short value) throws JMSException
/*     */   {
/* 139 */     checkName(name);
/* 140 */     ((Map)getPayload()).put(name, new Short(value));
/*     */   }
/*     */ 
/*     */   public void setChar(String name, char value) throws JMSException
/*     */   {
/* 145 */     checkName(name);
/* 146 */     ((Map)getPayload()).put(name, new Character(value));
/*     */   }
/*     */ 
/*     */   public void setInt(String name, int value) throws JMSException
/*     */   {
/* 151 */     checkName(name);
/* 152 */     ((Map)getPayload()).put(name, new Integer(value));
/*     */   }
/*     */ 
/*     */   public void setLong(String name, long value) throws JMSException
/*     */   {
/* 157 */     checkName(name);
/* 158 */     ((Map)getPayload()).put(name, new Long(value));
/*     */   }
/*     */ 
/*     */   public void setFloat(String name, float value) throws JMSException
/*     */   {
/* 163 */     checkName(name);
/* 164 */     ((Map)getPayload()).put(name, new Float(value));
/*     */   }
/*     */ 
/*     */   public void setDouble(String name, double value) throws JMSException
/*     */   {
/* 169 */     checkName(name);
/* 170 */     ((Map)getPayload()).put(name, new Double(value));
/*     */   }
/*     */ 
/*     */   public void setString(String name, String value) throws JMSException
/*     */   {
/* 175 */     checkName(name);
/* 176 */     ((Map)getPayload()).put(name, value);
/*     */   }
/*     */ 
/*     */   public void setBytes(String name, byte[] value) throws JMSException
/*     */   {
/* 181 */     checkName(name);
/* 182 */     ((Map)getPayload()).put(name, value.clone());
/*     */   }
/*     */ 
/*     */   public void setBytes(String name, byte[] value, int offset, int length) throws JMSException
/*     */   {
/* 187 */     checkName(name);
/* 188 */     if (offset + length > value.length)
/*     */     {
/* 190 */       throw new JMSException("Array is too small");
/*     */     }
/* 192 */     byte[] temp = new byte[length];
/* 193 */     for (int i = 0; i < length; i++)
/*     */     {
/* 195 */       temp[i] = value[(i + offset)];
/*     */     }
/* 197 */     ((Map)getPayload()).put(name, temp);
/*     */   }
/*     */ 
/*     */   public void setObject(String name, Object value) throws JMSException
/*     */   {
/* 202 */     checkName(name);
/* 203 */     if ((value instanceof Boolean))
/* 204 */       ((Map)getPayload()).put(name, value);
/* 205 */     else if ((value instanceof Byte))
/* 206 */       ((Map)getPayload()).put(name, value);
/* 207 */     else if ((value instanceof Short))
/* 208 */       ((Map)getPayload()).put(name, value);
/* 209 */     else if ((value instanceof Character))
/* 210 */       ((Map)getPayload()).put(name, value);
/* 211 */     else if ((value instanceof Integer))
/* 212 */       ((Map)getPayload()).put(name, value);
/* 213 */     else if ((value instanceof Long))
/* 214 */       ((Map)getPayload()).put(name, value);
/* 215 */     else if ((value instanceof Float))
/* 216 */       ((Map)getPayload()).put(name, value);
/* 217 */     else if ((value instanceof Double))
/* 218 */       ((Map)getPayload()).put(name, value);
/* 219 */     else if ((value instanceof String))
/* 220 */       ((Map)getPayload()).put(name, value);
/* 221 */     else if ((value instanceof byte[]))
/* 222 */       ((Map)getPayload()).put(name, ((byte[])(byte[])value).clone());
/*     */     else
/* 224 */       throw new MessageFormatException("Invalid object type.");
/*     */   }
/*     */ 
/*     */   public boolean getBoolean(String name)
/*     */     throws JMSException
/*     */   {
/* 232 */     Object value = ((Map)getPayload()).get(name);
/*     */ 
/* 234 */     if (value == null) {
/* 235 */       return Boolean.valueOf(null).booleanValue();
/*     */     }
/* 237 */     if ((value instanceof Boolean))
/* 238 */       return ((Boolean)value).booleanValue();
/* 239 */     if ((value instanceof String)) {
/* 240 */       return Boolean.valueOf((String)value).booleanValue();
/*     */     }
/* 242 */     throw new MessageFormatException("Invalid conversion");
/*     */   }
/*     */ 
/*     */   public byte getByte(String name)
/*     */     throws JMSException
/*     */   {
/* 249 */     Object value = ((Map)getPayload()).get(name);
/*     */ 
/* 251 */     if (value == null) {
/* 252 */       return Byte.parseByte(null);
/*     */     }
/* 254 */     if ((value instanceof Byte))
/* 255 */       return ((Byte)value).byteValue();
/* 256 */     if ((value instanceof String)) {
/* 257 */       return Byte.parseByte((String)value);
/*     */     }
/* 259 */     throw new MessageFormatException("Invalid conversion");
/*     */   }
/*     */ 
/*     */   public short getShort(String name)
/*     */     throws JMSException
/*     */   {
/* 266 */     Object value = ((Map)getPayload()).get(name);
/*     */ 
/* 268 */     if (value == null) {
/* 269 */       return Short.parseShort(null);
/*     */     }
/* 271 */     if ((value instanceof Byte))
/* 272 */       return ((Byte)value).shortValue();
/* 273 */     if ((value instanceof Short))
/* 274 */       return ((Short)value).shortValue();
/* 275 */     if ((value instanceof String)) {
/* 276 */       return Short.parseShort((String)value);
/*     */     }
/* 278 */     throw new MessageFormatException("Invalid conversion");
/*     */   }
/*     */ 
/*     */   public char getChar(String name)
/*     */     throws JMSException
/*     */   {
/* 285 */     Object value = ((Map)getPayload()).get(name);
/*     */ 
/* 287 */     if (value == null) {
/* 288 */       throw new NullPointerException("Invalid conversion");
/*     */     }
/* 290 */     if ((value instanceof Character)) {
/* 291 */       return ((Character)value).charValue();
/*     */     }
/* 293 */     throw new MessageFormatException("Invalid conversion");
/*     */   }
/*     */ 
/*     */   public int getInt(String name)
/*     */     throws JMSException
/*     */   {
/* 300 */     Object value = ((Map)getPayload()).get(name);
/*     */ 
/* 302 */     if (value == null) {
/* 303 */       return Integer.parseInt(null);
/*     */     }
/* 305 */     if ((value instanceof Byte))
/* 306 */       return ((Byte)value).intValue();
/* 307 */     if ((value instanceof Short))
/* 308 */       return ((Short)value).intValue();
/* 309 */     if ((value instanceof Integer))
/* 310 */       return ((Integer)value).intValue();
/* 311 */     if ((value instanceof String)) {
/* 312 */       return Integer.parseInt((String)value);
/*     */     }
/* 314 */     throw new MessageFormatException("Invalid conversion");
/*     */   }
/*     */ 
/*     */   public long getLong(String name)
/*     */     throws JMSException
/*     */   {
/* 321 */     Object value = ((Map)getPayload()).get(name);
/*     */ 
/* 323 */     if (value == null) {
/* 324 */       return Long.parseLong(null);
/*     */     }
/* 326 */     if ((value instanceof Byte))
/* 327 */       return ((Byte)value).longValue();
/* 328 */     if ((value instanceof Short))
/* 329 */       return ((Short)value).longValue();
/* 330 */     if ((value instanceof Integer))
/* 331 */       return ((Integer)value).longValue();
/* 332 */     if ((value instanceof Long))
/* 333 */       return ((Long)value).longValue();
/* 334 */     if ((value instanceof String)) {
/* 335 */       return Long.parseLong((String)value);
/*     */     }
/* 337 */     throw new MessageFormatException("Invalid conversion");
/*     */   }
/*     */ 
/*     */   public float getFloat(String name)
/*     */     throws JMSException
/*     */   {
/* 344 */     Object value = ((Map)getPayload()).get(name);
/*     */ 
/* 346 */     if (value == null) {
/* 347 */       return Float.parseFloat(null);
/*     */     }
/* 349 */     if ((value instanceof Float))
/* 350 */       return ((Float)value).floatValue();
/* 351 */     if ((value instanceof String)) {
/* 352 */       return Float.parseFloat((String)value);
/*     */     }
/* 354 */     throw new MessageFormatException("Invalid conversion");
/*     */   }
/*     */ 
/*     */   public double getDouble(String name)
/*     */     throws JMSException
/*     */   {
/* 361 */     Object value = ((Map)getPayload()).get(name);
/*     */ 
/* 363 */     if (value == null) {
/* 364 */       return Double.parseDouble(null);
/*     */     }
/* 366 */     if ((value instanceof Float))
/* 367 */       return ((Float)value).doubleValue();
/* 368 */     if ((value instanceof Double))
/* 369 */       return ((Double)value).doubleValue();
/* 370 */     if ((value instanceof String)) {
/* 371 */       return Double.parseDouble((String)value);
/*     */     }
/* 373 */     throw new MessageFormatException("Invalid conversion");
/*     */   }
/*     */ 
/*     */   public String getString(String name)
/*     */     throws JMSException
/*     */   {
/* 380 */     Object value = ((Map)getPayload()).get(name);
/*     */ 
/* 382 */     if (value == null) {
/* 383 */       return null;
/*     */     }
/* 385 */     if ((value instanceof Boolean))
/*     */     {
/* 387 */       return value.toString();
/*     */     }
/* 389 */     if ((value instanceof Byte))
/*     */     {
/* 391 */       return value.toString();
/*     */     }
/* 393 */     if ((value instanceof Short))
/*     */     {
/* 395 */       return value.toString();
/*     */     }
/* 397 */     if ((value instanceof Character))
/*     */     {
/* 399 */       return value.toString();
/*     */     }
/* 401 */     if ((value instanceof Integer))
/*     */     {
/* 403 */       return value.toString();
/*     */     }
/* 405 */     if ((value instanceof Long))
/*     */     {
/* 407 */       return value.toString();
/*     */     }
/* 409 */     if ((value instanceof Float))
/*     */     {
/* 411 */       return value.toString();
/*     */     }
/* 413 */     if ((value instanceof Double))
/*     */     {
/* 415 */       return value.toString();
/*     */     }
/* 417 */     if ((value instanceof String))
/*     */     {
/* 419 */       return (String)value;
/*     */     }
/*     */ 
/* 423 */     throw new MessageFormatException("Invalid conversion");
/*     */   }
/*     */ 
/*     */   public byte[] getBytes(String name)
/*     */     throws JMSException
/*     */   {
/* 431 */     Object value = ((Map)getPayload()).get(name);
/*     */ 
/* 433 */     if (value == null)
/* 434 */       return null;
/* 435 */     if ((value instanceof byte[])) {
/* 436 */       return (byte[])(byte[])value;
/*     */     }
/* 438 */     throw new MessageFormatException("Invalid conversion");
/*     */   }
/*     */ 
/*     */   public Object getObject(String name)
/*     */     throws JMSException
/*     */   {
/* 444 */     return ((Map)getPayload()).get(name);
/*     */   }
/*     */ 
/*     */   public Enumeration getMapNames()
/*     */     throws JMSException
/*     */   {
/* 450 */     return Collections.enumeration(new HashMap((Map)getPayload()).keySet());
/*     */   }
/*     */ 
/*     */   public boolean itemExists(String name) throws JMSException
/*     */   {
/* 455 */     return ((Map)getPayload()).containsKey(name);
/*     */   }
/*     */ 
/*     */   public void clearBody()
/*     */     throws JMSException
/*     */   {
/* 462 */     super.clearBody();
/* 463 */     this.payload = new HashMap();
/* 464 */     this.payloadAsByteArray = null;
/*     */   }
/*     */ 
/*     */   public JBossMessage doCopy()
/*     */   {
/* 469 */     return new JBossMapMessage(this);
/*     */   }
/*     */ 
/*     */   private void checkName(String name)
/*     */   {
/* 485 */     if (name == null)
/*     */     {
/* 487 */       throw new IllegalArgumentException("Name must not be null.");
/*     */     }
/*     */ 
/* 490 */     if (name.equals(""))
/*     */     {
/* 492 */       throw new IllegalArgumentException("Name must not be an empty String.");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.message.JBossMapMessage
 * JD-Core Version:    0.6.0
 */