/*      */ package org.jboss.jms.message;
/*      */ 
/*      */ import java.io.DataInputStream;
/*      */ import java.io.DataOutputStream;
/*      */ import java.io.Serializable;
/*      */ import java.util.Collections;
/*      */ import java.util.Enumeration;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Set;
/*      */ import javax.jms.BytesMessage;
/*      */ import javax.jms.Destination;
/*      */ import javax.jms.JMSException;
/*      */ import javax.jms.MapMessage;
/*      */ import javax.jms.Message;
/*      */ import javax.jms.MessageFormatException;
/*      */ import javax.jms.ObjectMessage;
/*      */ import javax.jms.StreamMessage;
/*      */ import javax.jms.TextMessage;
/*      */ import org.jboss.jms.destination.JBossDestination;
/*      */ import org.jboss.jms.exception.MessagingJMSException;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.messaging.core.impl.message.MessageSupport;
/*      */ import org.jboss.util.Primitives;
/*      */ import org.jboss.util.Strings;
/*      */ 
/*      */ public class JBossMessage extends MessageSupport
/*      */   implements Message, Serializable
/*      */ {
/*      */   private static final long serialVersionUID = 2833181306818971346L;
/*      */   public static final byte TYPE = 1;
/*      */   private static final char PROPERTY_PREFIX_CHAR = 'P';
/*      */   private static final String PROPERTY_PREFIX = "P";
/*      */   private static final String DESTINATION_HEADER_NAME = "H.DEST";
/*      */   private static final String REPLYTO_HEADER_NAME = "H.REPLYTO";
/*      */   private static final String CORRELATIONID_HEADER_NAME = "H.CORRELATIONID";
/*      */   private static final String JBM_MESSAGE_ID = "JBM_MESSAGE_ID";
/*      */   private static final String CORRELATIONIDBYTES_HEADER_NAME = "H.CORRELATIONIDBYTES";
/*      */   private static final String TYPE_HEADER_NAME = "H.TYPE";
/*      */   public static final String JMS_JBOSS_SCHEDULED_DELIVERY_PROP_NAME = "JMS_JBOSS_SCHEDULED_DELIVERY";
/*      */   public static final String JBOSS_MESSAGING_ORIG_DESTINATION = "JBM_ORIG_DESTINATION";
/*      */   public static final String JBOSS_MESSAGING_ORIG_MESSAGE_ID = "JBM_ORIG_MESSAGE_ID";
/*      */   public static final String JBOSS_MESSAGING_ACTUAL_EXPIRY_TIME = "JBM_ACTUAL_EXPIRY";
/*      */   public static final String JBOSS_MESSAGING_BRIDGE_MESSAGE_ID_LIST = "JBM_BRIDGE_MSG_ID_LIST";
/*  112 */   private static final Logger log = Logger.getLogger(JBossMessage.class);
/*      */ 
/*  116 */   private static final HashSet reservedIdentifiers = new HashSet();
/*      */   protected transient String connectionID;
/*      */   protected transient String jmsMessageID;
/*      */   private long scheduledDeliveryTime;
/*      */   private Destination destination;
/*      */ 
/*      */   public static MessageProxy createThinDelegate(long deliveryId, JBossMessage m, int deliveryCount)
/*      */   {
/*      */     MessageProxy del;
/*      */     MessageProxy del;
/*  136 */     if ((m instanceof BytesMessage))
/*      */     {
/*  138 */       del = new BytesMessageProxy(deliveryId, (JBossBytesMessage)m, deliveryCount);
/*      */     }
/*      */     else
/*      */     {
/*      */       MessageProxy del;
/*  140 */       if ((m instanceof MapMessage))
/*      */       {
/*  142 */         del = new MapMessageProxy(deliveryId, (JBossMapMessage)m, deliveryCount);
/*      */       }
/*      */       else
/*      */       {
/*      */         MessageProxy del;
/*  144 */         if ((m instanceof ObjectMessage))
/*      */         {
/*  146 */           del = new ObjectMessageProxy(deliveryId, (JBossObjectMessage)m, deliveryCount);
/*      */         }
/*      */         else
/*      */         {
/*      */           MessageProxy del;
/*  148 */           if ((m instanceof StreamMessage))
/*      */           {
/*  150 */             del = new StreamMessageProxy(deliveryId, (JBossStreamMessage)m, deliveryCount);
/*      */           }
/*      */           else
/*      */           {
/*      */             MessageProxy del;
/*  152 */             if ((m instanceof TextMessage))
/*      */             {
/*  154 */               del = new TextMessageProxy(deliveryId, (JBossTextMessage)m, deliveryCount);
/*      */             }
/*      */             else
/*      */             {
/*  158 */               del = new MessageProxy(deliveryId, m, deliveryCount);
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*  161 */     return del;
/*      */   }
/*      */ 
/*      */   public static String dump(JBossMessage m)
/*      */   {
/*  166 */     String type = null;
/*  167 */     if ((m instanceof BytesMessage))
/*      */     {
/*  169 */       type = "Bytes";
/*      */     }
/*  171 */     else if ((m instanceof MapMessage))
/*      */     {
/*  173 */       type = "Map";
/*      */     }
/*  175 */     else if ((m instanceof ObjectMessage))
/*      */     {
/*  177 */       type = "Object";
/*      */     }
/*  179 */     else if ((m instanceof StreamMessage))
/*      */     {
/*  181 */       type = "Stream";
/*      */     }
/*  183 */     else if ((m instanceof TextMessage))
/*      */     {
/*  185 */       type = "Text";
/*      */     }
/*      */     else
/*      */     {
/*  189 */       type = "Generic";
/*      */     }
/*      */ 
/*  192 */     StringBuffer sb = new StringBuffer();
/*      */ 
/*  194 */     sb.append("\n");
/*  195 */     sb.append("         MESSAGE DUMP\n");
/*  196 */     sb.append("              Core ID:       ").append(m.messageID).append('\n');
/*  197 */     sb.append("              reliable:      ").append(m.reliable).append('\n');
/*  198 */     sb.append("              expiration:    ").append(m.expiration).append('\n');
/*  199 */     sb.append("              timestamp:     ").append(m.timestamp).append('\n');
/*  200 */     sb.append("              headers:       ");
/*      */     Iterator i;
/*  202 */     if (m.headers.size() == 0)
/*      */     {
/*  204 */       sb.append("NO HEADERS").append('\n');
/*      */     }
/*      */     else
/*      */     {
/*  208 */       sb.append('\n');
/*  209 */       for (i = m.headers.keySet().iterator(); i.hasNext(); )
/*      */       {
/*  211 */         String name = (String)i.next();
/*  212 */         sb.append("                             ");
/*  213 */         sb.append(name).append(" - ").append(m.headers.get(name)).append('\n');
/*      */       }
/*      */     }
/*      */ 
/*  217 */     int deliveryCount = 0;
/*      */     try
/*      */     {
/*  220 */       deliveryCount = m.getIntProperty("JMSXDeliveryCount");
/*      */     }
/*      */     catch (JMSException e)
/*      */     {
/*  224 */       log.error("Failed to get delivery count", e);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  229 */       sb.append("              redelivered:   ").append(deliveryCount >= 1).append('\n');
/*  230 */       sb.append("              priority:      ").append(m.priority).append('\n');
/*  231 */       sb.append("              deliveryCount: ").append(deliveryCount).append('\n');
/*      */ 
/*  233 */       sb.append("              JMS ID:        ").append(m.getJMSMessageID()).append('\n');
/*  234 */       sb.append("              type:          ").append(type).append('\n');
/*  235 */       sb.append("              destination:   ").append(m.getJMSDestination()).append('\n');
/*  236 */       sb.append("              replyTo:       ").append(m.getJMSReplyTo()).append('\n');
/*  237 */       sb.append("              jmsType:       ").append(m.getJMSType()).append('\n');
/*  238 */       sb.append("              properties:    ");
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  242 */       log.error("Failed to dump message", e);
/*      */     }
/*      */ 
/*  245 */     Iterator iter = m.headers.entrySet().iterator();
/*      */ 
/*  247 */     int count = 0;
/*      */ 
/*  249 */     while (iter.hasNext())
/*      */     {
/*  251 */       Map.Entry entry = (Map.Entry)iter.next();
/*      */ 
/*  253 */       String propName = (String)entry.getKey();
/*      */ 
/*  255 */       if (propName.charAt(0) == 'P')
/*      */       {
/*  257 */         if (count == 0)
/*      */         {
/*  259 */           sb.append("\n");
/*      */         }
/*      */ 
/*  262 */         sb.append("                             ");
/*  263 */         sb.append(propName).append(" - ").append(entry.getValue()).append('\n');
/*      */ 
/*  265 */         count++;
/*      */       }
/*      */     }
/*      */ 
/*  269 */     sb.append("\n");
/*      */ 
/*  271 */     return sb.toString();
/*      */   }
/*      */ 
/*      */   public JBossMessage()
/*      */   {
/*      */   }
/*      */ 
/*      */   public JBossMessage(long messageID)
/*      */   {
/*  302 */     super(messageID, true, 0L, System.currentTimeMillis(), 4, null, null);
/*      */   }
/*      */ 
/*      */   public JBossMessage(long messageID, boolean reliable, long expiration, long timestamp, byte priority, Map headers, byte[] payloadAsByteArray)
/*      */   {
/*  311 */     super(messageID, reliable, expiration, timestamp, priority, headers, payloadAsByteArray);
/*      */   }
/*      */ 
/*      */   protected JBossMessage(JBossMessage other)
/*      */   {
/*  322 */     super(other);
/*  323 */     this.connectionID = other.connectionID;
/*  324 */     this.scheduledDeliveryTime = other.scheduledDeliveryTime;
/*  325 */     this.destination = other.destination;
/*      */   }
/*      */ 
/*      */   public JBossMessage(Message foreign, long messageID)
/*      */     throws JMSException
/*      */   {
/*  333 */     super(messageID);
/*      */ 
/*  335 */     setJMSTimestamp(foreign.getJMSTimestamp());
/*      */     try
/*      */     {
/*  339 */       byte[] corrIDBytes = foreign.getJMSCorrelationIDAsBytes();
/*  340 */       setJMSCorrelationIDAsBytes(corrIDBytes);
/*      */     }
/*      */     catch (JMSException e)
/*      */     {
/*  345 */       String corrIDString = foreign.getJMSCorrelationID();
/*  346 */       if (corrIDString != null)
/*      */       {
/*  348 */         setJMSCorrelationID(corrIDString);
/*      */       }
/*      */     }
/*      */ 
/*  352 */     setJMSReplyTo(foreign.getJMSReplyTo());
/*  353 */     setJMSDestination(foreign.getJMSDestination());
/*  354 */     setJMSDeliveryMode(foreign.getJMSDeliveryMode());
/*  355 */     setJMSExpiration(foreign.getJMSExpiration());
/*  356 */     setJMSPriority(foreign.getJMSPriority());
/*  357 */     setJMSType(foreign.getJMSType());
/*      */ 
/*  359 */     for (Enumeration props = foreign.getPropertyNames(); props.hasMoreElements(); )
/*      */     {
/*  361 */       String name = (String)props.nextElement();
/*      */ 
/*  363 */       Object prop = foreign.getObjectProperty(name);
/*      */ 
/*  365 */       setObjectProperty(name, prop);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isReference()
/*      */   {
/*  374 */     return false;
/*      */   }
/*      */ 
/*      */   public String getJMSMessageID()
/*      */   {
/*  381 */     if (this.jmsMessageID == null)
/*      */     {
/*  383 */       String headerID = (String)this.headers.get("JBM_MESSAGE_ID");
/*  384 */       if (headerID == null)
/*      */       {
/*  386 */         this.jmsMessageID = ("ID:JBM-" + this.messageID);
/*      */       }
/*      */       else
/*      */       {
/*  390 */         this.jmsMessageID = headerID;
/*      */       }
/*      */     }
/*  393 */     return this.jmsMessageID;
/*      */   }
/*      */ 
/*      */   public void setJMSMessageID(String jmsMessageID) throws JMSException
/*      */   {
/*  398 */     if ((jmsMessageID != null) && (!jmsMessageID.startsWith("ID:")))
/*      */     {
/*  400 */       throw new JMSException("JMSMessageID must start with ID:");
/*      */     }
/*  402 */     if (jmsMessageID == null)
/*      */     {
/*  404 */       this.headers.remove("JBM_MESSAGE_ID");
/*      */     }
/*      */     else
/*      */     {
/*  408 */       this.headers.put("JBM_MESSAGE_ID", jmsMessageID);
/*      */     }
/*  410 */     this.jmsMessageID = jmsMessageID;
/*      */   }
/*      */ 
/*      */   public long getJMSTimestamp() throws JMSException
/*      */   {
/*  415 */     return this.timestamp;
/*      */   }
/*      */ 
/*      */   public void setJMSTimestamp(long timestamp) throws JMSException
/*      */   {
/*  420 */     this.timestamp = timestamp;
/*      */   }
/*      */ 
/*      */   public byte[] getJMSCorrelationIDAsBytes() throws JMSException
/*      */   {
/*  425 */     return (byte[])(byte[])this.headers.get("H.CORRELATIONIDBYTES");
/*      */   }
/*      */ 
/*      */   public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException
/*      */   {
/*  430 */     if ((correlationID == null) || (correlationID.length == 0))
/*      */     {
/*  432 */       throw new JMSException("Please specify a non-zero length byte[]");
/*      */     }
/*  434 */     this.headers.put("H.CORRELATIONIDBYTES", correlationID);
/*      */ 
/*  436 */     this.headers.remove("H.CORRELATIONID");
/*      */   }
/*      */ 
/*      */   public void setJMSCorrelationID(String correlationID) throws JMSException
/*      */   {
/*  441 */     this.headers.put("H.CORRELATIONID", correlationID);
/*      */ 
/*  443 */     this.headers.remove("H.CORRELATIONIDBYTES");
/*      */   }
/*      */ 
/*      */   public String getJMSCorrelationID() throws JMSException
/*      */   {
/*  448 */     return (String)this.headers.get("H.CORRELATIONID");
/*      */   }
/*      */ 
/*      */   public Destination getJMSReplyTo() throws JMSException
/*      */   {
/*  453 */     return (Destination)this.headers.get("H.REPLYTO");
/*      */   }
/*      */ 
/*      */   public void setJMSReplyTo(Destination replyTo) throws JMSException
/*      */   {
/*  458 */     this.headers.put("H.REPLYTO", replyTo);
/*      */   }
/*      */ 
/*      */   public Destination getJMSDestination() throws JMSException
/*      */   {
/*  463 */     if (this.destination != null)
/*      */     {
/*  465 */       return this.destination;
/*      */     }
/*      */ 
/*  469 */     return (Destination)this.headers.get("H.DEST");
/*      */   }
/*      */ 
/*      */   public void setJMSDestination(Destination destination)
/*      */     throws JMSException
/*      */   {
/*  477 */     this.destination = destination;
/*      */   }
/*      */ 
/*      */   public Map getHeaders()
/*      */   {
/*  484 */     if (this.destination != null)
/*      */     {
/*  486 */       this.headers.put("H.DEST", this.destination);
/*      */     }
/*      */ 
/*  489 */     this.destination = null;
/*      */ 
/*  491 */     return this.headers;
/*      */   }
/*      */ 
/*      */   public int getJMSDeliveryMode() throws JMSException
/*      */   {
/*  496 */     return this.reliable ? 2 : 1;
/*      */   }
/*      */ 
/*      */   public void setJMSDeliveryMode(int deliveryMode) throws JMSException
/*      */   {
/*  501 */     if (deliveryMode == 2)
/*      */     {
/*  503 */       this.reliable = true;
/*      */     }
/*  505 */     else if (deliveryMode == 1)
/*      */     {
/*  507 */       this.reliable = false;
/*      */     }
/*      */     else
/*      */     {
/*  511 */       throw new MessagingJMSException("Delivery mode must be either DeliveryMode.PERSISTENT or DeliveryMode.NON_PERSISTENT");
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean getJMSRedelivered()
/*      */     throws JMSException
/*      */   {
/*  518 */     throw new IllegalStateException("This should never be called directly");
/*      */   }
/*      */ 
/*      */   public void setJMSRedelivered(boolean redelivered)
/*      */     throws JMSException
/*      */   {
/*  524 */     throw new IllegalStateException("This should never be called directly");
/*      */   }
/*      */ 
/*      */   public String getJMSType()
/*      */     throws JMSException
/*      */   {
/*  534 */     return (String)this.headers.get("H.TYPE");
/*      */   }
/*      */ 
/*      */   public void setJMSType(String type)
/*      */     throws JMSException
/*      */   {
/*  544 */     this.headers.put("H.TYPE", type);
/*      */   }
/*      */ 
/*      */   public long getJMSExpiration() throws JMSException
/*      */   {
/*  549 */     return this.expiration;
/*      */   }
/*      */ 
/*      */   public void setJMSExpiration(long expiration) throws JMSException
/*      */   {
/*  554 */     this.expiration = expiration;
/*      */   }
/*      */ 
/*      */   public int getJMSPriority() throws JMSException
/*      */   {
/*  559 */     return this.priority;
/*      */   }
/*      */ 
/*      */   public void setJMSPriority(int priority) throws JMSException
/*      */   {
/*  564 */     this.priority = (byte)priority;
/*      */   }
/*      */ 
/*      */   public void clearProperties() throws JMSException
/*      */   {
/*  569 */     Iterator iter = this.headers.keySet().iterator();
/*      */ 
/*  571 */     while (iter.hasNext())
/*      */     {
/*  573 */       String propName = (String)iter.next();
/*      */ 
/*  575 */       if (propName.charAt(0) == 'P')
/*      */       {
/*  577 */         iter.remove();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void clearBody() throws JMSException
/*      */   {
/*  584 */     this.payload = null;
/*      */ 
/*  586 */     this.payloadAsByteArray = null;
/*      */   }
/*      */ 
/*      */   public boolean propertyExists(String name) throws JMSException
/*      */   {
/*  591 */     return (this.headers.containsKey("P" + name)) || (name.equals("JMSXDeliveryCount"));
/*      */   }
/*      */ 
/*      */   public boolean getBooleanProperty(String name)
/*      */     throws JMSException
/*      */   {
/*  597 */     Object value = this.headers.get("P" + name);
/*  598 */     if (value == null) {
/*  599 */       return Boolean.valueOf(null).booleanValue();
/*      */     }
/*  601 */     if ((value instanceof Boolean))
/*  602 */       return ((Boolean)value).booleanValue();
/*  603 */     if ((value instanceof String)) {
/*  604 */       return Boolean.valueOf((String)value).booleanValue();
/*      */     }
/*  606 */     throw new MessageFormatException("Invalid conversion");
/*      */   }
/*      */ 
/*      */   public byte getByteProperty(String name) throws JMSException
/*      */   {
/*  611 */     Object value = this.headers.get("P" + name);
/*  612 */     if (value == null) {
/*  613 */       throw new NumberFormatException("Message property '" + name + "' not set.");
/*      */     }
/*  615 */     if ((value instanceof Byte))
/*  616 */       return ((Byte)value).byteValue();
/*  617 */     if ((value instanceof String)) {
/*  618 */       return Byte.parseByte((String)value);
/*      */     }
/*  620 */     throw new MessageFormatException("Invalid conversion");
/*      */   }
/*      */ 
/*      */   public short getShortProperty(String name) throws JMSException
/*      */   {
/*  625 */     Object value = this.headers.get("P" + name);
/*  626 */     if (value == null) {
/*  627 */       throw new NumberFormatException("Message property '" + name + "' not set.");
/*      */     }
/*  629 */     if ((value instanceof Byte))
/*  630 */       return ((Byte)value).shortValue();
/*  631 */     if ((value instanceof Short))
/*  632 */       return ((Short)value).shortValue();
/*  633 */     if ((value instanceof String)) {
/*  634 */       return Short.parseShort((String)value);
/*      */     }
/*  636 */     throw new MessageFormatException("Invalid conversion");
/*      */   }
/*      */ 
/*      */   public int getIntProperty(String name) throws JMSException
/*      */   {
/*  641 */     Object value = this.headers.get("P" + name);
/*      */ 
/*  643 */     if (value == null)
/*      */     {
/*  645 */       throw new NumberFormatException("Message property '" + name + "' not set.");
/*      */     }
/*      */ 
/*  648 */     if ((value instanceof Byte))
/*      */     {
/*  650 */       return ((Byte)value).intValue();
/*      */     }
/*  652 */     if ((value instanceof Short))
/*      */     {
/*  654 */       return ((Short)value).intValue();
/*      */     }
/*  656 */     if ((value instanceof Integer))
/*      */     {
/*  658 */       return ((Integer)value).intValue();
/*      */     }
/*  660 */     if ((value instanceof String))
/*      */     {
/*  662 */       return Integer.parseInt((String)value);
/*      */     }
/*      */ 
/*  666 */     throw new MessageFormatException("Invalid conversion");
/*      */   }
/*      */ 
/*      */   public long getLongProperty(String name)
/*      */     throws JMSException
/*      */   {
/*  672 */     if ("JMS_JBOSS_SCHEDULED_DELIVERY".equals(name))
/*      */     {
/*  674 */       if (this.scheduledDeliveryTime == 0L)
/*      */       {
/*  676 */         throw new NumberFormatException("Message property '" + name + "' not set.");
/*      */       }
/*      */ 
/*  680 */       return this.scheduledDeliveryTime;
/*      */     }
/*      */ 
/*  684 */     Object value = this.headers.get("P" + name);
/*      */ 
/*  686 */     if (value == null)
/*      */     {
/*  688 */       throw new NumberFormatException("Message property '" + name + "' not set.");
/*      */     }
/*      */ 
/*  691 */     if ((value instanceof Byte))
/*      */     {
/*  693 */       return ((Byte)value).longValue();
/*      */     }
/*  695 */     if ((value instanceof Short))
/*      */     {
/*  697 */       return ((Short)value).longValue();
/*      */     }
/*  699 */     if ((value instanceof Integer))
/*      */     {
/*  701 */       return ((Integer)value).longValue();
/*      */     }
/*  703 */     if ((value instanceof Long))
/*      */     {
/*  705 */       return ((Long)value).longValue();
/*      */     }
/*  707 */     if ((value instanceof String))
/*      */     {
/*  709 */       return Long.parseLong((String)value);
/*      */     }
/*      */ 
/*  713 */     throw new MessageFormatException("Invalid conversion");
/*      */   }
/*      */ 
/*      */   public float getFloatProperty(String name)
/*      */     throws JMSException
/*      */   {
/*  719 */     Object value = this.headers.get("P" + name);
/*  720 */     if (value == null) {
/*  721 */       return Float.valueOf(null).floatValue();
/*      */     }
/*  723 */     if ((value instanceof Float))
/*  724 */       return ((Float)value).floatValue();
/*  725 */     if ((value instanceof String)) {
/*  726 */       return Float.parseFloat((String)value);
/*      */     }
/*  728 */     throw new MessageFormatException("Invalid conversion");
/*      */   }
/*      */ 
/*      */   public double getDoubleProperty(String name) throws JMSException
/*      */   {
/*  733 */     Object value = this.headers.get("P" + name);
/*  734 */     if (value == null) {
/*  735 */       return Double.valueOf(null).doubleValue();
/*      */     }
/*  737 */     if ((value instanceof Float))
/*  738 */       return ((Float)value).doubleValue();
/*  739 */     if ((value instanceof Double))
/*  740 */       return ((Double)value).doubleValue();
/*  741 */     if ((value instanceof String)) {
/*  742 */       return Double.parseDouble((String)value);
/*      */     }
/*  744 */     throw new MessageFormatException("Invalid conversion");
/*      */   }
/*      */ 
/*      */   public String getStringProperty(String name) throws JMSException
/*      */   {
/*  749 */     if ("JMS_JBOSS_SCHEDULED_DELIVERY".equals(name))
/*      */     {
/*  751 */       if (this.scheduledDeliveryTime == 0L)
/*      */       {
/*  753 */         throw new NumberFormatException("Message property '" + name + "' not set.");
/*      */       }
/*      */ 
/*  757 */       return String.valueOf(this.scheduledDeliveryTime);
/*      */     }
/*      */ 
/*  761 */     Object value = this.headers.get("P" + name);
/*  762 */     if (value == null) {
/*  763 */       return null;
/*      */     }
/*  765 */     if ((value instanceof Boolean))
/*      */     {
/*  767 */       return value.toString();
/*      */     }
/*  769 */     if ((value instanceof Byte))
/*      */     {
/*  771 */       return value.toString();
/*      */     }
/*  773 */     if ((value instanceof Short))
/*      */     {
/*  775 */       return value.toString();
/*      */     }
/*  777 */     if ((value instanceof Integer))
/*      */     {
/*  779 */       return value.toString();
/*      */     }
/*  781 */     if ((value instanceof Long))
/*      */     {
/*  783 */       return value.toString();
/*      */     }
/*  785 */     if ((value instanceof Float))
/*      */     {
/*  787 */       return value.toString();
/*      */     }
/*  789 */     if ((value instanceof Double))
/*      */     {
/*  791 */       return value.toString();
/*      */     }
/*  793 */     if ((value instanceof String))
/*      */     {
/*  795 */       return (String)value;
/*      */     }
/*      */ 
/*  799 */     throw new MessageFormatException("Invalid conversion");
/*      */   }
/*      */ 
/*      */   public Object getObjectProperty(String name)
/*      */     throws JMSException
/*      */   {
/*  805 */     if ("JMS_JBOSS_SCHEDULED_DELIVERY".equals(name))
/*      */     {
/*  807 */       if (this.scheduledDeliveryTime == 0L)
/*      */       {
/*  809 */         return null;
/*      */       }
/*      */ 
/*  813 */       return new Long(this.scheduledDeliveryTime);
/*      */     }
/*      */ 
/*  817 */     return this.headers.get("P" + name);
/*      */   }
/*      */ 
/*      */   public Enumeration getPropertyNames() throws JMSException
/*      */   {
/*  822 */     HashSet set = new HashSet();
/*      */ 
/*  824 */     Iterator iter = this.headers.keySet().iterator();
/*      */ 
/*  826 */     while (iter.hasNext())
/*      */     {
/*  828 */       String propName = (String)iter.next();
/*      */ 
/*  830 */       if (propName.charAt(0) == 'P')
/*      */       {
/*  832 */         String name = propName.substring(1);
/*  833 */         set.add(name);
/*      */       }
/*      */     }
/*      */ 
/*  837 */     if (this.scheduledDeliveryTime != 0L)
/*      */     {
/*  839 */       set.add("JMS_JBOSS_SCHEDULED_DELIVERY");
/*      */     }
/*      */ 
/*  842 */     return Collections.enumeration(set);
/*      */   }
/*      */ 
/*      */   public void setBooleanProperty(String name, boolean value) throws JMSException
/*      */   {
/*  847 */     Boolean b = Primitives.valueOf(value);
/*  848 */     checkProperty(name, b);
/*  849 */     this.headers.put("P" + name, b);
/*      */   }
/*      */ 
/*      */   public void setByteProperty(String name, byte value) throws JMSException
/*      */   {
/*  854 */     Byte b = new Byte(value);
/*  855 */     checkProperty(name, b);
/*  856 */     this.headers.put("P" + name, b);
/*      */   }
/*      */ 
/*      */   public void setShortProperty(String name, short value) throws JMSException
/*      */   {
/*  861 */     Short s = new Short(value);
/*  862 */     checkProperty(name, s);
/*  863 */     this.headers.put("P" + name, s);
/*      */   }
/*      */ 
/*      */   public void setIntProperty(String name, int value) throws JMSException
/*      */   {
/*  868 */     Integer i = new Integer(value);
/*  869 */     checkProperty(name, i);
/*  870 */     this.headers.put("P" + name, i);
/*      */   }
/*      */ 
/*      */   public void setLongProperty(String name, long value)
/*      */     throws JMSException
/*      */   {
/*  876 */     if ("JMS_JBOSS_SCHEDULED_DELIVERY".equals(name))
/*      */     {
/*  878 */       this.scheduledDeliveryTime = value;
/*      */     }
/*      */     else
/*      */     {
/*  882 */       Long l = new Long(value);
/*  883 */       checkProperty(name, l);
/*  884 */       this.headers.put("P" + name, l);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setFloatProperty(String name, float value) throws JMSException
/*      */   {
/*  890 */     Float f = new Float(value);
/*  891 */     checkProperty(name, f);
/*  892 */     this.headers.put("P" + name, f);
/*      */   }
/*      */ 
/*      */   public void setDoubleProperty(String name, double value) throws JMSException
/*      */   {
/*  897 */     Double d = new Double(value);
/*  898 */     checkProperty(name, d);
/*  899 */     this.headers.put("P" + name, d);
/*      */   }
/*      */ 
/*      */   public void setStringProperty(String name, String value) throws JMSException
/*      */   {
/*  904 */     checkProperty(name, value);
/*  905 */     this.headers.put("P" + name, value);
/*      */   }
/*      */ 
/*      */   public void setObjectProperty(String name, Object value) throws JMSException
/*      */   {
/*  910 */     if (("JMS_JBOSS_SCHEDULED_DELIVERY".equals(name)) && ((value instanceof Long)))
/*      */     {
/*  912 */       this.scheduledDeliveryTime = ((Long)value).longValue();
/*  913 */       return;
/*      */     }
/*      */ 
/*  916 */     checkProperty(name, value);
/*      */ 
/*  918 */     if ((value instanceof Boolean))
/*      */     {
/*  920 */       this.headers.put("P" + name, value);
/*      */     }
/*  922 */     else if ((value instanceof Byte))
/*      */     {
/*  924 */       this.headers.put("P" + name, value);
/*      */     }
/*  926 */     else if ((value instanceof Short))
/*      */     {
/*  928 */       this.headers.put("P" + name, value);
/*      */     }
/*  930 */     else if ((value instanceof Integer))
/*      */     {
/*  932 */       this.headers.put("P" + name, value);
/*      */     }
/*  934 */     else if ((value instanceof Long))
/*      */     {
/*  936 */       this.headers.put("P" + name, value);
/*      */     }
/*  938 */     else if ((value instanceof Float))
/*      */     {
/*  940 */       this.headers.put("P" + name, value);
/*      */     }
/*  942 */     else if ((value instanceof Double))
/*      */     {
/*  944 */       this.headers.put("P" + name, value);
/*      */     }
/*  946 */     else if ((value instanceof String))
/*      */     {
/*  948 */       this.headers.put("P" + name, value);
/*      */     }
/*  950 */     else if (value == null)
/*      */     {
/*  952 */       this.headers.put("P" + name, null);
/*      */     }
/*      */     else
/*      */     {
/*  956 */       throw new MessageFormatException("Invalid object type");
/*      */     }
/*      */   }
/*      */ 
/*      */   public void doBeforeSend()
/*      */     throws JMSException
/*      */   {
/*      */   }
/*      */ 
/*      */   public void doBeforeReceive()
/*      */     throws JMSException
/*      */   {
/*      */   }
/*      */ 
/*      */   public byte getType()
/*      */   {
/*  972 */     return 1;
/*      */   }
/*      */ 
/*      */   public void copyPayload(Object payload) throws JMSException
/*      */   {
/*      */   }
/*      */ 
/*      */   public String getConnectionID()
/*      */   {
/*  981 */     return this.connectionID;
/*      */   }
/*      */ 
/*      */   public void setConnectionID(String connectionID)
/*      */   {
/*  986 */     this.connectionID = connectionID;
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/*  991 */     StringBuffer sb = new StringBuffer("JBossMessage[");
/*  992 */     sb.append("");
/*  993 */     sb.append(this.messageID);
/*  994 */     sb.append("]:");
/*  995 */     sb.append(isReliable() ? "PERSISTENT" : "NON-PERSISTENT");
/*  996 */     return sb.toString();
/*      */   }
/*      */ 
/*      */   public JBossMessage doCopy() throws JMSException
/*      */   {
/* 1001 */     return new JBossMessage(this);
/*      */   }
/*      */ 
/*      */   public void acknowledge()
/*      */   {
/* 1006 */     throw new IllegalStateException("Should not be handled here!");
/*      */   }
/*      */ 
/*      */   public void setMessageId(long messageID)
/*      */   {
/* 1011 */     this.messageID = messageID;
/*      */   }
/*      */ 
/*      */   public long getScheduledDeliveryTime()
/*      */   {
/* 1016 */     return this.scheduledDeliveryTime;
/*      */   }
/*      */ 
/*      */   public Map getJMSProperties()
/*      */   {
/* 1022 */     Map newHeaders = new HashMap();
/*      */ 
/* 1024 */     Iterator iter = this.headers.entrySet().iterator();
/*      */ 
/* 1026 */     while (iter.hasNext())
/*      */     {
/* 1028 */       Map.Entry entry = (Map.Entry)iter.next();
/*      */ 
/* 1030 */       String key = (String)entry.getKey();
/*      */ 
/* 1032 */       if (key.charAt(0) == 'P')
/*      */       {
/* 1034 */         newHeaders.put(key, entry.getValue());
/*      */       }
/*      */     }
/*      */ 
/* 1038 */     return newHeaders;
/*      */   }
/*      */ 
/*      */   public boolean isCorrelationIDBytes()
/*      */   {
/* 1044 */     return this.headers.get("H.CORRELATIONIDBYTES") != null;
/*      */   }
/*      */ 
/*      */   public void write(DataOutputStream out)
/*      */     throws Exception
/*      */   {
/* 1052 */     super.write(out);
/*      */ 
/* 1054 */     out.writeLong(this.scheduledDeliveryTime);
/*      */ 
/* 1056 */     JBossDestination.writeDestination(out, this.destination);
/*      */   }
/*      */ 
/*      */   public void read(DataInputStream in) throws Exception
/*      */   {
/* 1061 */     super.read(in);
/*      */ 
/* 1063 */     this.scheduledDeliveryTime = in.readLong();
/*      */ 
/* 1065 */     this.destination = JBossDestination.readDestination(in);
/*      */   }
/*      */ 
/*      */   void checkProperty(String name, Object value)
/*      */     throws JMSException
/*      */   {
/* 1079 */     if (name == null)
/*      */     {
/* 1081 */       throw new IllegalArgumentException("The name of a property must not be null.");
/*      */     }
/*      */ 
/* 1084 */     if (name.equals(""))
/*      */     {
/* 1086 */       throw new IllegalArgumentException("The name of a property must not be an empty String.");
/*      */     }
/*      */ 
/* 1089 */     if (!Strings.isValidJavaIdentifier(name))
/*      */     {
/* 1091 */       throw new IllegalArgumentException("The property name '" + name + "' is not a valid java identifier.");
/*      */     }
/*      */ 
/* 1095 */     if (reservedIdentifiers.contains(name))
/*      */     {
/* 1097 */       throw new IllegalArgumentException("The property name '" + name + "' is reserved due to selector syntax.");
/*      */     }
/*      */ 
/* 1101 */     if ((name.startsWith("JMSX")) && (!name.equals("JMSXGroupID")) && (!name.equals("JMSXGroupSeq")) && (!name.equals("JMSXDeliveryCount")))
/*      */     {
/* 1106 */       throw new JMSException("Can only set JMSXGroupId, JMSXGroupSeq, JMSXDeliveryCount");
/*      */     }
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*  119 */     reservedIdentifiers.add("NULL");
/*  120 */     reservedIdentifiers.add("TRUE");
/*  121 */     reservedIdentifiers.add("FALSE");
/*  122 */     reservedIdentifiers.add("NOT");
/*  123 */     reservedIdentifiers.add("AND");
/*  124 */     reservedIdentifiers.add("OR");
/*  125 */     reservedIdentifiers.add("BETWEEN");
/*  126 */     reservedIdentifiers.add("LIKE");
/*  127 */     reservedIdentifiers.add("IN");
/*  128 */     reservedIdentifiers.add("IS");
/*  129 */     reservedIdentifiers.add("ESCAPE");
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.message.JBossMessage
 * JD-Core Version:    0.6.0
 */