/*    */ package org.jboss.jms.message;
/*    */ 
/*    */ import javax.jms.JMSException;
/*    */ import org.jboss.jms.delegate.ConnectionEndpoint;
/*    */ import org.jboss.jms.delegate.IDBlock;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class MessageIdGenerator
/*    */ {
/* 44 */   private static final Logger log = Logger.getLogger(MessageIdGenerator.class);
/*    */ 
/* 50 */   private boolean trace = log.isTraceEnabled();
/*    */ 
/* 52 */   protected long high = -1L;
/*    */   protected long nextID;
/*    */   protected int blockSize;
/*    */ 
/*    */   public MessageIdGenerator(int blockSize)
/*    */     throws JMSException
/*    */   {
/* 60 */     this.blockSize = blockSize;
/*    */   }
/*    */ 
/*    */   protected void getNextBlock(ConnectionEndpoint connection)
/*    */     throws JMSException
/*    */   {
/* 67 */     IDBlock block = connection.getIdBlock(this.blockSize);
/*    */ 
/* 69 */     this.nextID = block.getLow();
/* 70 */     this.high = block.getHigh();
/*    */ 
/* 72 */     if (this.trace) log.trace("Got block of IDs from server, low=" + this.nextID + " high=" + this.high); 
/*    */   }
/*    */ 
/*    */   public synchronized long getId(ConnectionEndpoint connection)
/*    */     throws JMSException
/*    */   {
/* 77 */     if (this.nextID == this.high + 1L)
/*    */     {
/* 79 */       getNextBlock(connection);
/*    */     }
/*    */ 
/* 82 */     long id = this.nextID;
/*    */ 
/* 84 */     if (log.isTraceEnabled()) log.trace("Getting next message id=" + id);
/*    */ 
/* 86 */     this.nextID += 1L;
/*    */ 
/* 88 */     return id;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.message.MessageIdGenerator
 * JD-Core Version:    0.6.0
 */