/*    */ package org.jboss.jms.message;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import javax.jms.JMSException;
/*    */ import javax.jms.MessageNotWriteableException;
/*    */ import javax.jms.ObjectMessage;
/*    */ 
/*    */ public class ObjectMessageProxy extends MessageProxy
/*    */   implements ObjectMessage
/*    */ {
/*    */   private static final long serialVersionUID = 8797295997477962825L;
/*    */ 
/*    */   public ObjectMessageProxy(long deliveryId, JBossObjectMessage message, int deliveryCount)
/*    */   {
/* 44 */     super(deliveryId, message, deliveryCount);
/*    */   }
/*    */ 
/*    */   public ObjectMessageProxy(JBossObjectMessage message)
/*    */   {
/* 49 */     super(message);
/*    */   }
/*    */ 
/*    */   public void setObject(Serializable object) throws JMSException
/*    */   {
/* 54 */     if (this.bodyReadOnly)
/*    */     {
/* 56 */       throw new MessageNotWriteableException("setObject");
/*    */     }
/* 58 */     bodyChange();
/* 59 */     ((ObjectMessage)this.message).setObject(object);
/*    */   }
/*    */ 
/*    */   public Serializable getObject() throws JMSException
/*    */   {
/* 64 */     return ((ObjectMessage)this.message).getObject();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.message.ObjectMessageProxy
 * JD-Core Version:    0.6.0
 */