/*     */ package org.jboss.jms.server.connectionfactory;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.messaging.util.XMLUtil;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class JNDIBindings
/*     */ {
/*     */   private Element delegate;
/*     */   private List names;
/*     */ 
/*     */   public JNDIBindings(Element delegate)
/*     */   {
/*  55 */     parse(delegate);
/*  56 */     this.delegate = delegate;
/*     */   }
/*     */ 
/*     */   public Element getDelegate()
/*     */   {
/*  63 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   public List getNames()
/*     */   {
/*  71 */     return this.names;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  76 */     if (this.names == null)
/*     */     {
/*  78 */       return "";
/*     */     }
/*     */ 
/*  81 */     StringBuffer sb = new StringBuffer();
/*     */ 
/*  83 */     for (Iterator i = this.names.iterator(); i.hasNext(); )
/*     */     {
/*  85 */       sb.append(i.next());
/*  86 */       if (!i.hasNext())
/*     */         continue;
/*  88 */       sb.append(", ");
/*     */     }
/*     */ 
/*  91 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   private void parse(Element e)
/*     */   {
/* 102 */     if (!"bindings".equals(e.getNodeName()))
/*     */     {
/* 104 */       throw new IllegalArgumentException("The element is not a <bindings> element");
/*     */     }
/*     */ 
/* 107 */     if (!e.hasChildNodes())
/*     */     {
/* 109 */       this.names = Collections.EMPTY_LIST;
/* 110 */       return;
/*     */     }
/*     */ 
/* 113 */     NodeList nl = e.getChildNodes();
/* 114 */     for (int i = 0; i < nl.getLength(); i++)
/*     */     {
/* 116 */       Node n = nl.item(i);
/* 117 */       if (!"binding".equals(n.getNodeName()))
/*     */         continue;
/* 119 */       String text = XMLUtil.getTextContent(n).trim();
/* 120 */       if (this.names == null)
/*     */       {
/* 122 */         this.names = new ArrayList();
/*     */       }
/* 124 */       this.names.add(text);
/*     */     }
/*     */ 
/* 128 */     if (this.names == null)
/*     */     {
/* 130 */       this.names = Collections.EMPTY_LIST;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.connectionfactory.JNDIBindings
 * JD-Core Version:    0.6.0
 */