/*     */ package org.jboss.jms.server.container;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ServerLogInterceptor
/*     */   implements Interceptor
/*     */ {
/*  39 */   private static final Logger log = Logger.getLogger(ServerLogInterceptor.class);
/*     */ 
/*  45 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public String getName()
/*     */   {
/*  55 */     return "ServerLogInterceptor";
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/*  60 */     Method method = null;
/*  61 */     String methodName = null;
/*  62 */     Object target = null;
/*     */ 
/*  64 */     if (this.trace)
/*     */     {
/*  66 */       target = invocation.getTargetObject();
/*     */ 
/*  68 */       if (!(invocation instanceof MethodInvocation))
/*     */       {
/*  70 */         log.trace("invoking non-method invocation: " + invocation + " on " + target);
/*     */       }
/*     */       else
/*     */       {
/*  74 */         MethodInvocation mi = (MethodInvocation)invocation;
/*  75 */         method = mi.getMethod();
/*  76 */         methodName = method.getName();
/*     */ 
/*  78 */         StringBuffer sb = new StringBuffer();
/*  79 */         sb.append("invoking ").append(target).append('.').append(methodName).append('(');
/*  80 */         Object[] args = mi.getArguments();
/*  81 */         if (args != null)
/*     */         {
/*  83 */           for (int i = 0; i < args.length; i++)
/*     */           {
/*  86 */             if (("createConnectionDelegate".equals(methodName)) && (i == 1))
/*     */             {
/*  88 */               sb.append("*****");
/*     */             }
/*     */             else
/*     */             {
/*  92 */               sb.append(args[i]);
/*     */             }
/*  94 */             if (i >= args.length - 1)
/*     */               continue;
/*  96 */             sb.append(", ");
/*     */           }
/*     */         }
/*     */ 
/* 100 */         sb.append(')');
/* 101 */         log.trace(sb.toString());
/*     */       }
/*     */     }
/*     */ 
/* 105 */     Object result = invocation.invokeNext();
/*     */ 
/* 107 */     if (this.trace)
/*     */     {
/* 109 */       if (method == null)
/*     */       {
/* 111 */         log.trace(invocation + " successfully invoked on " + target);
/*     */       }
/* 115 */       else if (method.getReturnType() != Void.TYPE)
/*     */       {
/* 117 */         log.trace(target + "." + methodName + "() returned " + result);
/*     */       }
/*     */       else
/*     */       {
/* 121 */         log.trace(target + "." + methodName + "() OK");
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 126 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.container.ServerLogInterceptor
 * JD-Core Version:    0.6.0
 */