/*     */ package org.jboss.jms.server.endpoint;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.jms.IllegalStateException;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.Message;
/*     */ import org.jboss.jms.delegate.BrowserEndpoint;
/*     */ import org.jboss.jms.message.JBossMessage;
/*     */ import org.jboss.jms.server.selector.Selector;
/*     */ import org.jboss.jms.wireformat.Dispatcher;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Channel;
/*     */ import org.jboss.messaging.core.contract.Filter;
/*     */ import org.jboss.messaging.util.ExceptionUtil;
/*     */ 
/*     */ public class ServerBrowserEndpoint
/*     */   implements BrowserEndpoint
/*     */ {
/*  53 */   private static final Logger log = Logger.getLogger(ServerBrowserEndpoint.class);
/*     */ 
/*  57 */   private static boolean trace = log.isTraceEnabled();
/*     */   private String id;
/*     */   private boolean closed;
/*     */   private ServerSessionEndpoint session;
/*     */   private Channel destination;
/*     */   private Filter filter;
/*     */   private Iterator iterator;
/*     */ 
/*     */   ServerBrowserEndpoint(ServerSessionEndpoint session, String id, Channel destination, String messageSelector)
/*     */     throws JMSException
/*     */   {
/*  73 */     this.session = session;
/*  74 */     this.id = id;
/*  75 */     this.destination = destination;
/*     */ 
/*  77 */     if (messageSelector != null)
/*     */     {
/*  79 */       this.filter = new Selector(messageSelector);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/*  89 */       if (this.closed)
/*     */       {
/*  91 */         throw new IllegalStateException("Browser is closed");
/*     */       }
/*     */ 
/*  94 */       log.trace(this + " is being resetted");
/*     */ 
/*  96 */       this.iterator = createIterator();
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 100 */       throw ExceptionUtil.handleJMSInvocation(t, this + " hasNextMessage");
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean hasNextMessage() throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 108 */       if (this.closed)
/*     */       {
/* 110 */         throw new IllegalStateException("Browser is closed");
/*     */       }
/*     */ 
/* 113 */       if (this.iterator == null)
/*     */       {
/* 115 */         this.iterator = createIterator();
/*     */       }
/*     */ 
/* 118 */       boolean has = this.iterator.hasNext();
/* 119 */       if (trace) log.trace(this + (has ? " has" : " DOESN'T have") + " a next message");
/* 120 */       return has;
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 124 */     throw ExceptionUtil.handleJMSInvocation(t, this + " hasNextMessage");
/*     */   }
/*     */ 
/*     */   public JBossMessage nextMessage()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 132 */       if (this.closed)
/*     */       {
/* 134 */         throw new IllegalStateException("Browser is closed");
/*     */       }
/*     */ 
/* 137 */       if (this.iterator == null)
/*     */       {
/* 139 */         this.iterator = createIterator();
/*     */       }
/*     */ 
/* 142 */       JBossMessage r = (JBossMessage)this.iterator.next();
/*     */ 
/* 144 */       if (trace) log.trace(this + " returning " + r);
/*     */ 
/* 146 */       return r;
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 150 */     throw ExceptionUtil.handleJMSInvocation(t, this + " nextMessage");
/*     */   }
/*     */ 
/*     */   public JBossMessage[] nextMessageBlock(int maxMessages)
/*     */     throws JMSException
/*     */   {
/* 157 */     if (trace) log.trace(this + " returning next message block of " + maxMessages);
/*     */ 
/*     */     try
/*     */     {
/* 161 */       if (this.closed)
/*     */       {
/* 163 */         throw new IllegalStateException("Browser is closed");
/*     */       }
/*     */ 
/* 166 */       if (maxMessages < 2)
/*     */       {
/* 168 */         throw new IllegalArgumentException("maxMessages must be >=2 otherwise use nextMessage");
/*     */       }
/*     */ 
/* 171 */       if (this.iterator == null)
/*     */       {
/* 173 */         this.iterator = createIterator();
/*     */       }
/*     */ 
/* 176 */       ArrayList messages = new ArrayList(maxMessages);
/* 177 */       int i = 0;
/* 178 */       while (i < maxMessages)
/*     */       {
/* 180 */         if (!this.iterator.hasNext())
/*     */           break;
/* 182 */         Message m = (Message)this.iterator.next();
/* 183 */         messages.add(m);
/* 184 */         i++;
/*     */       }
/*     */ 
/* 188 */       return (JBossMessage[])(JBossMessage[])messages.toArray(new JBossMessage[messages.size()]);
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 192 */     throw ExceptionUtil.handleJMSInvocation(t, this + " nextMessageBlock");
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 200 */       localClose();
/* 201 */       this.session.removeBrowser(this.id);
/* 202 */       log.trace(this + " closed");
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 206 */       throw ExceptionUtil.handleJMSInvocation(t, this + " close");
/*     */     }
/*     */   }
/*     */ 
/*     */   public long closing(long sequence)
/*     */     throws JMSException
/*     */   {
/* 213 */     return -1L;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 220 */     return "BrowserEndpoint[" + this.id + "]";
/*     */   }
/*     */ 
/*     */   void localClose()
/*     */     throws JMSException
/*     */   {
/* 227 */     if (this.closed)
/*     */     {
/* 229 */       throw new IllegalStateException("Browser is already closed");
/*     */     }
/*     */ 
/* 232 */     this.iterator = null;
/*     */ 
/* 234 */     Dispatcher.instance.unregisterTarget(this.id, this);
/*     */ 
/* 236 */     this.closed = true;
/*     */   }
/*     */ 
/*     */   private Iterator createIterator()
/*     */   {
/* 245 */     return this.destination.browse(this.filter).iterator();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.endpoint.ServerBrowserEndpoint
 * JD-Core Version:    0.6.0
 */