/*     */ package org.jboss.jms.server.endpoint;
/*     */ 
/*     */ import java.util.Map;
/*     */ import javax.jms.JMSException;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.jms.client.delegate.ClientConnectionDelegate;
/*     */ import org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate;
/*     */ import org.jboss.jms.delegate.ConnectionFactoryEndpoint;
/*     */ import org.jboss.jms.delegate.CreateConnectionResult;
/*     */ import org.jboss.jms.delegate.TopologyResult;
/*     */ import org.jboss.jms.server.ConnectionManager;
/*     */ import org.jboss.jms.server.SecurityStore;
/*     */ import org.jboss.jms.server.ServerPeer;
/*     */ import org.jboss.jms.server.connectionfactory.JNDIBindings;
/*     */ import org.jboss.jms.server.endpoint.advised.ConnectionAdvised;
/*     */ import org.jboss.jms.server.plugin.contract.JMSUserManager;
/*     */ import org.jboss.jms.wireformat.ConnectionFactoryUpdate;
/*     */ import org.jboss.jms.wireformat.Dispatcher;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.impl.FailoverWaiter;
/*     */ import org.jboss.messaging.util.ExceptionUtil;
/*     */ import org.jboss.remoting.callback.Callback;
/*     */ import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
/*     */ 
/*     */ public class ServerConnectionFactoryEndpoint
/*     */   implements ConnectionFactoryEndpoint
/*     */ {
/*  57 */   private static final Logger log = Logger.getLogger(ServerConnectionFactoryEndpoint.class);
/*     */   private ServerPeer serverPeer;
/*     */   private String clientID;
/*     */   private String uniqueName;
/*     */   private String id;
/*     */   private JNDIBindings jndiBindings;
/*     */   private int prefetchSize;
/*     */   private int defaultTempQueueFullSize;
/*     */   private int defaultTempQueuePageSize;
/*     */   private int defaultTempQueueDownCacheSize;
/*     */   private int dupsOKBatchSize;
/*     */   private boolean supportsFailover;
/*     */   private boolean slowConsumers;
/*     */   ClientConnectionFactoryDelegate[] delegates;
/*     */   Map failoverMap;
/*     */ 
/*     */   public ServerConnectionFactoryEndpoint(String uniqueName, String id, ServerPeer serverPeer, String defaultClientID, JNDIBindings jndiBindings, int preFetchSize, boolean slowConsumers, int defaultTempQueueFullSize, int defaultTempQueuePageSize, int defaultTempQueueDownCacheSize, int dupsOKBatchSize, boolean supportsFailover)
/*     */   {
/* 114 */     this.uniqueName = uniqueName;
/* 115 */     this.serverPeer = serverPeer;
/* 116 */     this.clientID = defaultClientID;
/* 117 */     this.id = id;
/* 118 */     this.jndiBindings = jndiBindings;
/* 119 */     this.prefetchSize = preFetchSize;
/* 120 */     this.defaultTempQueueFullSize = defaultTempQueueFullSize;
/* 121 */     this.defaultTempQueuePageSize = defaultTempQueuePageSize;
/* 122 */     this.defaultTempQueueDownCacheSize = defaultTempQueueDownCacheSize;
/* 123 */     this.dupsOKBatchSize = dupsOKBatchSize;
/* 124 */     this.supportsFailover = supportsFailover;
/* 125 */     this.slowConsumers = slowConsumers;
/* 126 */     if (slowConsumers)
/*     */     {
/* 128 */       this.prefetchSize = 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   public CreateConnectionResult createConnectionDelegate(String username, String password, int failedNodeID)
/*     */     throws JMSException
/*     */   {
/* 141 */     throw new IllegalStateException("createConnectionDelegate should never be called directly");
/*     */   }
/*     */ 
/*     */   public CreateConnectionResult createConnectionDelegate(String username, String password, int failedNodeID, String remotingSessionID, String clientVMID, byte versionToUse, ServerInvokerCallbackHandler callbackHandler)
/*     */     throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 159 */       if (failedNodeID == -1)
/*     */       {
/* 162 */         ClientConnectionDelegate cd = createConnectionDelegateInternal(username, password, failedNodeID, remotingSessionID, clientVMID, versionToUse, callbackHandler);
/*     */ 
/* 167 */         return new CreateConnectionResult(cd);
/*     */       }
/*     */ 
/* 171 */       log.trace(this + " received client-side failover request. Creating failover " + "connection to replace connection to failed node " + failedNodeID);
/*     */ 
/* 175 */       int failoverNodeID = this.serverPeer.getFailoverWaiter().waitForFailover(failedNodeID);
/*     */ 
/* 177 */       if ((failoverNodeID == -1) || (failoverNodeID != this.serverPeer.getServerPeerID()))
/*     */       {
/* 179 */         log.trace(this + " realized that we are on the wrong node or no failover has occured");
/* 180 */         return new CreateConnectionResult(failoverNodeID);
/*     */       }
/*     */ 
/* 184 */       log.trace(this + " received notification that server-side failover completed, " + "creating connection delegate ...");
/*     */ 
/* 186 */       ClientConnectionDelegate cd = createConnectionDelegateInternal(username, password, failedNodeID, remotingSessionID, clientVMID, versionToUse, callbackHandler);
/*     */ 
/* 191 */       return new CreateConnectionResult(cd);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*     */     }
/*     */ 
/* 197 */     throw ExceptionUtil.handleJMSInvocation(t, this + " createFailoverConnectionDelegate");
/*     */   }
/*     */ 
/*     */   private ClientConnectionDelegate createConnectionDelegateInternal(String username, String password, int failedNodeID, String remotingSessionID, String clientVMID, byte versionToUse, ServerInvokerCallbackHandler callbackHandler)
/*     */     throws Exception
/*     */   {
/* 215 */     log.trace("creating a new connection for user " + username);
/*     */ 
/* 222 */     this.serverPeer.getSecurityManager().authenticate(username, password);
/*     */ 
/* 225 */     SecurityActions.popSubjectContext();
/*     */ 
/* 227 */     String clientIDUsed = this.clientID;
/*     */ 
/* 230 */     if (username != null)
/*     */     {
/* 232 */       String preconfClientID = this.serverPeer.getJmsUserManagerInstance().getPreConfiguredClientID(username);
/*     */ 
/* 235 */       if (preconfClientID != null)
/*     */       {
/* 237 */         clientIDUsed = preconfClientID;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 243 */     ServerConnectionEndpoint endpoint = new ServerConnectionEndpoint(this.serverPeer, clientIDUsed, username, password, this.prefetchSize, this.defaultTempQueueFullSize, this.defaultTempQueuePageSize, this.defaultTempQueueDownCacheSize, failedNodeID, this, remotingSessionID, clientVMID, versionToUse, callbackHandler, this.dupsOKBatchSize);
/*     */ 
/* 250 */     String connectionID = endpoint.getConnectionID();
/*     */     ConnectionAdvised connAdvised;
/* 256 */     synchronized (AspectManager.instance())
/*     */     {
/* 258 */       connAdvised = new ConnectionAdvised(endpoint);
/*     */     }
/*     */ 
/* 261 */     Dispatcher.instance.registerTarget(connectionID, connAdvised);
/*     */ 
/* 263 */     log.trace("created and registered " + endpoint);
/*     */ 
/* 267 */     synchronized (AspectManager.instance())
/*     */     {
/* 269 */       return new ClientConnectionDelegate(connectionID, this.serverPeer.getServerPeerID());
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte[] getClientAOPStack() throws JMSException
/*     */   {
/*     */     try
/*     */     {
/* 277 */       return this.serverPeer.getClientAOPStack();
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 281 */     throw ExceptionUtil.handleJMSInvocation(t, this + " getClientAOPStack");
/*     */   }
/*     */ 
/*     */   public void addCallback(String VMID, String remotingSessionID, ServerInvokerCallbackHandler callbackHandler)
/*     */     throws JMSException
/*     */   {
/* 288 */     log.debug("Adding callbackHandler on ConnectionFactory");
/* 289 */     this.serverPeer.getConnectionManager().addConnectionFactoryCallback(this.uniqueName, VMID, remotingSessionID, callbackHandler);
/*     */   }
/*     */ 
/*     */   public void removeCallback(String VMID, String remotingSessionID, ServerInvokerCallbackHandler callbackHandler)
/*     */     throws JMSException
/*     */   {
/* 295 */     log.debug("Removing callbackHandler on ConnectionFactory");
/* 296 */     this.serverPeer.getConnectionManager().removeConnectionFactoryCallback(this.uniqueName, VMID, callbackHandler);
/*     */   }
/*     */ 
/*     */   public TopologyResult getTopology() throws JMSException
/*     */   {
/* 301 */     return new TopologyResult(this.uniqueName, this.delegates, this.failoverMap);
/*     */   }
/*     */ 
/*     */   public String getID()
/*     */   {
/* 308 */     return this.id;
/*     */   }
/*     */ 
/*     */   public JNDIBindings getJNDIBindings()
/*     */   {
/* 313 */     return this.jndiBindings;
/*     */   }
/*     */ 
/*     */   public ServerPeer getServerPeer()
/*     */   {
/* 318 */     return this.serverPeer;
/*     */   }
/*     */ 
/*     */   public void updateClusteredClients(ClientConnectionFactoryDelegate[] delegates, Map failoverMap)
/*     */     throws Exception
/*     */   {
/* 330 */     updateTopology(delegates, failoverMap);
/*     */ 
/* 332 */     ServerInvokerCallbackHandler[] clientFactoriesToUpdate = this.serverPeer.getConnectionManager().getConnectionFactoryCallback(this.uniqueName);
/* 333 */     log.debug("updateClusteredClients being called!!! clientFactoriesToUpdate.size = " + clientFactoriesToUpdate.length);
/*     */ 
/* 335 */     ConnectionFactoryUpdate message = new ConnectionFactoryUpdate(this.uniqueName, delegates, failoverMap);
/*     */ 
/* 338 */     Callback callback = new Callback(message);
/*     */ 
/* 340 */     for (ServerInvokerCallbackHandler o : clientFactoriesToUpdate)
/*     */     {
/* 342 */       log.debug("Updating CF on callback " + o);
/* 343 */       o.handleCallbackOneway(callback);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void updateTopology(ClientConnectionFactoryDelegate[] delegates, Map failoverMap)
/*     */   {
/* 349 */     this.delegates = delegates;
/* 350 */     this.failoverMap = failoverMap;
/*     */   }
/*     */ 
/*     */   public boolean isSlowConsumers()
/*     */   {
/* 355 */     return this.slowConsumers;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 360 */     return "ConnectionFactoryEndpoint[" + this.id + "]";
/*     */   }
/*     */ 
/*     */   boolean isSupportsFailover()
/*     */   {
/* 367 */     return this.supportsFailover;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.endpoint.ServerConnectionFactoryEndpoint
 * JD-Core Version:    0.6.0
 */