/*     */ package org.jboss.jms.server.messagecounter;
/*     */ 
/*     */ import java.text.DateFormat;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Date;
/*     */ import java.util.GregorianCalendar;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Queue;
/*     */ 
/*     */ public class MessageCounter
/*     */ {
/*  51 */   protected static final Logger log = Logger.getLogger(MessageCounter.class);
/*     */   private String destName;
/*     */   private String destSubscription;
/*     */   private boolean destTopic;
/*     */   private boolean destDurable;
/*     */   private Queue destQueue;
/*     */   private int countTotal;
/*     */   private int countTotalLast;
/*     */   private int depthLast;
/*     */   private long timeLastUpdate;
/*     */   private int dayCounterMax;
/*     */   private ArrayList dayCounter;
/*     */   private int lastMessagesAdded;
/*     */ 
/*     */   public static List getMessageStatistics(List counters)
/*     */     throws Exception
/*     */   {
/*  81 */     List list = new ArrayList(counters.size());
/*     */ 
/*  83 */     Iterator iter = counters.iterator();
/*     */ 
/*  85 */     while (iter.hasNext())
/*     */     {
/*  87 */       MessageCounter counter = (MessageCounter)iter.next();
/*     */ 
/*  89 */       MessageStatistics stats = new MessageStatistics();
/*  90 */       stats.setName(counter.getDestinationName());
/*  91 */       stats.setSubscriptionID(counter.getDestinationSubscription());
/*  92 */       stats.setTopic(counter.getDestinationTopic());
/*  93 */       stats.setDurable(counter.getDestinationDurable());
/*  94 */       stats.setCount(counter.getCount());
/*  95 */       stats.setCountDelta(counter.getCountDelta());
/*  96 */       stats.setDepth(counter.getMessageCount());
/*  97 */       stats.setDepthDelta(counter.getMessageCountDelta());
/*  98 */       stats.setTimeLastUpdate(counter.getLastUpdate());
/*     */ 
/* 100 */       list.add(stats);
/*     */     }
/* 102 */     return list;
/*     */   }
/*     */ 
/*     */   public MessageCounter(String name, String subscription, Queue queue, boolean topic, boolean durable, int daycountmax)
/*     */   {
/* 123 */     this.destName = name;
/* 124 */     this.destSubscription = subscription;
/* 125 */     this.destTopic = topic;
/* 126 */     this.destDurable = durable;
/* 127 */     this.destQueue = queue;
/*     */ 
/* 130 */     resetCounter();
/*     */ 
/* 133 */     this.dayCounter = new ArrayList();
/*     */ 
/* 135 */     setHistoryLimit(daycountmax);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 143 */     return getCounterAsString();
/*     */   }
/*     */ 
/*     */   public synchronized void onTimer()
/*     */   {
/* 153 */     int latestMessagesAdded = this.destQueue.getMessagesAdded();
/*     */ 
/* 155 */     int newMessagesAdded = latestMessagesAdded - this.lastMessagesAdded;
/*     */ 
/* 157 */     this.countTotal += newMessagesAdded;
/*     */ 
/* 159 */     this.lastMessagesAdded = latestMessagesAdded;
/*     */ 
/* 162 */     this.timeLastUpdate = System.currentTimeMillis();
/*     */ 
/* 165 */     updateHistory(true);
/*     */   }
/*     */ 
/*     */   public String getDestinationName()
/*     */   {
/* 175 */     return this.destName;
/*     */   }
/*     */ 
/*     */   public String getDestinationSubscription()
/*     */   {
/* 185 */     return this.destSubscription;
/*     */   }
/*     */ 
/*     */   public boolean getDestinationTopic()
/*     */   {
/* 195 */     return this.destTopic;
/*     */   }
/*     */ 
/*     */   public boolean getDestinationDurable()
/*     */   {
/* 206 */     return this.destDurable;
/*     */   }
/*     */ 
/*     */   public int getCount()
/*     */   {
/* 217 */     return this.countTotal;
/*     */   }
/*     */ 
/*     */   public int getCountDelta()
/*     */   {
/* 227 */     int delta = this.countTotal - this.countTotalLast;
/*     */ 
/* 229 */     this.countTotalLast = this.countTotal;
/*     */ 
/* 231 */     return delta;
/*     */   }
/*     */ 
/*     */   public int getMessageCount()
/*     */   {
/* 242 */     return this.destQueue.getMessageCount();
/*     */   }
/*     */ 
/*     */   public int getMessageCountDelta()
/*     */   {
/* 253 */     int current = this.destQueue.getMessageCount();
/* 254 */     int delta = current - this.depthLast;
/*     */ 
/* 256 */     this.depthLast = current;
/*     */ 
/* 258 */     return delta;
/*     */   }
/*     */ 
/*     */   public long getLastUpdate()
/*     */   {
/* 268 */     return this.timeLastUpdate;
/*     */   }
/*     */ 
/*     */   public void resetCounter()
/*     */   {
/* 276 */     this.countTotal = 0;
/* 277 */     this.countTotalLast = 0;
/* 278 */     this.depthLast = 0;
/* 279 */     this.timeLastUpdate = 0L;
/*     */   }
/*     */ 
/*     */   public String getCounterAsString()
/*     */   {
/* 292 */     StringBuffer ret = new StringBuffer();
/*     */ 
/* 295 */     if (this.destTopic)
/* 296 */       ret.append("Topic,");
/*     */     else {
/* 298 */       ret.append("Queue,");
/*     */     }
/*     */ 
/* 301 */     ret.append(this.destName).append(",");
/*     */ 
/* 304 */     if (this.destSubscription != null)
/* 305 */       ret.append(this.destSubscription).append(",");
/*     */     else {
/* 307 */       ret.append("-,");
/*     */     }
/*     */ 
/* 310 */     if (this.destTopic)
/*     */     {
/* 313 */       if (this.destDurable)
/* 314 */         ret.append("true,");
/*     */       else {
/* 316 */         ret.append("false,");
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 321 */       ret.append("-,");
/*     */     }
/*     */ 
/* 325 */     ret.append(getCount()).append(",").append(getCountDelta()).append(",").append(getMessageCount()).append(",").append(getMessageCountDelta()).append(",");
/*     */ 
/* 328 */     if (this.timeLastUpdate > 0L)
/*     */     {
/* 330 */       DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
/*     */ 
/* 332 */       ret.append(dateFormat.format(new Date(this.timeLastUpdate)));
/*     */     }
/*     */     else
/*     */     {
/* 336 */       ret.append("-");
/*     */     }
/*     */ 
/* 339 */     return ret.toString();
/*     */   }
/*     */ 
/*     */   public int getHistoryLimit()
/*     */   {
/* 349 */     return this.dayCounterMax;
/*     */   }
/*     */ 
/*     */   public void setHistoryLimit(int daycountmax)
/*     */   {
/* 359 */     boolean bInitialize = false;
/*     */ 
/* 362 */     this.dayCounterMax = daycountmax;
/*     */ 
/* 365 */     synchronized (this.dayCounter)
/*     */     {
/* 367 */       if (this.dayCounterMax > 0)
/*     */       {
/* 370 */         int delta = this.dayCounter.size() - this.dayCounterMax;
/*     */ 
/* 372 */         for (int i = 0; i < delta; i++)
/*     */         {
/* 376 */           this.dayCounter.remove(0);
/*     */         }
/*     */ 
/* 380 */         bInitialize = this.dayCounter.isEmpty();
/*     */       }
/* 382 */       else if (this.dayCounterMax == 0)
/*     */       {
/* 385 */         this.dayCounter.clear();
/*     */       }
/*     */       else
/*     */       {
/* 392 */         bInitialize = this.dayCounter.isEmpty();
/*     */       }
/*     */ 
/* 396 */       if (bInitialize)
/*     */       {
/* 398 */         this.dayCounter.add(new DayCounter(new GregorianCalendar(), true));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void updateHistory(boolean incrementCounter)
/*     */   {
/* 409 */     if (this.dayCounter.isEmpty())
/*     */     {
/* 411 */       return;
/*     */     }
/*     */ 
/* 415 */     synchronized (this.dayCounter)
/*     */     {
/* 417 */       DayCounter counterLast = (DayCounter)this.dayCounter.get(this.dayCounter.size() - 1);
/*     */ 
/* 419 */       GregorianCalendar calNow = new GregorianCalendar();
/* 420 */       GregorianCalendar calLast = counterLast.getDate();
/*     */ 
/* 423 */       calNow.clear(9);
/* 424 */       calNow.clear(10);
/* 425 */       calNow.clear(11);
/* 426 */       calNow.clear(12);
/* 427 */       calNow.clear(13);
/* 428 */       calNow.clear(14);
/*     */ 
/* 430 */       calLast.clear(9);
/* 431 */       calLast.clear(10);
/* 432 */       calLast.clear(11);
/* 433 */       calLast.clear(12);
/* 434 */       calLast.clear(13);
/* 435 */       calLast.clear(14);
/*     */ 
/* 437 */       long millisPerDay = 86400000L;
/* 438 */       long millisDelta = calNow.getTime().getTime() - calLast.getTime().getTime();
/*     */ 
/* 440 */       int dayDelta = (int)(millisDelta / millisPerDay);
/*     */ 
/* 442 */       if (dayDelta > 0)
/*     */       {
/* 445 */         counterLast.finalizeDayCounter();
/*     */ 
/* 450 */         for (int i = 1; i < dayDelta; i++)
/*     */         {
/* 453 */           calLast.add(6, 1);
/*     */ 
/* 455 */           DayCounter counterNew = new DayCounter(calLast, false);
/* 456 */           counterNew.finalizeDayCounter();
/*     */ 
/* 458 */           this.dayCounter.add(counterNew);
/*     */         }
/*     */ 
/* 462 */         DayCounter counterNew = new DayCounter(calNow, false);
/*     */ 
/* 464 */         this.dayCounter.add(counterNew);
/*     */ 
/* 467 */         setHistoryLimit(this.dayCounterMax);
/*     */       }
/*     */ 
/* 471 */       counterLast = (DayCounter)this.dayCounter.get(this.dayCounter.size() - 1);
/* 472 */       counterLast.updateDayCounter(incrementCounter);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void resetHistory()
/*     */   {
/* 481 */     int max = this.dayCounterMax;
/*     */ 
/* 483 */     setHistoryLimit(0);
/* 484 */     setHistoryLimit(max);
/*     */   }
/*     */ 
/*     */   public String getHistoryAsString()
/*     */   {
/* 501 */     String ret = "";
/*     */ 
/* 504 */     updateHistory(false);
/*     */ 
/* 507 */     synchronized (this.dayCounter)
/*     */     {
/* 510 */       ret = ret + this.dayCounter.size() + "\n";
/*     */ 
/* 513 */       for (int i = 0; i < this.dayCounter.size(); i++)
/*     */       {
/* 515 */         DayCounter counter = (DayCounter)this.dayCounter.get(i);
/*     */ 
/* 517 */         ret = ret + counter.getDayCounterAsString() + "\n";
/*     */       }
/*     */     }
/*     */ 
/* 521 */     return ret;
/*     */   }
/*     */ 
/*     */   private static class DayCounter
/*     */   {
/*     */     static final int HOURS = 24;
/* 531 */     GregorianCalendar date = null;
/* 532 */     int[] counters = new int[24];
/*     */ 
/*     */     DayCounter(GregorianCalendar date, boolean isStartDay)
/*     */     {
/* 544 */       this.date = ((GregorianCalendar)date.clone());
/*     */ 
/* 548 */       int hour = date.get(11);
/*     */ 
/* 550 */       for (int i = 0; i < 24; i++)
/*     */       {
/* 552 */         if (i < hour)
/*     */         {
/* 554 */           if (isStartDay)
/* 555 */             this.counters[i] = -1;
/*     */           else {
/* 557 */             this.counters[i] = 0;
/*     */           }
/*     */         }
/*     */         else {
/* 561 */           this.counters[i] = -1;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 566 */       this.counters[hour] = 0;
/*     */     }
/*     */ 
/*     */     GregorianCalendar getDate()
/*     */     {
/* 576 */       return (GregorianCalendar)this.date.clone();
/*     */     }
/*     */ 
/*     */     void updateDayCounter(boolean incrementCounter)
/*     */     {
/* 587 */       GregorianCalendar cal = new GregorianCalendar();
/*     */ 
/* 589 */       int currentIndex = cal.get(11);
/*     */ 
/* 593 */       boolean bUpdate = false;
/*     */ 
/* 595 */       for (int i = 0; i <= currentIndex; i++)
/*     */       {
/* 597 */         if (this.counters[i] > -1)
/*     */         {
/* 602 */           bUpdate = true;
/*     */         }
/*     */ 
/* 605 */         if (bUpdate != true)
/*     */           continue;
/* 607 */         if (this.counters[i] == -1) {
/* 608 */           this.counters[i] = 0;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 613 */       if (incrementCounter)
/*     */       {
/* 615 */         this.counters[currentIndex] += 1;
/*     */       }
/*     */     }
/*     */ 
/*     */     void finalizeDayCounter()
/*     */     {
/* 626 */       boolean bFinalize = false;
/*     */ 
/* 628 */       for (int i = 0; i < 24; i++)
/*     */       {
/* 630 */         if (this.counters[i] > -1)
/*     */         {
/* 635 */           bFinalize = true;
/*     */         }
/*     */ 
/* 638 */         if (!bFinalize)
/*     */           continue;
/* 640 */         if (this.counters[i] == -1)
/* 641 */           this.counters[i] = 0;
/*     */       }
/*     */     }
/*     */ 
/*     */     String getDayCounterAsString()
/*     */     {
/* 655 */       DateFormat dateFormat = DateFormat.getDateInstance(3);
/*     */ 
/* 657 */       String strData = dateFormat.format(this.date.getTime());
/*     */ 
/* 660 */       for (int i = 0; i < 24; i++)
/*     */       {
/* 662 */         strData = strData + "," + this.counters[i];
/*     */       }
/*     */ 
/* 665 */       return strData;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.messagecounter.MessageCounter
 * JD-Core Version:    0.6.0
 */