/*     */ package org.jboss.jms.server.recovery;
/*     */ 
/*     */ import com.arjuna.ats.jta.recovery.XAResourceRecovery;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class MessagingXAResourceRecovery
/*     */   implements XAResourceRecovery
/*     */ {
/*  45 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*  47 */   private static final Logger log = Logger.getLogger(MessagingXAResourceRecovery.class);
/*     */   private String providerAdaptorName;
/*     */   private boolean hasMore;
/*     */   private String username;
/*     */   private String password;
/*     */   private MessagingXAResourceWrapper res;
/*     */ 
/*     */   public MessagingXAResourceRecovery()
/*     */   {
/*  61 */     if (this.trace) log.trace("Constructing BridgeXAResourceRecovery");
/*     */   }
/*     */ 
/*     */   public boolean initialise(String config)
/*     */   {
/*  66 */     if (log.isTraceEnabled()) log.trace(this + " intialise: " + config);
/*     */ 
/*  68 */     StringTokenizer tok = new StringTokenizer(config, ",");
/*     */ 
/*  72 */     if (!tok.hasMoreTokens())
/*     */     {
/*  74 */       throw new IllegalArgumentException("Must specify provider adaptor name in config");
/*     */     }
/*     */ 
/*  77 */     this.providerAdaptorName = tok.nextToken();
/*     */ 
/*  82 */     if (tok.hasMoreTokens())
/*     */     {
/*  84 */       this.username = tok.nextToken();
/*     */ 
/*  86 */       if (!tok.hasMoreTokens())
/*     */       {
/*  88 */         throw new IllegalArgumentException("If username is specified, password must be specified too");
/*     */       }
/*     */ 
/*  91 */       this.password = tok.nextToken();
/*     */     }
/*     */ 
/*  94 */     this.res = new MessagingXAResourceWrapper(this.providerAdaptorName, this.username, this.password);
/*     */ 
/*  96 */     if (log.isTraceEnabled()) log.trace(this + " initialised");
/*     */ 
/*  98 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean hasMoreResources()
/*     */   {
/* 103 */     if (log.isTraceEnabled()) log.trace(this + " hasMoreResources");
/*     */ 
/* 119 */     this.hasMore = (!this.hasMore);
/*     */ 
/* 121 */     return this.hasMore;
/*     */   }
/*     */ 
/*     */   public XAResource getXAResource()
/*     */   {
/* 126 */     if (log.isTraceEnabled()) log.trace(this + " getXAResource");
/*     */ 
/* 128 */     return this.res;
/*     */   }
/*     */ 
/*     */   protected void finalize()
/*     */   {
/* 133 */     this.res.close();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.recovery.MessagingXAResourceRecovery
 * JD-Core Version:    0.6.0
 */