/*     */ package org.jboss.jms.server.recovery;
/*     */ 
/*     */ import javax.jms.ExceptionListener;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.XAConnection;
/*     */ import javax.jms.XAConnectionFactory;
/*     */ import javax.jms.XASession;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.transaction.xa.XAException;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import javax.transaction.xa.Xid;
/*     */ import org.jboss.jms.jndi.JMSProviderAdapter;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.naming.Util;
/*     */ 
/*     */ public class MessagingXAResourceWrapper
/*     */   implements XAResource, ExceptionListener
/*     */ {
/*  57 */   private static final Logger log = Logger.getLogger(MessagingXAResourceWrapper.class);
/*     */   private String providerName;
/*  63 */   private static final Object lock = new Object();
/*     */   private XAConnection connection;
/*     */   private XAResource delegate;
/*     */   private String username;
/*     */   private String password;
/*     */ 
/*     */   public MessagingXAResourceWrapper(String providerName, String username, String password)
/*     */   {
/*  77 */     this.providerName = providerName;
/*     */ 
/*  79 */     this.username = username;
/*     */ 
/*  81 */     this.password = password;
/*     */   }
/*     */ 
/*     */   public String getProviderName()
/*     */   {
/*  91 */     return this.providerName;
/*     */   }
/*     */ 
/*     */   public void setProviderName(String providerName)
/*     */   {
/* 101 */     this.providerName = providerName;
/*     */   }
/*     */ 
/*     */   public Xid[] recover(int flag) throws XAException
/*     */   {
/* 106 */     log.debug("Recover " + this.providerName);
/* 107 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 110 */       return xaResource.recover(flag);
/*     */     }
/*     */     catch (XAException e) {
/*     */     }
/* 114 */     throw check(e);
/*     */   }
/*     */ 
/*     */   public void commit(Xid xid, boolean onePhase)
/*     */     throws XAException
/*     */   {
/* 120 */     log.debug("Commit " + this.providerName + " xid " + " onePhase=" + onePhase);
/* 121 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 124 */       xaResource.commit(xid, onePhase);
/*     */     }
/*     */     catch (XAException e)
/*     */     {
/* 128 */       throw check(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void rollback(Xid xid) throws XAException
/*     */   {
/* 134 */     log.debug("Rollback " + this.providerName + " xid ");
/* 135 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 138 */       xaResource.rollback(xid);
/*     */     }
/*     */     catch (XAException e)
/*     */     {
/* 142 */       throw check(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void forget(Xid xid) throws XAException
/*     */   {
/* 148 */     log.debug("Forget " + this.providerName + " xid ");
/* 149 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 152 */       xaResource.forget(xid);
/*     */     }
/*     */     catch (XAException e)
/*     */     {
/* 156 */       throw check(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isSameRM(XAResource xaRes) throws XAException
/*     */   {
/* 162 */     if ((xaRes instanceof MessagingXAResourceWrapper)) {
/* 163 */       xaRes = ((MessagingXAResourceWrapper)xaRes).getDelegate();
/*     */     }
/* 165 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 168 */       return xaResource.isSameRM(xaRes);
/*     */     }
/*     */     catch (XAException e) {
/*     */     }
/* 172 */     throw check(e);
/*     */   }
/*     */ 
/*     */   public int prepare(Xid xid)
/*     */     throws XAException
/*     */   {
/* 178 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 181 */       return xaResource.prepare(xid);
/*     */     }
/*     */     catch (XAException e) {
/*     */     }
/* 185 */     throw check(e);
/*     */   }
/*     */ 
/*     */   public void start(Xid xid, int flags)
/*     */     throws XAException
/*     */   {
/* 191 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 194 */       xaResource.start(xid, flags);
/*     */     }
/*     */     catch (XAException e)
/*     */     {
/* 198 */       throw check(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void end(Xid xid, int flags) throws XAException
/*     */   {
/* 204 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 207 */       xaResource.end(xid, flags);
/*     */     }
/*     */     catch (XAException e)
/*     */     {
/* 211 */       throw check(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getTransactionTimeout() throws XAException
/*     */   {
/* 217 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 220 */       return xaResource.getTransactionTimeout();
/*     */     }
/*     */     catch (XAException e) {
/*     */     }
/* 224 */     throw check(e);
/*     */   }
/*     */ 
/*     */   public boolean setTransactionTimeout(int seconds)
/*     */     throws XAException
/*     */   {
/* 230 */     XAResource xaResource = getDelegate();
/*     */     try
/*     */     {
/* 233 */       return xaResource.setTransactionTimeout(seconds);
/*     */     }
/*     */     catch (XAException e) {
/*     */     }
/* 237 */     throw check(e);
/*     */   }
/*     */ 
/*     */   public void onException(JMSException exception)
/*     */   {
/* 243 */     log.warn("Notified of connection failure in recovery delegate for provider " + this.providerName, exception);
/* 244 */     close();
/*     */   }
/*     */ 
/*     */   public XAResource getDelegate()
/*     */     throws XAException
/*     */   {
/* 255 */     XAResource result = null;
/* 256 */     Exception error = null;
/*     */     try
/*     */     {
/* 259 */       result = connect();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 263 */       log.error("********************************Failed to connect to server", e);
/* 264 */       error = e;
/*     */     }
/*     */ 
/* 267 */     if (result == null)
/*     */     {
/* 269 */       XAException xae = new XAException("Error trying to connect to provider " + this.providerName);
/* 270 */       xae.errorCode = -3;
/* 271 */       if (error != null)
/* 272 */         xae.initCause(error);
/* 273 */       log.debug("Cannot get delegate XAResource", xae);
/* 274 */       throw xae;
/*     */     }
/*     */ 
/* 277 */     return result;
/*     */   }
/*     */ 
/*     */   protected XAResource connect()
/*     */     throws Exception
/*     */   {
/* 289 */     synchronized (lock)
/*     */     {
/* 291 */       if (this.delegate != null)
/* 292 */         return this.delegate;
/*     */     }
/*     */     XAConnection xaConnection;
/*     */     XAConnection xaConnection;
/* 298 */     if (this.username == null)
/*     */     {
/* 300 */       xaConnection = getConnectionFactory().createXAConnection();
/*     */     }
/*     */     else
/*     */     {
/* 304 */       xaConnection = getConnectionFactory().createXAConnection(this.username, this.password);
/*     */     }
/*     */ 
/* 307 */     synchronized (lock)
/*     */     {
/* 309 */       this.connection = xaConnection;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 315 */       XASession session = this.connection.createXASession();
/* 316 */       XAResource result = session.getXAResource();
/* 317 */       synchronized (lock)
/*     */       {
/* 319 */         this.delegate = result;
/*     */       }
/* 321 */       return this.delegate;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 325 */       close();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected XAConnectionFactory getConnectionFactory()
/*     */     throws Exception
/*     */   {
/* 339 */     if (this.providerName == null)
/* 340 */       throw new IllegalArgumentException("Null provider name");
/* 341 */     Context ctx = new InitialContext();
/*     */ 
/* 343 */     JMSProviderAdapter adapter = (JMSProviderAdapter)ctx.lookup(this.providerName);
/*     */ 
/* 346 */     String connectionFactoryRef = adapter.getFactoryRef();
/* 347 */     if (connectionFactoryRef == null) {
/* 348 */       throw new IllegalStateException("Provider '" + this.providerName + "' has no FactoryRef");
/*     */     }
/*     */ 
/* 351 */     ctx = adapter.getInitialContext();
/*     */     try
/*     */     {
/* 354 */       XAConnectionFactory localXAConnectionFactory = (XAConnectionFactory)Util.lookup(ctx, connectionFactoryRef, XAConnectionFactory.class);
/*     */       return localXAConnectionFactory;
/*     */     }
/*     */     finally
/*     */     {
/* 358 */       ctx.close();
/* 359 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public void close()
/*     */   {
/*     */     try
/*     */     {
/* 369 */       XAConnection oldConnection = null;
/* 370 */       synchronized (lock)
/*     */       {
/* 372 */         oldConnection = this.connection;
/* 373 */         this.connection = null;
/* 374 */         this.delegate = null;
/*     */       }
/* 376 */       if (oldConnection != null)
/* 377 */         oldConnection.close();
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/* 381 */       log.trace("Ignored error during close", ignored);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected XAException check(XAException e)
/*     */     throws XAException
/*     */   {
/* 395 */     if (e.errorCode == 4)
/*     */     {
/* 397 */       log.debug("Fatal error in provider " + this.providerName, e);
/* 398 */       close();
/*     */     }
/* 400 */     throw new XAException(-7);
/*     */   }
/*     */ 
/*     */   protected void finalize() throws Throwable
/*     */   {
/* 405 */     close();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.recovery.MessagingXAResourceWrapper
 * JD-Core Version:    0.6.0
 */