/*     */ package org.jboss.jms.server.remoting;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
/*     */ import EDU.oswego.cs.dl.util.concurrent.Sync;
/*     */ import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.jms.exception.MessagingShutdownException;
/*     */ import org.jboss.jms.wireformat.CallbackRequestSupport;
/*     */ import org.jboss.jms.wireformat.RequestSupport;
/*     */ import org.jboss.jms.wireformat.ResponseSupport;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.util.Util;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.ServerInvocationHandler;
/*     */ import org.jboss.remoting.ServerInvoker;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
/*     */ 
/*     */ public class JMSServerInvocationHandler
/*     */   implements ServerInvocationHandler
/*     */ {
/*  56 */   private static final Logger log = Logger.getLogger(JMSServerInvocationHandler.class);
/*     */ 
/*  60 */   private static boolean closed = true;
/*     */   private static ReadWriteLock invokeLock;
/*     */   private ServerInvoker invoker;
/*     */   private MBeanServer server;
/*     */   protected Map callbackHandlers;
/*     */   private boolean trace;
/*     */ 
/*     */   public static void setClosed(boolean b)
/*     */   {
/*     */     try
/*     */     {
/*  68 */       invokeLock.writeLock().acquire();
/*     */       try
/*     */       {
/*  72 */         closed = b;
/*     */       }
/*     */       finally
/*     */       {
/*  76 */         invokeLock.writeLock().release();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException e)
/*     */     {
/*  81 */       log.error("Failed to set closed to " + closed, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public JMSServerInvocationHandler()
/*     */   {
/*  99 */     this.callbackHandlers = new HashMap();
/* 100 */     this.trace = log.isTraceEnabled();
/*     */ 
/* 102 */     invokeLock = new WriterPreferenceReadWriteLock();
/*     */   }
/*     */ 
/*     */   public void setMBeanServer(MBeanServer server)
/*     */   {
/* 109 */     this.server = server;
/* 110 */     log.debug("set MBeanServer to " + this.server);
/*     */   }
/*     */ 
/*     */   public ServerInvoker getInvoker()
/*     */   {
/* 115 */     return this.invoker;
/*     */   }
/*     */ 
/*     */   public void setInvoker(ServerInvoker invoker)
/*     */   {
/* 120 */     this.invoker = invoker;
/* 121 */     log.debug("set ServerInvoker to " + this.invoker);
/*     */   }
/*     */ 
/*     */   public Object invoke(InvocationRequest invocation) throws Throwable
/*     */   {
/* 126 */     if (this.trace) log.trace("invoking " + invocation);
/*     */ 
/* 128 */     invokeLock.readLock().acquire();
/*     */     try
/*     */     {
/* 131 */       if (closed)
/*     */       {
/* 133 */         throw new MessagingShutdownException("Cannot handle invocation since messaging server is not active (it is either starting up or shutting down)");
/*     */       }
/*     */ 
/* 136 */       RequestSupport request = (RequestSupport)invocation.getParameter();
/*     */ 
/* 138 */       if ((request instanceof CallbackRequestSupport))
/*     */       {
/* 140 */         performCallbackRequest(request);
/*     */       }
/*     */ 
/* 143 */       ResponseSupport localResponseSupport = request.serverInvoke();
/*     */       return localResponseSupport;
/*     */     }
/*     */     finally
/*     */     {
/* 147 */       invokeLock.readLock().release();
/* 148 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   public void addListener(InvokerCallbackHandler callbackHandler)
/*     */   {
/* 154 */     log.debug("adding callback handler " + callbackHandler);
/*     */ 
/* 156 */     if ((callbackHandler instanceof ServerInvokerCallbackHandler))
/*     */     {
/* 158 */       ServerInvokerCallbackHandler h = (ServerInvokerCallbackHandler)callbackHandler;
/* 159 */       String sessionId = h.getClientSessionId();
/*     */ 
/* 161 */       synchronized (this.callbackHandlers)
/*     */       {
/* 163 */         if (this.callbackHandlers.containsKey(sessionId))
/*     */         {
/* 165 */           String msg = "The remoting client " + sessionId + " already has a callback handler";
/* 166 */           log.error(msg);
/* 167 */           throw new IllegalStateException(msg);
/*     */         }
/* 169 */         this.callbackHandlers.put(sessionId, h);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 174 */       throw new RuntimeException("Do not know how to use callback handler " + callbackHandler);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeListener(InvokerCallbackHandler callbackHandler)
/*     */   {
/* 180 */     log.debug("removing callback handler " + callbackHandler);
/*     */     Iterator i;
/* 182 */     synchronized (this.callbackHandlers)
/*     */     {
/* 184 */       for (i = this.callbackHandlers.keySet().iterator(); i.hasNext(); )
/*     */       {
/* 186 */         Object key = i.next();
/* 187 */         if (callbackHandler.equals(this.callbackHandlers.get(key)))
/*     */         {
/* 189 */           this.callbackHandlers.remove(key);
/* 190 */           return;
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Collection getListeners()
/*     */   {
/* 201 */     synchronized (this.callbackHandlers)
/*     */     {
/* 203 */       return this.callbackHandlers.values();
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 211 */     return "JMSServerInvocationHandler[" + this.invoker + ", " + this.server + "]";
/*     */   }
/*     */ 
/*     */   private void performCallbackRequest(RequestSupport request)
/*     */   {
/* 222 */     CallbackRequestSupport cReq = (CallbackRequestSupport)request;
/*     */ 
/* 225 */     String remotingSessionId = cReq.getRemotingSessionID();
/*     */ 
/* 227 */     ServerInvokerCallbackHandler callbackHandler = null;
/* 228 */     synchronized (this.callbackHandlers)
/*     */     {
/* 230 */       callbackHandler = (ServerInvokerCallbackHandler)this.callbackHandlers.get(remotingSessionId);
/*     */     }
/* 232 */     if (callbackHandler != null)
/*     */     {
/* 234 */       log.debug("found calllback handler for remoting session " + Util.guidToString(remotingSessionId) + " UID=" + remotingSessionId);
/*     */ 
/* 236 */       cReq.setCallbackHandler(callbackHandler);
/*     */     }
/*     */     else
/*     */     {
/* 240 */       throw new IllegalStateException("Cannot find callback handler for session id " + remotingSessionId);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.remoting.JMSServerInvocationHandler
 * JD-Core Version:    0.6.0
 */