/*     */ package org.jboss.jms.tx;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import javax.transaction.xa.Xid;
/*     */ import org.jboss.messaging.util.Streamable;
/*     */ 
/*     */ public class TransactionRequest
/*     */   implements Streamable
/*     */ {
/*     */   public static final byte ONE_PHASE_COMMIT_REQUEST = 0;
/*     */   public static final byte TWO_PHASE_PREPARE_REQUEST = 2;
/*     */   public static final byte TWO_PHASE_COMMIT_REQUEST = 3;
/*     */   public static final byte TWO_PHASE_ROLLBACK_REQUEST = 4;
/*     */   private static final byte PRESENT = 1;
/*     */   private static final byte NULL = 0;
/*     */   protected int requestType;
/*     */   protected Xid xid;
/*     */   protected ClientTransaction state;
/*     */ 
/*     */   public TransactionRequest()
/*     */   {
/*     */   }
/*     */ 
/*     */   public TransactionRequest(int requestType, Xid xid, ClientTransaction state)
/*     */   {
/*  80 */     this.requestType = requestType;
/*  81 */     this.xid = xid;
/*  82 */     this.state = state;
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out)
/*     */     throws Exception
/*     */   {
/*  89 */     out.writeInt(this.requestType);
/*     */ 
/*  91 */     if (this.xid == null)
/*     */     {
/*  93 */       out.writeByte(0);
/*     */     }
/*     */     else
/*     */     {
/*  98 */       byte[] branchQual = this.xid.getBranchQualifier();
/*  99 */       int formatId = this.xid.getFormatId();
/* 100 */       byte[] globalTxId = this.xid.getGlobalTransactionId();
/*     */ 
/* 102 */       out.write(1);
/* 103 */       out.writeInt(branchQual.length);
/* 104 */       out.write(branchQual);
/* 105 */       out.writeInt(formatId);
/* 106 */       out.writeInt(globalTxId.length);
/* 107 */       out.write(globalTxId);
/*     */     }
/*     */ 
/* 110 */     if (this.state != null)
/*     */     {
/* 112 */       out.write(1);
/* 113 */       this.state.write(out);
/*     */     }
/*     */     else
/*     */     {
/* 117 */       out.write(0);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in) throws Exception
/*     */   {
/* 123 */     this.requestType = in.readInt();
/*     */ 
/* 125 */     byte isXid = in.readByte();
/*     */ 
/* 127 */     if (isXid == 0)
/*     */     {
/* 129 */       this.xid = null;
/*     */     }
/* 131 */     else if (isXid == 1)
/*     */     {
/* 133 */       int l = in.readInt();
/* 134 */       byte[] branchQual = new byte[l];
/* 135 */       in.readFully(branchQual);
/* 136 */       int formatId = in.readInt();
/* 137 */       l = in.readInt();
/* 138 */       byte[] globalTxId = new byte[l];
/* 139 */       in.readFully(globalTxId);
/* 140 */       this.xid = new MessagingXid(branchQual, formatId, globalTxId);
/*     */     }
/*     */     else
/*     */     {
/* 144 */       throw new IllegalStateException("Invalid value:" + isXid);
/*     */     }
/*     */ 
/* 147 */     byte isState = in.readByte();
/*     */ 
/* 149 */     if (isState == 0)
/*     */     {
/* 151 */       this.state = null;
/*     */     }
/*     */     else
/*     */     {
/* 155 */       this.state = new ClientTransaction();
/*     */ 
/* 157 */       this.state.read(in);
/*     */     }
/*     */   }
/*     */ 
/*     */   public ClientTransaction getState()
/*     */   {
/* 165 */     return this.state;
/*     */   }
/*     */ 
/*     */   public Xid getXid()
/*     */   {
/* 170 */     return this.xid;
/*     */   }
/*     */ 
/*     */   public int getRequestType()
/*     */   {
/* 175 */     return this.requestType;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 180 */     return "TransactionRequest[" + (this.requestType == 4 ? "TWO_PHASE_ROLLBACK_" : this.requestType == 3 ? "TWO_PHASE_COMMIT" : this.requestType == 2 ? "TWO_PHASE_PREPARE" : this.requestType == 0 ? "ONE_PHASE_COMMIT" : "UNKNOW_REQUEST_TYPE") + ", " + this.xid + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.tx.TransactionRequest
 * JD-Core Version:    0.6.0
 */