/*     */ package org.jboss.jms.wireformat;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
/*     */ 
/*     */ public abstract class CallbackRequestSupport extends RequestSupport
/*     */ {
/*     */   private String remotingSessionId;
/*     */   private transient ServerInvokerCallbackHandler callbackHandler;
/*     */   private String clientVMId;
/*     */ 
/*     */   protected CallbackRequestSupport()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected CallbackRequestSupport(String clientVMId, String remotingSessionId, String objectId, int methodId, byte version)
/*     */   {
/*  63 */     super(objectId, methodId, version);
/*  64 */     this.remotingSessionId = remotingSessionId;
/*  65 */     this.clientVMId = clientVMId;
/*     */   }
/*     */ 
/*     */   public String getRemotingSessionID()
/*     */   {
/*  72 */     return this.remotingSessionId;
/*     */   }
/*     */ 
/*     */   public String getClientVMID()
/*     */   {
/*  78 */     return this.clientVMId;
/*     */   }
/*     */ 
/*     */   public void setRemotingSessionId(String remotingSessionId)
/*     */   {
/*  83 */     this.remotingSessionId = remotingSessionId;
/*     */   }
/*     */ 
/*     */   public ServerInvokerCallbackHandler getCallbackHandler()
/*     */   {
/*  88 */     return this.callbackHandler;
/*     */   }
/*     */ 
/*     */   public void setCallbackHandler(ServerInvokerCallbackHandler callbackHandler)
/*     */   {
/*  93 */     this.callbackHandler = callbackHandler;
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream os) throws Exception
/*     */   {
/*  98 */     super.write(os);
/*     */ 
/* 100 */     os.writeUTF(this.remotingSessionId);
/*     */ 
/* 102 */     os.writeUTF(this.clientVMId);
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream is) throws Exception
/*     */   {
/* 107 */     super.read(is);
/*     */ 
/* 109 */     this.remotingSessionId = is.readUTF();
/*     */ 
/* 111 */     this.clientVMId = is.readUTF();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.CallbackRequestSupport
 * JD-Core Version:    0.6.0
 */