/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.jms.delegate.ConsumerEndpoint;
/*    */ 
/*    */ public class ConsumerChangeRateRequest extends RequestSupport
/*    */ {
/*    */   private float newRate;
/*    */ 
/*    */   public ConsumerChangeRateRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   public ConsumerChangeRateRequest(String objectId, byte version, float newRate)
/*    */   {
/* 52 */     super(objectId, 401, version);
/*    */ 
/* 54 */     this.newRate = newRate;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is) throws Exception
/*    */   {
/* 59 */     super.read(is);
/*    */ 
/* 61 */     this.newRate = is.readFloat();
/*    */   }
/*    */ 
/*    */   public ResponseSupport serverInvoke() throws Exception
/*    */   {
/* 66 */     ConsumerEndpoint endpoint = (ConsumerEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*    */ 
/* 69 */     if (endpoint == null)
/*    */     {
/* 71 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*    */     }
/*    */ 
/* 74 */     endpoint.changeRate(this.newRate);
/*    */ 
/* 76 */     return null;
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream os) throws Exception
/*    */   {
/* 81 */     super.write(os);
/*    */ 
/* 83 */     os.writeFloat(this.newRate);
/*    */ 
/* 85 */     os.flush();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.ConsumerChangeRateRequest
 * JD-Core Version:    0.6.0
 */