/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.remoting.InvocationRequest;
/*    */ 
/*    */ public abstract class RequestSupport extends PacketSupport
/*    */ {
/*    */   protected String objectId;
/*    */   protected byte version;
/*    */ 
/*    */   public RequestSupport()
/*    */   {
/*    */   }
/*    */ 
/*    */   public RequestSupport(String objectId, int methodId, byte version)
/*    */   {
/* 49 */     super(methodId);
/*    */ 
/* 51 */     this.objectId = objectId;
/*    */ 
/* 53 */     this.version = version;
/*    */   }
/*    */ 
/*    */   public Object getPayload()
/*    */   {
/* 60 */     InvocationRequest req = new InvocationRequest(null, "JMS", this, null, null, null);
/*    */ 
/* 63 */     return req;
/*    */   }
/*    */ 
/*    */   public int getMethodId()
/*    */   {
/* 68 */     return this.methodId;
/*    */   }
/*    */ 
/*    */   public String getObjectId()
/*    */   {
/* 73 */     return this.objectId;
/*    */   }
/*    */ 
/*    */   public byte getVersion()
/*    */   {
/* 78 */     return this.version;
/*    */   }
/*    */ 
/*    */   public abstract ResponseSupport serverInvoke() throws Exception;
/*    */ 
/*    */   public void write(DataOutputStream os) throws Exception {
/* 85 */     super.write(os);
/*    */ 
/* 87 */     os.writeByte(this.version);
/*    */ 
/* 89 */     os.writeUTF(this.objectId);
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is) throws Exception
/*    */   {
/* 94 */     this.version = is.readByte();
/*    */ 
/* 96 */     this.objectId = is.readUTF();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.RequestSupport
 * JD-Core Version:    0.6.0
 */