/*     */ package org.jboss.jms.wireformat;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.jms.delegate.Cancel;
/*     */ import org.jboss.jms.delegate.DefaultCancel;
/*     */ import org.jboss.jms.delegate.SessionEndpoint;
/*     */ 
/*     */ public class SessionCancelDeliveriesRequest extends RequestSupport
/*     */ {
/*     */   private List cancels;
/*     */ 
/*     */   public SessionCancelDeliveriesRequest()
/*     */   {
/*     */   }
/*     */ 
/*     */   public SessionCancelDeliveriesRequest(String objectId, byte version, List cancels)
/*     */   {
/*  57 */     super(objectId, 307, version);
/*     */ 
/*  59 */     this.cancels = cancels;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream is) throws Exception
/*     */   {
/*  64 */     super.read(is);
/*     */ 
/*  66 */     int size = is.readInt();
/*     */ 
/*  68 */     this.cancels = new ArrayList(size);
/*     */ 
/*  70 */     for (int i = 0; i < size; i++)
/*     */     {
/*  72 */       long deliveryId = is.readLong();
/*     */ 
/*  74 */       int deliveryCount = is.readInt();
/*     */ 
/*  76 */       boolean expired = is.readBoolean();
/*     */ 
/*  78 */       boolean reachedMax = is.readBoolean();
/*     */ 
/*  80 */       DefaultCancel cancel = new DefaultCancel(deliveryId, deliveryCount, expired, reachedMax);
/*     */ 
/*  82 */       this.cancels.add(cancel);
/*     */     }
/*     */   }
/*     */ 
/*     */   public ResponseSupport serverInvoke() throws Exception
/*     */   {
/*  88 */     SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*     */ 
/*  91 */     if (endpoint == null)
/*     */     {
/*  93 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*     */     }
/*     */ 
/*  96 */     endpoint.cancelDeliveries(this.cancels);
/*     */ 
/*  98 */     return null;
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream os) throws Exception
/*     */   {
/* 103 */     super.write(os);
/*     */ 
/* 105 */     os.writeInt(this.cancels.size());
/*     */ 
/* 107 */     Iterator iter = this.cancels.iterator();
/*     */ 
/* 109 */     while (iter.hasNext())
/*     */     {
/* 111 */       Cancel cancel = (Cancel)iter.next();
/*     */ 
/* 113 */       os.writeLong(cancel.getDeliveryId());
/*     */ 
/* 115 */       os.writeInt(cancel.getDeliveryCount());
/*     */ 
/* 117 */       os.writeBoolean(cancel.isExpired());
/*     */ 
/* 119 */       os.writeBoolean(cancel.isReachedMaxDeliveryAttempts());
/*     */     }
/*     */ 
/* 122 */     os.flush();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.SessionCancelDeliveriesRequest
 * JD-Core Version:    0.6.0
 */