/*     */ package org.jboss.jms.wireformat;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import org.jboss.jms.client.delegate.ClientConsumerDelegate;
/*     */ import org.jboss.jms.delegate.SessionEndpoint;
/*     */ import org.jboss.jms.destination.JBossDestination;
/*     */ 
/*     */ public class SessionCreateConsumerDelegateRequest extends RequestSupport
/*     */ {
/*     */   private JBossDestination dest;
/*     */   private String selector;
/*     */   private boolean noLocal;
/*     */   private String subName;
/*     */   private boolean connectionConsumer;
/*     */   private boolean autoFlowControl;
/*     */ 
/*     */   public SessionCreateConsumerDelegateRequest()
/*     */   {
/*     */   }
/*     */ 
/*     */   public SessionCreateConsumerDelegateRequest(String objectId, byte version, JBossDestination destination, String selector, boolean noLocal, String subName, boolean connectionConsumer, boolean autoFlowControl)
/*     */   {
/*  63 */     super(objectId, 301, version);
/*     */ 
/*  65 */     this.dest = destination;
/*  66 */     this.selector = selector;
/*  67 */     this.noLocal = noLocal;
/*  68 */     this.subName = subName;
/*  69 */     this.connectionConsumer = connectionConsumer;
/*  70 */     this.autoFlowControl = autoFlowControl;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream is) throws Exception
/*     */   {
/*  75 */     super.read(is);
/*     */ 
/*  77 */     this.dest = JBossDestination.readDestination(is);
/*     */ 
/*  79 */     this.selector = readNullableString(is);
/*     */ 
/*  81 */     this.noLocal = is.readBoolean();
/*     */ 
/*  83 */     this.subName = readNullableString(is);
/*     */ 
/*  85 */     this.connectionConsumer = is.readBoolean();
/*     */ 
/*  87 */     this.autoFlowControl = is.readBoolean();
/*     */   }
/*     */ 
/*     */   public ResponseSupport serverInvoke() throws Exception
/*     */   {
/*  92 */     SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*     */ 
/*  95 */     if (endpoint == null)
/*     */     {
/*  97 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*     */     }
/*     */ 
/* 100 */     return new SessionCreateConsumerDelegateResponse((ClientConsumerDelegate)endpoint.createConsumerDelegate(this.dest, this.selector, this.noLocal, this.subName, this.connectionConsumer, this.autoFlowControl));
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream os) throws Exception
/*     */   {
/* 105 */     super.write(os);
/*     */ 
/* 107 */     JBossDestination.writeDestination(os, this.dest);
/*     */ 
/* 109 */     writeNullableString(this.selector, os);
/*     */ 
/* 111 */     os.writeBoolean(this.noLocal);
/*     */ 
/* 113 */     writeNullableString(this.subName, os);
/*     */ 
/* 115 */     os.writeBoolean(this.connectionConsumer);
/*     */ 
/* 117 */     os.writeBoolean(this.autoFlowControl);
/*     */ 
/* 119 */     os.flush();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.SessionCreateConsumerDelegateRequest
 * JD-Core Version:    0.6.0
 */