/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.jms.delegate.SessionEndpoint;
/*    */ 
/*    */ public class SessionCreateQueueRequest extends RequestSupport
/*    */ {
/*    */   private String queueName;
/*    */ 
/*    */   public SessionCreateQueueRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   public SessionCreateQueueRequest(String objectId, byte version, String queueName)
/*    */   {
/* 52 */     super(objectId, 303, version);
/*    */ 
/* 54 */     this.queueName = queueName;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is) throws Exception
/*    */   {
/* 59 */     super.read(is);
/*    */ 
/* 61 */     this.queueName = is.readUTF();
/*    */   }
/*    */ 
/*    */   public ResponseSupport serverInvoke() throws Exception
/*    */   {
/* 66 */     SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*    */ 
/* 69 */     if (endpoint == null)
/*    */     {
/* 71 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*    */     }
/*    */ 
/* 74 */     return new SessionCreateQueueResponse(endpoint.createQueue(this.queueName));
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream os) throws Exception
/*    */   {
/* 79 */     super.write(os);
/*    */ 
/* 81 */     os.writeUTF(this.queueName);
/*    */ 
/* 83 */     os.flush();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.SessionCreateQueueRequest
 * JD-Core Version:    0.6.0
 */