/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.jms.delegate.SessionEndpoint;
/*    */ 
/*    */ public class SessionUnsubscribeRequest extends RequestSupport
/*    */ {
/*    */   private String subName;
/*    */ 
/*    */   public SessionUnsubscribeRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   public SessionUnsubscribeRequest(String objectId, byte version, String subName)
/*    */   {
/* 52 */     super(objectId, 311, version);
/*    */ 
/* 54 */     this.subName = subName;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is) throws Exception
/*    */   {
/* 59 */     super.read(is);
/*    */ 
/* 61 */     this.subName = is.readUTF();
/*    */   }
/*    */ 
/*    */   public ResponseSupport serverInvoke() throws Exception
/*    */   {
/* 66 */     SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*    */ 
/* 69 */     if (endpoint == null)
/*    */     {
/* 71 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*    */     }
/*    */ 
/* 74 */     endpoint.unsubscribe(this.subName);
/*    */ 
/* 76 */     return null;
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream os) throws Exception
/*    */   {
/* 81 */     super.write(os);
/*    */ 
/* 83 */     os.writeUTF(this.subName);
/*    */ 
/* 85 */     os.flush();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.SessionUnsubscribeRequest
 * JD-Core Version:    0.6.0
 */