/*     */ package org.jboss.joinpoint.plugins;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import org.jboss.joinpoint.spi.ConstructorJoinpoint;
/*     */ import org.jboss.joinpoint.spi.FieldGetJoinpoint;
/*     */ import org.jboss.joinpoint.spi.FieldSetJoinpoint;
/*     */ import org.jboss.joinpoint.spi.JoinpointException;
/*     */ import org.jboss.joinpoint.spi.JoinpointFactory;
/*     */ import org.jboss.joinpoint.spi.MethodJoinpoint;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.ConstructorInfo;
/*     */ import org.jboss.reflect.spi.FieldInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class Config
/*     */ {
/*  48 */   protected static final Logger log = Logger.getLogger(Config.class);
/*     */ 
/*  51 */   private static final String[] NO_PARAMS_TYPES = new String[0];
/*     */ 
/*  54 */   private static final Object[] NO_PARAMS = new Object[0];
/*     */ 
/*     */   public static Object instantiate(JoinpointFactory jpf, String[] paramTypes, Object[] params)
/*     */     throws Throwable
/*     */   {
/*  67 */     ConstructorJoinpoint joinpoint = getConstructorJoinpoint(jpf, paramTypes, params);
/*  68 */     return joinpoint.dispatch();
/*     */   }
/*     */ 
/*     */   public static void configure(Object object, JoinpointFactory jpf, String name, Object value)
/*     */     throws Throwable
/*     */   {
/*  82 */     FieldSetJoinpoint joinpoint = getFieldSetJoinpoint(object, jpf, name, value);
/*  83 */     joinpoint.dispatch();
/*     */   }
/*     */ 
/*     */   public static void unconfigure(Object object, JoinpointFactory jpf, String name)
/*     */     throws Throwable
/*     */   {
/*  96 */     FieldSetJoinpoint joinpoint = getFieldSetJoinpoint(object, jpf, name, null);
/*  97 */     joinpoint.dispatch();
/*     */   }
/*     */ 
/*     */   public static Object invoke(Object object, JoinpointFactory jpf, String name, String[] paramTypes, Object[] params)
/*     */     throws Throwable
/*     */   {
/* 113 */     MethodJoinpoint joinpoint = getMethodJoinpoint(object, jpf, name, paramTypes, params);
/* 114 */     return joinpoint.dispatch();
/*     */   }
/*     */ 
/*     */   public static ConstructorJoinpoint getConstructorJoinpoint(JoinpointFactory jpf)
/*     */     throws Throwable
/*     */   {
/* 126 */     return getConstructorJoinpoint(jpf, null, null);
/*     */   }
/*     */ 
/*     */   public static ConstructorJoinpoint getConstructorJoinpoint(JoinpointFactory jpf, String[] paramTypes, Object[] params)
/*     */     throws Throwable
/*     */   {
/* 140 */     if (paramTypes == null) {
/* 141 */       paramTypes = NO_PARAMS_TYPES;
/*     */     }
/* 143 */     if (params == null) {
/* 144 */       params = NO_PARAMS;
/*     */     }
/* 146 */     boolean trace = log.isTraceEnabled();
/* 147 */     if (trace) {
/* 148 */       log.trace("Get constructor Joinpoint jpf=" + jpf + " paramTypes=" + Arrays.asList(paramTypes) + " params=" + Arrays.asList(params));
/*     */     }
/* 150 */     ConstructorInfo constructorInfo = findConstructorInfo(jpf.getClassInfo(), paramTypes);
/* 151 */     ConstructorJoinpoint joinpoint = jpf.getConstructorJoinpoint(constructorInfo);
/* 152 */     joinpoint.setArguments(params);
/* 153 */     return joinpoint;
/*     */   }
/*     */ 
/*     */   public static FieldGetJoinpoint getFieldGetJoinpoint(Object object, JoinpointFactory jpf, String name)
/*     */     throws Throwable
/*     */   {
/* 167 */     boolean trace = log.isTraceEnabled();
/* 168 */     if (trace) {
/* 169 */       log.trace("Get field get Joinpoint jpf=" + jpf + " target=" + object + " name=" + name);
/*     */     }
/* 171 */     FieldInfo fieldInfo = findFieldInfo(jpf.getClassInfo(), name);
/* 172 */     FieldGetJoinpoint joinpoint = jpf.getFieldGetJoinpoint(fieldInfo);
/* 173 */     joinpoint.setTarget(object);
/* 174 */     return joinpoint;
/*     */   }
/*     */ 
/*     */   public static FieldSetJoinpoint getFieldSetJoinpoint(Object object, JoinpointFactory jpf, String name, Object value)
/*     */     throws Throwable
/*     */   {
/* 189 */     boolean trace = log.isTraceEnabled();
/* 190 */     if (trace) {
/* 191 */       log.trace("Get field set Joinpoint jpf=" + jpf + " target=" + object + " name=" + name + " value=" + value);
/*     */     }
/* 193 */     FieldInfo fieldInfo = findFieldInfo(jpf.getClassInfo(), name);
/* 194 */     FieldSetJoinpoint joinpoint = jpf.getFieldSetJoinpoint(fieldInfo);
/* 195 */     joinpoint.setTarget(object);
/* 196 */     joinpoint.setValue(value);
/* 197 */     return joinpoint;
/*     */   }
/*     */ 
/*     */   public static MethodJoinpoint getMethodJoinpoint(Object object, JoinpointFactory jpf, String name, String[] paramTypes, Object[] params)
/*     */     throws Throwable
/*     */   {
/* 213 */     boolean trace = log.isTraceEnabled();
/* 214 */     if (trace)
/*     */     {
/* 216 */       if (paramTypes != null)
/* 217 */         log.trace("Get method Joinpoint jpf=" + jpf + " target=" + object + " name=" + name + " paramTypes=" + Arrays.asList(paramTypes));
/*     */       else {
/* 219 */         log.trace("Get method Joinpoint jpf=" + jpf + " target=" + object + " name=" + name + " paramTypes=()");
/*     */       }
/*     */     }
/* 222 */     MethodInfo methodInfo = findMethodInfo(jpf.getClassInfo(), name, paramTypes);
/* 223 */     MethodJoinpoint joinpoint = jpf.getMethodJoinpoint(methodInfo);
/* 224 */     joinpoint.setTarget(object);
/* 225 */     joinpoint.setArguments(params);
/* 226 */     return joinpoint;
/*     */   }
/*     */ 
/*     */   public static MethodJoinpoint getStaticMethodJoinpoint(JoinpointFactory jpf, String name, String[] paramTypes, Object[] params)
/*     */     throws Throwable
/*     */   {
/* 241 */     boolean trace = log.isTraceEnabled();
/* 242 */     if (trace)
/*     */     {
/* 244 */       if (paramTypes != null)
/* 245 */         log.trace("Get method Joinpoint jpf=" + jpf + " name=" + name + " paramTypes=" + Arrays.asList(paramTypes));
/*     */       else {
/* 247 */         log.trace("Get method Joinpoint jpf=" + jpf + " name=" + name + " paramTypes=()");
/*     */       }
/*     */     }
/* 250 */     MethodInfo methodInfo = findMethodInfo(jpf.getClassInfo(), name, paramTypes, true, true);
/* 251 */     MethodJoinpoint joinpoint = jpf.getMethodJoinpoint(methodInfo);
/* 252 */     joinpoint.setArguments(params);
/* 253 */     return joinpoint;
/*     */   }
/*     */ 
/*     */   public static ConstructorInfo findConstructorInfo(ClassInfo classInfo, String[] paramTypes)
/*     */     throws JoinpointException
/*     */   {
/* 266 */     ConstructorInfo[] constructors = classInfo.getDeclaredConstructors();
/* 267 */     if (constructors != null)
/*     */     {
/* 269 */       for (int i = 0; i < constructors.length; i++)
/*     */       {
/* 271 */         if (equals(paramTypes, constructors[i].getParameterTypes()))
/* 272 */           return constructors[i];
/*     */       }
/* 274 */       throw new JoinpointException("Constructor not found " + classInfo.getName() + Arrays.asList(paramTypes) + " in " + Arrays.asList(constructors));
/*     */     }
/* 276 */     throw new JoinpointException("Constructor not found " + classInfo.getName() + Arrays.asList(paramTypes) + " no constructors");
/*     */   }
/*     */ 
/*     */   public static FieldInfo findFieldInfo(ClassInfo classInfo, String name)
/*     */     throws JoinpointException
/*     */   {
/* 289 */     if (classInfo == null)
/* 290 */       throw new IllegalArgumentException("ClassInfo cannot be null!");
/* 291 */     ClassInfo current = classInfo;
/* 292 */     while (current != null)
/*     */     {
/* 294 */       FieldInfo result = locateFieldInfo(current, name);
/* 295 */       if (result != null)
/* 296 */         return result;
/* 297 */       current = current.getSuperclass();
/*     */     }
/* 299 */     throw new JoinpointException("Field not found '" + name + "' for class " + classInfo.getName());
/*     */   }
/*     */ 
/*     */   private static FieldInfo locateFieldInfo(ClassInfo classInfo, String name)
/*     */   {
/* 311 */     FieldInfo[] fields = classInfo.getDeclaredFields();
/* 312 */     if (fields != null)
/*     */     {
/* 314 */       for (int i = 0; i < fields.length; i++)
/*     */       {
/* 316 */         if (name.equals(fields[i].getName()))
/* 317 */           return fields[i];
/*     */       }
/*     */     }
/* 320 */     return null;
/*     */   }
/*     */ 
/*     */   public static MethodInfo findMethodInfo(ClassInfo classInfo, String name, String[] paramTypes)
/*     */     throws JoinpointException
/*     */   {
/* 334 */     return findMethodInfo(classInfo, name, paramTypes, false, true);
/*     */   }
/*     */ 
/*     */   public static MethodInfo findMethodInfo(ClassInfo classInfo, String name, String[] paramTypes, boolean strict)
/*     */     throws JoinpointException
/*     */   {
/* 349 */     return findMethodInfo(classInfo, name, paramTypes, false, true, strict);
/*     */   }
/*     */ 
/*     */   public static MethodInfo findMethodInfo(ClassInfo classInfo, String name, String[] paramTypes, boolean isStatic, boolean isPublic)
/*     */     throws JoinpointException
/*     */   {
/* 365 */     return findMethodInfo(classInfo, name, paramTypes, isStatic, isPublic, true);
/*     */   }
/*     */ 
/*     */   public static MethodInfo findMethodInfo(ClassInfo classInfo, String name, String[] paramTypes, boolean isStatic, boolean isPublic, boolean strict)
/*     */     throws JoinpointException
/*     */   {
/* 382 */     if (classInfo == null) {
/* 383 */       throw new IllegalArgumentException("ClassInfo cannot be null!");
/*     */     }
/* 385 */     if (paramTypes == null) {
/* 386 */       paramTypes = NO_PARAMS_TYPES;
/*     */     }
/* 388 */     ClassInfo current = classInfo;
/* 389 */     while (current != null)
/*     */     {
/* 391 */       MethodInfo result = locateMethodInfo(current, name, paramTypes, isStatic, isPublic, strict);
/* 392 */       if (result != null)
/* 393 */         return result;
/* 394 */       current = current.getSuperclass();
/*     */     }
/* 396 */     throw new JoinpointException("Method not found " + name + Arrays.asList(paramTypes) + " for class " + classInfo.getName());
/*     */   }
/*     */ 
/*     */   private static MethodInfo locateMethodInfo(ClassInfo classInfo, String name, String[] paramTypes, boolean isStatic, boolean isPublic, boolean strict)
/*     */   {
/* 412 */     MethodInfo[] methods = classInfo.getDeclaredMethods();
/* 413 */     if (methods != null)
/*     */     {
/* 415 */       for (int i = 0; i < methods.length; i++)
/*     */       {
/* 417 */         if ((name.equals(methods[i].getName())) && (equals(paramTypes, methods[i].getParameterTypes())) && ((!strict) || ((methods[i].isStatic() == isStatic) && (methods[i].isPublic() == isPublic))))
/*     */         {
/* 420 */           return methods[i];
/*     */         }
/*     */       }
/*     */     }
/* 423 */     return null;
/*     */   }
/*     */ 
/*     */   public static boolean equals(String[] typeNames, TypeInfo[] typeInfos)
/*     */   {
/* 435 */     if (!simpleCheck(typeNames, typeInfos)) {
/* 436 */       return false;
/*     */     }
/* 438 */     for (int i = 0; i < typeNames.length; i++)
/*     */     {
/* 440 */       if ((typeNames[i] != null) && (!typeNames[i].equals(typeInfos[i].getName())))
/* 441 */         return false;
/*     */     }
/* 443 */     return true;
/*     */   }
/*     */ 
/*     */   protected static boolean simpleCheck(String[] typeNames, TypeInfo[] typeInfos)
/*     */   {
/* 455 */     if ((typeNames == null) || (typeInfos == null))
/*     */     {
/* 457 */       return false;
/*     */     }
/* 459 */     return typeNames.length == typeInfos.length;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.joinpoint.plugins.Config
 * JD-Core Version:    0.6.0
 */