/*     */ package org.jboss.kernel.plugins.annotations;
/*     */ 
/*     */ import java.lang.annotation.ElementType;
/*     */ import java.lang.annotation.Retention;
/*     */ import java.lang.annotation.Target;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.signature.ConstructorSignature;
/*     */ import org.jboss.metadata.spi.signature.FieldSignature;
/*     */ import org.jboss.metadata.spi.signature.MethodSignature;
/*     */ import org.jboss.metadata.spi.signature.Signature;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.ConstructorInfo;
/*     */ import org.jboss.reflect.spi.FieldInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ 
/*     */ public abstract class AbstractBeanAnnotationAdapter
/*     */   implements BeanAnnotationAdapter
/*     */ {
/*  57 */   protected Logger log = Logger.getLogger(AbstractBeanAnnotationAdapter.class);
/*     */ 
/*  59 */   protected Set<AnnotationPlugin> classAnnotationPlugins = new HashSet();
/*  60 */   protected Set<AnnotationPlugin> constructorAnnotationPlugins = new HashSet();
/*  61 */   protected Set<AnnotationPlugin> propertyAnnotationPlugins = new HashSet();
/*  62 */   protected Set<AnnotationPlugin> methodAnnotationPlugins = new HashSet();
/*  63 */   protected Set<AnnotationPlugin> fieldAnnotationPlugins = new HashSet();
/*     */ 
/*     */   protected void addAnnotationPlugin(AnnotationPlugin plugin)
/*     */   {
/*  74 */     if (plugin == null) {
/*  75 */       throw new IllegalArgumentException("Null plugin.");
/*     */     }
/*  77 */     Class annotation = plugin.getAnnotation();
/*  78 */     if (annotation == null) {
/*  79 */       throw new IllegalArgumentException("Null annotation class: " + plugin);
/*     */     }
/*  81 */     if (annotation.getAnnotation(Target.class) == null)
/*  82 */       this.log.warn("Annotation " + annotation + " missing @Target annotation!");
/*  83 */     if (annotation.getAnnotation(Retention.class) == null) {
/*  84 */       this.log.warn("Annotation " + annotation + " missing @Retention annotation!");
/*     */     }
/*  86 */     Set supported = plugin.getSupportedTypes();
/*  87 */     if ((supported == null) || (supported.isEmpty())) {
/*  88 */       throw new IllegalArgumentException("Null or empty support types: " + plugin);
/*     */     }
/*  90 */     if (supported.contains(ElementType.TYPE))
/*     */     {
/*  92 */       this.classAnnotationPlugins.add(plugin);
/*     */     }
/*  94 */     if (supported.contains(ElementType.CONSTRUCTOR))
/*     */     {
/*  96 */       this.constructorAnnotationPlugins.add(plugin);
/*     */     }
/*  98 */     if (supported.contains(ElementType.METHOD))
/*     */     {
/* 100 */       if ((plugin instanceof PropertyAware))
/* 101 */         this.propertyAnnotationPlugins.add(plugin);
/*     */       else
/* 103 */         this.methodAnnotationPlugins.add(plugin);
/*     */     }
/* 105 */     if (supported.contains(ElementType.FIELD))
/*     */     {
/* 107 */       this.fieldAnnotationPlugins.add(plugin);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void applyAnnotations(MetaDataVisitor visitor) throws Throwable
/*     */   {
/* 113 */     handleAnnotations(visitor, true);
/*     */   }
/*     */ 
/*     */   public void cleanAnnotations(MetaDataVisitor visitor) throws Throwable
/*     */   {
/* 118 */     handleAnnotations(visitor, false);
/*     */   }
/*     */ 
/*     */   protected void handleAnnotations(MetaDataVisitor visitor, boolean isApplyPhase)
/*     */     throws Throwable
/*     */   {
/* 130 */     if (visitor == null) {
/* 131 */       throw new IllegalArgumentException("Null meta data visitor.");
/*     */     }
/* 133 */     KernelControllerContext context = visitor.getControllerContext();
/* 134 */     Kernel kernel = context.getKernel();
/* 135 */     KernelMetaDataRepository repository = kernel.getMetaDataRepository();
/* 136 */     MetaData retrieval = repository.getMetaData(context);
/*     */ 
/* 138 */     boolean trace = this.log.isTraceEnabled();
/* 139 */     BeanInfo info = context.getBeanInfo();
/* 140 */     Object name = context.getName();
/* 141 */     if (trace) {
/* 142 */       this.log.trace(name + " apply annotations");
/*     */     }
/*     */ 
/* 145 */     ClassInfo classInfo = info.getClassInfo();
/* 146 */     for (AnnotationPlugin plugin : this.classAnnotationPlugins)
/*     */     {
/* 148 */       if (isApplyPhase)
/* 149 */         plugin.applyAnnotation(classInfo, retrieval, visitor);
/*     */       else {
/* 151 */         plugin.cleanAnnotation(classInfo, retrieval, visitor);
/*     */       }
/*     */     }
/*     */ 
/* 155 */     Set constructors = info.getConstructors();
/* 156 */     if ((constructors != null) && (!constructors.isEmpty()))
/*     */     {
/* 158 */       for (ConstructorInfo ci : constructors)
/*     */       {
/* 160 */         Signature cis = new ConstructorSignature(Configurator.getParameterTypes(trace, ci.getParameterTypes()));
/* 161 */         MetaData cmdr = retrieval.getComponentMetaData(cis);
/* 162 */         if (cmdr != null)
/*     */         {
/* 164 */           for (AnnotationPlugin plugin : this.constructorAnnotationPlugins)
/*     */           {
/* 166 */             if (isApplyPhase)
/* 167 */               plugin.applyAnnotation(ci, cmdr, visitor);
/*     */             else
/* 169 */               plugin.cleanAnnotation(ci, cmdr, visitor);
/*     */           }
/*     */         }
/* 172 */         else if (trace)
/* 173 */           this.log.trace("No annotations for " + ci);
/*     */       }
/*     */     }
/* 176 */     else if (trace) {
/* 177 */       this.log.trace("No constructors");
/*     */     }
/*     */ 
/* 180 */     Set visitedMethods = new HashSet();
/* 181 */     Set properties = info.getProperties();
/* 182 */     if ((properties != null) && (!properties.isEmpty()))
/*     */     {
/* 184 */       for (PropertyInfo pi : properties)
/*     */       {
/* 186 */         MethodInfo setter = pi.getSetter();
/* 187 */         if (setter != null)
/*     */         {
/* 189 */           visitedMethods.add(setter);
/* 190 */           Signature sis = new MethodSignature(setter);
/* 191 */           MetaData cmdr = retrieval.getComponentMetaData(sis);
/* 192 */           if (cmdr != null)
/*     */           {
/* 194 */             for (AnnotationPlugin plugin : this.propertyAnnotationPlugins)
/*     */             {
/* 196 */               if (isApplyPhase)
/* 197 */                 plugin.applyAnnotation(pi, cmdr, visitor);
/*     */               else
/* 199 */                 plugin.cleanAnnotation(pi, cmdr, visitor);
/*     */             }
/*     */           }
/* 202 */           else if (trace)
/* 203 */             this.log.trace("No annotations for property " + pi.getName());
/*     */         }
/*     */       }
/*     */     }
/* 207 */     else if (trace) {
/* 208 */       this.log.trace("No properties");
/*     */     }
/*     */ 
/* 211 */     Set methods = info.getMethods();
/* 212 */     if ((methods != null) && (!methods.isEmpty()))
/*     */     {
/* 214 */       for (MethodInfo mi : methods)
/*     */       {
/* 216 */         if (!visitedMethods.contains(mi))
/*     */         {
/* 218 */           Signature mis = new MethodSignature(mi);
/* 219 */           MetaData cmdr = retrieval.getComponentMetaData(mis);
/* 220 */           if (cmdr != null)
/*     */           {
/* 222 */             for (AnnotationPlugin plugin : this.methodAnnotationPlugins)
/*     */             {
/* 224 */               if (isApplyPhase)
/* 225 */                 plugin.applyAnnotation(mi, cmdr, visitor);
/*     */               else
/* 227 */                 plugin.cleanAnnotation(mi, cmdr, visitor);
/*     */             }
/*     */           }
/* 230 */           else if (trace)
/* 231 */             this.log.trace("No annotations for " + mi);
/*     */         }
/*     */       }
/*     */     }
/* 235 */     else if (trace) {
/* 236 */       this.log.trace("No methods");
/*     */     }
/*     */ 
/* 239 */     MethodInfo[] staticMethods = classInfo.getDeclaredMethods();
/* 240 */     if ((staticMethods != null) && (staticMethods.length != 0))
/*     */     {
/* 242 */       for (MethodInfo smi : staticMethods)
/*     */       {
/* 244 */         if ((!smi.isStatic()) || (!smi.isPublic()))
/*     */           continue;
/* 246 */         Signature mis = new MethodSignature(smi);
/* 247 */         MetaData cmdr = retrieval.getComponentMetaData(mis);
/* 248 */         if (cmdr != null)
/*     */         {
/* 250 */           for (AnnotationPlugin plugin : this.methodAnnotationPlugins)
/*     */           {
/* 252 */             if (isApplyPhase)
/* 253 */               plugin.applyAnnotation(smi, cmdr, visitor);
/*     */             else
/* 255 */               plugin.cleanAnnotation(smi, cmdr, visitor);
/*     */           }
/*     */         }
/* 258 */         else if (trace) {
/* 259 */           this.log.trace("No annotations for " + smi);
/*     */         }
/*     */       }
/*     */     }
/* 263 */     else if (trace) {
/* 264 */       this.log.trace("No static methods");
/*     */     }
/*     */ 
/* 267 */     FieldInfo[] fields = classInfo.getDeclaredFields();
/* 268 */     if ((fields != null) && (fields.length > 0))
/*     */     {
/* 270 */       for (FieldInfo fi : fields)
/*     */       {
/* 272 */         Signature fis = new FieldSignature(fi.getName());
/* 273 */         MetaData cmdr = retrieval.getComponentMetaData(fis);
/* 274 */         if (cmdr != null)
/*     */         {
/* 276 */           for (AnnotationPlugin plugin : this.fieldAnnotationPlugins)
/*     */           {
/* 278 */             if (isApplyPhase)
/* 279 */               plugin.applyAnnotation(fi, cmdr, visitor);
/*     */             else
/* 281 */               plugin.cleanAnnotation(fi, cmdr, visitor);
/*     */           }
/*     */         }
/* 284 */         else if (trace)
/* 285 */           this.log.trace("No annotations for field " + fi.getName());
/*     */       }
/*     */     }
/* 288 */     else if (trace)
/* 289 */       this.log.trace("No fields");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.AbstractBeanAnnotationAdapter
 * JD-Core Version:    0.6.0
 */