/*    */ package org.jboss.kernel.plugins.annotations;
/*    */ 
/*    */ import java.util.List;
/*    */ import java.util.Set;
/*    */ import org.jboss.beans.metadata.api.annotations.Aliases;
/*    */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*    */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*    */ import org.jboss.dependency.spi.Controller;
/*    */ import org.jboss.dependency.spi.ControllerContext;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ import org.jboss.metadata.spi.MetaData;
/*    */ import org.jboss.reflect.spi.ClassInfo;
/*    */ import org.jboss.util.StringPropertyReplacer;
/*    */ 
/*    */ public class AliasesAnnotationPlugin extends ClassAnnotationPlugin<Aliases>
/*    */ {
/*    */   public AliasesAnnotationPlugin()
/*    */   {
/* 46 */     super(Aliases.class);
/*    */   }
/*    */ 
/*    */   protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(ClassInfo info, Aliases annotation, KernelControllerContext context) throws Throwable
/*    */   {
/* 51 */     BeanMetaData beanMetaData = context.getBeanMetaData();
/* 52 */     Set aliases = beanMetaData.getAliases();
/* 53 */     Controller controller = context.getController();
/* 54 */     for (String alias : annotation.value())
/*    */     {
/* 57 */       if (annotation.replace()) {
/* 58 */         alias = StringPropertyReplacer.replaceProperties(alias);
/*    */       }
/* 60 */       if ((aliases != null) && (aliases.contains(alias))) {
/*    */         continue;
/*    */       }
/* 63 */       if (controller.getContext(alias + "_Alias", null) == null)
/*    */       {
/* 65 */         controller.addAlias(alias, beanMetaData.getName());
/*    */       }
/*    */       else
/*    */       {
/* 69 */         ControllerContext existingContext = controller.getContext(alias, null);
/* 70 */         if ((existingContext != null) && (existingContext != context)) {
/* 71 */           throw new IllegalArgumentException("Alias " + alias + " already registered for different bean: " + existingContext);
/*    */         }
/*    */       }
/*    */     }
/*    */ 
/* 76 */     return null;
/*    */   }
/*    */ 
/*    */   protected void internalCleanAnnotation(ClassInfo info, MetaData retrieval, Aliases annotation, KernelControllerContext context) throws Throwable
/*    */   {
/* 81 */     BeanMetaData beanMetaData = context.getBeanMetaData();
/* 82 */     Set aliases = beanMetaData.getAliases();
/* 83 */     Controller controller = context.getController();
/* 84 */     for (String alias : annotation.value())
/*    */     {
/* 87 */       if (annotation.replace()) {
/* 88 */         alias = StringPropertyReplacer.replaceProperties(alias);
/*    */       }
/* 90 */       if ((aliases != null) && (aliases.contains(alias))) {
/*    */         continue;
/*    */       }
/* 93 */       if (controller.getContext(alias + "_Alias", null) == null)
/*    */         continue;
/* 95 */       controller.removeAlias(alias);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.AliasesAnnotationPlugin
 * JD-Core Version:    0.6.0
 */