/*    */ package org.jboss.kernel.plugins.annotations;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedAction;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.reflect.plugins.introspection.ReflectionUtils;
/*    */ 
/*    */ public class BeanAnnotationAdapterFactory
/*    */ {
/* 37 */   private static Logger log = Logger.getLogger(BeanAnnotationAdapterFactory.class);
/* 38 */   private static final BeanAnnotationAdapterFactory factory = new BeanAnnotationAdapterFactory();
/*    */ 
/* 40 */   private String adapterClassName = BasicBeanAnnotationAdapter.class.getName();
/*    */   private BeanAnnotationAdapter adapter;
/*    */ 
/*    */   public static BeanAnnotationAdapterFactory getInstance()
/*    */   {
/* 49 */     return factory;
/*    */   }
/*    */ 
/*    */   public void setAdapterClassName(String adapterClassName)
/*    */   {
/* 54 */     this.adapterClassName = adapterClassName;
/*    */   }
/*    */ 
/*    */   public BeanAnnotationAdapter getBeanAnnotationAdapter()
/*    */   {
/* 63 */     if (this.adapter == null) {
/* 64 */       this.adapter = ((BeanAnnotationAdapter)AccessController.doPrivileged(new AdapterLookup(null)));
/*    */     }
/* 66 */     return this.adapter;
/*    */   }
/*    */ 
/*    */   private class AdapterLookup implements PrivilegedAction<BeanAnnotationAdapter> {
/*    */     private AdapterLookup() {
/*    */     }
/*    */ 
/*    */     public BeanAnnotationAdapter run() {
/*    */       try {
/* 75 */         String adapterClass = System.getProperty("org.jboss.kernel.plugins.annotations.BeanAnnotationAdapter", BeanAnnotationAdapterFactory.this.adapterClassName);
/* 76 */         if (BeanAnnotationAdapterFactory.log.isTraceEnabled())
/* 77 */           BeanAnnotationAdapterFactory.log.trace("Instantiating bean annotation adapter: " + adapterClass);
/* 78 */         Object result = ReflectionUtils.newInstance(adapterClass);
/* 79 */         return (BeanAnnotationAdapter)BeanAnnotationAdapter.class.cast(result);
/*    */       }
/*    */       catch (Throwable t)
/*    */       {
/* 83 */         BeanAnnotationAdapterFactory.log.warn("Exception while creating bean annotation adapter instance: " + t);
/* 84 */       }return new BasicBeanAnnotationAdapter();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.BeanAnnotationAdapterFactory
 * JD-Core Version:    0.6.0
 */