/*    */ package org.jboss.kernel.plugins.annotations;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.HashSet;
/*    */ import java.util.List;
/*    */ import java.util.Set;
/*    */ import org.jboss.beans.metadata.api.annotations.Demand;
/*    */ import org.jboss.beans.metadata.api.annotations.Demands;
/*    */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*    */ import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
/*    */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*    */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ import org.jboss.reflect.spi.ClassInfo;
/*    */ 
/*    */ public class DemandsAnnotationPlugin extends ClassAnnotationPlugin<Demands>
/*    */ {
/*    */   public DemandsAnnotationPlugin()
/*    */   {
/* 49 */     super(Demands.class);
/*    */   }
/*    */ 
/*    */   protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(ClassInfo info, Demands annotation, KernelControllerContext context)
/*    */   {
/* 54 */     BeanMetaData beanMetaData = context.getBeanMetaData();
/* 55 */     Set demands = beanMetaData.getDemands();
/* 56 */     if (demands == null)
/*    */     {
/* 58 */       demands = new HashSet();
/* 59 */       ((AbstractBeanMetaData)beanMetaData).setDemands(demands);
/*    */     }
/* 61 */     List nodes = new ArrayList();
/* 62 */     for (Demand demand : annotation.value())
/*    */     {
/* 64 */       AbstractDemandMetaData admd = new AbstractDemandMetaData(demand.value());
/* 65 */       admd.setWhenRequired(new ControllerState(demand.whenRequired()));
/* 66 */       if (isAttributePresent(demand.transformer())) {
/* 67 */         admd.setTransformer(demand.transformer());
/*    */       }
/* 69 */       if (demands.add(admd))
/* 70 */         nodes.add(admd);
/*    */     }
/* 72 */     return nodes;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.DemandsAnnotationPlugin
 * JD-Core Version:    0.6.0
 */