/*    */ package org.jboss.kernel.plugins.annotations;
/*    */ 
/*    */ import java.lang.annotation.ElementType;
/*    */ import java.util.Collections;
/*    */ import java.util.List;
/*    */ import org.jboss.beans.metadata.api.annotations.FactoryMethod;
/*    */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*    */ import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
/*    */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*    */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*    */ import org.jboss.reflect.spi.MethodInfo;
/*    */ import org.jboss.reflect.spi.ParameterInfo;
/*    */ 
/*    */ public class FactoryMethodAnnotationPlugin extends AbstractParameterAnnotationPlugin<MethodInfo, FactoryMethod, AbstractConstructorMetaData>
/*    */ {
/*    */   public FactoryMethodAnnotationPlugin(Annotation2ValueMetaDataAdapter[] adapters)
/*    */   {
/* 45 */     super(FactoryMethod.class, adapters);
/*    */   }
/*    */ 
/*    */   protected boolean checkAnnotatedInfo(ElementType type)
/*    */   {
/* 50 */     return ElementType.METHOD == type;
/*    */   }
/*    */ 
/*    */   protected boolean isMetaDataAlreadyPresent(MethodInfo info, FactoryMethod annotation, BeanMetaData beanMetaData)
/*    */   {
/* 55 */     if ((!info.isPublic()) || (!info.isStatic()))
/* 56 */       throw new IllegalArgumentException("Method marked as @FactoryMethod must be public and static");
/* 57 */     return beanMetaData.getConstructor() != null;
/*    */   }
/*    */ 
/*    */   protected ParameterInfo[] getParameters(MethodInfo info)
/*    */   {
/* 62 */     return info.getParameters();
/*    */   }
/*    */ 
/*    */   protected List<? extends MetaDataVisitorNode> handleParameterlessInfo(MethodInfo info, FactoryMethod annotation, BeanMetaData beanMetaData)
/*    */   {
/* 67 */     AbstractConstructorMetaData constructorMetaData = createParametrizedMetaData(info, annotation, beanMetaData);
/* 68 */     setParameterizedMetaData(constructorMetaData, beanMetaData);
/* 69 */     return Collections.singletonList(constructorMetaData);
/*    */   }
/*    */ 
/*    */   protected AbstractConstructorMetaData createParametrizedMetaData(MethodInfo info, FactoryMethod annotation, BeanMetaData beanMetaData)
/*    */   {
/* 74 */     AbstractConstructorMetaData constructor = new AbstractConstructorMetaData();
/* 75 */     constructor.setFactoryClass(beanMetaData.getBean());
/* 76 */     constructor.setFactoryMethod(info.getName());
/* 77 */     return constructor;
/*    */   }
/*    */ 
/*    */   protected void setParameterizedMetaData(AbstractConstructorMetaData parameterizedMetaData, BeanMetaData beanMetaData)
/*    */   {
/* 82 */     AbstractBeanMetaData abmd = (AbstractBeanMetaData)beanMetaData;
/* 83 */     abmd.setConstructor(parameterizedMetaData);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.FactoryMethodAnnotationPlugin
 * JD-Core Version:    0.6.0
 */