/*    */ package org.jboss.kernel.plugins.annotations;
/*    */ 
/*    */ import org.jboss.beans.metadata.api.annotations.Inject;
/*    */ import org.jboss.beans.metadata.api.annotations.InjectOption;
/*    */ import org.jboss.beans.metadata.api.annotations.InjectType;
/*    */ import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
/*    */ import org.jboss.beans.metadata.plugins.InjectionOption;
/*    */ import org.jboss.beans.metadata.spi.AutowireType;
/*    */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ 
/*    */ public class InjectAnnotationPlugin extends PropertyAnnotationPlugin<Inject>
/*    */ {
/* 39 */   static InjectAnnotationPlugin INSTANCE = new InjectAnnotationPlugin();
/*    */ 
/*    */   public InjectAnnotationPlugin()
/*    */   {
/* 43 */     super(Inject.class);
/*    */   }
/*    */ 
/*    */   public ValueMetaData createValueMetaData(Inject annotation)
/*    */   {
/* 48 */     AbstractInjectionValueMetaData injection = new AbstractInjectionValueMetaData();
/* 49 */     if (isAttributePresent(annotation.bean()))
/* 50 */       injection.setValue(annotation.bean());
/* 51 */     if (isAttributePresent(annotation.property()))
/* 52 */       injection.setProperty(annotation.property());
/* 53 */     injection.setDependentState(new ControllerState(annotation.dependentState()));
/* 54 */     if (isAttributePresent(annotation.whenRequired()))
/* 55 */       injection.setWhenRequiredState(new ControllerState(annotation.whenRequired()));
/* 56 */     injection.setInjectionOption(InjectionOption.getInstance(annotation.option().toString()));
/* 57 */     injection.setInjectionType(AutowireType.getInstance(annotation.type().toString()));
/* 58 */     if (!org.jboss.beans.metadata.api.annotations.FromContext.NONE.equals(annotation.fromContext()))
/* 59 */       injection.setFromContext(org.jboss.beans.metadata.plugins.FromContext.getInstance(annotation.fromContext().toString()));
/* 60 */     return injection;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.InjectAnnotationPlugin
 * JD-Core Version:    0.6.0
 */