/*     */ package org.jboss.kernel.plugins.annotations;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.annotation.ElementType;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.info.spi.PropertyInfo;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.PropertyMetaData;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ 
/*     */ public abstract class PropertyAnnotationPlugin<C extends Annotation> extends AbstractAnnotationPlugin<PropertyInfo, C>
/*     */   implements PropertyAware, Annotation2ValueMetaDataAdapter<C>
/*     */ {
/*     */   protected PropertyAnnotationPlugin(Class<C> annotation)
/*     */   {
/*  51 */     super(annotation);
/*     */   }
/*     */ 
/*     */   protected boolean isElementTypeSupported(ElementType type)
/*     */   {
/*  56 */     return (ElementType.METHOD == type) || (ElementType.PARAMETER == type);
/*     */   }
/*     */ 
/*     */   protected boolean isMetaDataAlreadyPresent(PropertyInfo info, C annotation, BeanMetaData beanMetaData)
/*     */   {
/*  61 */     Set properties = beanMetaData.getProperties();
/*  62 */     if ((properties != null) && (!properties.isEmpty()))
/*     */     {
/*  64 */       for (PropertyMetaData pmd : properties)
/*     */       {
/*  66 */         if (pmd.getName().equals(info.getName()))
/*  67 */           return true;
/*     */       }
/*     */     }
/*  70 */     return false;
/*     */   }
/*     */ 
/*     */   protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(PropertyInfo info, C annotation, KernelControllerContext context)
/*     */   {
/*  75 */     Set properties = getProperties(context);
/*  76 */     PropertyMetaData property = getPropertyMetaData(info, annotation, context);
/*  77 */     properties.add(property);
/*  78 */     return Collections.singletonList(property);
/*     */   }
/*     */ 
/*     */   protected PropertyMetaData getPropertyMetaData(PropertyInfo info, C annotation, KernelControllerContext context)
/*     */   {
/*  91 */     return getPropertyMetaData(info, annotation, context.getBeanMetaData());
/*     */   }
/*     */ 
/*     */   protected PropertyMetaData getPropertyMetaData(PropertyInfo info, C annotation, BeanMetaData beanMetaData)
/*     */   {
/* 104 */     return getPropertyMetaData(info, annotation);
/*     */   }
/*     */ 
/*     */   protected PropertyMetaData getPropertyMetaData(PropertyInfo info, C annotation)
/*     */   {
/* 116 */     ValueMetaData value = createValueMetaData(annotation);
/* 117 */     return new AbstractPropertyMetaData(info.getName(), value);
/*     */   }
/*     */ 
/*     */   protected Set<PropertyMetaData> getProperties(KernelControllerContext context)
/*     */   {
/* 128 */     BeanMetaData beanMetaData = context.getBeanMetaData();
/* 129 */     Set properties = beanMetaData.getProperties();
/* 130 */     if (properties == null)
/*     */     {
/* 132 */       properties = new HashSet();
/* 133 */       AbstractBeanMetaData bean = (AbstractBeanMetaData)beanMetaData;
/* 134 */       bean.setProperties(properties);
/*     */     }
/* 136 */     return properties;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.PropertyAnnotationPlugin
 * JD-Core Version:    0.6.0
 */