/*    */ package org.jboss.kernel.plugins.dependency;
/*    */ 
/*    */ import org.jboss.dependency.plugins.AttributeCallbackItem;
/*    */ import org.jboss.dependency.spi.Cardinality;
/*    */ import org.jboss.dependency.spi.Controller;
/*    */ import org.jboss.dependency.spi.ControllerContext;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ import org.jboss.dependency.spi.DependencyItem;
/*    */ import org.jboss.dependency.spi.dispatch.AttributeDispatchContext;
/*    */ import org.jboss.kernel.spi.dependency.KernelController;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class ClassAttributeCallbackItem extends AttributeCallbackItem<Class>
/*    */ {
/*    */   protected Cardinality cardinality;
/*    */ 
/*    */   public ClassAttributeCallbackItem(Class name, AttributeDispatchContext owner, String attribute)
/*    */   {
/* 45 */     super(name, owner, attribute);
/*    */   }
/*    */ 
/*    */   public ClassAttributeCallbackItem(Class name, ControllerState whenRequired, ControllerState dependentState, Cardinality cardinality, AttributeDispatchContext owner, String attribute)
/*    */   {
/* 50 */     super(name, whenRequired, dependentState, owner, attribute);
/* 51 */     this.cardinality = cardinality;
/*    */   }
/*    */ 
/*    */   public void ownerCallback(Controller controller, boolean isInstallPhase) throws Throwable
/*    */   {
/* 56 */     if ((controller instanceof KernelController))
/*    */     {
/* 58 */       KernelController kc = (KernelController)controller;
/* 59 */       KernelControllerContext context = kc.getContextByClass((Class)getIDependOn());
/* 60 */       if (context != null)
/*    */       {
/* 62 */         Object target = context.getTarget();
/* 63 */         ((AttributeDispatchContext)this.owner).set(getAttributeName(), target);
/*    */       }
/*    */     }
/*    */     else {
/* 67 */       this.log.info("Controller not KernelController instance, cannot execute owner callback.");
/*    */     }
/*    */   }
/*    */ 
/*    */   protected DependencyItem createDependencyItem(ControllerContext owner) {
/* 72 */     if (this.cardinality != null) {
/* 73 */       return new CallbackDependencyItem(owner.getName(), (Class)getIDependOn(), this.whenRequired, this.dependentState, this.cardinality);
/*    */     }
/* 75 */     return null;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.ClassAttributeCallbackItem
 * JD-Core Version:    0.6.0
 */