/*    */ package org.jboss.kernel.plugins.dependency;
/*    */ 
/*    */ import org.jboss.beans.info.spi.BeanInfo;
/*    */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*    */ import org.jboss.dependency.spi.DependencyInfo;
/*    */ import org.jboss.joinpoint.spi.Joinpoint;
/*    */ import org.jboss.kernel.Kernel;
/*    */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*    */ import org.jboss.kernel.spi.dependency.InstantiateKernelControllerContextAware;
/*    */ import org.jboss.kernel.spi.dependency.KernelController;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class InstantiateAction extends KernelControllerContextAction
/*    */ {
/*    */   protected void installActionInternal(KernelControllerContext context)
/*    */     throws Throwable
/*    */   {
/* 45 */     KernelController controller = (KernelController)context.getController();
/* 46 */     Kernel kernel = controller.getKernel();
/* 47 */     KernelConfigurator configurator = kernel.getConfigurator();
/*    */ 
/* 49 */     BeanMetaData metaData = context.getBeanMetaData();
/* 50 */     BeanInfo info = context.getBeanInfo();
/* 51 */     Joinpoint joinPoint = configurator.getConstructorJoinPoint(info, metaData.getConstructor(), metaData);
/*    */ 
/* 53 */     Object object = dispatchJoinPoint(context, joinPoint);
/* 54 */     if (object == null)
/* 55 */       throw new IllegalStateException("Instantiate joinpoint returned a null object: " + joinPoint);
/* 56 */     context.setTarget(object);
/*    */     try
/*    */     {
/* 60 */       if (info == null)
/*    */       {
/* 62 */         info = configurator.getBeanInfo(object.getClass());
/* 63 */         context.setBeanInfo(info);
/*    */       }
/*    */ 
/* 66 */       DependencyInfo dependencyInfo = context.getDependencyInfo();
/* 67 */       if ((dependencyInfo != null) && (dependencyInfo.isAutowireCandidate()))
/* 68 */         controller.addInstantiatedContext(context);
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 72 */       uninstall(context);
/* 73 */       throw t;
/*    */     }
/*    */   }
/*    */ 
/*    */   protected Class<? extends KernelControllerContextAware> getActionAwareInterface()
/*    */   {
/* 79 */     return InstantiateKernelControllerContextAware.class;
/*    */   }
/*    */ 
/*    */   protected void uninstallActionInternal(KernelControllerContext context)
/*    */   {
/*    */     try
/*    */     {
/* 86 */       Object object = context.getTarget();
/* 87 */       if (object != null)
/*    */       {
/* 92 */         KernelController controller = (KernelController)context.getController();
/* 93 */         DependencyInfo dependencyInfo = context.getDependencyInfo();
/* 94 */         if ((dependencyInfo != null) && (dependencyInfo.isAutowireCandidate())) {
/* 95 */           controller.removeInstantiatedContext(context);
/*    */         }
/*    */       }
/*    */     }
/*    */     catch (Throwable ignored)
/*    */     {
/* 101 */       this.log.debug("Ignored error unsetting context ", ignored);
/*    */     }
/*    */     finally
/*    */     {
/* 105 */       context.setTarget(null);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.InstantiateAction
 * JD-Core Version:    0.6.0
 */