/*     */ package org.jboss.kernel.plugins.dependency;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.kernel.api.dependency.NumberMatcher;
/*     */ 
/*     */ public class IntervalMatcher extends NumberMatcher
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private Number floor;
/*     */   private Number ceiling;
/*     */   private boolean floorIsGreaterThan;
/*     */   private boolean ceilingIsLessThan;
/*     */ 
/*     */   public IntervalMatcher(Number floor, Number ceiling, boolean floorIsGreaterThan, boolean ceilingIsLessThan)
/*     */   {
/*  55 */     this.floor = floor;
/*  56 */     this.ceiling = ceiling;
/*  57 */     this.floorIsGreaterThan = floorIsGreaterThan;
/*  58 */     this.ceilingIsLessThan = ceilingIsLessThan;
/*     */   }
/*     */ 
/*     */   protected int compareTo(Number other, Number edge, int defaultValue)
/*     */   {
/*  72 */     if (edge == null) {
/*  73 */       return defaultValue;
/*     */     }
/*  75 */     double dOther = other.doubleValue();
/*  76 */     double dEdge = edge.doubleValue();
/*  77 */     return Double.compare(dOther, dEdge);
/*     */   }
/*     */ 
/*     */   protected boolean matchByType(Number other)
/*     */   {
/*  82 */     boolean isInRange = this.floor == null;
/*  83 */     if (!isInRange)
/*     */     {
/*  86 */       int floorCompare = compareTo(other, this.floor, 1);
/*  87 */       if (((this.floorIsGreaterThan) && (floorCompare > 0)) || ((!this.floorIsGreaterThan) && (floorCompare >= 0)))
/*     */       {
/*  89 */         isInRange = this.ceiling == null;
/*  90 */         if (!isInRange)
/*     */         {
/*  93 */           int ceilingCompare = compareTo(other, this.ceiling, -1);
/*  94 */           if (((this.ceilingIsLessThan) && (ceilingCompare < 0)) || ((!this.ceilingIsLessThan) && (ceilingCompare <= 0)))
/*     */           {
/*  96 */             isInRange = true;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 101 */     return isInRange;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dependency.IntervalMatcher
 * JD-Core Version:    0.6.0
 */