/*    */ package org.jboss.kernel.plugins.deployment.props.vertex;
/*    */ 
/*    */ import java.util.Set;
/*    */ import org.jboss.beans.metadata.plugins.StringValueMetaData;
/*    */ import org.jboss.beans.metadata.plugins.ValueMetaDataAware;
/*    */ import org.jboss.kernel.plugins.deployment.props.TreeVertex;
/*    */ import org.jboss.util.graph.Vertex;
/*    */ 
/*    */ public class ValueVertex extends TreeVertex<Vertex<String>>
/*    */ {
/*    */   public ValueVertex(String value)
/*    */   {
/* 40 */     super(value);
/*    */   }
/*    */ 
/*    */   public void visit(Vertex<String> parent, Set<Vertex<String>> children)
/*    */   {
/* 45 */     if ((parent instanceof ValueMetaDataAware))
/*    */     {
/* 47 */       StringValueMetaData value = new StringValueMetaData(getName());
/* 48 */       Set parentsChildren = getChildren(parent);
/* 49 */       for (Vertex vertex : parentsChildren)
/*    */       {
/* 51 */         if (vertex == this) {
/*    */           continue;
/*    */         }
/* 54 */         String name = vertex.getName();
/* 55 */         if (name.endsWith("type"))
/*    */         {
/* 57 */           Vertex next = getNext(vertex);
/* 58 */           value.setType(next.getName());
/*    */         }
/* 60 */         else if (name.endsWith("trim"))
/*    */         {
/* 62 */           Vertex next = getNext(vertex);
/* 63 */           value.setTrim(Boolean.parseBoolean(next.getName()));
/*    */         }
/* 65 */         else if (name.endsWith("replace"))
/*    */         {
/* 67 */           Vertex next = getNext(vertex);
/* 68 */           value.setReplace(Boolean.parseBoolean(next.getName()));
/*    */         }
/*    */       }
/* 71 */       ValueMetaDataAware valueMetaDataAware = (ValueMetaDataAware)parent;
/* 72 */       valueMetaDataAware.setValue(value);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.deployment.props.vertex.ValueVertex
 * JD-Core Version:    0.6.0
 */