/*    */ package org.jboss.kernel.plugins.deployment.xml;
/*    */ 
/*    */ import javax.xml.namespace.NamespaceContext;
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.beans.metadata.plugins.factory.GenericBeanFactoryMetaData;
/*    */ import org.jboss.beans.metadata.spi.ConstructorMetaData;
/*    */ import org.jboss.beans.metadata.spi.PropertyMetaData;
/*    */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*    */ import org.jboss.dependency.spi.ControllerMode;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*    */ import org.xml.sax.Attributes;
/*    */ 
/*    */ public class BeanFactoryHandler extends DefaultElementHandler
/*    */ {
/* 45 */   public static final BeanFactoryHandler HANDLER = new BeanFactoryHandler();
/*    */ 
/*    */   public Object startElement(Object parent, QName name, ElementBinding element)
/*    */   {
/* 49 */     return new GenericBeanFactoryMetaData();
/*    */   }
/*    */ 
/*    */   public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*    */   {
/* 54 */     GenericBeanFactoryMetaData bean = (GenericBeanFactoryMetaData)o;
/* 55 */     for (int i = 0; i < attrs.getLength(); i++)
/*    */     {
/* 57 */       String localName = attrs.getLocalName(i);
/* 58 */       if ("name".equals(localName))
/* 59 */         bean.setName(attrs.getValue(i));
/* 60 */       else if ("class".equals(localName))
/* 61 */         bean.setBeanClass(attrs.getValue(i));
/* 62 */       else if ("mode".equals(localName))
/* 63 */         bean.setMode(new ControllerMode(attrs.getValue(i)));
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object endElement(Object o, QName qName, ElementBinding element)
/*    */   {
/* 69 */     GenericBeanFactoryMetaData bean = (GenericBeanFactoryMetaData)o;
/* 70 */     if (bean.getBeanClass() == null)
/*    */     {
/* 72 */       PropertyMetaData property = bean.getProperty("constructor");
/* 73 */       if (property == null)
/* 74 */         throw new IllegalArgumentException("BeanFactory should have a class attribute or a constructor element.");
/* 75 */       ValueMetaData value = property.getValue();
/* 76 */       if (value == null)
/* 77 */         throw new IllegalArgumentException("BeanFactory should have a class attribute or a constructor element.");
/* 78 */       ConstructorMetaData constructor = (ConstructorMetaData)value.getUnderlyingValue();
/* 79 */       if (constructor == null)
/* 80 */         throw new IllegalArgumentException("BeanFactory should have a class attribute or a constructor element.");
/* 81 */       if (constructor.getFactoryMethod() == null)
/* 82 */         throw new IllegalArgumentException("BeanFactory should have a class attribute or the constructor element should have a factoryMethod attribute.");
/* 83 */       if ((constructor.getFactory() == null) && (constructor.getFactoryClass() == null))
/* 84 */         throw new IllegalArgumentException("BeanFactory should have a class attribute or the constructor element should have a either a factoryClass attribute or a factory element.");
/*    */     }
/* 86 */     return bean;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.deployment.xml.BeanFactoryHandler
 * JD-Core Version:    0.6.0
 */