/*      */ package org.jboss.kernel.plugins.deployment.xml;
/*      */ 
/*      */ import java.util.ArrayList;
/*      */ import java.util.HashSet;
/*      */ import java.util.List;
/*      */ import java.util.Set;
/*      */ import javax.xml.namespace.NamespaceContext;
/*      */ import javax.xml.namespace.QName;
/*      */ import org.jboss.beans.metadata.plugins.AbstractArrayMetaData;
/*      */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*      */ import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
/*      */ import org.jboss.beans.metadata.plugins.AbstractCollectionMetaData;
/*      */ import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
/*      */ import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
/*      */ import org.jboss.beans.metadata.plugins.AbstractDependencyMetaData;
/*      */ import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
/*      */ import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
/*      */ import org.jboss.beans.metadata.plugins.AbstractLifecycleMetaData;
/*      */ import org.jboss.beans.metadata.plugins.AbstractListMetaData;
/*      */ import org.jboss.beans.metadata.plugins.AbstractMapMetaData;
/*      */ import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
/*      */ import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
/*      */ import org.jboss.beans.metadata.plugins.AbstractSetMetaData;
/*      */ import org.jboss.beans.metadata.plugins.AbstractSupplyMetaData;
/*      */ import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
/*      */ import org.jboss.beans.metadata.plugins.FromContext;
/*      */ import org.jboss.beans.metadata.plugins.InjectionOption;
/*      */ import org.jboss.beans.metadata.plugins.StringValueMetaData;
/*      */ import org.jboss.beans.metadata.plugins.factory.GenericBeanFactoryMetaData;
/*      */ import org.jboss.beans.metadata.spi.AutowireType;
/*      */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*      */ import org.jboss.dependency.spi.ControllerMode;
/*      */ import org.jboss.dependency.spi.ControllerState;
/*      */ import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementInterceptor;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*      */ import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
/*      */ import org.xml.sax.Attributes;
/*      */ 
/*      */ public class BeanSchemaBinding
/*      */ {
/*   83 */   private static final Logger log = Logger.getLogger(BeanSchemaBinding.class);
/*      */   private static final String BEAN_DEPLOYER_NS = "urn:jboss:bean-deployer";
/*   89 */   private static final QName deploymentTypeQName = new QName("urn:jboss:bean-deployer", "deploymentType");
/*      */ 
/*   92 */   private static final QName beanTypeQName = new QName("urn:jboss:bean-deployer", "beanType");
/*      */ 
/*   95 */   private static final QName beanQName = new QName("urn:jboss:bean-deployer", "bean");
/*      */ 
/*   98 */   private static final QName beanFactoryTypeQName = new QName("urn:jboss:bean-deployer", "beanfactoryType");
/*      */ 
/*  101 */   private static final QName beanFactoryQName = new QName("urn:jboss:bean-deployer", "beanfactory");
/*      */ 
/*  104 */   private static final QName classloaderTypeQName = new QName("urn:jboss:bean-deployer", "classloaderType");
/*      */ 
/*  107 */   private static final QName classloaderQName = new QName("urn:jboss:bean-deployer", "classloader");
/*      */ 
/*  110 */   private static final QName constructorTypeQName = new QName("urn:jboss:bean-deployer", "constructorType");
/*      */ 
/*  113 */   private static final QName constructorQName = new QName("urn:jboss:bean-deployer", "constructor");
/*      */ 
/*  116 */   private static final QName factoryQName = new QName("urn:jboss:bean-deployer", "factory");
/*      */ 
/*  119 */   private static final QName parameterTypeQName = new QName("urn:jboss:bean-deployer", "parameterType");
/*      */ 
/*  122 */   private static final QName parameterQName = new QName("urn:jboss:bean-deployer", "parameter");
/*      */ 
/*  125 */   private static final QName lifecycleTypeQName = new QName("urn:jboss:bean-deployer", "lifecycleType");
/*      */ 
/*  128 */   private static final QName createQName = new QName("urn:jboss:bean-deployer", "create");
/*      */ 
/*  131 */   private static final QName startQName = new QName("urn:jboss:bean-deployer", "start");
/*      */ 
/*  134 */   private static final QName stopQName = new QName("urn:jboss:bean-deployer", "stop");
/*      */ 
/*  137 */   private static final QName destroyQName = new QName("urn:jboss:bean-deployer", "destroy");
/*      */ 
/*  140 */   private static final QName propertyTypeQName = new QName("urn:jboss:bean-deployer", "propertyType");
/*      */ 
/*  143 */   private static final QName propertyQName = new QName("urn:jboss:bean-deployer", "property");
/*      */ 
/*  146 */   private static final QName dependsTypeQName = new QName("urn:jboss:bean-deployer", "dependsType");
/*      */ 
/*  149 */   private static final QName dependsQName = new QName("urn:jboss:bean-deployer", "depends");
/*      */ 
/*  152 */   private static final QName demandTypeQName = new QName("urn:jboss:bean-deployer", "demandType");
/*      */ 
/*  155 */   private static final QName demandQName = new QName("urn:jboss:bean-deployer", "demand");
/*      */ 
/*  158 */   private static final QName supplyTypeQName = new QName("urn:jboss:bean-deployer", "supplyType");
/*      */ 
/*  161 */   private static final QName supplyQName = new QName("urn:jboss:bean-deployer", "supply");
/*      */ 
/*  164 */   private static final QName dependencyTypeQName = new QName("urn:jboss:bean-deployer", "dependencyType");
/*      */ 
/*  167 */   private static final QName injectionTypeQName = new QName("urn:jboss:bean-deployer", "injectionType");
/*      */ 
/*  170 */   private static final QName injectQName = new QName("urn:jboss:bean-deployer", "inject");
/*      */ 
/*  173 */   private static final QName plainValueTypeQName = new QName("urn:jboss:bean-deployer", "plainValueType");
/*      */ 
/*  176 */   private static final QName valueTypeQName = new QName("urn:jboss:bean-deployer", "valueType");
/*      */ 
/*  179 */   private static final QName valueQName = new QName("urn:jboss:bean-deployer", "value");
/*      */ 
/*  182 */   private static final QName nullQName = new QName("urn:jboss:bean-deployer", "null");
/*      */ 
/*  185 */   private static final QName collectionTypeQName = new QName("urn:jboss:bean-deployer", "collectionType");
/*      */ 
/*  188 */   private static final QName collectionQName = new QName("urn:jboss:bean-deployer", "collection");
/*      */ 
/*  191 */   private static final QName listTypeQName = new QName("urn:jboss:bean-deployer", "listType");
/*      */ 
/*  194 */   private static final QName listQName = new QName("urn:jboss:bean-deployer", "list");
/*      */ 
/*  197 */   private static final QName setTypeQName = new QName("urn:jboss:bean-deployer", "setType");
/*      */ 
/*  200 */   private static final QName setQName = new QName("urn:jboss:bean-deployer", "set");
/*      */ 
/*  203 */   private static final QName arrayTypeQName = new QName("urn:jboss:bean-deployer", "arrayType");
/*      */ 
/*  206 */   private static final QName arrayQName = new QName("urn:jboss:bean-deployer", "array");
/*      */ 
/*  209 */   private static final QName mapTypeQName = new QName("urn:jboss:bean-deployer", "mapType");
/*      */ 
/*  212 */   private static final QName mapQName = new QName("urn:jboss:bean-deployer", "map");
/*      */ 
/*  215 */   private static final QName entryTypeQName = new QName("urn:jboss:bean-deployer", "entryType");
/*      */ 
/*  218 */   private static final QName entryQName = new QName("urn:jboss:bean-deployer", "entry");
/*      */ 
/*  221 */   private static final QName keyQName = new QName("urn:jboss:bean-deployer", "key");
/*      */   private static SchemaBinding schemaBinding;
/*  227 */   public static ValueMetaDataElementInterceptor VALUES = new ValueMetaDataElementInterceptor(null);
/*      */ 
/*  230 */   public static NullValueElementInterceptor NULLVALUES = new NullValueElementInterceptor(null);
/*      */ 
/*      */   protected static synchronized void init(SchemaBinding schemaBinding)
/*      */   {
/*  240 */     log.warn("You should use the 2.0 version of the Microcontainer xml. xmlns='urn:jboss:bean-deployer:2.0'");
/*      */ 
/*  242 */     schemaBinding = schemaBinding;
/*      */ 
/*  245 */     schemaBinding.setReplacePropertyRefs(false);
/*      */ 
/*  248 */     TypeBinding deploymentType = schemaBinding.getType(deploymentTypeQName);
/*  249 */     deploymentType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/*  253 */         return new AbstractKernelDeployment();
/*      */       }
/*      */     });
/*  258 */     deploymentType.pushInterceptor(classloaderQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  262 */         AbstractKernelDeployment deployment = (AbstractKernelDeployment)parent;
/*  263 */         AbstractClassLoaderMetaData classloader = (AbstractClassLoaderMetaData)child;
/*  264 */         deployment.setClassLoader(classloader);
/*      */ 
/*  266 */         List beans = deployment.getBeanFactories();
/*  267 */         if (beans == null)
/*      */         {
/*  269 */           beans = new ArrayList();
/*  270 */           deployment.setBeanFactories(beans);
/*      */         }
/*  272 */         beans.add(classloader);
/*      */       }
/*      */     });
/*  277 */     deploymentType.pushInterceptor(beanQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  281 */         AbstractKernelDeployment deployment = (AbstractKernelDeployment)parent;
/*  282 */         AbstractBeanMetaData bean = (AbstractBeanMetaData)child;
/*  283 */         List beans = deployment.getBeanFactories();
/*  284 */         if (beans == null)
/*      */         {
/*  286 */           beans = new ArrayList();
/*  287 */           deployment.setBeanFactories(beans);
/*      */         }
/*  289 */         beans.add(bean);
/*      */       }
/*      */     });
/*  294 */     deploymentType.pushInterceptor(beanFactoryQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  298 */         AbstractKernelDeployment deployment = (AbstractKernelDeployment)parent;
/*  299 */         AbstractBeanMetaData bean = (AbstractBeanMetaData)child;
/*  300 */         List beans = deployment.getBeanFactories();
/*  301 */         if (beans == null)
/*      */         {
/*  303 */           beans = new ArrayList();
/*  304 */           deployment.setBeanFactories(beans);
/*      */         }
/*  306 */         beans.add(bean);
/*      */       }
/*      */     });
/*  311 */     TypeBinding beanType = schemaBinding.getType(beanTypeQName);
/*      */ 
/*  336 */     beanType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/*  341 */         return new AbstractBeanMetaData();
/*      */       }
/*      */ 
/*      */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */       {
/*  346 */         AbstractBeanMetaData bean = (AbstractBeanMetaData)o;
/*  347 */         for (int i = 0; i < attrs.getLength(); i++)
/*      */         {
/*  349 */           String localName = attrs.getLocalName(i);
/*  350 */           if ("name".equals(localName))
/*  351 */             bean.setName(attrs.getValue(i));
/*  352 */           else if ("class".equals(localName))
/*  353 */             bean.setBean(attrs.getValue(i));
/*  354 */           else if ("mode".equals(localName))
/*  355 */             bean.setMode(new ControllerMode(attrs.getValue(i)));
/*      */         }
/*      */       }
/*      */     });
/*  361 */     TypeBinding beanFactoryType = schemaBinding.getType(beanFactoryTypeQName);
/*  362 */     beanFactoryType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/*  366 */         return new GenericBeanFactoryMetaData();
/*      */       }
/*      */ 
/*      */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */       {
/*  371 */         GenericBeanFactoryMetaData bean = (GenericBeanFactoryMetaData)o;
/*  372 */         for (int i = 0; i < attrs.getLength(); i++)
/*      */         {
/*  374 */           String localName = attrs.getLocalName(i);
/*  375 */           if ("name".equals(localName))
/*  376 */             bean.setName(attrs.getValue(i));
/*  377 */           else if ("class".equals(localName))
/*  378 */             bean.setBeanClass(attrs.getValue(i));
/*  379 */           else if ("mode".equals(localName))
/*  380 */             bean.setMode(new ControllerMode(attrs.getValue(i)));
/*      */         }
/*      */       }
/*      */     });
/*  386 */     beanType.pushInterceptor(classloaderQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  390 */         AbstractBeanMetaData bean = (AbstractBeanMetaData)parent;
/*  391 */         AbstractClassLoaderMetaData classloader = (AbstractClassLoaderMetaData)child;
/*  392 */         bean.setClassLoader(classloader);
/*      */       }
/*      */     });
/*  397 */     beanFactoryType.pushInterceptor(classloaderQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  401 */         GenericBeanFactoryMetaData bean = (GenericBeanFactoryMetaData)parent;
/*  402 */         AbstractClassLoaderMetaData classloader = (AbstractClassLoaderMetaData)child;
/*  403 */         bean.setClassLoader(classloader);
/*      */       }
/*      */     });
/*  408 */     beanType.pushInterceptor(constructorQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  412 */         AbstractBeanMetaData bean = (AbstractBeanMetaData)parent;
/*  413 */         AbstractConstructorMetaData constructor = (AbstractConstructorMetaData)child;
/*  414 */         bean.setConstructor(constructor);
/*      */       }
/*      */     });
/*  419 */     beanFactoryType.pushInterceptor(constructorQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  423 */         GenericBeanFactoryMetaData bean = (GenericBeanFactoryMetaData)parent;
/*  424 */         AbstractConstructorMetaData constructor = (AbstractConstructorMetaData)child;
/*  425 */         bean.setBeanConstructor(constructor);
/*      */       }
/*      */     });
/*  430 */     TypeBinding classloaderType = schemaBinding.getType(classloaderTypeQName);
/*  431 */     configureValueBindings(classloaderType);
/*  432 */     classloaderType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/*  436 */         return new AbstractClassLoaderMetaData();
/*      */       }
/*      */ 
/*      */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */       {
/*      */       }
/*      */     });
/*  445 */     TypeBinding constructorType = schemaBinding.getType(constructorTypeQName);
/*  446 */     constructorType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/*  450 */         return new AbstractConstructorMetaData();
/*      */       }
/*      */ 
/*      */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */       {
/*  455 */         AbstractConstructorMetaData constructor = (AbstractConstructorMetaData)o;
/*  456 */         for (int i = 0; i < attrs.getLength(); i++)
/*      */         {
/*  458 */           String localName = attrs.getLocalName(i);
/*  459 */           if ("factoryClass".equals(localName))
/*  460 */             constructor.setFactoryClass(attrs.getValue(i));
/*  461 */           else if ("factoryMethod".equals(localName))
/*  462 */             constructor.setFactoryMethod(attrs.getValue(i));
/*      */         }
/*      */       }
/*      */     });
/*  468 */     constructorType.pushInterceptor(factoryQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  472 */         AbstractConstructorMetaData constructor = (AbstractConstructorMetaData)parent;
/*  473 */         AbstractDependencyValueMetaData factory = (AbstractDependencyValueMetaData)child;
/*  474 */         constructor.setFactory(factory);
/*      */       }
/*      */     });
/*  479 */     constructorType.pushInterceptor(parameterQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  483 */         AbstractConstructorMetaData constructor = (AbstractConstructorMetaData)parent;
/*  484 */         AbstractParameterMetaData parameter = (AbstractParameterMetaData)child;
/*  485 */         List parameters = constructor.getParameters();
/*  486 */         if (parameters == null)
/*      */         {
/*  488 */           parameters = new ArrayList();
/*  489 */           constructor.setParameters(parameters);
/*      */         }
/*  491 */         parameter.setIndex(parameters.size());
/*  492 */         parameters.add(parameter);
/*      */       }
/*      */     });
/*  497 */     TypeBinding parameterType = schemaBinding.getType(parameterTypeQName);
/*  498 */     configureValueBindings(parameterType);
/*  499 */     parameterType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/*  503 */         return new AbstractParameterMetaData();
/*      */       }
/*      */ 
/*      */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */       {
/*  508 */         AbstractParameterMetaData parameter = (AbstractParameterMetaData)o;
/*  509 */         for (int i = 0; i < attrs.getLength(); i++)
/*      */         {
/*  511 */           String localName = attrs.getLocalName(i);
/*  512 */           if ("class".equals(localName)) {
/*  513 */             parameter.setType(attrs.getValue(i)); } else {
/*  514 */             if ((!"replace".equals(localName)) && (!"trim".equals(localName)))
/*      */               continue;
/*  516 */             org.jboss.beans.metadata.spi.ValueMetaData vmd = parameter.getValue();
/*      */             StringValueMetaData stringValueMetaData;
/*      */             StringValueMetaData stringValueMetaData;
/*  518 */             if ((vmd != null) && ((vmd instanceof StringValueMetaData))) {
/*  519 */               stringValueMetaData = (StringValueMetaData)vmd;
/*      */             }
/*      */             else {
/*  522 */               stringValueMetaData = new StringValueMetaData();
/*  523 */               parameter.setValue(stringValueMetaData);
/*      */             }
/*  525 */             if ("replace".equals(localName))
/*  526 */               stringValueMetaData.setReplace(Boolean.parseBoolean(attrs.getValue(i)));
/*  527 */             else if ("trim".equals(localName))
/*  528 */               stringValueMetaData.setTrim(Boolean.parseBoolean(attrs.getValue(i)));
/*      */           }
/*      */         }
/*      */       }
/*      */     });
/*  535 */     parameterType.setSimpleType(new CharactersHandler()
/*      */     {
/*      */       public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, org.jboss.xb.binding.metadata.ValueMetaData valueMetaData, String value)
/*      */       {
/*  539 */         return new StringValueMetaData(value);
/*      */       }
/*      */ 
/*      */       public void setValue(QName qName, ElementBinding element, Object owner, Object value)
/*      */       {
/*  544 */         AbstractParameterMetaData parameter = (AbstractParameterMetaData)owner;
/*  545 */         StringValueMetaData svmd = (StringValueMetaData)value;
/*  546 */         org.jboss.beans.metadata.spi.ValueMetaData vmd = parameter.getValue();
/*  547 */         if ((vmd != null) && ((vmd instanceof StringValueMetaData)))
/*      */         {
/*  549 */           StringValueMetaData previous = (StringValueMetaData)vmd;
/*  550 */           svmd.setReplace(previous.isReplace());
/*  551 */           svmd.setTrim(previous.isTrim());
/*  552 */           String type = previous.getType();
/*  553 */           if (type != null)
/*  554 */             svmd.setType(type);
/*      */         }
/*  556 */         parameter.setValue(svmd);
/*      */       }
/*      */     });
/*  560 */     beanType.pushInterceptor(createQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  564 */         AbstractBeanMetaData bean = (AbstractBeanMetaData)parent;
/*  565 */         AbstractLifecycleMetaData lifecycle = (AbstractLifecycleMetaData)child;
/*  566 */         lifecycle.setType("create");
/*  567 */         bean.setCreate(lifecycle);
/*      */       }
/*      */     });
/*  572 */     beanFactoryType.pushInterceptor(createQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  576 */         GenericBeanFactoryMetaData bean = (GenericBeanFactoryMetaData)parent;
/*  577 */         AbstractLifecycleMetaData lifecycle = (AbstractLifecycleMetaData)child;
/*  578 */         lifecycle.setType("create");
/*  579 */         bean.setBeanCreate(lifecycle);
/*      */       }
/*      */     });
/*  584 */     beanType.pushInterceptor(startQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  588 */         AbstractBeanMetaData bean = (AbstractBeanMetaData)parent;
/*  589 */         AbstractLifecycleMetaData lifecycle = (AbstractLifecycleMetaData)child;
/*  590 */         lifecycle.setType("start");
/*  591 */         bean.setStart(lifecycle);
/*      */       }
/*      */     });
/*  596 */     beanFactoryType.pushInterceptor(startQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  600 */         GenericBeanFactoryMetaData bean = (GenericBeanFactoryMetaData)parent;
/*  601 */         AbstractLifecycleMetaData lifecycle = (AbstractLifecycleMetaData)child;
/*  602 */         lifecycle.setType("start");
/*  603 */         bean.setBeanStart(lifecycle);
/*      */       }
/*      */     });
/*  608 */     beanType.pushInterceptor(stopQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  612 */         AbstractBeanMetaData bean = (AbstractBeanMetaData)parent;
/*  613 */         AbstractLifecycleMetaData lifecycle = (AbstractLifecycleMetaData)child;
/*  614 */         lifecycle.setType("stop");
/*  615 */         bean.setStop(lifecycle);
/*      */       }
/*      */     });
/*  620 */     beanType.pushInterceptor(destroyQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  624 */         AbstractBeanMetaData bean = (AbstractBeanMetaData)parent;
/*  625 */         AbstractLifecycleMetaData lifecycle = (AbstractLifecycleMetaData)child;
/*  626 */         lifecycle.setType("destroy");
/*  627 */         bean.setDestroy(lifecycle);
/*      */       }
/*      */     });
/*  632 */     TypeBinding lifecycleType = schemaBinding.getType(lifecycleTypeQName);
/*  633 */     lifecycleType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/*  637 */         return new AbstractLifecycleMetaData();
/*      */       }
/*      */ 
/*      */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */       {
/*  642 */         AbstractLifecycleMetaData lifecycle = (AbstractLifecycleMetaData)o;
/*  643 */         for (int i = 0; i < attrs.getLength(); i++)
/*      */         {
/*  645 */           String localName = attrs.getLocalName(i);
/*  646 */           if ("method".equals(localName))
/*  647 */             lifecycle.setMethodName(attrs.getValue(i));
/*  648 */           else if ("ignored".equals(localName))
/*  649 */             lifecycle.setIgnored(Boolean.parseBoolean(attrs.getValue(i)));
/*      */         }
/*      */       }
/*      */     });
/*  655 */     lifecycleType.pushInterceptor(parameterQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  659 */         AbstractLifecycleMetaData lifecycle = (AbstractLifecycleMetaData)parent;
/*  660 */         AbstractParameterMetaData parameter = (AbstractParameterMetaData)child;
/*  661 */         List parameters = lifecycle.getParameters();
/*  662 */         if (parameters == null)
/*      */         {
/*  664 */           parameters = new ArrayList();
/*  665 */           lifecycle.setParameters(parameters);
/*      */         }
/*  667 */         parameter.setIndex(parameters.size());
/*  668 */         parameters.add(parameter);
/*      */       }
/*      */     });
/*  673 */     beanType.pushInterceptor(propertyQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  677 */         AbstractBeanMetaData bean = (AbstractBeanMetaData)parent;
/*  678 */         AbstractPropertyMetaData property = (AbstractPropertyMetaData)child;
/*  679 */         Set properties = bean.getProperties();
/*  680 */         if (properties == null)
/*      */         {
/*  682 */           properties = new HashSet();
/*  683 */           bean.setProperties(properties);
/*      */         }
/*  685 */         properties.add(property);
/*      */       }
/*      */     });
/*  690 */     beanFactoryType.pushInterceptor(propertyQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  694 */         GenericBeanFactoryMetaData bean = (GenericBeanFactoryMetaData)parent;
/*  695 */         AbstractPropertyMetaData property = (AbstractPropertyMetaData)child;
/*  696 */         bean.addBeanProperty(property);
/*      */       }
/*      */     });
/*  701 */     beanType.pushInterceptor(dependsQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  705 */         AbstractBeanMetaData bean = (AbstractBeanMetaData)parent;
/*  706 */         AbstractDependencyMetaData dependency = (AbstractDependencyMetaData)child;
/*  707 */         Set depends = bean.getDepends();
/*  708 */         if (depends == null)
/*      */         {
/*  710 */           depends = new HashSet();
/*  711 */           bean.setDepends(depends);
/*      */         }
/*  713 */         depends.add(dependency);
/*      */       }
/*      */     });
/*  718 */     beanFactoryType.pushInterceptor(dependsQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  722 */         GenericBeanFactoryMetaData bean = (GenericBeanFactoryMetaData)parent;
/*  723 */         AbstractDependencyMetaData dependency = (AbstractDependencyMetaData)child;
/*  724 */         Set depends = bean.getDepends();
/*  725 */         if (depends == null)
/*      */         {
/*  727 */           depends = new HashSet();
/*  728 */           bean.setDepends(depends);
/*      */         }
/*  730 */         depends.add(dependency);
/*      */       }
/*      */     });
/*  735 */     beanType.pushInterceptor(demandQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  739 */         AbstractBeanMetaData bean = (AbstractBeanMetaData)parent;
/*  740 */         AbstractDemandMetaData demand = (AbstractDemandMetaData)child;
/*  741 */         Set demands = bean.getDemands();
/*  742 */         if (demands == null)
/*      */         {
/*  744 */           demands = new HashSet();
/*  745 */           bean.setDemands(demands);
/*      */         }
/*  747 */         demands.add(demand);
/*      */       }
/*      */     });
/*  752 */     beanFactoryType.pushInterceptor(demandQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  756 */         AbstractBeanMetaData bean = (AbstractBeanMetaData)parent;
/*  757 */         AbstractDemandMetaData demand = (AbstractDemandMetaData)child;
/*  758 */         Set demands = bean.getDemands();
/*  759 */         if (demands == null)
/*      */         {
/*  761 */           demands = new HashSet();
/*  762 */           bean.setDemands(demands);
/*      */         }
/*  764 */         demands.add(demand);
/*      */       }
/*      */     });
/*  769 */     beanType.pushInterceptor(supplyQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  773 */         AbstractBeanMetaData bean = (AbstractBeanMetaData)parent;
/*  774 */         AbstractSupplyMetaData supply = (AbstractSupplyMetaData)child;
/*  775 */         Set supplies = bean.getSupplies();
/*  776 */         if (supplies == null)
/*      */         {
/*  778 */           supplies = new HashSet();
/*  779 */           bean.setSupplies(supplies);
/*      */         }
/*  781 */         supplies.add(supply);
/*      */       }
/*      */     });
/*  786 */     beanFactoryType.pushInterceptor(supplyQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/*  790 */         AbstractBeanMetaData bean = (AbstractBeanMetaData)parent;
/*  791 */         AbstractSupplyMetaData supply = (AbstractSupplyMetaData)child;
/*  792 */         Set supplies = bean.getSupplies();
/*  793 */         if (supplies == null)
/*      */         {
/*  795 */           supplies = new HashSet();
/*  796 */           bean.setSupplies(supplies);
/*      */         }
/*  798 */         supplies.add(supply);
/*      */       }
/*      */     });
/*  803 */     TypeBinding propertyType = schemaBinding.getType(propertyTypeQName);
/*  804 */     configureValueBindings(propertyType);
/*  805 */     propertyType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/*  809 */         return new AbstractPropertyMetaData();
/*      */       }
/*      */ 
/*      */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */       {
/*  814 */         AbstractPropertyMetaData property = (AbstractPropertyMetaData)o;
/*  815 */         for (int i = 0; i < attrs.getLength(); i++)
/*      */         {
/*  817 */           String localName = attrs.getLocalName(i);
/*  818 */           if ("name".equals(localName)) {
/*  819 */             property.setName(attrs.getValue(i));
/*  820 */           } else if ("preinstantiate".equals(localName)) {
/*  821 */             property.setPreInstantiate(Boolean.parseBoolean(attrs.getValue(i))); } else {
/*  822 */             if ((!"class".equals(localName)) && (!"replace".equals(localName)) && (!"trim".equals(localName))) {
/*      */               continue;
/*      */             }
/*  825 */             org.jboss.beans.metadata.spi.ValueMetaData vmd = property.getValue();
/*      */             StringValueMetaData svmd;
/*  826 */             if ((vmd == null) || (!(vmd instanceof StringValueMetaData)))
/*      */             {
/*  828 */               StringValueMetaData svmd = new StringValueMetaData();
/*  829 */               property.setValue(svmd);
/*      */             }
/*      */             else
/*      */             {
/*  833 */               svmd = (StringValueMetaData)vmd;
/*      */             }
/*  835 */             if ("class".equals(localName))
/*  836 */               svmd.setType(attrs.getValue(i));
/*  837 */             else if ("replace".equals(localName))
/*  838 */               svmd.setReplace(Boolean.parseBoolean(attrs.getValue(i)));
/*  839 */             else if ("trim".equals(localName))
/*  840 */               svmd.setTrim(Boolean.parseBoolean(attrs.getValue(i)));
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*      */       public Object endElement(Object o, QName qName, ElementBinding element)
/*      */       {
/*  847 */         AbstractPropertyMetaData x = (AbstractPropertyMetaData)o;
/*  848 */         String name = x.getName();
/*  849 */         if ((name == null) || (name.trim().length() == 0))
/*  850 */           throw new IllegalArgumentException("Null or empty property name.");
/*  851 */         return o;
/*      */       }
/*      */     });
/*  856 */     propertyType.setSimpleType(new CharactersHandler()
/*      */     {
/*      */       public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, org.jboss.xb.binding.metadata.ValueMetaData valueMetaData, String value)
/*      */       {
/*  860 */         return new StringValueMetaData(value);
/*      */       }
/*      */ 
/*      */       public void setValue(QName qName, ElementBinding element, Object owner, Object value)
/*      */       {
/*  865 */         AbstractPropertyMetaData property = (AbstractPropertyMetaData)owner;
/*  866 */         StringValueMetaData svmd = (StringValueMetaData)value;
/*  867 */         org.jboss.beans.metadata.spi.ValueMetaData vmd = property.getValue();
/*  868 */         if ((vmd != null) && ((vmd instanceof StringValueMetaData)))
/*      */         {
/*  870 */           StringValueMetaData previous = (StringValueMetaData)vmd;
/*  871 */           svmd.setReplace(previous.isReplace());
/*  872 */           svmd.setTrim(previous.isTrim());
/*  873 */           String type = previous.getType();
/*  874 */           if (type != null)
/*  875 */             svmd.setType(type);
/*      */         }
/*  877 */         property.setValue(svmd);
/*      */       }
/*      */     });
/*  882 */     TypeBinding dependsType = schemaBinding.getType(dependsTypeQName);
/*  883 */     dependsType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/*  887 */         return new AbstractDependencyMetaData();
/*      */       }
/*      */ 
/*      */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */       {
/*      */       }
/*      */ 
/*      */       public Object endElement(Object o, QName qName, ElementBinding element)
/*      */       {
/*  896 */         AbstractDependencyMetaData x = (AbstractDependencyMetaData)o;
/*  897 */         String name = (String)x.getDependency();
/*  898 */         if ((name == null) || (name.trim().length() == 0))
/*  899 */           throw new IllegalArgumentException("Null or empty dependency.");
/*  900 */         return o;
/*      */       }
/*      */     });
/*  905 */     dependsType.setSimpleType(new CharactersHandler()
/*      */     {
/*      */       public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, org.jboss.xb.binding.metadata.ValueMetaData valueMetaData, String value)
/*      */       {
/*  909 */         return value;
/*      */       }
/*      */ 
/*      */       public void setValue(QName qname, ElementBinding element, Object owner, Object value)
/*      */       {
/*  914 */         AbstractDependencyMetaData depends = (AbstractDependencyMetaData)owner;
/*  915 */         depends.setDependency(value);
/*      */       }
/*      */     });
/*  920 */     TypeBinding demandType = schemaBinding.getType(demandTypeQName);
/*  921 */     demandType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/*  925 */         return new AbstractDemandMetaData();
/*      */       }
/*      */ 
/*      */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */       {
/*  930 */         AbstractDemandMetaData demand = (AbstractDemandMetaData)o;
/*  931 */         for (int i = 0; i < attrs.getLength(); i++)
/*      */         {
/*  933 */           String localName = attrs.getLocalName(i);
/*  934 */           if ("state".equals(localName))
/*  935 */             demand.setWhenRequired(new ControllerState(attrs.getValue(i)));
/*      */         }
/*      */       }
/*      */ 
/*      */       public Object endElement(Object o, QName qName, ElementBinding element)
/*      */       {
/*  941 */         AbstractDemandMetaData x = (AbstractDemandMetaData)o;
/*  942 */         String name = (String)x.getDemand();
/*  943 */         if ((name == null) || (name.trim().length() == 0))
/*  944 */           throw new IllegalArgumentException("Null or empty demand.");
/*  945 */         return o;
/*      */       }
/*      */     });
/*  950 */     demandType.setSimpleType(new CharactersHandler()
/*      */     {
/*      */       public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, org.jboss.xb.binding.metadata.ValueMetaData valueMetaData, String value)
/*      */       {
/*  954 */         return value;
/*      */       }
/*      */ 
/*      */       public void setValue(QName qname, ElementBinding element, Object owner, Object value)
/*      */       {
/*  959 */         AbstractDemandMetaData demand = (AbstractDemandMetaData)owner;
/*  960 */         demand.setDemand(value);
/*      */       }
/*      */     });
/*  965 */     TypeBinding supplyType = schemaBinding.getType(supplyTypeQName);
/*  966 */     supplyType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/*  970 */         return new AbstractSupplyMetaData();
/*      */       }
/*      */ 
/*      */       public Object endElement(Object o, QName qName, ElementBinding element)
/*      */       {
/*  975 */         AbstractSupplyMetaData x = (AbstractSupplyMetaData)o;
/*  976 */         String name = (String)x.getSupply();
/*  977 */         if ((name == null) || (name.trim().length() == 0))
/*  978 */           throw new IllegalArgumentException("Null or empty supply.");
/*  979 */         return o;
/*      */       }
/*      */     });
/*  984 */     supplyType.setSimpleType(new CharactersHandler()
/*      */     {
/*      */       public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, org.jboss.xb.binding.metadata.ValueMetaData valueMetaData, String value)
/*      */       {
/*  988 */         return value;
/*      */       }
/*      */ 
/*      */       public void setValue(QName qName, ElementBinding element, Object owner, Object value)
/*      */       {
/*  993 */         AbstractSupplyMetaData supply = (AbstractSupplyMetaData)owner;
/*  994 */         supply.setSupply(value);
/*      */       }
/*      */     });
/*  999 */     TypeBinding dependencyType = schemaBinding.getType(dependencyTypeQName);
/* 1000 */     dependencyType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/* 1004 */         return new AbstractDependencyValueMetaData();
/*      */       }
/*      */ 
/*      */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */       {
/* 1009 */         AbstractDependencyValueMetaData dependency = (AbstractDependencyValueMetaData)o;
/* 1010 */         for (int i = 0; i < attrs.getLength(); i++)
/*      */         {
/* 1012 */           String localName = attrs.getLocalName(i);
/* 1013 */           if ("bean".equals(localName))
/* 1014 */             dependency.setValue(attrs.getValue(i));
/* 1015 */           else if ("property".equals(localName))
/* 1016 */             dependency.setProperty(attrs.getValue(i));
/* 1017 */           else if ("state".equals(localName))
/* 1018 */             dependency.setDependentState(new ControllerState(attrs.getValue(i)));
/* 1019 */           else if ("whenRequired".equals(localName))
/* 1020 */             dependency.setWhenRequiredState(new ControllerState(attrs.getValue(i)));
/*      */         }
/*      */       }
/*      */ 
/*      */       public Object endElement(Object o, QName qName, ElementBinding element)
/*      */       {
/* 1026 */         AbstractDependencyValueMetaData x = (AbstractDependencyValueMetaData)o;
/* 1027 */         String name = (String)x.getUnderlyingValue();
/* 1028 */         if ((name == null) || (name.trim().length() == 0))
/* 1029 */           throw new IllegalArgumentException("Null or empty bean in injection/factory.");
/* 1030 */         return o;
/*      */       }
/*      */     });
/* 1035 */     TypeBinding injectionType = schemaBinding.getType(injectionTypeQName);
/* 1036 */     injectionType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/* 1040 */         AbstractInjectionValueMetaData vmd = new AbstractInjectionValueMetaData();
/* 1041 */         if ((parent instanceof AbstractPropertyMetaData))
/*      */         {
/* 1043 */           AbstractPropertyMetaData x = (AbstractPropertyMetaData)parent;
/* 1044 */           vmd.setPropertyMetaData(x);
/*      */         }
/* 1046 */         return vmd;
/*      */       }
/*      */ 
/*      */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */       {
/* 1051 */         AbstractInjectionValueMetaData injection = (AbstractInjectionValueMetaData)o;
/* 1052 */         for (int i = 0; i < attrs.getLength(); i++)
/*      */         {
/* 1054 */           String localName = attrs.getLocalName(i);
/* 1055 */           if ("bean".equals(localName))
/* 1056 */             injection.setValue(attrs.getValue(i));
/* 1057 */           else if ("property".equals(localName))
/* 1058 */             injection.setProperty(attrs.getValue(i));
/* 1059 */           else if ("state".equals(localName))
/* 1060 */             injection.setDependentState(new ControllerState(attrs.getValue(i)));
/* 1061 */           else if ("whenRequired".equals(localName))
/* 1062 */             injection.setWhenRequiredState(new ControllerState(attrs.getValue(i)));
/* 1063 */           else if ("type".equals(localName))
/* 1064 */             injection.setInjectionType(AutowireType.getInstance(attrs.getValue(i)));
/* 1065 */           else if ("option".equals(localName))
/* 1066 */             injection.setInjectionOption(InjectionOption.getInstance(attrs.getValue(i)));
/* 1067 */           else if ("fromContext".equals(localName))
/* 1068 */             injection.setFromContext(FromContext.getInstance(attrs.getValue(i)));
/*      */         }
/*      */       }
/*      */     });
/* 1074 */     TypeBinding plainValueType = schemaBinding.getType(plainValueTypeQName);
/* 1075 */     plainValueType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/* 1079 */         return new StringValueMetaData();
/*      */       }
/*      */ 
/*      */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */       {
/* 1084 */         StringValueMetaData value = (StringValueMetaData)o;
/* 1085 */         for (int i = 0; i < attrs.getLength(); i++)
/*      */         {
/* 1087 */           String localName = attrs.getLocalName(i);
/* 1088 */           if ("class".equals(localName))
/* 1089 */             value.setType(attrs.getValue(i));
/* 1090 */           else if ("replace".equals(localName))
/* 1091 */             value.setReplace(Boolean.parseBoolean(attrs.getValue(i)));
/* 1092 */           else if ("trim".equals(localName))
/* 1093 */             value.setTrim(Boolean.parseBoolean(attrs.getValue(i)));
/*      */         }
/*      */       }
/*      */     });
/* 1099 */     plainValueType.setSimpleType(new CharactersHandler()
/*      */     {
/*      */       public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, org.jboss.xb.binding.metadata.ValueMetaData valueMetaData, String value)
/*      */       {
/* 1103 */         return value;
/*      */       }
/*      */ 
/*      */       public void setValue(QName qName, ElementBinding element, Object owner, Object value)
/*      */       {
/* 1108 */         StringValueMetaData valueMetaData = (StringValueMetaData)owner;
/* 1109 */         valueMetaData.setValue(value);
/*      */       }
/*      */     });
/* 1114 */     TypeBinding valueType = schemaBinding.getType(valueTypeQName);
/* 1115 */     configureValueBindings(valueType);
/* 1116 */     valueType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/* 1120 */         return new AbstractValueMetaData(new StringValueMetaData());
/*      */       }
/*      */ 
/*      */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */       {
/* 1125 */         AbstractValueMetaData value = (AbstractValueMetaData)o;
/* 1126 */         StringValueMetaData string = (StringValueMetaData)value.getValue();
/* 1127 */         for (int i = 0; i < attrs.getLength(); i++)
/*      */         {
/* 1129 */           String localName = attrs.getLocalName(i);
/* 1130 */           if ("class".equals(localName))
/* 1131 */             string.setType(attrs.getValue(i));
/* 1132 */           else if ("replace".equals(localName))
/* 1133 */             string.setReplace(Boolean.parseBoolean(attrs.getValue(i)));
/* 1134 */           else if ("trim".equals(localName))
/* 1135 */             string.setTrim(Boolean.parseBoolean(attrs.getValue(i)));
/*      */         }
/*      */       }
/*      */     });
/* 1141 */     valueType.setSimpleType(new CharactersHandler()
/*      */     {
/*      */       public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, org.jboss.xb.binding.metadata.ValueMetaData valueMetaData, String value)
/*      */       {
/* 1145 */         return value;
/*      */       }
/*      */ 
/*      */       public void setValue(QName qName, ElementBinding element, Object owner, Object value)
/*      */       {
/* 1150 */         AbstractValueMetaData valueMetaData = (AbstractValueMetaData)owner;
/* 1151 */         StringValueMetaData string = (StringValueMetaData)valueMetaData.getValue();
/* 1152 */         string.setValue(value);
/*      */       }
/*      */     });
/* 1157 */     configureCollection(collectionTypeQName);
/*      */ 
/* 1160 */     configureCollection(listTypeQName);
/*      */ 
/* 1163 */     configureCollection(setTypeQName);
/*      */ 
/* 1166 */     configureCollection(arrayTypeQName);
/*      */ 
/* 1169 */     TypeBinding mapType = schemaBinding.getType(mapTypeQName);
/* 1170 */     mapType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/* 1174 */         return new AbstractMapMetaData();
/*      */       }
/*      */ 
/*      */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */       {
/* 1179 */         AbstractMapMetaData collection = (AbstractMapMetaData)o;
/* 1180 */         for (int i = 0; i < attrs.getLength(); i++)
/*      */         {
/* 1182 */           String localName = attrs.getLocalName(i);
/* 1183 */           if ("class".equals(localName))
/* 1184 */             collection.setType(attrs.getValue(i));
/* 1185 */           else if ("keyClass".equals(localName))
/* 1186 */             collection.setKeyType(attrs.getValue(i));
/* 1187 */           else if ("valueClass".equals(localName))
/* 1188 */             collection.setValueType(attrs.getValue(i));
/*      */         }
/*      */       }
/*      */     });
/* 1194 */     mapType.pushInterceptor(entryQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/* 1198 */         AbstractMapMetaData map = (AbstractMapMetaData)parent;
/* 1199 */         BeanSchemaBinding.MapEntry entry = (BeanSchemaBinding.MapEntry)child;
/* 1200 */         AbstractValueMetaData entryKey = (AbstractValueMetaData)entry.key;
/* 1201 */         if (entryKey == null)
/* 1202 */           throw new IllegalArgumentException("No key in map entry");
/* 1203 */         AbstractValueMetaData entryValue = (AbstractValueMetaData)entry.value;
/* 1204 */         if (entryValue == null)
/* 1205 */           throw new IllegalArgumentException("No value in map entry");
/* 1206 */         map.put((MetaDataVisitorNode)entryKey.getValue(), (MetaDataVisitorNode)entryValue.getValue());
/*      */       }
/*      */     });
/* 1211 */     TypeBinding entryType = schemaBinding.getType(entryTypeQName);
/* 1212 */     entryType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/* 1216 */         return new BeanSchemaBinding.MapEntry(null);
/*      */       }
/*      */     });
/* 1221 */     entryType.pushInterceptor(keyQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/* 1225 */         BeanSchemaBinding.MapEntry entry = (BeanSchemaBinding.MapEntry)parent;
/* 1226 */         entry.key = child;
/*      */       }
/*      */     });
/* 1231 */     entryType.pushInterceptor(valueQName, new DefaultElementInterceptor()
/*      */     {
/*      */       public void add(Object parent, Object child, QName name)
/*      */       {
/* 1235 */         BeanSchemaBinding.MapEntry entry = (BeanSchemaBinding.MapEntry)parent;
/* 1236 */         entry.value = child;
/*      */       }
/*      */     });
/*      */   }
/*      */ 
/*      */   private static void configureCollection(QName qname)
/*      */   {
/* 1247 */     TypeBinding collectionType = schemaBinding.getType(qname);
/* 1248 */     collectionType.setHandler(new DefaultElementHandler()
/*      */     {
/*      */       public Object startElement(Object parent, QName name, ElementBinding element)
/*      */       {
/* 1252 */         if (BeanSchemaBinding.collectionQName.equals(name))
/* 1253 */           return new AbstractCollectionMetaData();
/* 1254 */         if (BeanSchemaBinding.listQName.equals(name))
/* 1255 */           return new AbstractListMetaData();
/* 1256 */         if (BeanSchemaBinding.setQName.equals(name))
/* 1257 */           return new AbstractSetMetaData();
/* 1258 */         if (BeanSchemaBinding.arrayQName.equals(name)) {
/* 1259 */           return new AbstractArrayMetaData();
/*      */         }
/* 1261 */         throw new IllegalArgumentException("Unknown collection qname=" + name);
/*      */       }
/*      */ 
/*      */       public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*      */       {
/* 1266 */         AbstractCollectionMetaData collection = (AbstractCollectionMetaData)o;
/* 1267 */         for (int i = 0; i < attrs.getLength(); i++)
/*      */         {
/* 1269 */           String localName = attrs.getLocalName(i);
/* 1270 */           if ("class".equals(localName))
/* 1271 */             collection.setType(attrs.getValue(i));
/* 1272 */           else if ("elementClass".equals(localName))
/* 1273 */             collection.setElementType(attrs.getValue(i));
/*      */         }
/*      */       }
/*      */     });
/* 1278 */     configureValueBindings(collectionType);
/*      */   }
/*      */ 
/*      */   private static void configureValueBindings(TypeBinding typeBinding)
/*      */   {
/* 1284 */     typeBinding.pushInterceptor(valueQName, VALUES);
/*      */ 
/* 1287 */     typeBinding.pushInterceptor(injectQName, VALUES);
/*      */ 
/* 1290 */     typeBinding.pushInterceptor(collectionQName, VALUES);
/*      */ 
/* 1293 */     typeBinding.pushInterceptor(listQName, VALUES);
/*      */ 
/* 1296 */     typeBinding.pushInterceptor(setQName, VALUES);
/*      */ 
/* 1299 */     typeBinding.pushInterceptor(arrayQName, VALUES);
/*      */ 
/* 1302 */     typeBinding.pushInterceptor(mapQName, VALUES);
/*      */ 
/* 1305 */     typeBinding.pushInterceptor(nullQName, NULLVALUES);
/*      */   }
/*      */ 
/*      */   private static class MapEntry
/*      */   {
/*      */     public Object key;
/*      */     public Object value;
/*      */   }
/*      */ 
/*      */   private static class ValueMetaDataElementInterceptor extends DefaultElementInterceptor
/*      */   {
/*      */     public void add(Object parent, Object child, QName name)
/*      */     {
/* 1344 */       if ((parent instanceof AbstractCollectionMetaData))
/*      */       {
/* 1346 */         AbstractCollectionMetaData collection = (AbstractCollectionMetaData)parent;
/* 1347 */         org.jboss.beans.metadata.spi.ValueMetaData value = (org.jboss.beans.metadata.spi.ValueMetaData)child;
/* 1348 */         collection.add(value);
/*      */       }
/* 1350 */       else if ((parent instanceof AbstractParameterMetaData))
/*      */       {
/* 1352 */         AbstractParameterMetaData valueMetaData = (AbstractParameterMetaData)parent;
/* 1353 */         org.jboss.beans.metadata.spi.ValueMetaData value = (org.jboss.beans.metadata.spi.ValueMetaData)child;
/* 1354 */         valueMetaData.setValue(value);
/*      */       }
/* 1356 */       else if ((parent instanceof AbstractPropertyMetaData))
/*      */       {
/* 1358 */         AbstractPropertyMetaData valueMetaData = (AbstractPropertyMetaData)parent;
/* 1359 */         org.jboss.beans.metadata.spi.ValueMetaData value = (org.jboss.beans.metadata.spi.ValueMetaData)child;
/* 1360 */         valueMetaData.setValue(value);
/*      */       }
/* 1362 */       else if ((parent instanceof AbstractClassLoaderMetaData))
/*      */       {
/* 1364 */         AbstractClassLoaderMetaData valueMetaData = (AbstractClassLoaderMetaData)parent;
/* 1365 */         org.jboss.beans.metadata.spi.ValueMetaData value = (org.jboss.beans.metadata.spi.ValueMetaData)child;
/* 1366 */         valueMetaData.setClassLoader(value);
/*      */       }
/*      */       else
/*      */       {
/* 1370 */         AbstractValueMetaData valueMetaData = (AbstractValueMetaData)parent;
/* 1371 */         org.jboss.beans.metadata.spi.ValueMetaData value = (org.jboss.beans.metadata.spi.ValueMetaData)child;
/* 1372 */         valueMetaData.setValue(value);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class NullValueElementInterceptor extends DefaultElementInterceptor
/*      */   {
/*      */     public void add(Object parent, Object child, QName name)
/*      */     {
/* 1312 */       if ((parent instanceof AbstractCollectionMetaData))
/*      */       {
/* 1314 */         AbstractCollectionMetaData collection = (AbstractCollectionMetaData)parent;
/* 1315 */         collection.add(new AbstractValueMetaData());
/*      */       }
/* 1317 */       else if ((parent instanceof AbstractParameterMetaData))
/*      */       {
/* 1319 */         AbstractParameterMetaData valueMetaData = (AbstractParameterMetaData)parent;
/* 1320 */         valueMetaData.setValue(new AbstractValueMetaData());
/*      */       }
/* 1322 */       else if ((parent instanceof AbstractPropertyMetaData))
/*      */       {
/* 1324 */         AbstractPropertyMetaData valueMetaData = (AbstractPropertyMetaData)parent;
/* 1325 */         valueMetaData.setValue(new AbstractValueMetaData());
/*      */       }
/* 1327 */       else if ((parent instanceof AbstractClassLoaderMetaData))
/*      */       {
/* 1329 */         AbstractClassLoaderMetaData valueMetaData = (AbstractClassLoaderMetaData)parent;
/* 1330 */         valueMetaData.setClassLoader(new AbstractValueMetaData());
/*      */       }
/*      */       else
/*      */       {
/* 1334 */         AbstractValueMetaData valueMetaData = (AbstractValueMetaData)parent;
/* 1335 */         valueMetaData.setValue(new AbstractValueMetaData());
/*      */       }
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.deployment.xml.BeanSchemaBinding
 * JD-Core Version:    0.6.0
 */