/*     */ package org.jboss.kernel.plugins.deployment.xml;
/*     */ 
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
/*     */ 
/*     */ public class BeanSchemaBindingHelper
/*     */ {
/*     */   public static void initDeploymentHandlers(TypeBinding deploymentType)
/*     */   {
/*  45 */     deploymentType.setHandler(DeploymentHandler.HANDLER);
/*     */ 
/*  48 */     deploymentType.pushInterceptor(BeanSchemaBinding20.annotationQName, DeploymentAnnotationInterceptor.INTERCEPTOR);
/*     */ 
/*  51 */     deploymentType.pushInterceptor(BeanSchemaBinding20.classloaderQName, DeploymentClassLoaderInterceptor.INTERCEPTOR);
/*     */ 
/*  54 */     deploymentType.pushInterceptor(BeanSchemaBinding20.createQName, LifecycleCreateInterceptor.INTERCEPTOR);
/*     */ 
/*  57 */     deploymentType.pushInterceptor(BeanSchemaBinding20.startQName, LifecycleStartInterceptor.INTERCEPTOR);
/*     */ 
/*  60 */     deploymentType.pushInterceptor(BeanSchemaBinding20.stopQName, LifecycleStopInterceptor.INTERCEPTOR);
/*     */ 
/*  63 */     deploymentType.pushInterceptor(BeanSchemaBinding20.destroyQName, LifecycleDestroyInterceptor.INTERCEPTOR);
/*     */ 
/*  66 */     deploymentType.pushInterceptor(BeanSchemaBinding20.aliasQName, DeploymentAliasInterceptor.INTERCEPTOR);
/*     */ 
/*  69 */     deploymentType.pushInterceptor(BeanSchemaBinding20.beanQName, DeploymentBeanInterceptor.INTERCEPTOR);
/*     */ 
/*  72 */     deploymentType.pushInterceptor(BeanSchemaBinding20.beanFactoryQName, DeploymentBeanInterceptor.INTERCEPTOR);
/*     */ 
/*  75 */     deploymentType.pushInterceptor(BeanSchemaBinding20.lazyQName, DeploymentBeanInterceptor.INTERCEPTOR);
/*     */ 
/*  78 */     deploymentType.getWildcard().setWildcardHandler(DeploymentWildcardHandler.HANDLER);
/*     */   }
/*     */ 
/*     */   public static void initBeanHandlers(TypeBinding beanType)
/*     */   {
/*  88 */     beanType.setHandler(BeanHandler.HANDLER);
/*     */ 
/*  91 */     beanType.pushInterceptor(BeanSchemaBinding20.classloaderQName, BeanClassLoaderInterceptor.INTERCEPTOR);
/*     */ 
/*  94 */     beanType.pushInterceptor(BeanSchemaBinding20.constructorQName, BeanConstructorInterceptor.INTERCEPTOR);
/*     */ 
/*  97 */     beanType.pushInterceptor(BeanSchemaBinding20.propertyQName, BeanPropertyInterceptor.INTERCEPTOR);
/*     */ 
/* 100 */     beanType.pushInterceptor(BeanSchemaBinding20.createQName, LifecycleCreateInterceptor.INTERCEPTOR);
/*     */ 
/* 103 */     beanType.pushInterceptor(BeanSchemaBinding20.startQName, LifecycleStartInterceptor.INTERCEPTOR);
/*     */ 
/* 106 */     beanType.pushInterceptor(BeanSchemaBinding20.stopQName, LifecycleStopInterceptor.INTERCEPTOR);
/*     */ 
/* 109 */     beanType.pushInterceptor(BeanSchemaBinding20.destroyQName, LifecycleDestroyInterceptor.INTERCEPTOR);
/*     */ 
/* 112 */     beanType.pushInterceptor(BeanSchemaBinding20.aliasQName, BeanAliasInterceptor.INTERCEPTOR);
/*     */ 
/* 115 */     beanType.pushInterceptor(BeanSchemaBinding20.annotationQName, BeanAnnotationInterceptor.INTERCEPTOR);
/*     */ 
/* 118 */     beanType.pushInterceptor(BeanSchemaBinding20.installQName, BeanInstallInterceptor.INTERCEPTOR);
/*     */ 
/* 121 */     beanType.pushInterceptor(BeanSchemaBinding20.uninstallQName, BeanUninstallInterceptor.INTERCEPTOR);
/*     */ 
/* 124 */     beanType.pushInterceptor(BeanSchemaBinding20.installCallbackQName, BeanInstallCallbackInterceptor.INTERCEPTOR);
/*     */ 
/* 127 */     beanType.pushInterceptor(BeanSchemaBinding20.uninstallCallbackQName, BeanUninstallCallbackInterceptor.INTERCEPTOR);
/*     */ 
/* 130 */     beanType.pushInterceptor(BeanSchemaBinding20.dependsQName, BeanDependsInterceptor.INTERCEPTOR);
/*     */ 
/* 133 */     beanType.pushInterceptor(BeanSchemaBinding20.demandQName, BeanDemandsInterceptor.INTERCEPTOR);
/*     */ 
/* 136 */     beanType.pushInterceptor(BeanSchemaBinding20.supplyQName, BeanSuppliesInterceptor.INTERCEPTOR);
/*     */   }
/*     */ 
/*     */   public static void initBeanFactoryHandlers(TypeBinding beanFactoryType)
/*     */   {
/* 146 */     beanFactoryType.setHandler(BeanFactoryHandler.HANDLER);
/*     */ 
/* 149 */     beanFactoryType.pushInterceptor(BeanSchemaBinding20.aliasQName, BeanAliasInterceptor.INTERCEPTOR);
/*     */ 
/* 152 */     beanFactoryType.pushInterceptor(BeanSchemaBinding20.classloaderQName, BeanClassLoaderInterceptor.INTERCEPTOR);
/*     */ 
/* 155 */     beanFactoryType.pushInterceptor(BeanSchemaBinding20.constructorQName, BeanFactoryConstructorInterceptor.INTERCEPTOR);
/*     */ 
/* 158 */     beanFactoryType.pushInterceptor(BeanSchemaBinding20.propertyQName, BeanFactoryPropertyInterceptor.INTERCEPTOR);
/*     */ 
/* 161 */     beanFactoryType.pushInterceptor(BeanSchemaBinding20.createQName, BeanFactoryCreateInterceptor.INTERCEPTOR);
/*     */ 
/* 164 */     beanFactoryType.pushInterceptor(BeanSchemaBinding20.startQName, BeanFactoryStartInterceptor.INTERCEPTOR);
/*     */ 
/* 167 */     beanFactoryType.pushInterceptor(BeanSchemaBinding20.installQName, BeanInstallInterceptor.INTERCEPTOR);
/*     */ 
/* 170 */     beanFactoryType.pushInterceptor(BeanSchemaBinding20.uninstallQName, BeanUninstallInterceptor.INTERCEPTOR);
/*     */ 
/* 181 */     beanFactoryType.pushInterceptor(BeanSchemaBinding20.dependsQName, BeanDependsInterceptor.INTERCEPTOR);
/*     */ 
/* 184 */     beanFactoryType.pushInterceptor(BeanSchemaBinding20.demandQName, BeanDemandsInterceptor.INTERCEPTOR);
/*     */ 
/* 187 */     beanFactoryType.pushInterceptor(BeanSchemaBinding20.supplyQName, BeanSuppliesInterceptor.INTERCEPTOR);
/*     */   }
/*     */ 
/*     */   public static void initLazyHandlers(TypeBinding beanFactoryType)
/*     */   {
/* 197 */     beanFactoryType.setHandler(LazyHandler.HANDLER);
/*     */ 
/* 200 */     beanFactoryType.pushInterceptor(BeanSchemaBinding20.interfaceQName, LazyInterfaceInterceptor.INTERCEPTOR);
/*     */   }
/*     */ 
/*     */   public static void initClassLoaderHandlers(TypeBinding classloaderType)
/*     */   {
/* 210 */     classloaderType.setHandler(ClassLoaderHandler.HANDLER);
/*     */ 
/* 212 */     configureValueBindings(classloaderType);
/*     */   }
/*     */ 
/*     */   public static void initConstructorHandlers(TypeBinding constructorType)
/*     */   {
/* 222 */     constructorType.setHandler(ConstructorHandler.HANDLER);
/*     */ 
/* 225 */     constructorType.pushInterceptor(BeanSchemaBinding20.annotationQName, ConstructorAnnotationsInterceptor.INTERCEPTOR);
/*     */ 
/* 228 */     constructorType.pushInterceptor(BeanSchemaBinding20.factoryQName, ConstructorFactoryInterceptor.INTERCEPTOR);
/*     */ 
/* 231 */     constructorType.pushInterceptor(BeanSchemaBinding20.parameterQName, ConstructorParametersInterceptor.INTERCEPTOR);
/*     */ 
/* 233 */     configureValueBindings(constructorType);
/*     */   }
/*     */ 
/*     */   public static void initPropertyHandlers(TypeBinding propertyType)
/*     */   {
/* 243 */     propertyType.setHandler(PropertyHandler.HANDLER);
/*     */ 
/* 246 */     propertyType.pushInterceptor(BeanSchemaBinding20.annotationQName, PropertyAnnotationsInterceptor.INTERCEPTOR);
/*     */ 
/* 249 */     propertyType.setSimpleType(PropertyCharactersHandler.HANDLER);
/*     */ 
/* 251 */     configureValueBindings(propertyType);
/*     */   }
/*     */ 
/*     */   public static void initParameterHandlers(TypeBinding parameterType)
/*     */   {
/* 261 */     parameterType.setHandler(ParameterHandler.HANDLER);
/*     */ 
/* 264 */     parameterType.pushInterceptor(BeanSchemaBinding20.annotationQName, ParameterAnnotationsInterceptor.INTERCEPTOR);
/*     */ 
/* 267 */     parameterType.setSimpleType(ParameterCharactersHandler.HANDLER);
/*     */ 
/* 269 */     configureValueBindings(parameterType);
/*     */   }
/*     */ 
/*     */   public static void initLifecycleHandlers(TypeBinding lifecycleType)
/*     */   {
/* 279 */     lifecycleType.setHandler(LifecycleHandler.HANDLER);
/*     */ 
/* 282 */     lifecycleType.pushInterceptor(BeanSchemaBinding20.annotationQName, LifecycleAnnotationsInterceptor.INTERCEPTOR);
/*     */ 
/* 285 */     lifecycleType.pushInterceptor(BeanSchemaBinding20.parameterQName, LifecycleParametersInterceptor.INTERCEPTOR);
/*     */   }
/*     */ 
/*     */   public static void initInstallHandlers(TypeBinding installType)
/*     */   {
/* 295 */     installType.setHandler(InstallHandler.HANDLER);
/*     */ 
/* 298 */     installType.pushInterceptor(BeanSchemaBinding20.annotationQName, InstallAnnotationsInterceptor.INTERCEPTOR);
/*     */ 
/* 301 */     installType.pushInterceptor(BeanSchemaBinding20.parameterQName, InstallParametersInterceptor.INTERCEPTOR);
/*     */   }
/*     */ 
/*     */   public static void initCallbackHandlers(TypeBinding installType)
/*     */   {
/* 311 */     installType.setHandler(CallbackHandler.HANDLER);
/*     */ 
/* 314 */     installType.pushInterceptor(BeanSchemaBinding20.annotationQName, CallbackAnnotationsInterceptor.INTERCEPTOR);
/*     */   }
/*     */ 
/*     */   public static void initNamedAliasHandlers(TypeBinding aliasType)
/*     */   {
/* 324 */     aliasType.setHandler(NamedAliasHandler.HANDLER);
/*     */ 
/* 327 */     aliasType.setSimpleType(AliasCharactersHandler.HANDLER);
/*     */   }
/*     */ 
/*     */   public static void initInterfaceHandlers(TypeBinding interfaceType)
/*     */   {
/* 337 */     interfaceType.setHandler(ClassHandler.HANDLER);
/*     */ 
/* 340 */     interfaceType.setSimpleType(ClassCharactersHandler.HANDLER);
/*     */   }
/*     */ 
/*     */   public static void initAliasHandlers(TypeBinding aliasType)
/*     */   {
/* 350 */     aliasType.setHandler(AliasHandler.HANDLER);
/*     */ 
/* 353 */     aliasType.setSimpleType(AliasCharactersHandler.HANDLER);
/*     */   }
/*     */ 
/*     */   public static void initAnnotationHandlers(TypeBinding annotationType)
/*     */   {
/* 363 */     annotationType.setHandler(AnnotationHandler.HANDLER);
/*     */ 
/* 366 */     annotationType.setSimpleType(AnnotationCharactersHandler.HANDLER);
/*     */   }
/*     */ 
/*     */   public static void initDependsHandlers(TypeBinding dependsType)
/*     */   {
/* 376 */     dependsType.setHandler(DependsHandler.HANDLER);
/*     */ 
/* 379 */     dependsType.setSimpleType(DependsCharactersHandler.HANDLER);
/*     */   }
/*     */ 
/*     */   public static void initDemandHandlers(TypeBinding demandType)
/*     */   {
/* 389 */     demandType.setHandler(DemandHandler.HANDLER);
/*     */ 
/* 392 */     demandType.setSimpleType(DemandCharactersHandler.HANDLER);
/*     */   }
/*     */ 
/*     */   public static void initSupplyHandlers(TypeBinding supplyType)
/*     */   {
/* 402 */     supplyType.setHandler(SupplyHandler.HANDLER);
/*     */ 
/* 405 */     supplyType.setSimpleType(SupplyCharactersHandler.HANDLER);
/*     */   }
/*     */ 
/*     */   public static void initDependencyHandlers(TypeBinding dependencyType)
/*     */   {
/* 415 */     dependencyType.setHandler(DependencyHandler.HANDLER);
/*     */   }
/*     */ 
/*     */   public static void initInjectionHandlers(TypeBinding dependencyType)
/*     */   {
/* 425 */     dependencyType.setHandler(InjectionHandler.HANDLER);
/*     */   }
/*     */ 
/*     */   public static void initValueFactoryHandlers(TypeBinding valueFactoryType)
/*     */   {
/* 435 */     valueFactoryType.setHandler(ValueFactoryHandler.HANDLER);
/*     */ 
/* 438 */     valueFactoryType.pushInterceptor(BeanSchemaBinding20.parameterQName, ValueFactoryParametersInterceptor.INTERCEPTOR);
/*     */   }
/*     */ 
/*     */   public static void initFactoryHandlers(TypeBinding factoryType)
/*     */   {
/* 448 */     factoryType.setHandler(FactoryHandler.HANDLER);
/*     */ 
/* 451 */     factoryType.getWildcard().setWildcardHandler(FactoryWildcardHandler.WILDCARD);
/*     */   }
/*     */ 
/*     */   public static void initPlainValueHandlers(TypeBinding plainValueType)
/*     */   {
/* 461 */     plainValueType.setHandler(PlainValueHandler.HANDLER);
/*     */ 
/* 464 */     plainValueType.setSimpleType(PlainValueCharactersHandler.HANDLER);
/*     */   }
/*     */ 
/*     */   public static void initValueHandlers(TypeBinding valueType)
/*     */   {
/* 474 */     valueType.setHandler(ValueHandler.HANDLER);
/*     */ 
/* 477 */     valueType.setSimpleType(ValueCharactersHandler.HANDLER);
/*     */ 
/* 479 */     configureValueBindings(valueType);
/*     */   }
/*     */ 
/*     */   public static void initMapHandlers(TypeBinding mapType)
/*     */   {
/* 489 */     mapType.setHandler(MapHandler.HANDLER);
/*     */ 
/* 492 */     mapType.pushInterceptor(BeanSchemaBinding20.entryQName, MapEntryInterceptor.INTERCEPTOR);
/*     */   }
/*     */ 
/*     */   public static void initEntryHandlers(TypeBinding entryType)
/*     */   {
/* 502 */     entryType.setHandler(EntryHandler.HANDLER);
/*     */ 
/* 505 */     entryType.pushInterceptor(BeanSchemaBinding20.keyQName, EntryKeyInterceptor.INTERCEPTOR);
/*     */ 
/* 508 */     entryType.pushInterceptor(BeanSchemaBinding20.valueQName, EntryValueInterceptor.INTERCEPTOR);
/*     */   }
/*     */ 
/*     */   public static void configureCollection(SchemaBinding schemaBinding, QName qname)
/*     */   {
/* 519 */     TypeBinding collectionType = schemaBinding.getType(qname);
/* 520 */     collectionType.setHandler(CollectionHandler.HANDLER);
/* 521 */     configureValueBindings(collectionType);
/*     */   }
/*     */ 
/*     */   public static void configureValueBindings(TypeBinding typeBinding)
/*     */   {
/* 538 */     typeBinding.pushInterceptor(BeanSchemaBinding20.valueQName, ValueMetaDataElementInterceptor.VALUES);
/*     */ 
/* 541 */     typeBinding.pushInterceptor(BeanSchemaBinding20.injectQName, ValueMetaDataElementInterceptor.VALUES);
/*     */ 
/* 544 */     typeBinding.pushInterceptor(BeanSchemaBinding20.valueFactoryQName, ValueMetaDataElementInterceptor.VALUES);
/*     */ 
/* 547 */     typeBinding.pushInterceptor(BeanSchemaBinding20.collectionQName, ValueMetaDataElementInterceptor.VALUES);
/*     */ 
/* 550 */     typeBinding.pushInterceptor(BeanSchemaBinding20.listQName, ValueMetaDataElementInterceptor.VALUES);
/*     */ 
/* 553 */     typeBinding.pushInterceptor(BeanSchemaBinding20.setQName, ValueMetaDataElementInterceptor.VALUES);
/*     */ 
/* 556 */     typeBinding.pushInterceptor(BeanSchemaBinding20.arrayQName, ValueMetaDataElementInterceptor.VALUES);
/*     */ 
/* 559 */     typeBinding.pushInterceptor(BeanSchemaBinding20.mapQName, ValueMetaDataElementInterceptor.VALUES);
/*     */ 
/* 562 */     typeBinding.pushInterceptor(BeanSchemaBinding20.nullQName, NullValueElementInterceptor.NULLVALUES);
/*     */ 
/* 565 */     typeBinding.pushInterceptor(BeanSchemaBinding20.thisQName, ThisValueElementInterceptor.THISVALUES);
/*     */ 
/* 568 */     WildcardBinding wcb = typeBinding.getWildcard();
/* 569 */     if (wcb == null)
/* 570 */       throw new IllegalStateException("Missing wildcard binding for type: " + typeBinding.getQName());
/* 571 */     wcb.setWildcardHandler(ValueWildcardHandler.WILDCARD);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.deployment.xml.BeanSchemaBindingHelper
 * JD-Core Version:    0.6.0
 */