/*    */ package org.jboss.kernel.plugins.deployment.xml;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ import javax.xml.namespace.NamespaceContext;
/*    */ import javax.xml.namespace.QName;
/*    */ import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
/*    */ import org.jboss.beans.metadata.plugins.AbstractValueFactoryMetaData;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
/*    */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*    */ import org.xml.sax.Attributes;
/*    */ 
/*    */ public class ValueFactoryHandler extends DefaultElementHandler
/*    */ {
/* 45 */   public static final ValueFactoryHandler HANDLER = new ValueFactoryHandler();
/*    */ 
/*    */   public Object startElement(Object parent, QName name, ElementBinding element)
/*    */   {
/* 49 */     return new AbstractValueFactoryMetaData();
/*    */   }
/*    */ 
/*    */   public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*    */   {
/* 54 */     AbstractValueFactoryMetaData valueFactory = (AbstractValueFactoryMetaData)o;
/* 55 */     for (int i = 0; i < attrs.getLength(); i++)
/*    */     {
/* 57 */       String localName = attrs.getLocalName(i);
/* 58 */       if ("bean".equals(localName))
/* 59 */         valueFactory.setValue(attrs.getValue(i));
/* 60 */       else if ("method".equals(localName))
/* 61 */         valueFactory.setMethod(attrs.getValue(i));
/* 62 */       else if ("state".equals(localName))
/* 63 */         valueFactory.setDependentState(new ControllerState(attrs.getValue(i)));
/* 64 */       else if ("whenRequired".equals(localName))
/* 65 */         valueFactory.setWhenRequiredState(new ControllerState(attrs.getValue(i)));
/* 66 */       else if ("parameter".equals(localName))
/* 67 */         valueFactory.setParameter(attrs.getValue(i));
/* 68 */       else if ("default".equals(localName))
/* 69 */         valueFactory.setDefaultValue(attrs.getValue(i));
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object endElement(Object o, QName qName, ElementBinding element)
/*    */   {
/* 75 */     AbstractValueFactoryMetaData vf = (AbstractValueFactoryMetaData)o;
/* 76 */     if ((vf.getUnderlyingValue() == null) || (vf.getMethod() == null))
/* 77 */       throw new IllegalArgumentException("Bean or method cannot null: " + vf);
/* 78 */     if ((vf.getParameter() != null) && (vf.getParameters() != null))
/* 79 */       throw new IllegalArgumentException("Both parameter and parameters cannot be set: " + vf);
/* 80 */     if (vf.getParameter() != null)
/*    */     {
/* 82 */       List parameters = new ArrayList();
/* 83 */       parameters.add(new AbstractParameterMetaData(String.class.getName(), vf.getParameter()));
/* 84 */       vf.setParameters(parameters);
/*    */     }
/* 86 */     return vf;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.deployment.xml.ValueFactoryHandler
 * JD-Core Version:    0.6.0
 */