/*     */ package org.jboss.kernel.plugins.dispatch;
/*     */ 
/*     */ import java.util.List;
/*     */ import org.jboss.beans.metadata.spi.ParameterMetaData;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class InvokeDispatchHelper
/*     */ {
/*  41 */   private static final Logger log = Logger.getLogger(InvokeDispatchHelper.class);
/*     */ 
/*     */   public static Object invoke(KernelConfigurator configurator, Object target, InvokeDispatchContext context, String methodName, List<ParameterMetaData> params)
/*     */     throws Throwable
/*     */   {
/*     */     Object[] parameters;
/*     */     String[] signature;
/*     */     Object[] parameters;
/*  63 */     if ((params == null) || (params.isEmpty()))
/*     */     {
/*  65 */       String[] signature = new String[0];
/*  66 */       parameters = new Object[0];
/*     */     }
/*     */     else
/*     */     {
/*  70 */       int size = params.size();
/*  71 */       signature = Configurator.getParameterTypes(log.isTraceEnabled(), params);
/*     */ 
/*  73 */       if (target != null)
/*     */       {
/*  75 */         MethodInfo methodInfo = Configurator.findMethodInfo(configurator.getClassInfo(target.getClass()), methodName, signature);
/*  76 */         Object[] parameters = Configurator.getParameters(log.isTraceEnabled(), context.getClassLoader(), methodInfo.getParameterTypes(), params);
/*     */ 
/*  78 */         for (int i = 0; i < size; i++)
/*     */         {
/*  80 */           if (signature[i] != null)
/*     */             continue;
/*  82 */           signature[i] = methodInfo.getParameterTypes()[i].getName();
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/*  88 */         parameters = new Object[size];
/*  89 */         ClassLoader classLoader = context.getClassLoader();
/*  90 */         for (int i = 0; i < size; i++)
/*     */         {
/*  92 */           ParameterMetaData pmd = (ParameterMetaData)params.get(i);
/*  93 */           TypeInfo typeInfo = null;
/*  94 */           if (signature[i] != null)
/*     */           {
/*  96 */             typeInfo = configurator.getClassInfo(signature[i], classLoader);
/*     */           }
/*     */ 
/*  99 */           parameters[i] = pmd.getValue().getValue(typeInfo, classLoader);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 104 */     return context.invoke(methodName, parameters, signature);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.dispatch.InvokeDispatchHelper
 * JD-Core Version:    0.6.0
 */