/*     */ package org.jboss.kernel.plugins.lazy;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.spi.config.KernelConfigurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.kernel.spi.lazy.LazyInitializer;
/*     */ import org.jboss.kernel.spi.registry.KernelBus;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public abstract class AbstractLazyInitializer
/*     */   implements LazyInitializer
/*     */ {
/*     */   protected static boolean isGetter(Method minfo)
/*     */   {
/* 112 */     String name = minfo.getName();
/* 113 */     Class returnType = minfo.getReturnType();
/* 114 */     Class[] parameters = minfo.getParameterTypes();
/* 115 */     if (((name.length() > 3) && (name.startsWith("get"))) || ((name.length() > 2) && (name.startsWith("is"))))
/*     */     {
/* 118 */       if ((name.startsWith("is")) && (!Boolean.TYPE.equals(returnType)))
/* 119 */         return false;
/* 120 */       if ((parameters.length == 0) && (!Void.TYPE.equals(returnType)))
/* 121 */         return true;
/*     */     }
/* 123 */     return false;
/*     */   }
/*     */ 
/*     */   protected static boolean isSetter(Method minfo)
/*     */   {
/* 134 */     String name = minfo.getName();
/* 135 */     Class returnType = minfo.getReturnType();
/* 136 */     Class[] parameters = minfo.getParameterTypes();
/* 137 */     if ((name.length() > 3) && (name.startsWith("set")))
/*     */     {
/* 139 */       if ((parameters.length == 1) && (Void.TYPE.equals(returnType)))
/* 140 */         return true;
/*     */     }
/* 142 */     return false;
/*     */   }
/*     */ 
/*     */   protected static String getLowerPropertyName(String name)
/*     */   {
/* 153 */     int start = name.startsWith("is") ? 2 : 3;
/* 154 */     name = name.substring(start);
/*     */ 
/* 158 */     if (name.length() > 1)
/*     */     {
/* 160 */       if (Character.isUpperCase(name.charAt(1))) {
/* 161 */         return name;
/*     */       }
/*     */     }
/* 164 */     JBossStringBuilder buffer = new JBossStringBuilder(name.length());
/* 165 */     buffer.append(Character.toLowerCase(name.charAt(0)));
/* 166 */     if (name.length() > 1)
/* 167 */       buffer.append(name.substring(1));
/* 168 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   protected KernelControllerContext getKernelControllerContext(Kernel kernel, String bean)
/*     */   {
/* 181 */     Controller controller = kernel.getController();
/* 182 */     ControllerContext context = controller.getContext(bean, ControllerState.DESCRIBED);
/* 183 */     if (context == null)
/* 184 */       throw new IllegalArgumentException("Should not be here, dependency failed.");
/* 185 */     if (!(context instanceof KernelControllerContext))
/* 186 */       throw new IllegalArgumentException("Context not KernelControllerContext: " + context);
/* 187 */     return (KernelControllerContext)KernelControllerContext.class.cast(context);
/*     */   }
/*     */ 
/*     */   protected BeanInfo getBeanInfo(Kernel kernel, String bean)
/*     */   {
/* 199 */     KernelControllerContext context = getKernelControllerContext(kernel, bean);
/* 200 */     return context.getBeanInfo();
/*     */   }
/*     */ 
/*     */   protected static Class[] getClasses(KernelConfigurator configurator, Set<String> classNames, ClassLoader cl)
/*     */     throws Throwable
/*     */   {
/* 215 */     Class[] classes = new Class[classNames.size()];
/* 216 */     int i = 0;
/* 217 */     for (String className : classNames)
/*     */     {
/* 219 */       classes[i] = configurator.getClassInfo(className, cl).getType();
/*     */     }
/* 221 */     return classes;
/*     */   }
/*     */ 
/*     */   protected abstract class AbstractInvokeHandler
/*     */   {
/*     */     private String bean;
/*     */     private KernelBus bus;
/*     */     private Class proxyClass;
/*     */ 
/*     */     protected AbstractInvokeHandler(String bean, KernelBus bus, Class proxyClass)
/*     */     {
/*  56 */       if (bean == null)
/*  57 */         throw new IllegalArgumentException("Null bean name.");
/*  58 */       this.bean = bean;
/*  59 */       if (bus == null)
/*  60 */         throw new IllegalArgumentException("Null Kernel bus.");
/*  61 */       this.bus = bus;
/*  62 */       this.proxyClass = proxyClass;
/*     */     }
/*     */ 
/*     */     protected Object executeInvoke(Object proxy, Method method, Object[] args)
/*     */       throws Throwable
/*     */     {
/*  76 */       String methodName = method.getName();
/*     */ 
/*  78 */       if ("hashCode".equals(methodName))
/*  79 */         return Integer.valueOf(System.identityHashCode(proxy));
/*  80 */       if ("getClass".equalsIgnoreCase(methodName))
/*  81 */         return this.proxyClass;
/*  82 */       if ("equals".equals(methodName))
/*  83 */         return Boolean.valueOf(proxy == args[0]);
/*  84 */       if ("toString".equals(methodName)) {
/*  85 */         return this.bean + "Proxy";
/*     */       }
/*  87 */       if (AbstractLazyInitializer.isGetter(method))
/*     */       {
/*  89 */         return this.bus.get(this.bean, AbstractLazyInitializer.getLowerPropertyName(methodName));
/*     */       }
/*  91 */       if (AbstractLazyInitializer.isSetter(method))
/*     */       {
/*  93 */         this.bus.set(this.bean, AbstractLazyInitializer.getLowerPropertyName(methodName), args[0]);
/*  94 */         return null;
/*     */       }
/*     */ 
/*  98 */       int length = args != null ? args.length : 0;
/*  99 */       return this.bus.invoke(this.bean, methodName, args, new String[length]);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.lazy.AbstractLazyInitializer
 * JD-Core Version:    0.6.0
 */