/*     */ package org.jboss.kernel.plugins.lazy;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Set;
/*     */ import javassist.util.proxy.MethodFilter;
/*     */ import javassist.util.proxy.MethodHandler;
/*     */ import javassist.util.proxy.ProxyFactory;
/*     */ import javassist.util.proxy.ProxyObject;
/*     */ import org.jboss.beans.info.spi.BeanInfo;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.plugins.config.Configurator;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.kernel.spi.registry.KernelBus;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ 
/*     */ public class JavassistLazyInitializer extends AbstractLazyInitializer
/*     */ {
/*  79 */   private static final MethodFilter FINALIZE_FILTER = new MethodFilter()
/*     */   {
/*     */     public boolean isHandled(Method m)
/*     */     {
/*  84 */       return (!"finalize".equals(m.getName())) || (m.getParameterTypes().length != 0);
/*     */     }
/*  79 */   };
/*     */ 
/*     */   public Object initializeProxy(Kernel kernel, String bean, boolean exposeClass, Set<String> interfaces)
/*     */     throws Throwable
/*     */   {
/*  48 */     KernelControllerContext context = getKernelControllerContext(kernel, bean);
/*  49 */     BeanInfo beanInfo = context.getBeanInfo();
/*  50 */     if (beanInfo == null) {
/*  51 */       throw new IllegalArgumentException("Cannot proxy factory beans.");
/*     */     }
/*  53 */     ProxyFactory factory = new ProxyFactory();
/*  54 */     factory.setFilter(FINALIZE_FILTER);
/*  55 */     if (exposeClass)
/*     */     {
/*  57 */       factory.setSuperclass(beanInfo.getClassInfo().getType());
/*     */     }
/*  59 */     if ((interfaces != null) && (interfaces.size() > 0))
/*     */     {
/*  61 */       ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
/*  62 */       factory.setInterfaces(getClasses(kernel.getConfigurator(), interfaces, cl));
/*     */     }
/*  64 */     Class proxyClass = getProxyClass(factory);
/*  65 */     ProxyObject proxy = (ProxyObject)proxyClass.newInstance();
/*  66 */     proxy.setHandler(new LazyHandler(bean, kernel.getBus(), beanInfo.getClassInfo().getType()));
/*  67 */     return proxy;
/*     */   }
/*     */ 
/*     */   protected Class getProxyClass(ProxyFactory factory)
/*     */   {
/*  72 */     SecurityManager sm = System.getSecurityManager();
/*  73 */     if (sm == null) {
/*  74 */       return factory.createClass();
/*     */     }
/*  76 */     return (Class)AccessController.doPrivileged(new ClassCreator(factory));
/*     */   }
/*     */ 
/*     */   protected class ClassCreator
/*     */     implements PrivilegedAction<Class>
/*     */   {
/*     */     private ProxyFactory factory;
/*     */ 
/*     */     public ClassCreator(ProxyFactory factory)
/*     */     {
/* 113 */       this.factory = factory;
/*     */     }
/*     */ 
/*     */     public Class run()
/*     */     {
/* 118 */       return this.factory.createClass();
/*     */     }
/*     */   }
/*     */ 
/*     */   public class LazyHandler extends AbstractLazyInitializer.AbstractInvokeHandler
/*     */     implements MethodHandler
/*     */   {
/*     */     public LazyHandler(String bean, KernelBus bus, Class proxyClass)
/*     */     {
/*  95 */       super(bean, bus, proxyClass);
/*     */     }
/*     */ 
/*     */     public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable
/*     */     {
/* 100 */       return executeInvoke(self, thisMethod, args);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.lazy.JavassistLazyInitializer
 * JD-Core Version:    0.6.0
 */