/*     */ package org.jboss.logging;
/*     */ 
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.Socket;
/*     */ import org.apache.log4j.LogManager;
/*     */ import org.apache.log4j.MDC;
/*     */ import org.apache.log4j.net.SocketNode;
/*     */ import org.apache.log4j.spi.LoggerRepository;
/*     */ import org.jboss.system.MissingAttributeException;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class Log4jSocketServer extends ServiceMBeanSupport
/*     */   implements Log4jSocketServerMBean
/*     */ {
/*  58 */   protected int port = -1;
/*     */ 
/*  61 */   protected int backlog = 50;
/*     */   protected InetAddress bindAddress;
/*  67 */   protected boolean listenerEnabled = true;
/*     */   protected SocketListenerThread listenerThread;
/*     */   protected ServerSocket serverSocket;
/*     */   protected LoggerRepositoryFactory loggerRepositoryFactory;
/*     */ 
/*     */   public void setPort(int port)
/*     */   {
/*  91 */     this.port = port;
/*     */   }
/*     */ 
/*     */   public int getPort()
/*     */   {
/*  99 */     return this.port;
/*     */   }
/*     */ 
/*     */   public void setBacklog(int backlog)
/*     */   {
/* 107 */     this.backlog = backlog;
/*     */   }
/*     */ 
/*     */   public int getBacklog()
/*     */   {
/* 115 */     return this.backlog;
/*     */   }
/*     */ 
/*     */   public void setBindAddress(InetAddress addr)
/*     */   {
/* 123 */     this.bindAddress = addr;
/*     */   }
/*     */ 
/*     */   public InetAddress getBindAddress()
/*     */   {
/* 131 */     return this.bindAddress;
/*     */   }
/*     */ 
/*     */   public void setListenerEnabled(boolean enabled)
/*     */   {
/* 139 */     this.listenerEnabled = enabled;
/*     */   }
/*     */ 
/*     */   public boolean setListenerEnabled()
/*     */   {
/* 147 */     return this.listenerEnabled;
/*     */   }
/*     */ 
/*     */   public void setLoggerRepositoryFactoryType(Class type)
/*     */     throws InstantiationException, IllegalAccessException, ClassCastException
/*     */   {
/* 156 */     this.loggerRepositoryFactory = ((LoggerRepositoryFactory)type.newInstance());
/*     */   }
/*     */ 
/*     */   public Class getLoggerRepositoryFactoryType()
/*     */   {
/* 164 */     if (this.loggerRepositoryFactory == null)
/* 165 */       return null;
/* 166 */     return this.loggerRepositoryFactory.getClass();
/*     */   }
/*     */ 
/*     */   public LoggerRepository getLoggerRepository(InetAddress addr)
/*     */   {
/* 174 */     return this.loggerRepositoryFactory.create(addr);
/*     */   }
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/* 328 */     this.listenerThread = new SocketListenerThread(false);
/* 329 */     this.listenerThread.setDaemon(true);
/* 330 */     this.listenerThread.start();
/* 331 */     this.log.debug("Socket listener thread started");
/*     */ 
/* 333 */     if (this.loggerRepositoryFactory == null)
/*     */     {
/* 335 */       this.log.debug("Using default logger repository factory");
/* 336 */       this.loggerRepositoryFactory = new DefaultLoggerRepositoryFactory();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void startService() throws Exception
/*     */   {
/* 342 */     if (this.port == -1) {
/* 343 */       throw new MissingAttributeException("Port");
/*     */     }
/*     */ 
/* 346 */     if (this.bindAddress == null)
/*     */     {
/* 348 */       this.serverSocket = new ServerSocket(this.port, this.backlog);
/*     */     }
/*     */     else
/*     */     {
/* 352 */       this.serverSocket = new ServerSocket(this.port, this.backlog, this.bindAddress);
/*     */     }
/*     */ 
/* 355 */     this.log.info("Listening on " + this.serverSocket);
/*     */ 
/* 357 */     this.listenerThread.setEnabled(this.listenerEnabled);
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 362 */     this.listenerThread.setEnabled(false);
/*     */   }
/*     */ 
/*     */   protected void destroyService() throws Exception
/*     */   {
/* 367 */     this.listenerThread.shutdown();
/* 368 */     this.listenerThread = null;
/* 369 */     this.serverSocket = null;
/*     */   }
/*     */ 
/*     */   public static class DefaultLoggerRepositoryFactory
/*     */     implements Log4jSocketServer.LoggerRepositoryFactory
/*     */   {
/*     */     private LoggerRepository repo;
/*     */ 
/*     */     public LoggerRepository create(InetAddress addr)
/*     */     {
/* 316 */       if (this.repo == null)
/* 317 */         this.repo = LogManager.getLoggerRepository();
/* 318 */       return this.repo;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static abstract interface LoggerRepositoryFactory
/*     */   {
/*     */     public abstract LoggerRepository create(InetAddress paramInetAddress);
/*     */   }
/*     */ 
/*     */   static class SocketThread extends Thread
/*     */   {
/*     */     String host;
/*     */ 
/*     */     SocketThread(Runnable target, String host)
/*     */     {
/* 286 */       super(host + " LoggingEvent Thread");
/* 287 */       this.host = host;
/*     */     }
/*     */ 
/*     */     public void run() {
/* 291 */       MDC.put("host", this.host);
/* 292 */       super.run();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class SocketListenerThread extends Thread
/*     */   {
/* 185 */     protected Logger log = Logger.getLogger(SocketListenerThread.class);
/*     */     protected boolean enabled;
/*     */     protected boolean shuttingDown;
/* 188 */     protected Object lock = new Object();
/*     */ 
/*     */     public SocketListenerThread(boolean enabled)
/*     */     {
/* 192 */       super();
/*     */ 
/* 194 */       this.enabled = enabled;
/*     */     }
/*     */ 
/*     */     public void setEnabled(boolean enabled)
/*     */     {
/* 199 */       this.enabled = enabled;
/*     */ 
/* 201 */       synchronized (this.lock)
/*     */       {
/* 203 */         this.lock.notifyAll();
/*     */       }
/* 205 */       this.log.debug("Notified that enabled: " + enabled);
/*     */     }
/*     */ 
/*     */     public void shutdown()
/*     */     {
/* 210 */       this.enabled = false;
/* 211 */       this.shuttingDown = true;
/*     */ 
/* 213 */       synchronized (this.lock)
/*     */       {
/* 215 */         this.lock.notifyAll();
/*     */       }
/* 217 */       this.log.debug("Notified to shutdown");
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/* 222 */       while (!this.shuttingDown)
/*     */       {
/* 225 */         if (!this.enabled)
/*     */         {
/*     */           try
/*     */           {
/* 229 */             this.log.debug("Disabled, waiting for notification");
/* 230 */             synchronized (this.lock)
/*     */             {
/* 232 */               this.lock.wait();
/*     */             }
/*     */           }
/*     */           catch (InterruptedException ignore)
/*     */           {
/*     */           }
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 242 */           doRun();
/*     */         }
/*     */         catch (Throwable e)
/*     */         {
/* 246 */           this.log.error("Exception caught from main loop; ignoring", e);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     protected void doRun() throws Exception
/*     */     {
/* 253 */       while (this.enabled)
/*     */       {
/* 255 */         Socket socket = Log4jSocketServer.this.serverSocket.accept();
/* 256 */         InetAddress addr = socket.getInetAddress();
/* 257 */         this.log.debug("Connected to client at " + addr);
/*     */ 
/* 259 */         LoggerRepository repo = Log4jSocketServer.this.getLoggerRepository(addr);
/* 260 */         this.log.debug("Using repository: " + repo);
/*     */ 
/* 266 */         this.log.debug("Starting new socket node");
/* 267 */         SocketNode node = new SocketNode(socket, repo);
/*     */ 
/* 271 */         String clientHost = addr.getHostName();
/* 272 */         Log4jSocketServer.SocketThread thread = new Log4jSocketServer.SocketThread(node, clientHost);
/* 273 */         thread.start();
/* 274 */         this.log.debug("Socket node started");
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.logging.Log4jSocketServer
 * JD-Core Version:    0.6.0
 */